package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Indicates how traffic is distributed among the load balancer Availability Zones.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * NetworkLoadBalancer lb = NetworkLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         // Whether deletion protection is enabled.
 *         .deletionProtection(true)
 *         // Whether cross-zone load balancing is enabled.
 *         .crossZoneEnabled(true)
 *         // Whether the load balancer blocks traffic through the Internet Gateway (IGW).
 *         .denyAllIgwTraffic(false)
 *         // Indicates how traffic is distributed among the load balancer Availability Zones.
 *         .clientRoutingPolicy(ClientRoutingPolicy.AVAILABILITY_ZONE_AFFINITY)
 *         // Indicates whether zonal shift is enabled.
 *         .zonalShift(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity">https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:33.159Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.ClientRoutingPolicy")
public enum ClientRoutingPolicy {
    /**
     * 100 percent zonal affinity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AVAILABILITY_ZONE_AFFINITY,
    /**
     * 85 percent zonal affinity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARTIAL_AVAILABILITY_ZONE_AFFINITY,
    /**
     * No zonal affinity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ANY_AVAILABILITY_ZONE,
}
