package software.amazon.awscdk.services.fsx;

/**
 * Creates an FSx for ONTAP or Amazon FSx for OpenZFS storage volume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * CfnVolume cfnVolume = CfnVolume.Builder.create(this, "MyCfnVolume")
 *         .name("name")
 *         // the properties below are optional
 *         .backupId("backupId")
 *         .ontapConfiguration(OntapConfigurationProperty.builder()
 *                 .storageVirtualMachineId("storageVirtualMachineId")
 *                 // the properties below are optional
 *                 .aggregateConfiguration(AggregateConfigurationProperty.builder()
 *                         .aggregates(List.of("aggregates"))
 *                         .constituentsPerAggregate(123)
 *                         .build())
 *                 .copyTagsToBackups("copyTagsToBackups")
 *                 .junctionPath("junctionPath")
 *                 .ontapVolumeType("ontapVolumeType")
 *                 .securityStyle("securityStyle")
 *                 .sizeInBytes("sizeInBytes")
 *                 .sizeInMegabytes("sizeInMegabytes")
 *                 .snaplockConfiguration(SnaplockConfigurationProperty.builder()
 *                         .snaplockType("snaplockType")
 *                         // the properties below are optional
 *                         .auditLogVolume("auditLogVolume")
 *                         .autocommitPeriod(AutocommitPeriodProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .value(123)
 *                                 .build())
 *                         .privilegedDelete("privilegedDelete")
 *                         .retentionPeriod(SnaplockRetentionPeriodProperty.builder()
 *                                 .defaultRetention(RetentionPeriodProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .value(123)
 *                                         .build())
 *                                 .maximumRetention(RetentionPeriodProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .value(123)
 *                                         .build())
 *                                 .minimumRetention(RetentionPeriodProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .volumeAppendModeEnabled("volumeAppendModeEnabled")
 *                         .build())
 *                 .snapshotPolicy("snapshotPolicy")
 *                 .storageEfficiencyEnabled("storageEfficiencyEnabled")
 *                 .tieringPolicy(TieringPolicyProperty.builder()
 *                         .coolingPeriod(123)
 *                         .name("name")
 *                         .build())
 *                 .volumeStyle("volumeStyle")
 *                 .build())
 *         .openZfsConfiguration(OpenZFSConfigurationProperty.builder()
 *                 .parentVolumeId("parentVolumeId")
 *                 // the properties below are optional
 *                 .copyTagsToSnapshots(false)
 *                 .dataCompressionType("dataCompressionType")
 *                 .nfsExports(List.of(NfsExportsProperty.builder()
 *                         .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
 *                                 .clients("clients")
 *                                 .options(List.of("options"))
 *                                 .build()))
 *                         .build()))
 *                 .options(List.of("options"))
 *                 .originSnapshot(OriginSnapshotProperty.builder()
 *                         .copyStrategy("copyStrategy")
 *                         .snapshotArn("snapshotArn")
 *                         .build())
 *                 .readOnly(false)
 *                 .recordSizeKiB(123)
 *                 .storageCapacityQuotaGiB(123)
 *                 .storageCapacityReservationGiB(123)
 *                 .userAndGroupQuotas(List.of(UserAndGroupQuotasProperty.builder()
 *                         .id(123)
 *                         .storageCapacityQuotaGiB(123)
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .volumeType("volumeType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:33.722Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume")
public class CfnVolume extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.fsx.CfnVolume.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVolume(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.CfnVolumeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the volume's Amazon Resource Name (ARN).
     * <p>
     * Example: <code>arn:aws:fsx:us-east-2:111122223333:volume/fs-0123456789abcdef9/fsvol-01234567891112223</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the volume's universally unique identifier (UUID).
     * <p>
     * Example: <code>abcd0123-cd45-ef67-11aa-1111aaaa23bc</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUuid() {
        return software.amazon.jsii.Kernel.get(this, "attrUuid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the volume's ID.
     * <p>
     * Example: <code>fsvol-0123456789abcdefa</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVolumeId() {
        return software.amazon.jsii.Kernel.get(this, "attrVolumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Specifies the ID of the volume backup to use to create a new volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBackupId() {
        return software.amazon.jsii.Kernel.get(this, "backupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the ID of the volume backup to use to create a new volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "backupId", value);
    }

    /**
     * The configuration of an Amazon FSx for NetApp ONTAP volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOntapConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "ontapConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of an Amazon FSx for NetApp ONTAP volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOntapConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ontapConfiguration", value);
    }

    /**
     * The configuration of an Amazon FSx for NetApp ONTAP volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOntapConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnVolume.OntapConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "ontapConfiguration", value);
    }

    /**
     * The configuration of an Amazon FSx for OpenZFS volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOpenZfsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "openZfsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of an Amazon FSx for OpenZFS volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenZfsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "openZfsConfiguration", value);
    }

    /**
     * The configuration of an Amazon FSx for OpenZFS volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenZfsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnVolume.OpenZFSConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "openZfsConfiguration", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The type of the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
        return software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVolumeType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "volumeType", value);
    }
    /**
     * Use to specify configuration options for a volume’s storage aggregate or aggregates.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * AggregateConfigurationProperty aggregateConfigurationProperty = AggregateConfigurationProperty.builder()
     *         .aggregates(List.of("aggregates"))
     *         .constituentsPerAggregate(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-aggregateconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-aggregateconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.AggregateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AggregateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AggregateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of aggregates that this volume resides on.
         * <p>
         * Aggregates are storage pools which make up your primary storage tier. Each high-availability (HA) pair has one aggregate. The names of the aggregates map to the names of the aggregates in the ONTAP CLI and REST API. For FlexVols, there will always be a single entry.
         * <p>
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * <p>
         * <ul>
         * <li>The strings in the value of <code>Aggregates</code> are not are not formatted as <code>aggrX</code> , where X is a number between 1 and 12.</li>
         * <li>The value of <code>Aggregates</code> contains aggregates that are not present.</li>
         * <li>One or more of the aggregates supplied are too close to the volume limit to support adding more volumes.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-aggregateconfiguration.html#cfn-fsx-volume-aggregateconfiguration-aggregates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-aggregateconfiguration.html#cfn-fsx-volume-aggregateconfiguration-aggregates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAggregates() {
            return null;
        }

        /**
         * Used to explicitly set the number of constituents within the FlexGroup per storage aggregate.
         * <p>
         * This field is optional when creating a FlexGroup volume. If unspecified, the default value will be 8. This field cannot be provided when creating a FlexVol volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-aggregateconfiguration.html#cfn-fsx-volume-aggregateconfiguration-constituentsperaggregate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-aggregateconfiguration.html#cfn-fsx-volume-aggregateconfiguration-constituentsperaggregate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConstituentsPerAggregate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AggregateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AggregateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AggregateConfigurationProperty> {
            java.util.List<java.lang.String> aggregates;
            java.lang.Number constituentsPerAggregate;

            /**
             * Sets the value of {@link AggregateConfigurationProperty#getAggregates}
             * @param aggregates The list of aggregates that this volume resides on.
             *                   Aggregates are storage pools which make up your primary storage tier. Each high-availability (HA) pair has one aggregate. The names of the aggregates map to the names of the aggregates in the ONTAP CLI and REST API. For FlexVols, there will always be a single entry.
             *                   <p>
             *                   Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
             *                   <p>
             *                   <ul>
             *                   <li>The strings in the value of <code>Aggregates</code> are not are not formatted as <code>aggrX</code> , where X is a number between 1 and 12.</li>
             *                   <li>The value of <code>Aggregates</code> contains aggregates that are not present.</li>
             *                   <li>One or more of the aggregates supplied are too close to the volume limit to support adding more volumes.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregates(java.util.List<java.lang.String> aggregates) {
                this.aggregates = aggregates;
                return this;
            }

            /**
             * Sets the value of {@link AggregateConfigurationProperty#getConstituentsPerAggregate}
             * @param constituentsPerAggregate Used to explicitly set the number of constituents within the FlexGroup per storage aggregate.
             *                                 This field is optional when creating a FlexGroup volume. If unspecified, the default value will be 8. This field cannot be provided when creating a FlexVol volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constituentsPerAggregate(java.lang.Number constituentsPerAggregate) {
                this.constituentsPerAggregate = constituentsPerAggregate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AggregateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AggregateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AggregateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AggregateConfigurationProperty {
            private final java.util.List<java.lang.String> aggregates;
            private final java.lang.Number constituentsPerAggregate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregates = software.amazon.jsii.Kernel.get(this, "aggregates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.constituentsPerAggregate = software.amazon.jsii.Kernel.get(this, "constituentsPerAggregate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregates = builder.aggregates;
                this.constituentsPerAggregate = builder.constituentsPerAggregate;
            }

            @Override
            public final java.util.List<java.lang.String> getAggregates() {
                return this.aggregates;
            }

            @Override
            public final java.lang.Number getConstituentsPerAggregate() {
                return this.constituentsPerAggregate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAggregates() != null) {
                    data.set("aggregates", om.valueToTree(this.getAggregates()));
                }
                if (this.getConstituentsPerAggregate() != null) {
                    data.set("constituentsPerAggregate", om.valueToTree(this.getConstituentsPerAggregate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.AggregateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AggregateConfigurationProperty.Jsii$Proxy that = (AggregateConfigurationProperty.Jsii$Proxy) o;

                if (this.aggregates != null ? !this.aggregates.equals(that.aggregates) : that.aggregates != null) return false;
                return this.constituentsPerAggregate != null ? this.constituentsPerAggregate.equals(that.constituentsPerAggregate) : that.constituentsPerAggregate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregates != null ? this.aggregates.hashCode() : 0;
                result = 31 * result + (this.constituentsPerAggregate != null ? this.constituentsPerAggregate.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sets the autocommit period of files in an FSx for ONTAP SnapLock volume, which determines how long the files must remain unmodified before they're automatically transitioned to the write once, read many (WORM) state.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-autocommit">Autocommit</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * AutocommitPeriodProperty autocommitPeriodProperty = AutocommitPeriodProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-autocommitperiod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-autocommitperiod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.AutocommitPeriodProperty")
    @software.amazon.jsii.Jsii.Proxy(AutocommitPeriodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutocommitPeriodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
         * <p>
         * Setting this value to <code>NONE</code> disables autocommit. The default value is <code>NONE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-autocommitperiod.html#cfn-fsx-volume-autocommitperiod-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-autocommitperiod.html#cfn-fsx-volume-autocommitperiod-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Defines the amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
         * <p>
         * The following ranges are valid:
         * <p>
         * <ul>
         * <li><code>Minutes</code> : 5 - 65,535</li>
         * <li><code>Hours</code> : 1 - 65,535</li>
         * <li><code>Days</code> : 1 - 3,650</li>
         * <li><code>Months</code> : 1 - 120</li>
         * <li><code>Years</code> : 1 - 10</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-autocommitperiod.html#cfn-fsx-volume-autocommitperiod-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-autocommitperiod.html#cfn-fsx-volume-autocommitperiod-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutocommitPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutocommitPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutocommitPeriodProperty> {
            java.lang.String type;
            java.lang.Number value;

            /**
             * Sets the value of {@link AutocommitPeriodProperty#getType}
             * @param type Defines the type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. This parameter is required.
             *             Setting this value to <code>NONE</code> disables autocommit. The default value is <code>NONE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link AutocommitPeriodProperty#getValue}
             * @param value Defines the amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
             *              The following ranges are valid:
             *              <p>
             *              <ul>
             *              <li><code>Minutes</code> : 5 - 65,535</li>
             *              <li><code>Hours</code> : 1 - 65,535</li>
             *              <li><code>Days</code> : 1 - 3,650</li>
             *              <li><code>Months</code> : 1 - 120</li>
             *              <li><code>Years</code> : 1 - 10</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutocommitPeriodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutocommitPeriodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutocommitPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutocommitPeriodProperty {
            private final java.lang.String type;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.AutocommitPeriodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutocommitPeriodProperty.Jsii$Proxy that = (AutocommitPeriodProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies who can mount an OpenZFS file system and the options available while mounting the file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * ClientConfigurationsProperty clientConfigurationsProperty = ClientConfigurationsProperty.builder()
     *         .clients("clients")
     *         .options(List.of("options"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-clientconfigurations.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-clientconfigurations.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.ClientConfigurationsProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientConfigurationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientConfigurationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that specifies who can mount the file system.
         * <p>
         * You can provide a wildcard character ( <code>*</code> ), an IP address ( <code>0.0.0.0</code> ), or a CIDR address ( <code>192.0.2.0/24</code> ). By default, Amazon FSx uses the wildcard character when specifying the client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-clientconfigurations.html#cfn-fsx-volume-clientconfigurations-clients">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-clientconfigurations.html#cfn-fsx-volume-clientconfigurations-clients</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClients();

        /**
         * The options to use when mounting the file system.
         * <p>
         * For a list of options that you can use with Network File System (NFS), see the <a href="https://docs.aws.amazon.com/https://linux.die.net/man/5/exports">exports(5) - Linux man page</a> . When choosing your options, consider the following:
         * <p>
         * <ul>
         * <li><code>crossmnt</code> is used by default. If you don't specify <code>crossmnt</code> when changing the client configuration, you won't be able to see or access snapshots in your file system's snapshot directory.</li>
         * <li><code>sync</code> is used by default. If you instead specify <code>async</code> , the system acknowledges writes before writing to disk. If the system crashes before the writes are finished, you lose the unwritten data.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-clientconfigurations.html#cfn-fsx-volume-clientconfigurations-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-clientconfigurations.html#cfn-fsx-volume-clientconfigurations-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getOptions();

        /**
         * @return a {@link Builder} of {@link ClientConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientConfigurationsProperty> {
            java.lang.String clients;
            java.util.List<java.lang.String> options;

            /**
             * Sets the value of {@link ClientConfigurationsProperty#getClients}
             * @param clients A value that specifies who can mount the file system. This parameter is required.
             *                You can provide a wildcard character ( <code>*</code> ), an IP address ( <code>0.0.0.0</code> ), or a CIDR address ( <code>192.0.2.0/24</code> ). By default, Amazon FSx uses the wildcard character when specifying the client.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clients(java.lang.String clients) {
                this.clients = clients;
                return this;
            }

            /**
             * Sets the value of {@link ClientConfigurationsProperty#getOptions}
             * @param options The options to use when mounting the file system. This parameter is required.
             *                For a list of options that you can use with Network File System (NFS), see the <a href="https://docs.aws.amazon.com/https://linux.die.net/man/5/exports">exports(5) - Linux man page</a> . When choosing your options, consider the following:
             *                <p>
             *                <ul>
             *                <li><code>crossmnt</code> is used by default. If you don't specify <code>crossmnt</code> when changing the client configuration, you won't be able to see or access snapshots in your file system's snapshot directory.</li>
             *                <li><code>sync</code> is used by default. If you instead specify <code>async</code> , the system acknowledges writes before writing to disk. If the system crashes before the writes are finished, you lose the unwritten data.</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<java.lang.String> options) {
                this.options = options;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientConfigurationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientConfigurationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientConfigurationsProperty {
            private final java.lang.String clients;
            private final java.util.List<java.lang.String> options;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clients = software.amazon.jsii.Kernel.get(this, "clients", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clients = java.util.Objects.requireNonNull(builder.clients, "clients is required");
                this.options = java.util.Objects.requireNonNull(builder.options, "options is required");
            }

            @Override
            public final java.lang.String getClients() {
                return this.clients;
            }

            @Override
            public final java.util.List<java.lang.String> getOptions() {
                return this.options;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clients", om.valueToTree(this.getClients()));
                data.set("options", om.valueToTree(this.getOptions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.ClientConfigurationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientConfigurationsProperty.Jsii$Proxy that = (ClientConfigurationsProperty.Jsii$Proxy) o;

                if (!clients.equals(that.clients)) return false;
                return this.options.equals(that.options);
            }

            @Override
            public final int hashCode() {
                int result = this.clients.hashCode();
                result = 31 * result + (this.options.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration object for mounting a Network File System (NFS) file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * NfsExportsProperty nfsExportsProperty = NfsExportsProperty.builder()
     *         .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
     *                 .clients("clients")
     *                 .options(List.of("options"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-nfsexports.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-nfsexports.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.NfsExportsProperty")
    @software.amazon.jsii.Jsii.Proxy(NfsExportsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NfsExportsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of configuration objects that contain the client and options for mounting the OpenZFS file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-nfsexports.html#cfn-fsx-volume-nfsexports-clientconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-nfsexports.html#cfn-fsx-volume-nfsexports-clientconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClientConfigurations();

        /**
         * @return a {@link Builder} of {@link NfsExportsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NfsExportsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NfsExportsProperty> {
            java.lang.Object clientConfigurations;

            /**
             * Sets the value of {@link NfsExportsProperty#getClientConfigurations}
             * @param clientConfigurations A list of configuration objects that contain the client and options for mounting the OpenZFS file system. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientConfigurations(software.amazon.awscdk.IResolvable clientConfigurations) {
                this.clientConfigurations = clientConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NfsExportsProperty#getClientConfigurations}
             * @param clientConfigurations A list of configuration objects that contain the client and options for mounting the OpenZFS file system. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientConfigurations(java.util.List<? extends java.lang.Object> clientConfigurations) {
                this.clientConfigurations = clientConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NfsExportsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NfsExportsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NfsExportsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NfsExportsProperty {
            private final java.lang.Object clientConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientConfigurations = software.amazon.jsii.Kernel.get(this, "clientConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientConfigurations = java.util.Objects.requireNonNull(builder.clientConfigurations, "clientConfigurations is required");
            }

            @Override
            public final java.lang.Object getClientConfigurations() {
                return this.clientConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientConfigurations", om.valueToTree(this.getClientConfigurations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.NfsExportsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NfsExportsProperty.Jsii$Proxy that = (NfsExportsProperty.Jsii$Proxy) o;

                return this.clientConfigurations.equals(that.clientConfigurations);
            }

            @Override
            public final int hashCode() {
                int result = this.clientConfigurations.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of the ONTAP volume that you are creating.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * OntapConfigurationProperty ontapConfigurationProperty = OntapConfigurationProperty.builder()
     *         .storageVirtualMachineId("storageVirtualMachineId")
     *         // the properties below are optional
     *         .aggregateConfiguration(AggregateConfigurationProperty.builder()
     *                 .aggregates(List.of("aggregates"))
     *                 .constituentsPerAggregate(123)
     *                 .build())
     *         .copyTagsToBackups("copyTagsToBackups")
     *         .junctionPath("junctionPath")
     *         .ontapVolumeType("ontapVolumeType")
     *         .securityStyle("securityStyle")
     *         .sizeInBytes("sizeInBytes")
     *         .sizeInMegabytes("sizeInMegabytes")
     *         .snaplockConfiguration(SnaplockConfigurationProperty.builder()
     *                 .snaplockType("snaplockType")
     *                 // the properties below are optional
     *                 .auditLogVolume("auditLogVolume")
     *                 .autocommitPeriod(AutocommitPeriodProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .value(123)
     *                         .build())
     *                 .privilegedDelete("privilegedDelete")
     *                 .retentionPeriod(SnaplockRetentionPeriodProperty.builder()
     *                         .defaultRetention(RetentionPeriodProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .value(123)
     *                                 .build())
     *                         .maximumRetention(RetentionPeriodProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .value(123)
     *                                 .build())
     *                         .minimumRetention(RetentionPeriodProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .value(123)
     *                                 .build())
     *                         .build())
     *                 .volumeAppendModeEnabled("volumeAppendModeEnabled")
     *                 .build())
     *         .snapshotPolicy("snapshotPolicy")
     *         .storageEfficiencyEnabled("storageEfficiencyEnabled")
     *         .tieringPolicy(TieringPolicyProperty.builder()
     *                 .coolingPeriod(123)
     *                 .name("name")
     *                 .build())
     *         .volumeStyle("volumeStyle")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.OntapConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OntapConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OntapConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the ONTAP SVM in which to create the volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-storagevirtualmachineid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-storagevirtualmachineid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStorageVirtualMachineId();

        /**
         * Used to specify the configuration options for an FSx for ONTAP volume's storage aggregate or aggregates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-aggregateconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-aggregateconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAggregateConfiguration() {
            return null;
        }

        /**
         * A boolean flag indicating whether tags for the volume should be copied to backups.
         * <p>
         * This value defaults to false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the volume, regardless of this value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-copytagstobackups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-copytagstobackups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCopyTagsToBackups() {
            return null;
        }

        /**
         * Specifies the location in the SVM's namespace where the volume is mounted.
         * <p>
         * This parameter is required. The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-junctionpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-junctionpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJunctionPath() {
            return null;
        }

        /**
         * Specifies the type of volume you are creating. Valid values are the following:.
         * <p>
         * <ul>
         * <li><code>RW</code> specifies a read/write volume. <code>RW</code> is the default.</li>
         * <li><code>DP</code> specifies a data-protection volume. A <code>DP</code> volume is read-only and can be used as the destination of a NetApp SnapMirror relationship.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-types">Volume types</a> in the Amazon FSx for NetApp ONTAP User Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-ontapvolumetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-ontapvolumetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOntapVolumeType() {
            return null;
        }

        /**
         * Specifies the security style for the volume.
         * <p>
         * If a volume's security style is not specified, it is automatically set to the root volume's security style. The security style determines the type of permissions that FSx for ONTAP uses to control data access. Specify one of the following values:
         * <p>
         * <ul>
         * <li><code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.</li>
         * <li><code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</li>
         * <li><code>MIXED</code> This is an advanced setting. For more information, see the topic <a href="https://docs.aws.amazon.com/https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html">What the security styles and their effects are</a> in the NetApp Documentation Center.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-security-style">Volume security style</a> in the FSx for ONTAP User Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-securitystyle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-securitystyle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityStyle() {
            return null;
        }

        /**
         * Specifies the configured size of the volume, in bytes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-sizeinbytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-sizeinbytes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSizeInBytes() {
            return null;
        }

        /**
         * Use <code>SizeInBytes</code> instead.
         * <p>
         * Specifies the size of the volume, in megabytes (MB), that you are creating.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-sizeinmegabytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-sizeinmegabytes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSizeInMegabytes() {
            return null;
        }

        /**
         * The SnapLock configuration object for an FSx for ONTAP SnapLock volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-snaplockconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-snaplockconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnaplockConfiguration() {
            return null;
        }

        /**
         * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:.
         * <p>
         * <ul>
         * <li><code>default</code> : This is the default policy. A maximum of six hourly snapshots taken five minutes past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.</li>
         * <li><code>default-1weekly</code> : This policy is the same as the <code>default</code> policy except that it only retains one snapshot from the weekly schedule.</li>
         * <li><code>none</code> : This policy does not take any snapshots. This policy can be assigned to volumes to prevent automatic snapshots from being taken.</li>
         * </ul>
         * <p>
         * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies">Snapshot policies</a> in the Amazon FSx for NetApp ONTAP User Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-snapshotpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-snapshotpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotPolicy() {
            return null;
        }

        /**
         * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume, or set to false to disable them.
         * <p>
         * <code>StorageEfficiencyEnabled</code> is required when creating a <code>RW</code> volume ( <code>OntapVolumeType</code> set to <code>RW</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-storageefficiencyenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-storageefficiencyenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStorageEfficiencyEnabled() {
            return null;
        }

        /**
         * Describes the data tiering policy for an ONTAP volume.
         * <p>
         * When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
         * <p>
         * Valid tiering policies are the following:
         * <p>
         * <ul>
         * <li><code>SNAPSHOT_ONLY</code> - (Default value) moves cold snapshots to the capacity pool storage tier.</li>
         * <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
         * <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
         * <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-tieringpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-tieringpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTieringPolicy() {
            return null;
        }

        /**
         * Use to specify the style of an ONTAP volume.
         * <p>
         * FSx for ONTAP offers two styles of volumes that you can use for different purposes, FlexVol and FlexGroup volumes. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-styles">Volume styles</a> in the Amazon FSx for NetApp ONTAP User Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-volumestyle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-ontapconfiguration.html#cfn-fsx-volume-ontapconfiguration-volumestyle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeStyle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OntapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OntapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OntapConfigurationProperty> {
            java.lang.String storageVirtualMachineId;
            java.lang.Object aggregateConfiguration;
            java.lang.String copyTagsToBackups;
            java.lang.String junctionPath;
            java.lang.String ontapVolumeType;
            java.lang.String securityStyle;
            java.lang.String sizeInBytes;
            java.lang.String sizeInMegabytes;
            java.lang.Object snaplockConfiguration;
            java.lang.String snapshotPolicy;
            java.lang.String storageEfficiencyEnabled;
            java.lang.Object tieringPolicy;
            java.lang.String volumeStyle;

            /**
             * Sets the value of {@link OntapConfigurationProperty#getStorageVirtualMachineId}
             * @param storageVirtualMachineId Specifies the ONTAP SVM in which to create the volume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageVirtualMachineId(java.lang.String storageVirtualMachineId) {
                this.storageVirtualMachineId = storageVirtualMachineId;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getAggregateConfiguration}
             * @param aggregateConfiguration Used to specify the configuration options for an FSx for ONTAP volume's storage aggregate or aggregates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregateConfiguration(software.amazon.awscdk.IResolvable aggregateConfiguration) {
                this.aggregateConfiguration = aggregateConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getAggregateConfiguration}
             * @param aggregateConfiguration Used to specify the configuration options for an FSx for ONTAP volume's storage aggregate or aggregates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregateConfiguration(software.amazon.awscdk.services.fsx.CfnVolume.AggregateConfigurationProperty aggregateConfiguration) {
                this.aggregateConfiguration = aggregateConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getCopyTagsToBackups}
             * @param copyTagsToBackups A boolean flag indicating whether tags for the volume should be copied to backups.
             *                          This value defaults to false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the volume, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToBackups(java.lang.String copyTagsToBackups) {
                this.copyTagsToBackups = copyTagsToBackups;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getJunctionPath}
             * @param junctionPath Specifies the location in the SVM's namespace where the volume is mounted.
             *                     This parameter is required. The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder junctionPath(java.lang.String junctionPath) {
                this.junctionPath = junctionPath;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getOntapVolumeType}
             * @param ontapVolumeType Specifies the type of volume you are creating. Valid values are the following:.
             *                        <ul>
             *                        <li><code>RW</code> specifies a read/write volume. <code>RW</code> is the default.</li>
             *                        <li><code>DP</code> specifies a data-protection volume. A <code>DP</code> volume is read-only and can be used as the destination of a NetApp SnapMirror relationship.</li>
             *                        </ul>
             *                        <p>
             *                        For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-types">Volume types</a> in the Amazon FSx for NetApp ONTAP User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ontapVolumeType(java.lang.String ontapVolumeType) {
                this.ontapVolumeType = ontapVolumeType;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getSecurityStyle}
             * @param securityStyle Specifies the security style for the volume.
             *                      If a volume's security style is not specified, it is automatically set to the root volume's security style. The security style determines the type of permissions that FSx for ONTAP uses to control data access. Specify one of the following values:
             *                      <p>
             *                      <ul>
             *                      <li><code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.</li>
             *                      <li><code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</li>
             *                      <li><code>MIXED</code> This is an advanced setting. For more information, see the topic <a href="https://docs.aws.amazon.com/https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html">What the security styles and their effects are</a> in the NetApp Documentation Center.</li>
             *                      </ul>
             *                      <p>
             *                      For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-security-style">Volume security style</a> in the FSx for ONTAP User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityStyle(java.lang.String securityStyle) {
                this.securityStyle = securityStyle;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getSizeInBytes}
             * @param sizeInBytes Specifies the configured size of the volume, in bytes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInBytes(java.lang.String sizeInBytes) {
                this.sizeInBytes = sizeInBytes;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getSizeInMegabytes}
             * @param sizeInMegabytes Use <code>SizeInBytes</code> instead.
             *                        Specifies the size of the volume, in megabytes (MB), that you are creating.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInMegabytes(java.lang.String sizeInMegabytes) {
                this.sizeInMegabytes = sizeInMegabytes;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getSnaplockConfiguration}
             * @param snaplockConfiguration The SnapLock configuration object for an FSx for ONTAP SnapLock volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snaplockConfiguration(software.amazon.awscdk.IResolvable snaplockConfiguration) {
                this.snaplockConfiguration = snaplockConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getSnaplockConfiguration}
             * @param snaplockConfiguration The SnapLock configuration object for an FSx for ONTAP SnapLock volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snaplockConfiguration(software.amazon.awscdk.services.fsx.CfnVolume.SnaplockConfigurationProperty snaplockConfiguration) {
                this.snaplockConfiguration = snaplockConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getSnapshotPolicy}
             * @param snapshotPolicy Specifies the snapshot policy for the volume. There are three built-in snapshot policies:.
             *                       <ul>
             *                       <li><code>default</code> : This is the default policy. A maximum of six hourly snapshots taken five minutes past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.</li>
             *                       <li><code>default-1weekly</code> : This policy is the same as the <code>default</code> policy except that it only retains one snapshot from the weekly schedule.</li>
             *                       <li><code>none</code> : This policy does not take any snapshots. This policy can be assigned to volumes to prevent automatic snapshots from being taken.</li>
             *                       </ul>
             *                       <p>
             *                       You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
             *                       <p>
             *                       For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies">Snapshot policies</a> in the Amazon FSx for NetApp ONTAP User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotPolicy(java.lang.String snapshotPolicy) {
                this.snapshotPolicy = snapshotPolicy;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getStorageEfficiencyEnabled}
             * @param storageEfficiencyEnabled Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume, or set to false to disable them.
             *                                 <code>StorageEfficiencyEnabled</code> is required when creating a <code>RW</code> volume ( <code>OntapVolumeType</code> set to <code>RW</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageEfficiencyEnabled(java.lang.String storageEfficiencyEnabled) {
                this.storageEfficiencyEnabled = storageEfficiencyEnabled;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getTieringPolicy}
             * @param tieringPolicy Describes the data tiering policy for an ONTAP volume.
             *                      When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
             *                      <p>
             *                      Valid tiering policies are the following:
             *                      <p>
             *                      <ul>
             *                      <li><code>SNAPSHOT_ONLY</code> - (Default value) moves cold snapshots to the capacity pool storage tier.</li>
             *                      <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
             *                      <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
             *                      <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tieringPolicy(software.amazon.awscdk.IResolvable tieringPolicy) {
                this.tieringPolicy = tieringPolicy;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getTieringPolicy}
             * @param tieringPolicy Describes the data tiering policy for an ONTAP volume.
             *                      When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
             *                      <p>
             *                      Valid tiering policies are the following:
             *                      <p>
             *                      <ul>
             *                      <li><code>SNAPSHOT_ONLY</code> - (Default value) moves cold snapshots to the capacity pool storage tier.</li>
             *                      <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
             *                      <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
             *                      <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tieringPolicy(software.amazon.awscdk.services.fsx.CfnVolume.TieringPolicyProperty tieringPolicy) {
                this.tieringPolicy = tieringPolicy;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getVolumeStyle}
             * @param volumeStyle Use to specify the style of an ONTAP volume.
             *                    FSx for ONTAP offers two styles of volumes that you can use for different purposes, FlexVol and FlexGroup volumes. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html#volume-styles">Volume styles</a> in the Amazon FSx for NetApp ONTAP User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeStyle(java.lang.String volumeStyle) {
                this.volumeStyle = volumeStyle;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OntapConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OntapConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OntapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OntapConfigurationProperty {
            private final java.lang.String storageVirtualMachineId;
            private final java.lang.Object aggregateConfiguration;
            private final java.lang.String copyTagsToBackups;
            private final java.lang.String junctionPath;
            private final java.lang.String ontapVolumeType;
            private final java.lang.String securityStyle;
            private final java.lang.String sizeInBytes;
            private final java.lang.String sizeInMegabytes;
            private final java.lang.Object snaplockConfiguration;
            private final java.lang.String snapshotPolicy;
            private final java.lang.String storageEfficiencyEnabled;
            private final java.lang.Object tieringPolicy;
            private final java.lang.String volumeStyle;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.storageVirtualMachineId = software.amazon.jsii.Kernel.get(this, "storageVirtualMachineId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.aggregateConfiguration = software.amazon.jsii.Kernel.get(this, "aggregateConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.copyTagsToBackups = software.amazon.jsii.Kernel.get(this, "copyTagsToBackups", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.junctionPath = software.amazon.jsii.Kernel.get(this, "junctionPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ontapVolumeType = software.amazon.jsii.Kernel.get(this, "ontapVolumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityStyle = software.amazon.jsii.Kernel.get(this, "securityStyle", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sizeInBytes = software.amazon.jsii.Kernel.get(this, "sizeInBytes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sizeInMegabytes = software.amazon.jsii.Kernel.get(this, "sizeInMegabytes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snaplockConfiguration = software.amazon.jsii.Kernel.get(this, "snaplockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snapshotPolicy = software.amazon.jsii.Kernel.get(this, "snapshotPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.storageEfficiencyEnabled = software.amazon.jsii.Kernel.get(this, "storageEfficiencyEnabled", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tieringPolicy = software.amazon.jsii.Kernel.get(this, "tieringPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumeStyle = software.amazon.jsii.Kernel.get(this, "volumeStyle", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.storageVirtualMachineId = java.util.Objects.requireNonNull(builder.storageVirtualMachineId, "storageVirtualMachineId is required");
                this.aggregateConfiguration = builder.aggregateConfiguration;
                this.copyTagsToBackups = builder.copyTagsToBackups;
                this.junctionPath = builder.junctionPath;
                this.ontapVolumeType = builder.ontapVolumeType;
                this.securityStyle = builder.securityStyle;
                this.sizeInBytes = builder.sizeInBytes;
                this.sizeInMegabytes = builder.sizeInMegabytes;
                this.snaplockConfiguration = builder.snaplockConfiguration;
                this.snapshotPolicy = builder.snapshotPolicy;
                this.storageEfficiencyEnabled = builder.storageEfficiencyEnabled;
                this.tieringPolicy = builder.tieringPolicy;
                this.volumeStyle = builder.volumeStyle;
            }

            @Override
            public final java.lang.String getStorageVirtualMachineId() {
                return this.storageVirtualMachineId;
            }

            @Override
            public final java.lang.Object getAggregateConfiguration() {
                return this.aggregateConfiguration;
            }

            @Override
            public final java.lang.String getCopyTagsToBackups() {
                return this.copyTagsToBackups;
            }

            @Override
            public final java.lang.String getJunctionPath() {
                return this.junctionPath;
            }

            @Override
            public final java.lang.String getOntapVolumeType() {
                return this.ontapVolumeType;
            }

            @Override
            public final java.lang.String getSecurityStyle() {
                return this.securityStyle;
            }

            @Override
            public final java.lang.String getSizeInBytes() {
                return this.sizeInBytes;
            }

            @Override
            public final java.lang.String getSizeInMegabytes() {
                return this.sizeInMegabytes;
            }

            @Override
            public final java.lang.Object getSnaplockConfiguration() {
                return this.snaplockConfiguration;
            }

            @Override
            public final java.lang.String getSnapshotPolicy() {
                return this.snapshotPolicy;
            }

            @Override
            public final java.lang.String getStorageEfficiencyEnabled() {
                return this.storageEfficiencyEnabled;
            }

            @Override
            public final java.lang.Object getTieringPolicy() {
                return this.tieringPolicy;
            }

            @Override
            public final java.lang.String getVolumeStyle() {
                return this.volumeStyle;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("storageVirtualMachineId", om.valueToTree(this.getStorageVirtualMachineId()));
                if (this.getAggregateConfiguration() != null) {
                    data.set("aggregateConfiguration", om.valueToTree(this.getAggregateConfiguration()));
                }
                if (this.getCopyTagsToBackups() != null) {
                    data.set("copyTagsToBackups", om.valueToTree(this.getCopyTagsToBackups()));
                }
                if (this.getJunctionPath() != null) {
                    data.set("junctionPath", om.valueToTree(this.getJunctionPath()));
                }
                if (this.getOntapVolumeType() != null) {
                    data.set("ontapVolumeType", om.valueToTree(this.getOntapVolumeType()));
                }
                if (this.getSecurityStyle() != null) {
                    data.set("securityStyle", om.valueToTree(this.getSecurityStyle()));
                }
                if (this.getSizeInBytes() != null) {
                    data.set("sizeInBytes", om.valueToTree(this.getSizeInBytes()));
                }
                if (this.getSizeInMegabytes() != null) {
                    data.set("sizeInMegabytes", om.valueToTree(this.getSizeInMegabytes()));
                }
                if (this.getSnaplockConfiguration() != null) {
                    data.set("snaplockConfiguration", om.valueToTree(this.getSnaplockConfiguration()));
                }
                if (this.getSnapshotPolicy() != null) {
                    data.set("snapshotPolicy", om.valueToTree(this.getSnapshotPolicy()));
                }
                if (this.getStorageEfficiencyEnabled() != null) {
                    data.set("storageEfficiencyEnabled", om.valueToTree(this.getStorageEfficiencyEnabled()));
                }
                if (this.getTieringPolicy() != null) {
                    data.set("tieringPolicy", om.valueToTree(this.getTieringPolicy()));
                }
                if (this.getVolumeStyle() != null) {
                    data.set("volumeStyle", om.valueToTree(this.getVolumeStyle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.OntapConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OntapConfigurationProperty.Jsii$Proxy that = (OntapConfigurationProperty.Jsii$Proxy) o;

                if (!storageVirtualMachineId.equals(that.storageVirtualMachineId)) return false;
                if (this.aggregateConfiguration != null ? !this.aggregateConfiguration.equals(that.aggregateConfiguration) : that.aggregateConfiguration != null) return false;
                if (this.copyTagsToBackups != null ? !this.copyTagsToBackups.equals(that.copyTagsToBackups) : that.copyTagsToBackups != null) return false;
                if (this.junctionPath != null ? !this.junctionPath.equals(that.junctionPath) : that.junctionPath != null) return false;
                if (this.ontapVolumeType != null ? !this.ontapVolumeType.equals(that.ontapVolumeType) : that.ontapVolumeType != null) return false;
                if (this.securityStyle != null ? !this.securityStyle.equals(that.securityStyle) : that.securityStyle != null) return false;
                if (this.sizeInBytes != null ? !this.sizeInBytes.equals(that.sizeInBytes) : that.sizeInBytes != null) return false;
                if (this.sizeInMegabytes != null ? !this.sizeInMegabytes.equals(that.sizeInMegabytes) : that.sizeInMegabytes != null) return false;
                if (this.snaplockConfiguration != null ? !this.snaplockConfiguration.equals(that.snaplockConfiguration) : that.snaplockConfiguration != null) return false;
                if (this.snapshotPolicy != null ? !this.snapshotPolicy.equals(that.snapshotPolicy) : that.snapshotPolicy != null) return false;
                if (this.storageEfficiencyEnabled != null ? !this.storageEfficiencyEnabled.equals(that.storageEfficiencyEnabled) : that.storageEfficiencyEnabled != null) return false;
                if (this.tieringPolicy != null ? !this.tieringPolicy.equals(that.tieringPolicy) : that.tieringPolicy != null) return false;
                return this.volumeStyle != null ? this.volumeStyle.equals(that.volumeStyle) : that.volumeStyle == null;
            }

            @Override
            public final int hashCode() {
                int result = this.storageVirtualMachineId.hashCode();
                result = 31 * result + (this.aggregateConfiguration != null ? this.aggregateConfiguration.hashCode() : 0);
                result = 31 * result + (this.copyTagsToBackups != null ? this.copyTagsToBackups.hashCode() : 0);
                result = 31 * result + (this.junctionPath != null ? this.junctionPath.hashCode() : 0);
                result = 31 * result + (this.ontapVolumeType != null ? this.ontapVolumeType.hashCode() : 0);
                result = 31 * result + (this.securityStyle != null ? this.securityStyle.hashCode() : 0);
                result = 31 * result + (this.sizeInBytes != null ? this.sizeInBytes.hashCode() : 0);
                result = 31 * result + (this.sizeInMegabytes != null ? this.sizeInMegabytes.hashCode() : 0);
                result = 31 * result + (this.snaplockConfiguration != null ? this.snaplockConfiguration.hashCode() : 0);
                result = 31 * result + (this.snapshotPolicy != null ? this.snapshotPolicy.hashCode() : 0);
                result = 31 * result + (this.storageEfficiencyEnabled != null ? this.storageEfficiencyEnabled.hashCode() : 0);
                result = 31 * result + (this.tieringPolicy != null ? this.tieringPolicy.hashCode() : 0);
                result = 31 * result + (this.volumeStyle != null ? this.volumeStyle.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of the Amazon FSx for OpenZFS volume that you are creating.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * OpenZFSConfigurationProperty openZFSConfigurationProperty = OpenZFSConfigurationProperty.builder()
     *         .parentVolumeId("parentVolumeId")
     *         // the properties below are optional
     *         .copyTagsToSnapshots(false)
     *         .dataCompressionType("dataCompressionType")
     *         .nfsExports(List.of(NfsExportsProperty.builder()
     *                 .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
     *                         .clients("clients")
     *                         .options(List.of("options"))
     *                         .build()))
     *                 .build()))
     *         .options(List.of("options"))
     *         .originSnapshot(OriginSnapshotProperty.builder()
     *                 .copyStrategy("copyStrategy")
     *                 .snapshotArn("snapshotArn")
     *                 .build())
     *         .readOnly(false)
     *         .recordSizeKiB(123)
     *         .storageCapacityQuotaGiB(123)
     *         .storageCapacityReservationGiB(123)
     *         .userAndGroupQuotas(List.of(UserAndGroupQuotasProperty.builder()
     *                 .id(123)
     *                 .storageCapacityQuotaGiB(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.OpenZFSConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenZFSConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenZFSConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the volume to use as the parent volume of the volume that you are creating.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-parentvolumeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-parentvolumeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParentVolumeId();

        /**
         * A Boolean value indicating whether tags for the volume should be copied to snapshots.
         * <p>
         * This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-copytagstosnapshots">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-copytagstosnapshots</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshots() {
            return null;
        }

        /**
         * Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by default.
         * <p>
         * <ul>
         * <li><code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.</li>
         * <li><code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.</li>
         * <li><code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-datacompressiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-datacompressiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataCompressionType() {
            return null;
        }

        /**
         * The configuration object for mounting a Network File System (NFS) file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-nfsexports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-nfsexports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNfsExports() {
            return null;
        }

        /**
         * To delete the volume's child volumes, snapshots, and clones, use the string <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOptions() {
            return null;
        }

        /**
         * The configuration object that specifies the snapshot to use as the origin of the data for the volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-originsnapshot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-originsnapshot</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOriginSnapshot() {
            return null;
        }

        /**
         * A Boolean value indicating whether the volume is read-only.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-readonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-readonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * Specifies the suggested block size for a volume in a ZFS dataset, in kibibytes (KiB).
         * <p>
         * For file systems using the Intelligent-Tiering storage class, valid values are 128, 256, 512, 1024, 2048, or 4096 KiB, with a default of 1024 KiB. For all other file systems, valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB, with a default of 128 KiB. We recommend using the default setting for the majority of use cases. Generally, workloads that write in fixed small or large record sizes may benefit from setting a custom record size, like database workloads (small record size) or media streaming workloads (large record size). For additional guidance on when to set a custom record size, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#record-size-performance">ZFS Record size</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-recordsizekib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-recordsizekib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRecordSizeKiB() {
            return null;
        }

        /**
         * Sets the maximum storage size in gibibytes (GiB) for the volume.
         * <p>
         * You can specify a quota that is larger than the storage on the parent volume. A volume quota limits the amount of storage that the volume can consume to the configured amount, but does not guarantee the space will be available on the parent volume. To guarantee quota space, you must also set <code>StorageCapacityReservationGiB</code> . To <em>not</em> specify a storage capacity quota, set this to <code>-1</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume properties</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-storagecapacityquotagib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-storagecapacityquotagib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStorageCapacityQuotaGiB() {
            return null;
        }

        /**
         * Specifies the amount of storage in gibibytes (GiB) to reserve from the parent volume.
         * <p>
         * Setting <code>StorageCapacityReservationGiB</code> guarantees that the specified amount of storage space on the parent volume will always be available for the volume. You can't reserve more storage than the parent volume has. To <em>not</em> specify a storage capacity reservation, set this to <code>0</code> or <code>-1</code> . For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume properties</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-storagecapacityreservationgib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-storagecapacityreservationgib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStorageCapacityReservationGiB() {
            return null;
        }

        /**
         * Configures how much storage users and groups can use on the volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-userandgroupquotas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-openzfsconfiguration.html#cfn-fsx-volume-openzfsconfiguration-userandgroupquotas</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserAndGroupQuotas() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenZFSConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenZFSConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenZFSConfigurationProperty> {
            java.lang.String parentVolumeId;
            java.lang.Object copyTagsToSnapshots;
            java.lang.String dataCompressionType;
            java.lang.Object nfsExports;
            java.util.List<java.lang.String> options;
            java.lang.Object originSnapshot;
            java.lang.Object readOnly;
            java.lang.Number recordSizeKiB;
            java.lang.Number storageCapacityQuotaGiB;
            java.lang.Number storageCapacityReservationGiB;
            java.lang.Object userAndGroupQuotas;

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getParentVolumeId}
             * @param parentVolumeId The ID of the volume to use as the parent volume of the volume that you are creating. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parentVolumeId(java.lang.String parentVolumeId) {
                this.parentVolumeId = parentVolumeId;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getCopyTagsToSnapshots}
             * @param copyTagsToSnapshots A Boolean value indicating whether tags for the volume should be copied to snapshots.
             *                            This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToSnapshots(java.lang.Boolean copyTagsToSnapshots) {
                this.copyTagsToSnapshots = copyTagsToSnapshots;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getCopyTagsToSnapshots}
             * @param copyTagsToSnapshots A Boolean value indicating whether tags for the volume should be copied to snapshots.
             *                            This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToSnapshots(software.amazon.awscdk.IResolvable copyTagsToSnapshots) {
                this.copyTagsToSnapshots = copyTagsToSnapshots;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getDataCompressionType}
             * @param dataCompressionType Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by default.
             *                            <ul>
             *                            <li><code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.</li>
             *                            <li><code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.</li>
             *                            <li><code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCompressionType(java.lang.String dataCompressionType) {
                this.dataCompressionType = dataCompressionType;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getNfsExports}
             * @param nfsExports The configuration object for mounting a Network File System (NFS) file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nfsExports(software.amazon.awscdk.IResolvable nfsExports) {
                this.nfsExports = nfsExports;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getNfsExports}
             * @param nfsExports The configuration object for mounting a Network File System (NFS) file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nfsExports(java.util.List<? extends java.lang.Object> nfsExports) {
                this.nfsExports = nfsExports;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getOptions}
             * @param options To delete the volume's child volumes, snapshots, and clones, use the string <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<java.lang.String> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getOriginSnapshot}
             * @param originSnapshot The configuration object that specifies the snapshot to use as the origin of the data for the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originSnapshot(software.amazon.awscdk.IResolvable originSnapshot) {
                this.originSnapshot = originSnapshot;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getOriginSnapshot}
             * @param originSnapshot The configuration object that specifies the snapshot to use as the origin of the data for the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originSnapshot(software.amazon.awscdk.services.fsx.CfnVolume.OriginSnapshotProperty originSnapshot) {
                this.originSnapshot = originSnapshot;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getReadOnly}
             * @param readOnly A Boolean value indicating whether the volume is read-only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getReadOnly}
             * @param readOnly A Boolean value indicating whether the volume is read-only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getRecordSizeKiB}
             * @param recordSizeKiB Specifies the suggested block size for a volume in a ZFS dataset, in kibibytes (KiB).
             *                      For file systems using the Intelligent-Tiering storage class, valid values are 128, 256, 512, 1024, 2048, or 4096 KiB, with a default of 1024 KiB. For all other file systems, valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB, with a default of 128 KiB. We recommend using the default setting for the majority of use cases. Generally, workloads that write in fixed small or large record sizes may benefit from setting a custom record size, like database workloads (small record size) or media streaming workloads (large record size). For additional guidance on when to set a custom record size, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#record-size-performance">ZFS Record size</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordSizeKiB(java.lang.Number recordSizeKiB) {
                this.recordSizeKiB = recordSizeKiB;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getStorageCapacityQuotaGiB}
             * @param storageCapacityQuotaGiB Sets the maximum storage size in gibibytes (GiB) for the volume.
             *                                You can specify a quota that is larger than the storage on the parent volume. A volume quota limits the amount of storage that the volume can consume to the configured amount, but does not guarantee the space will be available on the parent volume. To guarantee quota space, you must also set <code>StorageCapacityReservationGiB</code> . To <em>not</em> specify a storage capacity quota, set this to <code>-1</code> .
             *                                <p>
             *                                For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume properties</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageCapacityQuotaGiB(java.lang.Number storageCapacityQuotaGiB) {
                this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getStorageCapacityReservationGiB}
             * @param storageCapacityReservationGiB Specifies the amount of storage in gibibytes (GiB) to reserve from the parent volume.
             *                                      Setting <code>StorageCapacityReservationGiB</code> guarantees that the specified amount of storage space on the parent volume will always be available for the volume. You can't reserve more storage than the parent volume has. To <em>not</em> specify a storage capacity reservation, set this to <code>0</code> or <code>-1</code> . For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume properties</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageCapacityReservationGiB(java.lang.Number storageCapacityReservationGiB) {
                this.storageCapacityReservationGiB = storageCapacityReservationGiB;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getUserAndGroupQuotas}
             * @param userAndGroupQuotas Configures how much storage users and groups can use on the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userAndGroupQuotas(software.amazon.awscdk.IResolvable userAndGroupQuotas) {
                this.userAndGroupQuotas = userAndGroupQuotas;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getUserAndGroupQuotas}
             * @param userAndGroupQuotas Configures how much storage users and groups can use on the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userAndGroupQuotas(java.util.List<? extends java.lang.Object> userAndGroupQuotas) {
                this.userAndGroupQuotas = userAndGroupQuotas;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenZFSConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenZFSConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenZFSConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenZFSConfigurationProperty {
            private final java.lang.String parentVolumeId;
            private final java.lang.Object copyTagsToSnapshots;
            private final java.lang.String dataCompressionType;
            private final java.lang.Object nfsExports;
            private final java.util.List<java.lang.String> options;
            private final java.lang.Object originSnapshot;
            private final java.lang.Object readOnly;
            private final java.lang.Number recordSizeKiB;
            private final java.lang.Number storageCapacityQuotaGiB;
            private final java.lang.Number storageCapacityReservationGiB;
            private final java.lang.Object userAndGroupQuotas;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parentVolumeId = software.amazon.jsii.Kernel.get(this, "parentVolumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.copyTagsToSnapshots = software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshots", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataCompressionType = software.amazon.jsii.Kernel.get(this, "dataCompressionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nfsExports = software.amazon.jsii.Kernel.get(this, "nfsExports", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.originSnapshot = software.amazon.jsii.Kernel.get(this, "originSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordSizeKiB = software.amazon.jsii.Kernel.get(this, "recordSizeKiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.storageCapacityQuotaGiB = software.amazon.jsii.Kernel.get(this, "storageCapacityQuotaGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.storageCapacityReservationGiB = software.amazon.jsii.Kernel.get(this, "storageCapacityReservationGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.userAndGroupQuotas = software.amazon.jsii.Kernel.get(this, "userAndGroupQuotas", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parentVolumeId = java.util.Objects.requireNonNull(builder.parentVolumeId, "parentVolumeId is required");
                this.copyTagsToSnapshots = builder.copyTagsToSnapshots;
                this.dataCompressionType = builder.dataCompressionType;
                this.nfsExports = builder.nfsExports;
                this.options = builder.options;
                this.originSnapshot = builder.originSnapshot;
                this.readOnly = builder.readOnly;
                this.recordSizeKiB = builder.recordSizeKiB;
                this.storageCapacityQuotaGiB = builder.storageCapacityQuotaGiB;
                this.storageCapacityReservationGiB = builder.storageCapacityReservationGiB;
                this.userAndGroupQuotas = builder.userAndGroupQuotas;
            }

            @Override
            public final java.lang.String getParentVolumeId() {
                return this.parentVolumeId;
            }

            @Override
            public final java.lang.Object getCopyTagsToSnapshots() {
                return this.copyTagsToSnapshots;
            }

            @Override
            public final java.lang.String getDataCompressionType() {
                return this.dataCompressionType;
            }

            @Override
            public final java.lang.Object getNfsExports() {
                return this.nfsExports;
            }

            @Override
            public final java.util.List<java.lang.String> getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getOriginSnapshot() {
                return this.originSnapshot;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            public final java.lang.Number getRecordSizeKiB() {
                return this.recordSizeKiB;
            }

            @Override
            public final java.lang.Number getStorageCapacityQuotaGiB() {
                return this.storageCapacityQuotaGiB;
            }

            @Override
            public final java.lang.Number getStorageCapacityReservationGiB() {
                return this.storageCapacityReservationGiB;
            }

            @Override
            public final java.lang.Object getUserAndGroupQuotas() {
                return this.userAndGroupQuotas;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parentVolumeId", om.valueToTree(this.getParentVolumeId()));
                if (this.getCopyTagsToSnapshots() != null) {
                    data.set("copyTagsToSnapshots", om.valueToTree(this.getCopyTagsToSnapshots()));
                }
                if (this.getDataCompressionType() != null) {
                    data.set("dataCompressionType", om.valueToTree(this.getDataCompressionType()));
                }
                if (this.getNfsExports() != null) {
                    data.set("nfsExports", om.valueToTree(this.getNfsExports()));
                }
                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }
                if (this.getOriginSnapshot() != null) {
                    data.set("originSnapshot", om.valueToTree(this.getOriginSnapshot()));
                }
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }
                if (this.getRecordSizeKiB() != null) {
                    data.set("recordSizeKiB", om.valueToTree(this.getRecordSizeKiB()));
                }
                if (this.getStorageCapacityQuotaGiB() != null) {
                    data.set("storageCapacityQuotaGiB", om.valueToTree(this.getStorageCapacityQuotaGiB()));
                }
                if (this.getStorageCapacityReservationGiB() != null) {
                    data.set("storageCapacityReservationGiB", om.valueToTree(this.getStorageCapacityReservationGiB()));
                }
                if (this.getUserAndGroupQuotas() != null) {
                    data.set("userAndGroupQuotas", om.valueToTree(this.getUserAndGroupQuotas()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.OpenZFSConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenZFSConfigurationProperty.Jsii$Proxy that = (OpenZFSConfigurationProperty.Jsii$Proxy) o;

                if (!parentVolumeId.equals(that.parentVolumeId)) return false;
                if (this.copyTagsToSnapshots != null ? !this.copyTagsToSnapshots.equals(that.copyTagsToSnapshots) : that.copyTagsToSnapshots != null) return false;
                if (this.dataCompressionType != null ? !this.dataCompressionType.equals(that.dataCompressionType) : that.dataCompressionType != null) return false;
                if (this.nfsExports != null ? !this.nfsExports.equals(that.nfsExports) : that.nfsExports != null) return false;
                if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
                if (this.originSnapshot != null ? !this.originSnapshot.equals(that.originSnapshot) : that.originSnapshot != null) return false;
                if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
                if (this.recordSizeKiB != null ? !this.recordSizeKiB.equals(that.recordSizeKiB) : that.recordSizeKiB != null) return false;
                if (this.storageCapacityQuotaGiB != null ? !this.storageCapacityQuotaGiB.equals(that.storageCapacityQuotaGiB) : that.storageCapacityQuotaGiB != null) return false;
                if (this.storageCapacityReservationGiB != null ? !this.storageCapacityReservationGiB.equals(that.storageCapacityReservationGiB) : that.storageCapacityReservationGiB != null) return false;
                return this.userAndGroupQuotas != null ? this.userAndGroupQuotas.equals(that.userAndGroupQuotas) : that.userAndGroupQuotas == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parentVolumeId.hashCode();
                result = 31 * result + (this.copyTagsToSnapshots != null ? this.copyTagsToSnapshots.hashCode() : 0);
                result = 31 * result + (this.dataCompressionType != null ? this.dataCompressionType.hashCode() : 0);
                result = 31 * result + (this.nfsExports != null ? this.nfsExports.hashCode() : 0);
                result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
                result = 31 * result + (this.originSnapshot != null ? this.originSnapshot.hashCode() : 0);
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                result = 31 * result + (this.recordSizeKiB != null ? this.recordSizeKiB.hashCode() : 0);
                result = 31 * result + (this.storageCapacityQuotaGiB != null ? this.storageCapacityQuotaGiB.hashCode() : 0);
                result = 31 * result + (this.storageCapacityReservationGiB != null ? this.storageCapacityReservationGiB.hashCode() : 0);
                result = 31 * result + (this.userAndGroupQuotas != null ? this.userAndGroupQuotas.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration object that specifies the snapshot to use as the origin of the data for the volume.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * OriginSnapshotProperty originSnapshotProperty = OriginSnapshotProperty.builder()
     *         .copyStrategy("copyStrategy")
     *         .snapshotArn("snapshotArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-originsnapshot.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-originsnapshot.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.OriginSnapshotProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginSnapshotProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginSnapshotProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the strategy used when copying data from the snapshot to the new volume.
         * <p>
         * <ul>
         * <li><code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than copying data from the snapshot to a new volume and doesn't consume disk throughput. However, the origin snapshot can't be deleted if there is a volume using its copied data.</li>
         * <li><code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.</li>
         * </ul>
         * <p>
         * Specify this option to create the volume from a snapshot on another FSx for OpenZFS file system.
         * <p>
         * <blockquote>
         * <p>
         * The <code>INCREMENTAL_COPY</code> option is only for updating an existing volume by using a snapshot from another FSx for OpenZFS file system. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_CopySnapshotAndUpdateVolume.html">CopySnapshotAndUpdateVolume</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-originsnapshot.html#cfn-fsx-volume-originsnapshot-copystrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-originsnapshot.html#cfn-fsx-volume-originsnapshot-copystrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCopyStrategy();

        /**
         * Specifies the snapshot to use when creating an OpenZFS volume from a snapshot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-originsnapshot.html#cfn-fsx-volume-originsnapshot-snapshotarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-originsnapshot.html#cfn-fsx-volume-originsnapshot-snapshotarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSnapshotArn();

        /**
         * @return a {@link Builder} of {@link OriginSnapshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginSnapshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginSnapshotProperty> {
            java.lang.String copyStrategy;
            java.lang.String snapshotArn;

            /**
             * Sets the value of {@link OriginSnapshotProperty#getCopyStrategy}
             * @param copyStrategy Specifies the strategy used when copying data from the snapshot to the new volume. This parameter is required.
             *                     <ul>
             *                     <li><code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than copying data from the snapshot to a new volume and doesn't consume disk throughput. However, the origin snapshot can't be deleted if there is a volume using its copied data.</li>
             *                     <li><code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.</li>
             *                     </ul>
             *                     <p>
             *                     Specify this option to create the volume from a snapshot on another FSx for OpenZFS file system.
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     The <code>INCREMENTAL_COPY</code> option is only for updating an existing volume by using a snapshot from another FSx for OpenZFS file system. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_CopySnapshotAndUpdateVolume.html">CopySnapshotAndUpdateVolume</a> .
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyStrategy(java.lang.String copyStrategy) {
                this.copyStrategy = copyStrategy;
                return this;
            }

            /**
             * Sets the value of {@link OriginSnapshotProperty#getSnapshotArn}
             * @param snapshotArn Specifies the snapshot to use when creating an OpenZFS volume from a snapshot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotArn(java.lang.String snapshotArn) {
                this.snapshotArn = snapshotArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginSnapshotProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginSnapshotProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginSnapshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginSnapshotProperty {
            private final java.lang.String copyStrategy;
            private final java.lang.String snapshotArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.copyStrategy = software.amazon.jsii.Kernel.get(this, "copyStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotArn = software.amazon.jsii.Kernel.get(this, "snapshotArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.copyStrategy = java.util.Objects.requireNonNull(builder.copyStrategy, "copyStrategy is required");
                this.snapshotArn = java.util.Objects.requireNonNull(builder.snapshotArn, "snapshotArn is required");
            }

            @Override
            public final java.lang.String getCopyStrategy() {
                return this.copyStrategy;
            }

            @Override
            public final java.lang.String getSnapshotArn() {
                return this.snapshotArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("copyStrategy", om.valueToTree(this.getCopyStrategy()));
                data.set("snapshotArn", om.valueToTree(this.getSnapshotArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.OriginSnapshotProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginSnapshotProperty.Jsii$Proxy that = (OriginSnapshotProperty.Jsii$Proxy) o;

                if (!copyStrategy.equals(that.copyStrategy)) return false;
                return this.snapshotArn.equals(that.snapshotArn);
            }

            @Override
            public final int hashCode() {
                int result = this.copyStrategy.hashCode();
                result = 31 * result + (this.snapshotArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the retention period of an FSx for ONTAP SnapLock volume.
     * <p>
     * After it is set, it can't be changed. Files can't be deleted or modified during the retention period.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-retention.html">Working with the retention period in SnapLock</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * RetentionPeriodProperty retentionPeriodProperty = RetentionPeriodProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-retentionperiod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-retentionperiod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.RetentionPeriodProperty")
    @software.amazon.jsii.Jsii.Proxy(RetentionPeriodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetentionPeriodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume.
         * <p>
         * Set it to one of the valid types. If you set it to <code>INFINITE</code> , the files are retained forever. If you set it to <code>UNSPECIFIED</code> , the files are retained until you set an explicit retention period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-retentionperiod.html#cfn-fsx-volume-retentionperiod-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-retentionperiod.html#cfn-fsx-volume-retentionperiod-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Defines the amount of time for the retention period of an FSx for ONTAP SnapLock volume.
         * <p>
         * You can't set a value for <code>INFINITE</code> or <code>UNSPECIFIED</code> . For all other options, the following ranges are valid:
         * <p>
         * <ul>
         * <li><code>Seconds</code> : 0 - 65,535</li>
         * <li><code>Minutes</code> : 0 - 65,535</li>
         * <li><code>Hours</code> : 0 - 24</li>
         * <li><code>Days</code> : 0 - 365</li>
         * <li><code>Months</code> : 0 - 12</li>
         * <li><code>Years</code> : 0 - 100</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-retentionperiod.html#cfn-fsx-volume-retentionperiod-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-retentionperiod.html#cfn-fsx-volume-retentionperiod-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetentionPeriodProperty> {
            java.lang.String type;
            java.lang.Number value;

            /**
             * Sets the value of {@link RetentionPeriodProperty#getType}
             * @param type Defines the type of time for the retention period of an FSx for ONTAP SnapLock volume. This parameter is required.
             *             Set it to one of the valid types. If you set it to <code>INFINITE</code> , the files are retained forever. If you set it to <code>UNSPECIFIED</code> , the files are retained until you set an explicit retention period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link RetentionPeriodProperty#getValue}
             * @param value Defines the amount of time for the retention period of an FSx for ONTAP SnapLock volume.
             *              You can't set a value for <code>INFINITE</code> or <code>UNSPECIFIED</code> . For all other options, the following ranges are valid:
             *              <p>
             *              <ul>
             *              <li><code>Seconds</code> : 0 - 65,535</li>
             *              <li><code>Minutes</code> : 0 - 65,535</li>
             *              <li><code>Hours</code> : 0 - 24</li>
             *              <li><code>Days</code> : 0 - 365</li>
             *              <li><code>Months</code> : 0 - 12</li>
             *              <li><code>Years</code> : 0 - 100</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetentionPeriodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetentionPeriodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetentionPeriodProperty {
            private final java.lang.String type;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.RetentionPeriodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetentionPeriodProperty.Jsii$Proxy that = (RetentionPeriodProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the SnapLock configuration for an FSx for ONTAP SnapLock volume.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * SnaplockConfigurationProperty snaplockConfigurationProperty = SnaplockConfigurationProperty.builder()
     *         .snaplockType("snaplockType")
     *         // the properties below are optional
     *         .auditLogVolume("auditLogVolume")
     *         .autocommitPeriod(AutocommitPeriodProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .value(123)
     *                 .build())
     *         .privilegedDelete("privilegedDelete")
     *         .retentionPeriod(SnaplockRetentionPeriodProperty.builder()
     *                 .defaultRetention(RetentionPeriodProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .value(123)
     *                         .build())
     *                 .maximumRetention(RetentionPeriodProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .value(123)
     *                         .build())
     *                 .minimumRetention(RetentionPeriodProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .value(123)
     *                         .build())
     *                 .build())
     *         .volumeAppendModeEnabled("volumeAppendModeEnabled")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.SnaplockConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SnaplockConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnaplockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the retention mode of an FSx for ONTAP SnapLock volume.
         * <p>
         * After it is set, it can't be changed. You can choose one of the following retention modes:
         * <p>
         * <ul>
         * <li><code>COMPLIANCE</code> : Files transitioned to write once, read many (WORM) on a Compliance volume can't be deleted until their retention periods expire. This retention mode is used to address government or industry-specific mandates or to protect against ransomware attacks. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html">SnapLock Compliance</a> .</li>
         * <li><code>ENTERPRISE</code> : Files transitioned to WORM on an Enterprise volume can be deleted by authorized users before their retention periods expire using privileged delete. This retention mode is used to advance an organization's data integrity and internal compliance or to test retention settings before using SnapLock Compliance. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html">SnapLock Enterprise</a> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-snaplocktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-snaplocktype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSnaplockType();

        /**
         * Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume.
         * <p>
         * The default value is <code>false</code> . If you set <code>AuditLogVolume</code> to <code>true</code> , the SnapLock volume is created as an audit log volume. The minimum retention period for an audit log volume is six months.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume">SnapLock audit log volumes</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-auditlogvolume">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-auditlogvolume</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuditLogVolume() {
            return null;
        }

        /**
         * The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-autocommitperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-autocommitperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutocommitPeriod() {
            return null;
        }

        /**
         * Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume.
         * <p>
         * Enabling privileged delete allows SnapLock administrators to delete write once, read many (WORM) files even if they have active retention periods. <code>PERMANENTLY_DISABLED</code> is a terminal state. If privileged delete is permanently disabled on a SnapLock volume, you can't re-enable it. The default value is <code>DISABLED</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete">Privileged delete</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-privilegeddelete">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-privilegeddelete</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivilegedDelete() {
            return null;
        }

        /**
         * Specifies the retention period of an FSx for ONTAP SnapLock volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-retentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-retentionperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetentionPeriod() {
            return null;
        }

        /**
         * Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume.
         * <p>
         * Volume-append mode allows you to create WORM-appendable files and write data to them incrementally. The default value is <code>false</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append">Volume-append mode</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-volumeappendmodeenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockconfiguration.html#cfn-fsx-volume-snaplockconfiguration-volumeappendmodeenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeAppendModeEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnaplockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnaplockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnaplockConfigurationProperty> {
            java.lang.String snaplockType;
            java.lang.String auditLogVolume;
            java.lang.Object autocommitPeriod;
            java.lang.String privilegedDelete;
            java.lang.Object retentionPeriod;
            java.lang.String volumeAppendModeEnabled;

            /**
             * Sets the value of {@link SnaplockConfigurationProperty#getSnaplockType}
             * @param snaplockType Specifies the retention mode of an FSx for ONTAP SnapLock volume. This parameter is required.
             *                     After it is set, it can't be changed. You can choose one of the following retention modes:
             *                     <p>
             *                     <ul>
             *                     <li><code>COMPLIANCE</code> : Files transitioned to write once, read many (WORM) on a Compliance volume can't be deleted until their retention periods expire. This retention mode is used to address government or industry-specific mandates or to protect against ransomware attacks. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html">SnapLock Compliance</a> .</li>
             *                     <li><code>ENTERPRISE</code> : Files transitioned to WORM on an Enterprise volume can be deleted by authorized users before their retention periods expire using privileged delete. This retention mode is used to advance an organization's data integrity and internal compliance or to test retention settings before using SnapLock Compliance. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html">SnapLock Enterprise</a> .</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snaplockType(java.lang.String snaplockType) {
                this.snaplockType = snaplockType;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockConfigurationProperty#getAuditLogVolume}
             * @param auditLogVolume Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume.
             *                       The default value is <code>false</code> . If you set <code>AuditLogVolume</code> to <code>true</code> , the SnapLock volume is created as an audit log volume. The minimum retention period for an audit log volume is six months.
             *                       <p>
             *                       For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume">SnapLock audit log volumes</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auditLogVolume(java.lang.String auditLogVolume) {
                this.auditLogVolume = auditLogVolume;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockConfigurationProperty#getAutocommitPeriod}
             * @param autocommitPeriod The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autocommitPeriod(software.amazon.awscdk.IResolvable autocommitPeriod) {
                this.autocommitPeriod = autocommitPeriod;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockConfigurationProperty#getAutocommitPeriod}
             * @param autocommitPeriod The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autocommitPeriod(software.amazon.awscdk.services.fsx.CfnVolume.AutocommitPeriodProperty autocommitPeriod) {
                this.autocommitPeriod = autocommitPeriod;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockConfigurationProperty#getPrivilegedDelete}
             * @param privilegedDelete Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume.
             *                         Enabling privileged delete allows SnapLock administrators to delete write once, read many (WORM) files even if they have active retention periods. <code>PERMANENTLY_DISABLED</code> is a terminal state. If privileged delete is permanently disabled on a SnapLock volume, you can't re-enable it. The default value is <code>DISABLED</code> .
             *                         <p>
             *                         For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete">Privileged delete</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privilegedDelete(java.lang.String privilegedDelete) {
                this.privilegedDelete = privilegedDelete;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockConfigurationProperty#getRetentionPeriod}
             * @param retentionPeriod Specifies the retention period of an FSx for ONTAP SnapLock volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retentionPeriod(software.amazon.awscdk.IResolvable retentionPeriod) {
                this.retentionPeriod = retentionPeriod;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockConfigurationProperty#getRetentionPeriod}
             * @param retentionPeriod Specifies the retention period of an FSx for ONTAP SnapLock volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retentionPeriod(software.amazon.awscdk.services.fsx.CfnVolume.SnaplockRetentionPeriodProperty retentionPeriod) {
                this.retentionPeriod = retentionPeriod;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockConfigurationProperty#getVolumeAppendModeEnabled}
             * @param volumeAppendModeEnabled Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume.
             *                                Volume-append mode allows you to create WORM-appendable files and write data to them incrementally. The default value is <code>false</code> .
             *                                <p>
             *                                For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append">Volume-append mode</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeAppendModeEnabled(java.lang.String volumeAppendModeEnabled) {
                this.volumeAppendModeEnabled = volumeAppendModeEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnaplockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnaplockConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnaplockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnaplockConfigurationProperty {
            private final java.lang.String snaplockType;
            private final java.lang.String auditLogVolume;
            private final java.lang.Object autocommitPeriod;
            private final java.lang.String privilegedDelete;
            private final java.lang.Object retentionPeriod;
            private final java.lang.String volumeAppendModeEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.snaplockType = software.amazon.jsii.Kernel.get(this, "snaplockType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.auditLogVolume = software.amazon.jsii.Kernel.get(this, "auditLogVolume", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.autocommitPeriod = software.amazon.jsii.Kernel.get(this, "autocommitPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privilegedDelete = software.amazon.jsii.Kernel.get(this, "privilegedDelete", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumeAppendModeEnabled = software.amazon.jsii.Kernel.get(this, "volumeAppendModeEnabled", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.snaplockType = java.util.Objects.requireNonNull(builder.snaplockType, "snaplockType is required");
                this.auditLogVolume = builder.auditLogVolume;
                this.autocommitPeriod = builder.autocommitPeriod;
                this.privilegedDelete = builder.privilegedDelete;
                this.retentionPeriod = builder.retentionPeriod;
                this.volumeAppendModeEnabled = builder.volumeAppendModeEnabled;
            }

            @Override
            public final java.lang.String getSnaplockType() {
                return this.snaplockType;
            }

            @Override
            public final java.lang.String getAuditLogVolume() {
                return this.auditLogVolume;
            }

            @Override
            public final java.lang.Object getAutocommitPeriod() {
                return this.autocommitPeriod;
            }

            @Override
            public final java.lang.String getPrivilegedDelete() {
                return this.privilegedDelete;
            }

            @Override
            public final java.lang.Object getRetentionPeriod() {
                return this.retentionPeriod;
            }

            @Override
            public final java.lang.String getVolumeAppendModeEnabled() {
                return this.volumeAppendModeEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("snaplockType", om.valueToTree(this.getSnaplockType()));
                if (this.getAuditLogVolume() != null) {
                    data.set("auditLogVolume", om.valueToTree(this.getAuditLogVolume()));
                }
                if (this.getAutocommitPeriod() != null) {
                    data.set("autocommitPeriod", om.valueToTree(this.getAutocommitPeriod()));
                }
                if (this.getPrivilegedDelete() != null) {
                    data.set("privilegedDelete", om.valueToTree(this.getPrivilegedDelete()));
                }
                if (this.getRetentionPeriod() != null) {
                    data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
                }
                if (this.getVolumeAppendModeEnabled() != null) {
                    data.set("volumeAppendModeEnabled", om.valueToTree(this.getVolumeAppendModeEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.SnaplockConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnaplockConfigurationProperty.Jsii$Proxy that = (SnaplockConfigurationProperty.Jsii$Proxy) o;

                if (!snaplockType.equals(that.snaplockType)) return false;
                if (this.auditLogVolume != null ? !this.auditLogVolume.equals(that.auditLogVolume) : that.auditLogVolume != null) return false;
                if (this.autocommitPeriod != null ? !this.autocommitPeriod.equals(that.autocommitPeriod) : that.autocommitPeriod != null) return false;
                if (this.privilegedDelete != null ? !this.privilegedDelete.equals(that.privilegedDelete) : that.privilegedDelete != null) return false;
                if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
                return this.volumeAppendModeEnabled != null ? this.volumeAppendModeEnabled.equals(that.volumeAppendModeEnabled) : that.volumeAppendModeEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.snaplockType.hashCode();
                result = 31 * result + (this.auditLogVolume != null ? this.auditLogVolume.hashCode() : 0);
                result = 31 * result + (this.autocommitPeriod != null ? this.autocommitPeriod.hashCode() : 0);
                result = 31 * result + (this.privilegedDelete != null ? this.privilegedDelete.hashCode() : 0);
                result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
                result = 31 * result + (this.volumeAppendModeEnabled != null ? this.volumeAppendModeEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration to set the retention period of an FSx for ONTAP SnapLock volume.
     * <p>
     * The retention period includes default, maximum, and minimum settings. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-retention.html">Working with the retention period in SnapLock</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * SnaplockRetentionPeriodProperty snaplockRetentionPeriodProperty = SnaplockRetentionPeriodProperty.builder()
     *         .defaultRetention(RetentionPeriodProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .value(123)
     *                 .build())
     *         .maximumRetention(RetentionPeriodProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .value(123)
     *                 .build())
     *         .minimumRetention(RetentionPeriodProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .value(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockretentionperiod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockretentionperiod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.SnaplockRetentionPeriodProperty")
    @software.amazon.jsii.Jsii.Proxy(SnaplockRetentionPeriodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnaplockRetentionPeriodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The retention period assigned to a write once, read many (WORM) file by default if an explicit retention period is not set for an FSx for ONTAP SnapLock volume.
         * <p>
         * The default retention period must be greater than or equal to the minimum retention period and less than or equal to the maximum retention period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockretentionperiod.html#cfn-fsx-volume-snaplockretentionperiod-defaultretention">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockretentionperiod.html#cfn-fsx-volume-snaplockretentionperiod-defaultretention</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultRetention();

        /**
         * The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockretentionperiod.html#cfn-fsx-volume-snaplockretentionperiod-maximumretention">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockretentionperiod.html#cfn-fsx-volume-snaplockretentionperiod-maximumretention</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMaximumRetention();

        /**
         * The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockretentionperiod.html#cfn-fsx-volume-snaplockretentionperiod-minimumretention">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-snaplockretentionperiod.html#cfn-fsx-volume-snaplockretentionperiod-minimumretention</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMinimumRetention();

        /**
         * @return a {@link Builder} of {@link SnaplockRetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnaplockRetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnaplockRetentionPeriodProperty> {
            java.lang.Object defaultRetention;
            java.lang.Object maximumRetention;
            java.lang.Object minimumRetention;

            /**
             * Sets the value of {@link SnaplockRetentionPeriodProperty#getDefaultRetention}
             * @param defaultRetention The retention period assigned to a write once, read many (WORM) file by default if an explicit retention period is not set for an FSx for ONTAP SnapLock volume. This parameter is required.
             *                         The default retention period must be greater than or equal to the minimum retention period and less than or equal to the maximum retention period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultRetention(software.amazon.awscdk.IResolvable defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockRetentionPeriodProperty#getDefaultRetention}
             * @param defaultRetention The retention period assigned to a write once, read many (WORM) file by default if an explicit retention period is not set for an FSx for ONTAP SnapLock volume. This parameter is required.
             *                         The default retention period must be greater than or equal to the minimum retention period and less than or equal to the maximum retention period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultRetention(software.amazon.awscdk.services.fsx.CfnVolume.RetentionPeriodProperty defaultRetention) {
                this.defaultRetention = defaultRetention;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockRetentionPeriodProperty#getMaximumRetention}
             * @param maximumRetention The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRetention(software.amazon.awscdk.IResolvable maximumRetention) {
                this.maximumRetention = maximumRetention;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockRetentionPeriodProperty#getMaximumRetention}
             * @param maximumRetention The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRetention(software.amazon.awscdk.services.fsx.CfnVolume.RetentionPeriodProperty maximumRetention) {
                this.maximumRetention = maximumRetention;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockRetentionPeriodProperty#getMinimumRetention}
             * @param minimumRetention The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumRetention(software.amazon.awscdk.IResolvable minimumRetention) {
                this.minimumRetention = minimumRetention;
                return this;
            }

            /**
             * Sets the value of {@link SnaplockRetentionPeriodProperty#getMinimumRetention}
             * @param minimumRetention The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumRetention(software.amazon.awscdk.services.fsx.CfnVolume.RetentionPeriodProperty minimumRetention) {
                this.minimumRetention = minimumRetention;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnaplockRetentionPeriodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnaplockRetentionPeriodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnaplockRetentionPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnaplockRetentionPeriodProperty {
            private final java.lang.Object defaultRetention;
            private final java.lang.Object maximumRetention;
            private final java.lang.Object minimumRetention;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultRetention = software.amazon.jsii.Kernel.get(this, "defaultRetention", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumRetention = software.amazon.jsii.Kernel.get(this, "maximumRetention", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.minimumRetention = software.amazon.jsii.Kernel.get(this, "minimumRetention", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultRetention = java.util.Objects.requireNonNull(builder.defaultRetention, "defaultRetention is required");
                this.maximumRetention = java.util.Objects.requireNonNull(builder.maximumRetention, "maximumRetention is required");
                this.minimumRetention = java.util.Objects.requireNonNull(builder.minimumRetention, "minimumRetention is required");
            }

            @Override
            public final java.lang.Object getDefaultRetention() {
                return this.defaultRetention;
            }

            @Override
            public final java.lang.Object getMaximumRetention() {
                return this.maximumRetention;
            }

            @Override
            public final java.lang.Object getMinimumRetention() {
                return this.minimumRetention;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultRetention", om.valueToTree(this.getDefaultRetention()));
                data.set("maximumRetention", om.valueToTree(this.getMaximumRetention()));
                data.set("minimumRetention", om.valueToTree(this.getMinimumRetention()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.SnaplockRetentionPeriodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnaplockRetentionPeriodProperty.Jsii$Proxy that = (SnaplockRetentionPeriodProperty.Jsii$Proxy) o;

                if (!defaultRetention.equals(that.defaultRetention)) return false;
                if (!maximumRetention.equals(that.maximumRetention)) return false;
                return this.minimumRetention.equals(that.minimumRetention);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultRetention.hashCode();
                result = 31 * result + (this.maximumRetention.hashCode());
                result = 31 * result + (this.minimumRetention.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes the data tiering policy for an ONTAP volume.
     * <p>
     * When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
     * <p>
     * Valid tiering policies are the following:
     * <p>
     * <ul>
     * <li><code>SNAPSHOT_ONLY</code> - (Default value) moves cold snapshots to the capacity pool storage tier.</li>
     * <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
     * <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
     * <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * TieringPolicyProperty tieringPolicyProperty = TieringPolicyProperty.builder()
     *         .coolingPeriod(123)
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-tieringpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-tieringpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.TieringPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(TieringPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TieringPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool.
         * <p>
         * Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code> tiering policies. Enter a whole number between 2 and 183. Default values are 31 days for <code>AUTO</code> and 2 days for <code>SNAPSHOT_ONLY</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-tieringpolicy.html#cfn-fsx-volume-tieringpolicy-coolingperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-tieringpolicy.html#cfn-fsx-volume-tieringpolicy-coolingperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCoolingPeriod() {
            return null;
        }

        /**
         * Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code> .
         * <p>
         * <ul>
         * <li><code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.</li>
         * <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
         * <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
         * <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-tieringpolicy.html#cfn-fsx-volume-tieringpolicy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-tieringpolicy.html#cfn-fsx-volume-tieringpolicy-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TieringPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TieringPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TieringPolicyProperty> {
            java.lang.Number coolingPeriod;
            java.lang.String name;

            /**
             * Sets the value of {@link TieringPolicyProperty#getCoolingPeriod}
             * @param coolingPeriod Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool.
             *                      Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code> tiering policies. Enter a whole number between 2 and 183. Default values are 31 days for <code>AUTO</code> and 2 days for <code>SNAPSHOT_ONLY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coolingPeriod(java.lang.Number coolingPeriod) {
                this.coolingPeriod = coolingPeriod;
                return this;
            }

            /**
             * Sets the value of {@link TieringPolicyProperty#getName}
             * @param name Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code> .
             *             <ul>
             *             <li><code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.</li>
             *             <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
             *             <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
             *             <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TieringPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TieringPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TieringPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TieringPolicyProperty {
            private final java.lang.Number coolingPeriod;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coolingPeriod = software.amazon.jsii.Kernel.get(this, "coolingPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coolingPeriod = builder.coolingPeriod;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Number getCoolingPeriod() {
                return this.coolingPeriod;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCoolingPeriod() != null) {
                    data.set("coolingPeriod", om.valueToTree(this.getCoolingPeriod()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.TieringPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TieringPolicyProperty.Jsii$Proxy that = (TieringPolicyProperty.Jsii$Proxy) o;

                if (this.coolingPeriod != null ? !this.coolingPeriod.equals(that.coolingPeriod) : that.coolingPeriod != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.coolingPeriod != null ? this.coolingPeriod.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures how much storage users and groups can use on the volume.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * UserAndGroupQuotasProperty userAndGroupQuotasProperty = UserAndGroupQuotasProperty.builder()
     *         .id(123)
     *         .storageCapacityQuotaGiB(123)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-userandgroupquotas.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-userandgroupquotas.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.UserAndGroupQuotasProperty")
    @software.amazon.jsii.Jsii.Proxy(UserAndGroupQuotasProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserAndGroupQuotasProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the user or group that the quota applies to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-userandgroupquotas.html#cfn-fsx-volume-userandgroupquotas-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-userandgroupquotas.html#cfn-fsx-volume-userandgroupquotas-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getId();

        /**
         * The user or group's storage quota, in gibibytes (GiB).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-userandgroupquotas.html#cfn-fsx-volume-userandgroupquotas-storagecapacityquotagib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-userandgroupquotas.html#cfn-fsx-volume-userandgroupquotas-storagecapacityquotagib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getStorageCapacityQuotaGiB();

        /**
         * Specifies whether the quota applies to a user or group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-userandgroupquotas.html#cfn-fsx-volume-userandgroupquotas-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-volume-userandgroupquotas.html#cfn-fsx-volume-userandgroupquotas-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link UserAndGroupQuotasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserAndGroupQuotasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserAndGroupQuotasProperty> {
            java.lang.Number id;
            java.lang.Number storageCapacityQuotaGiB;
            java.lang.String type;

            /**
             * Sets the value of {@link UserAndGroupQuotasProperty#getId}
             * @param id The ID of the user or group that the quota applies to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.Number id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link UserAndGroupQuotasProperty#getStorageCapacityQuotaGiB}
             * @param storageCapacityQuotaGiB The user or group's storage quota, in gibibytes (GiB). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageCapacityQuotaGiB(java.lang.Number storageCapacityQuotaGiB) {
                this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
                return this;
            }

            /**
             * Sets the value of {@link UserAndGroupQuotasProperty#getType}
             * @param type Specifies whether the quota applies to a user or group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserAndGroupQuotasProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserAndGroupQuotasProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserAndGroupQuotasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserAndGroupQuotasProperty {
            private final java.lang.Number id;
            private final java.lang.Number storageCapacityQuotaGiB;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.storageCapacityQuotaGiB = software.amazon.jsii.Kernel.get(this, "storageCapacityQuotaGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.storageCapacityQuotaGiB = java.util.Objects.requireNonNull(builder.storageCapacityQuotaGiB, "storageCapacityQuotaGiB is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Number getId() {
                return this.id;
            }

            @Override
            public final java.lang.Number getStorageCapacityQuotaGiB() {
                return this.storageCapacityQuotaGiB;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("storageCapacityQuotaGiB", om.valueToTree(this.getStorageCapacityQuotaGiB()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.UserAndGroupQuotasProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserAndGroupQuotasProperty.Jsii$Proxy that = (UserAndGroupQuotasProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!storageCapacityQuotaGiB.equals(that.storageCapacityQuotaGiB)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.storageCapacityQuotaGiB.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fsx.CfnVolume}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fsx.CfnVolume> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.fsx.CfnVolumeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.fsx.CfnVolumeProps.Builder();
        }

        /**
         * The name of the volume.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-name</a>
         * @param name The name of the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Specifies the ID of the volume backup to use to create a new volume.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-backupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-backupid</a>
         * @param backupId Specifies the ID of the volume backup to use to create a new volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupId(final java.lang.String backupId) {
            this.props.backupId(backupId);
            return this;
        }

        /**
         * The configuration of an Amazon FSx for NetApp ONTAP volume.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-ontapconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-ontapconfiguration</a>
         * @param ontapConfiguration The configuration of an Amazon FSx for NetApp ONTAP volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ontapConfiguration(final software.amazon.awscdk.IResolvable ontapConfiguration) {
            this.props.ontapConfiguration(ontapConfiguration);
            return this;
        }
        /**
         * The configuration of an Amazon FSx for NetApp ONTAP volume.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-ontapconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-ontapconfiguration</a>
         * @param ontapConfiguration The configuration of an Amazon FSx for NetApp ONTAP volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ontapConfiguration(final software.amazon.awscdk.services.fsx.CfnVolume.OntapConfigurationProperty ontapConfiguration) {
            this.props.ontapConfiguration(ontapConfiguration);
            return this;
        }

        /**
         * The configuration of an Amazon FSx for OpenZFS volume.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-openzfsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-openzfsconfiguration</a>
         * @param openZfsConfiguration The configuration of an Amazon FSx for OpenZFS volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(final software.amazon.awscdk.IResolvable openZfsConfiguration) {
            this.props.openZfsConfiguration(openZfsConfiguration);
            return this;
        }
        /**
         * The configuration of an Amazon FSx for OpenZFS volume.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-openzfsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-openzfsconfiguration</a>
         * @param openZfsConfiguration The configuration of an Amazon FSx for OpenZFS volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(final software.amazon.awscdk.services.fsx.CfnVolume.OpenZFSConfigurationProperty openZfsConfiguration) {
            this.props.openZfsConfiguration(openZfsConfiguration);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The type of the volume.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-volumetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-volumetype</a>
         * @param volumeType The type of the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeType(final java.lang.String volumeType) {
            this.props.volumeType(volumeType);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.fsx.CfnVolume}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fsx.CfnVolume build() {
            return new software.amazon.awscdk.services.fsx.CfnVolume(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
