package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a <code>CfnJobTemplate</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * Object abortConfig;
 * Object jobExecutionsRolloutConfig;
 * Object presignedUrlConfig;
 * Object timeoutConfig;
 * CfnJobTemplateProps cfnJobTemplateProps = CfnJobTemplateProps.builder()
 *         .description("description")
 *         .jobTemplateId("jobTemplateId")
 *         // the properties below are optional
 *         .abortConfig(abortConfig)
 *         .destinationPackageVersions(List.of("destinationPackageVersions"))
 *         .document("document")
 *         .documentSource("documentSource")
 *         .jobArn("jobArn")
 *         .jobExecutionsRetryConfig(JobExecutionsRetryConfigProperty.builder()
 *                 .retryCriteriaList(List.of(RetryCriteriaProperty.builder()
 *                         .failureType("failureType")
 *                         .numberOfRetries(123)
 *                         .build()))
 *                 .build())
 *         .jobExecutionsRolloutConfig(jobExecutionsRolloutConfig)
 *         .maintenanceWindows(List.of(MaintenanceWindowProperty.builder()
 *                 .durationInMinutes(123)
 *                 .startTime("startTime")
 *                 .build()))
 *         .presignedUrlConfig(presignedUrlConfig)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeoutConfig(timeoutConfig)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:34.452Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnJobTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnJobTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description of the job template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * A unique identifier for the job template.
     * <p>
     * We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobtemplateid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobtemplateid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobTemplateId();

    /**
     * The criteria that determine when and how a job abort takes place.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-abortconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-abortconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAbortConfig() {
        return null;
    }

    /**
     * The package version Amazon Resource Names (ARNs) that are installed on the device’s reserved named shadow ( <code>$package</code> ) when the job successfully completes.
     * <p>
     * <em>Note:</em> Up to 25 package version ARNS are allowed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-destinationpackageversions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-destinationpackageversions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDestinationPackageVersions() {
        return null;
    }

    /**
     * The job document.
     * <p>
     * Required if you don't specify a value for <code>documentSource</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-document">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-document</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDocument() {
        return null;
    }

    /**
     * An S3 link, or S3 object URL, to the job document.
     * <p>
     * The link is an Amazon S3 object URL and is required if you don't specify a value for <code>document</code> .
     * <p>
     * For example, <code>--document-source https://s3. *region-code* .amazonaws.com/example-firmware/device-firmware.1.0</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-bucket-intro.html">Methods for accessing a bucket</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-documentsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-documentsource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDocumentSource() {
        return null;
    }

    /**
     * The ARN of the job to use as the basis for the job template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobArn() {
        return null;
    }

    /**
     * Allows you to create the criteria to retry a job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsretryconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsretryconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getJobExecutionsRetryConfig() {
        return null;
    }

    /**
     * Allows you to create a staged rollout of a job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsrolloutconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsrolloutconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getJobExecutionsRolloutConfig() {
        return null;
    }

    /**
     * An optional configuration within the SchedulingConfig to setup a recurring maintenance window with a predetermined start time and duration for the rollout of a job document to all devices in a target group for a job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-maintenancewindows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-maintenancewindows</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindows() {
        return null;
    }

    /**
     * Configuration for pre-signed S3 URLs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-presignedurlconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-presignedurlconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPresignedUrlConfig() {
        return null;
    }

    /**
     * Metadata that can be used to manage the job template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies the amount of time each device has to finish its execution of the job.
     * <p>
     * A timer is started when the job execution status is set to <code>IN_PROGRESS</code> . If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-timeoutconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-timeoutconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTimeoutConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnJobTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnJobTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnJobTemplateProps> {
        java.lang.String description;
        java.lang.String jobTemplateId;
        java.lang.Object abortConfig;
        java.util.List<java.lang.String> destinationPackageVersions;
        java.lang.String document;
        java.lang.String documentSource;
        java.lang.String jobArn;
        java.lang.Object jobExecutionsRetryConfig;
        java.lang.Object jobExecutionsRolloutConfig;
        java.lang.Object maintenanceWindows;
        java.lang.Object presignedUrlConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object timeoutConfig;

        /**
         * Sets the value of {@link CfnJobTemplateProps#getDescription}
         * @param description A description of the job template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getJobTemplateId}
         * @param jobTemplateId A unique identifier for the job template. This parameter is required.
         *                      We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobTemplateId(java.lang.String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getAbortConfig}
         * @param abortConfig The criteria that determine when and how a job abort takes place.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder abortConfig(java.lang.Object abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getDestinationPackageVersions}
         * @param destinationPackageVersions The package version Amazon Resource Names (ARNs) that are installed on the device’s reserved named shadow ( <code>$package</code> ) when the job successfully completes.
         *                                   <em>Note:</em> Up to 25 package version ARNS are allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationPackageVersions(java.util.List<java.lang.String> destinationPackageVersions) {
            this.destinationPackageVersions = destinationPackageVersions;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getDocument}
         * @param document The job document.
         *                 Required if you don't specify a value for <code>documentSource</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder document(java.lang.String document) {
            this.document = document;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getDocumentSource}
         * @param documentSource An S3 link, or S3 object URL, to the job document.
         *                       The link is an Amazon S3 object URL and is required if you don't specify a value for <code>document</code> .
         *                       <p>
         *                       For example, <code>--document-source https://s3. *region-code* .amazonaws.com/example-firmware/device-firmware.1.0</code>
         *                       <p>
         *                       For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-bucket-intro.html">Methods for accessing a bucket</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentSource(java.lang.String documentSource) {
            this.documentSource = documentSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getJobArn}
         * @param jobArn The ARN of the job to use as the basis for the job template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobArn(java.lang.String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getJobExecutionsRetryConfig}
         * @param jobExecutionsRetryConfig Allows you to create the criteria to retry a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobExecutionsRetryConfig(software.amazon.awscdk.IResolvable jobExecutionsRetryConfig) {
            this.jobExecutionsRetryConfig = jobExecutionsRetryConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getJobExecutionsRetryConfig}
         * @param jobExecutionsRetryConfig Allows you to create the criteria to retry a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobExecutionsRetryConfig(software.amazon.awscdk.services.iot.CfnJobTemplate.JobExecutionsRetryConfigProperty jobExecutionsRetryConfig) {
            this.jobExecutionsRetryConfig = jobExecutionsRetryConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getJobExecutionsRolloutConfig}
         * @param jobExecutionsRolloutConfig Allows you to create a staged rollout of a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobExecutionsRolloutConfig(java.lang.Object jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getMaintenanceWindows}
         * @param maintenanceWindows An optional configuration within the SchedulingConfig to setup a recurring maintenance window with a predetermined start time and duration for the rollout of a job document to all devices in a target group for a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindows(software.amazon.awscdk.IResolvable maintenanceWindows) {
            this.maintenanceWindows = maintenanceWindows;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getMaintenanceWindows}
         * @param maintenanceWindows An optional configuration within the SchedulingConfig to setup a recurring maintenance window with a predetermined start time and duration for the rollout of a job document to all devices in a target group for a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindows(java.util.List<? extends java.lang.Object> maintenanceWindows) {
            this.maintenanceWindows = maintenanceWindows;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getPresignedUrlConfig}
         * @param presignedUrlConfig Configuration for pre-signed S3 URLs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder presignedUrlConfig(java.lang.Object presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getTags}
         * @param tags Metadata that can be used to manage the job template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getTimeoutConfig}
         * @param timeoutConfig Specifies the amount of time each device has to finish its execution of the job.
         *                      A timer is started when the job execution status is set to <code>IN_PROGRESS</code> . If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutConfig(java.lang.Object timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnJobTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnJobTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnJobTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnJobTemplateProps {
        private final java.lang.String description;
        private final java.lang.String jobTemplateId;
        private final java.lang.Object abortConfig;
        private final java.util.List<java.lang.String> destinationPackageVersions;
        private final java.lang.String document;
        private final java.lang.String documentSource;
        private final java.lang.String jobArn;
        private final java.lang.Object jobExecutionsRetryConfig;
        private final java.lang.Object jobExecutionsRolloutConfig;
        private final java.lang.Object maintenanceWindows;
        private final java.lang.Object presignedUrlConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object timeoutConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobTemplateId = software.amazon.jsii.Kernel.get(this, "jobTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.abortConfig = software.amazon.jsii.Kernel.get(this, "abortConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.destinationPackageVersions = software.amazon.jsii.Kernel.get(this, "destinationPackageVersions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.document = software.amazon.jsii.Kernel.get(this, "document", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.documentSource = software.amazon.jsii.Kernel.get(this, "documentSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobArn = software.amazon.jsii.Kernel.get(this, "jobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobExecutionsRetryConfig = software.amazon.jsii.Kernel.get(this, "jobExecutionsRetryConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.jobExecutionsRolloutConfig = software.amazon.jsii.Kernel.get(this, "jobExecutionsRolloutConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maintenanceWindows = software.amazon.jsii.Kernel.get(this, "maintenanceWindows", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.presignedUrlConfig = software.amazon.jsii.Kernel.get(this, "presignedUrlConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.timeoutConfig = software.amazon.jsii.Kernel.get(this, "timeoutConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.jobTemplateId = java.util.Objects.requireNonNull(builder.jobTemplateId, "jobTemplateId is required");
            this.abortConfig = builder.abortConfig;
            this.destinationPackageVersions = builder.destinationPackageVersions;
            this.document = builder.document;
            this.documentSource = builder.documentSource;
            this.jobArn = builder.jobArn;
            this.jobExecutionsRetryConfig = builder.jobExecutionsRetryConfig;
            this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
            this.maintenanceWindows = builder.maintenanceWindows;
            this.presignedUrlConfig = builder.presignedUrlConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.timeoutConfig = builder.timeoutConfig;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getJobTemplateId() {
            return this.jobTemplateId;
        }

        @Override
        public final java.lang.Object getAbortConfig() {
            return this.abortConfig;
        }

        @Override
        public final java.util.List<java.lang.String> getDestinationPackageVersions() {
            return this.destinationPackageVersions;
        }

        @Override
        public final java.lang.String getDocument() {
            return this.document;
        }

        @Override
        public final java.lang.String getDocumentSource() {
            return this.documentSource;
        }

        @Override
        public final java.lang.String getJobArn() {
            return this.jobArn;
        }

        @Override
        public final java.lang.Object getJobExecutionsRetryConfig() {
            return this.jobExecutionsRetryConfig;
        }

        @Override
        public final java.lang.Object getJobExecutionsRolloutConfig() {
            return this.jobExecutionsRolloutConfig;
        }

        @Override
        public final java.lang.Object getMaintenanceWindows() {
            return this.maintenanceWindows;
        }

        @Override
        public final java.lang.Object getPresignedUrlConfig() {
            return this.presignedUrlConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTimeoutConfig() {
            return this.timeoutConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("description", om.valueToTree(this.getDescription()));
            data.set("jobTemplateId", om.valueToTree(this.getJobTemplateId()));
            if (this.getAbortConfig() != null) {
                data.set("abortConfig", om.valueToTree(this.getAbortConfig()));
            }
            if (this.getDestinationPackageVersions() != null) {
                data.set("destinationPackageVersions", om.valueToTree(this.getDestinationPackageVersions()));
            }
            if (this.getDocument() != null) {
                data.set("document", om.valueToTree(this.getDocument()));
            }
            if (this.getDocumentSource() != null) {
                data.set("documentSource", om.valueToTree(this.getDocumentSource()));
            }
            if (this.getJobArn() != null) {
                data.set("jobArn", om.valueToTree(this.getJobArn()));
            }
            if (this.getJobExecutionsRetryConfig() != null) {
                data.set("jobExecutionsRetryConfig", om.valueToTree(this.getJobExecutionsRetryConfig()));
            }
            if (this.getJobExecutionsRolloutConfig() != null) {
                data.set("jobExecutionsRolloutConfig", om.valueToTree(this.getJobExecutionsRolloutConfig()));
            }
            if (this.getMaintenanceWindows() != null) {
                data.set("maintenanceWindows", om.valueToTree(this.getMaintenanceWindows()));
            }
            if (this.getPresignedUrlConfig() != null) {
                data.set("presignedUrlConfig", om.valueToTree(this.getPresignedUrlConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeoutConfig() != null) {
                data.set("timeoutConfig", om.valueToTree(this.getTimeoutConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnJobTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnJobTemplateProps.Jsii$Proxy that = (CfnJobTemplateProps.Jsii$Proxy) o;

            if (!description.equals(that.description)) return false;
            if (!jobTemplateId.equals(that.jobTemplateId)) return false;
            if (this.abortConfig != null ? !this.abortConfig.equals(that.abortConfig) : that.abortConfig != null) return false;
            if (this.destinationPackageVersions != null ? !this.destinationPackageVersions.equals(that.destinationPackageVersions) : that.destinationPackageVersions != null) return false;
            if (this.document != null ? !this.document.equals(that.document) : that.document != null) return false;
            if (this.documentSource != null ? !this.documentSource.equals(that.documentSource) : that.documentSource != null) return false;
            if (this.jobArn != null ? !this.jobArn.equals(that.jobArn) : that.jobArn != null) return false;
            if (this.jobExecutionsRetryConfig != null ? !this.jobExecutionsRetryConfig.equals(that.jobExecutionsRetryConfig) : that.jobExecutionsRetryConfig != null) return false;
            if (this.jobExecutionsRolloutConfig != null ? !this.jobExecutionsRolloutConfig.equals(that.jobExecutionsRolloutConfig) : that.jobExecutionsRolloutConfig != null) return false;
            if (this.maintenanceWindows != null ? !this.maintenanceWindows.equals(that.maintenanceWindows) : that.maintenanceWindows != null) return false;
            if (this.presignedUrlConfig != null ? !this.presignedUrlConfig.equals(that.presignedUrlConfig) : that.presignedUrlConfig != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.timeoutConfig != null ? this.timeoutConfig.equals(that.timeoutConfig) : that.timeoutConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + (this.jobTemplateId.hashCode());
            result = 31 * result + (this.abortConfig != null ? this.abortConfig.hashCode() : 0);
            result = 31 * result + (this.destinationPackageVersions != null ? this.destinationPackageVersions.hashCode() : 0);
            result = 31 * result + (this.document != null ? this.document.hashCode() : 0);
            result = 31 * result + (this.documentSource != null ? this.documentSource.hashCode() : 0);
            result = 31 * result + (this.jobArn != null ? this.jobArn.hashCode() : 0);
            result = 31 * result + (this.jobExecutionsRetryConfig != null ? this.jobExecutionsRetryConfig.hashCode() : 0);
            result = 31 * result + (this.jobExecutionsRolloutConfig != null ? this.jobExecutionsRolloutConfig.hashCode() : 0);
            result = 31 * result + (this.maintenanceWindows != null ? this.maintenanceWindows.hashCode() : 0);
            result = 31 * result + (this.presignedUrlConfig != null ? this.presignedUrlConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeoutConfig != null ? this.timeoutConfig.hashCode() : 0);
            return result;
        }
    }
}
