package software.amazon.awscdk.services.iotfleetwise;

/**
 * Properties for defining a <code>CfnVehicle</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * Object onChange;
 * CfnVehicleProps cfnVehicleProps = CfnVehicleProps.builder()
 *         .decoderManifestArn("decoderManifestArn")
 *         .modelManifestArn("modelManifestArn")
 *         .name("name")
 *         // the properties below are optional
 *         .associationBehavior("associationBehavior")
 *         .attributes(Map.of(
 *                 "attributesKey", "attributes"))
 *         .stateTemplates(List.of(StateTemplateAssociationProperty.builder()
 *                 .identifier("identifier")
 *                 .stateTemplateUpdateStrategy(StateTemplateUpdateStrategyProperty.builder()
 *                         .onChange(onChange)
 *                         .periodic(PeriodicStateTemplateUpdateStrategyProperty.builder()
 *                                 .stateTemplateUpdateRate(TimePeriodProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:34.714Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnVehicleProps")
@software.amazon.jsii.Jsii.Proxy(CfnVehicleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVehicleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of a decoder manifest associated with the vehicle to create.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-decodermanifestarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-decodermanifestarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDecoderManifestArn();

    /**
     * The Amazon Resource Name (ARN) of the vehicle model (model manifest) to create the vehicle from.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-modelmanifestarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-modelmanifestarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModelManifestArn();

    /**
     * The unique ID of the vehicle.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An option to create a new AWS IoT thing when creating a vehicle, or to validate an existing thing as a vehicle.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-associationbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-associationbehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssociationBehavior() {
        return null;
    }

    /**
     * Static information about a vehicle in a key-value pair.
     * <p>
     * For example: <code>"engine Type"</code> : <code>"v6"</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-attributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
        return null;
    }

    /**
     * Associate state templates to track the state of the vehicle.
     * <p>
     * State templates determine which signal updates the vehicle sends to the cloud.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-statetemplates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-statetemplates</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStateTemplates() {
        return null;
    }

    /**
     * Metadata which can be used to manage the vehicle.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-vehicle.html#cfn-iotfleetwise-vehicle-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVehicleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVehicleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVehicleProps> {
        java.lang.String decoderManifestArn;
        java.lang.String modelManifestArn;
        java.lang.String name;
        java.lang.String associationBehavior;
        java.lang.Object attributes;
        java.lang.Object stateTemplates;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnVehicleProps#getDecoderManifestArn}
         * @param decoderManifestArn The Amazon Resource Name (ARN) of a decoder manifest associated with the vehicle to create. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder decoderManifestArn(java.lang.String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnVehicleProps#getModelManifestArn}
         * @param modelManifestArn The Amazon Resource Name (ARN) of the vehicle model (model manifest) to create the vehicle from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelManifestArn(java.lang.String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnVehicleProps#getName}
         * @param name The unique ID of the vehicle. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnVehicleProps#getAssociationBehavior}
         * @param associationBehavior An option to create a new AWS IoT thing when creating a vehicle, or to validate an existing thing as a vehicle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associationBehavior(java.lang.String associationBehavior) {
            this.associationBehavior = associationBehavior;
            return this;
        }

        /**
         * Sets the value of {@link CfnVehicleProps#getAttributes}
         * @param attributes Static information about a vehicle in a key-value pair.
         *                   For example: <code>"engine Type"</code> : <code>"v6"</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(java.util.Map<java.lang.String, java.lang.String> attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnVehicleProps#getAttributes}
         * @param attributes Static information about a vehicle in a key-value pair.
         *                   For example: <code>"engine Type"</code> : <code>"v6"</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnVehicleProps#getStateTemplates}
         * @param stateTemplates Associate state templates to track the state of the vehicle.
         *                       State templates determine which signal updates the vehicle sends to the cloud.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateTemplates(software.amazon.awscdk.IResolvable stateTemplates) {
            this.stateTemplates = stateTemplates;
            return this;
        }

        /**
         * Sets the value of {@link CfnVehicleProps#getStateTemplates}
         * @param stateTemplates Associate state templates to track the state of the vehicle.
         *                       State templates determine which signal updates the vehicle sends to the cloud.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateTemplates(java.util.List<? extends java.lang.Object> stateTemplates) {
            this.stateTemplates = stateTemplates;
            return this;
        }

        /**
         * Sets the value of {@link CfnVehicleProps#getTags}
         * @param tags Metadata which can be used to manage the vehicle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVehicleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVehicleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVehicleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVehicleProps {
        private final java.lang.String decoderManifestArn;
        private final java.lang.String modelManifestArn;
        private final java.lang.String name;
        private final java.lang.String associationBehavior;
        private final java.lang.Object attributes;
        private final java.lang.Object stateTemplates;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.decoderManifestArn = software.amazon.jsii.Kernel.get(this, "decoderManifestArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelManifestArn = software.amazon.jsii.Kernel.get(this, "modelManifestArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.associationBehavior = software.amazon.jsii.Kernel.get(this, "associationBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stateTemplates = software.amazon.jsii.Kernel.get(this, "stateTemplates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.decoderManifestArn = java.util.Objects.requireNonNull(builder.decoderManifestArn, "decoderManifestArn is required");
            this.modelManifestArn = java.util.Objects.requireNonNull(builder.modelManifestArn, "modelManifestArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.associationBehavior = builder.associationBehavior;
            this.attributes = builder.attributes;
            this.stateTemplates = builder.stateTemplates;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDecoderManifestArn() {
            return this.decoderManifestArn;
        }

        @Override
        public final java.lang.String getModelManifestArn() {
            return this.modelManifestArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getAssociationBehavior() {
            return this.associationBehavior;
        }

        @Override
        public final java.lang.Object getAttributes() {
            return this.attributes;
        }

        @Override
        public final java.lang.Object getStateTemplates() {
            return this.stateTemplates;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("decoderManifestArn", om.valueToTree(this.getDecoderManifestArn()));
            data.set("modelManifestArn", om.valueToTree(this.getModelManifestArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAssociationBehavior() != null) {
                data.set("associationBehavior", om.valueToTree(this.getAssociationBehavior()));
            }
            if (this.getAttributes() != null) {
                data.set("attributes", om.valueToTree(this.getAttributes()));
            }
            if (this.getStateTemplates() != null) {
                data.set("stateTemplates", om.valueToTree(this.getStateTemplates()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnVehicleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVehicleProps.Jsii$Proxy that = (CfnVehicleProps.Jsii$Proxy) o;

            if (!decoderManifestArn.equals(that.decoderManifestArn)) return false;
            if (!modelManifestArn.equals(that.modelManifestArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.associationBehavior != null ? !this.associationBehavior.equals(that.associationBehavior) : that.associationBehavior != null) return false;
            if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
            if (this.stateTemplates != null ? !this.stateTemplates.equals(that.stateTemplates) : that.stateTemplates != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.decoderManifestArn.hashCode();
            result = 31 * result + (this.modelManifestArn.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.associationBehavior != null ? this.associationBehavior.hashCode() : 0);
            result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
            result = 31 * result + (this.stateTemplates != null ? this.stateTemplates.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
