package software.amazon.awscdk.services.kendra;

/**
 * Creates an Amazon Kendra index.
 * <p>
 * Once the index is active you can add documents to your index using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html">BatchPutDocument</a> operation or using one of the supported data sources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kendra.*;
 * CfnIndex cfnIndex = CfnIndex.Builder.create(this, "MyCfnIndex")
 *         .edition("edition")
 *         .name("name")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .capacityUnits(CapacityUnitsConfigurationProperty.builder()
 *                 .queryCapacityUnits(123)
 *                 .storageCapacityUnits(123)
 *                 .build())
 *         .description("description")
 *         .documentMetadataConfigurations(List.of(DocumentMetadataConfigurationProperty.builder()
 *                 .name("name")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .relevance(RelevanceProperty.builder()
 *                         .duration("duration")
 *                         .freshness(false)
 *                         .importance(123)
 *                         .rankOrder("rankOrder")
 *                         .valueImportanceItems(List.of(ValueImportanceItemProperty.builder()
 *                                 .key("key")
 *                                 .value(123)
 *                                 .build()))
 *                         .build())
 *                 .search(SearchProperty.builder()
 *                         .displayable(false)
 *                         .facetable(false)
 *                         .searchable(false)
 *                         .sortable(false)
 *                         .build())
 *                 .build()))
 *         .serverSideEncryptionConfiguration(ServerSideEncryptionConfigurationProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userContextPolicy("userContextPolicy")
 *         .userTokenConfigurations(List.of(UserTokenConfigurationProperty.builder()
 *                 .jsonTokenTypeConfiguration(JsonTokenTypeConfigurationProperty.builder()
 *                         .groupAttributeField("groupAttributeField")
 *                         .userNameAttributeField("userNameAttributeField")
 *                         .build())
 *                 .jwtTokenTypeConfiguration(JwtTokenTypeConfigurationProperty.builder()
 *                         .keyLocation("keyLocation")
 *                         // the properties below are optional
 *                         .claimRegex("claimRegex")
 *                         .groupAttributeField("groupAttributeField")
 *                         .issuer("issuer")
 *                         .secretManagerArn("secretManagerArn")
 *                         .url("url")
 *                         .userNameAttributeField("userNameAttributeField")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:34.963Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnIndex")
public class CfnIndex extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnIndex(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIndex(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kendra.CfnIndex.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIndex(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kendra.CfnIndexProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the index.
     * <p>
     * For example: <code>arn:aws:kendra:us-west-2:111122223333:index/0123456789abcdef</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the index.
     * <p>
     * For example: <code>f4aeaa10-8056-4b2c-a343-522ca0f41234</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Indicates whether the index is a Enterprise Edition index, a Developer Edition index, or a GenAI Enterprise Edition index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEdition() {
        return software.amazon.jsii.Kernel.get(this, "edition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether the index is a Enterprise Edition index, a Developer Edition index, or a GenAI Enterprise Edition index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEdition(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "edition", java.util.Objects.requireNonNull(value, "edition is required"));
    }

    /**
     * The name of the index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * An IAM role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An IAM role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * Specifies additional capacity units configured for your Enterprise Edition index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCapacityUnits() {
        return software.amazon.jsii.Kernel.get(this, "capacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies additional capacity units configured for your Enterprise Edition index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "capacityUnits", value);
    }

    /**
     * Specifies additional capacity units configured for your Enterprise Edition index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kendra.CfnIndex.CapacityUnitsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "capacityUnits", value);
    }

    /**
     * A description for the index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies the properties of an index field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDocumentMetadataConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "documentMetadataConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the properties of an index field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocumentMetadataConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "documentMetadataConfigurations", value);
    }

    /**
     * Specifies the properties of an index field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocumentMetadataConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.kendra.CfnIndex.DocumentMetadataConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.kendra.CfnIndex.DocumentMetadataConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "documentMetadataConfigurations", value);
    }

    /**
     * The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServerSideEncryptionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "serverSideEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerSideEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serverSideEncryptionConfiguration", value);
    }

    /**
     * The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerSideEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kendra.CfnIndex.ServerSideEncryptionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "serverSideEncryptionConfiguration", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The user context policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUserContextPolicy() {
        return software.amazon.jsii.Kernel.get(this, "userContextPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user context policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserContextPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userContextPolicy", value);
    }

    /**
     * Defines the type of user token used for the index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUserTokenConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "userTokenConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines the type of user token used for the index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserTokenConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "userTokenConfigurations", value);
    }

    /**
     * Defines the type of user token used for the index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserTokenConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.kendra.CfnIndex.UserTokenConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.kendra.CfnIndex.UserTokenConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "userTokenConfigurations", value);
    }
    /**
     * Specifies additional capacity units configured for your Enterprise Edition index.
     * <p>
     * You can add and remove capacity units to fit your usage requirements.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * CapacityUnitsConfigurationProperty capacityUnitsConfigurationProperty = CapacityUnitsConfigurationProperty.builder()
     *         .queryCapacityUnits(123)
     *         .storageCapacityUnits(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnIndex.CapacityUnitsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityUnitsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityUnitsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of extra query capacity for an index and <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html">GetQuerySuggestions</a> capacity.
         * <p>
         * A single extra capacity unit for an index provides 0.1 queries per second or approximately 8,000 queries per day. You can add up to 100 extra capacity units.
         * <p>
         * <code>GetQuerySuggestions</code> capacity is five times the provisioned query capacity for an index, or the base capacity of 2.5 calls per second, whichever is higher. For example, the base capacity for an index is 0.1 queries per second, and <code>GetQuerySuggestions</code> capacity has a base of 2.5 calls per second. If you add another 0.1 queries per second to total 0.2 queries per second for an index, the <code>GetQuerySuggestions</code> capacity is 2.5 calls per second (higher than five times 0.2 queries per second).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html#cfn-kendra-index-capacityunitsconfiguration-querycapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html#cfn-kendra-index-capacityunitsconfiguration-querycapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQueryCapacityUnits();

        /**
         * The amount of extra storage capacity for an index.
         * <p>
         * A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. You can add up to 100 extra capacity units.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html#cfn-kendra-index-capacityunitsconfiguration-storagecapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html#cfn-kendra-index-capacityunitsconfiguration-storagecapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getStorageCapacityUnits();

        /**
         * @return a {@link Builder} of {@link CapacityUnitsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityUnitsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityUnitsConfigurationProperty> {
            java.lang.Number queryCapacityUnits;
            java.lang.Number storageCapacityUnits;

            /**
             * Sets the value of {@link CapacityUnitsConfigurationProperty#getQueryCapacityUnits}
             * @param queryCapacityUnits The amount of extra query capacity for an index and <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html">GetQuerySuggestions</a> capacity. This parameter is required.
             *                           A single extra capacity unit for an index provides 0.1 queries per second or approximately 8,000 queries per day. You can add up to 100 extra capacity units.
             *                           <p>
             *                           <code>GetQuerySuggestions</code> capacity is five times the provisioned query capacity for an index, or the base capacity of 2.5 calls per second, whichever is higher. For example, the base capacity for an index is 0.1 queries per second, and <code>GetQuerySuggestions</code> capacity has a base of 2.5 calls per second. If you add another 0.1 queries per second to total 0.2 queries per second for an index, the <code>GetQuerySuggestions</code> capacity is 2.5 calls per second (higher than five times 0.2 queries per second).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryCapacityUnits(java.lang.Number queryCapacityUnits) {
                this.queryCapacityUnits = queryCapacityUnits;
                return this;
            }

            /**
             * Sets the value of {@link CapacityUnitsConfigurationProperty#getStorageCapacityUnits}
             * @param storageCapacityUnits The amount of extra storage capacity for an index. This parameter is required.
             *                             A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. You can add up to 100 extra capacity units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageCapacityUnits(java.lang.Number storageCapacityUnits) {
                this.storageCapacityUnits = storageCapacityUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityUnitsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityUnitsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityUnitsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityUnitsConfigurationProperty {
            private final java.lang.Number queryCapacityUnits;
            private final java.lang.Number storageCapacityUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryCapacityUnits = software.amazon.jsii.Kernel.get(this, "queryCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.storageCapacityUnits = software.amazon.jsii.Kernel.get(this, "storageCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryCapacityUnits = java.util.Objects.requireNonNull(builder.queryCapacityUnits, "queryCapacityUnits is required");
                this.storageCapacityUnits = java.util.Objects.requireNonNull(builder.storageCapacityUnits, "storageCapacityUnits is required");
            }

            @Override
            public final java.lang.Number getQueryCapacityUnits() {
                return this.queryCapacityUnits;
            }

            @Override
            public final java.lang.Number getStorageCapacityUnits() {
                return this.storageCapacityUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryCapacityUnits", om.valueToTree(this.getQueryCapacityUnits()));
                data.set("storageCapacityUnits", om.valueToTree(this.getStorageCapacityUnits()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnIndex.CapacityUnitsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityUnitsConfigurationProperty.Jsii$Proxy that = (CapacityUnitsConfigurationProperty.Jsii$Proxy) o;

                if (!queryCapacityUnits.equals(that.queryCapacityUnits)) return false;
                return this.storageCapacityUnits.equals(that.storageCapacityUnits);
            }

            @Override
            public final int hashCode() {
                int result = this.queryCapacityUnits.hashCode();
                result = 31 * result + (this.storageCapacityUnits.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the properties, such as relevance tuning and searchability, of an index field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * DocumentMetadataConfigurationProperty documentMetadataConfigurationProperty = DocumentMetadataConfigurationProperty.builder()
     *         .name("name")
     *         .type("type")
     *         // the properties below are optional
     *         .relevance(RelevanceProperty.builder()
     *                 .duration("duration")
     *                 .freshness(false)
     *                 .importance(123)
     *                 .rankOrder("rankOrder")
     *                 .valueImportanceItems(List.of(ValueImportanceItemProperty.builder()
     *                         .key("key")
     *                         .value(123)
     *                         .build()))
     *                 .build())
     *         .search(SearchProperty.builder()
     *                 .displayable(false)
     *                 .facetable(false)
     *                 .searchable(false)
     *                 .sortable(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnIndex.DocumentMetadataConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentMetadataConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentMetadataConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the index field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The data type of the index field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Provides tuning parameters to determine how the field affects the search results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-relevance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-relevance</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelevance() {
            return null;
        }

        /**
         * Provides information about how the field is used during a search.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-search">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-search</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSearch() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentMetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentMetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentMetadataConfigurationProperty> {
            java.lang.String name;
            java.lang.String type;
            java.lang.Object relevance;
            java.lang.Object search;

            /**
             * Sets the value of {@link DocumentMetadataConfigurationProperty#getName}
             * @param name The name of the index field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DocumentMetadataConfigurationProperty#getType}
             * @param type The data type of the index field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DocumentMetadataConfigurationProperty#getRelevance}
             * @param relevance Provides tuning parameters to determine how the field affects the search results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relevance(software.amazon.awscdk.IResolvable relevance) {
                this.relevance = relevance;
                return this;
            }

            /**
             * Sets the value of {@link DocumentMetadataConfigurationProperty#getRelevance}
             * @param relevance Provides tuning parameters to determine how the field affects the search results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relevance(software.amazon.awscdk.services.kendra.CfnIndex.RelevanceProperty relevance) {
                this.relevance = relevance;
                return this;
            }

            /**
             * Sets the value of {@link DocumentMetadataConfigurationProperty#getSearch}
             * @param search Provides information about how the field is used during a search.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder search(software.amazon.awscdk.IResolvable search) {
                this.search = search;
                return this;
            }

            /**
             * Sets the value of {@link DocumentMetadataConfigurationProperty#getSearch}
             * @param search Provides information about how the field is used during a search.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder search(software.amazon.awscdk.services.kendra.CfnIndex.SearchProperty search) {
                this.search = search;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentMetadataConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentMetadataConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentMetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentMetadataConfigurationProperty {
            private final java.lang.String name;
            private final java.lang.String type;
            private final java.lang.Object relevance;
            private final java.lang.Object search;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.relevance = software.amazon.jsii.Kernel.get(this, "relevance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.search = software.amazon.jsii.Kernel.get(this, "search", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.relevance = builder.relevance;
                this.search = builder.search;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getRelevance() {
                return this.relevance;
            }

            @Override
            public final java.lang.Object getSearch() {
                return this.search;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getRelevance() != null) {
                    data.set("relevance", om.valueToTree(this.getRelevance()));
                }
                if (this.getSearch() != null) {
                    data.set("search", om.valueToTree(this.getSearch()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnIndex.DocumentMetadataConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentMetadataConfigurationProperty.Jsii$Proxy that = (DocumentMetadataConfigurationProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!type.equals(that.type)) return false;
                if (this.relevance != null ? !this.relevance.equals(that.relevance) : that.relevance != null) return false;
                return this.search != null ? this.search.equals(that.search) : that.search == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.relevance != null ? this.relevance.hashCode() : 0);
                result = 31 * result + (this.search != null ? this.search.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for the JSON token type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * JsonTokenTypeConfigurationProperty jsonTokenTypeConfigurationProperty = JsonTokenTypeConfigurationProperty.builder()
     *         .groupAttributeField("groupAttributeField")
     *         .userNameAttributeField("userNameAttributeField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnIndex.JsonTokenTypeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonTokenTypeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonTokenTypeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The group attribute field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html#cfn-kendra-index-jsontokentypeconfiguration-groupattributefield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html#cfn-kendra-index-jsontokentypeconfiguration-groupattributefield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupAttributeField();

        /**
         * The user name attribute field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html#cfn-kendra-index-jsontokentypeconfiguration-usernameattributefield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html#cfn-kendra-index-jsontokentypeconfiguration-usernameattributefield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserNameAttributeField();

        /**
         * @return a {@link Builder} of {@link JsonTokenTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonTokenTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonTokenTypeConfigurationProperty> {
            java.lang.String groupAttributeField;
            java.lang.String userNameAttributeField;

            /**
             * Sets the value of {@link JsonTokenTypeConfigurationProperty#getGroupAttributeField}
             * @param groupAttributeField The group attribute field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupAttributeField(java.lang.String groupAttributeField) {
                this.groupAttributeField = groupAttributeField;
                return this;
            }

            /**
             * Sets the value of {@link JsonTokenTypeConfigurationProperty#getUserNameAttributeField}
             * @param userNameAttributeField The user name attribute field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userNameAttributeField(java.lang.String userNameAttributeField) {
                this.userNameAttributeField = userNameAttributeField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonTokenTypeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonTokenTypeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonTokenTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonTokenTypeConfigurationProperty {
            private final java.lang.String groupAttributeField;
            private final java.lang.String userNameAttributeField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupAttributeField = software.amazon.jsii.Kernel.get(this, "groupAttributeField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userNameAttributeField = software.amazon.jsii.Kernel.get(this, "userNameAttributeField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupAttributeField = java.util.Objects.requireNonNull(builder.groupAttributeField, "groupAttributeField is required");
                this.userNameAttributeField = java.util.Objects.requireNonNull(builder.userNameAttributeField, "userNameAttributeField is required");
            }

            @Override
            public final java.lang.String getGroupAttributeField() {
                return this.groupAttributeField;
            }

            @Override
            public final java.lang.String getUserNameAttributeField() {
                return this.userNameAttributeField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groupAttributeField", om.valueToTree(this.getGroupAttributeField()));
                data.set("userNameAttributeField", om.valueToTree(this.getUserNameAttributeField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnIndex.JsonTokenTypeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonTokenTypeConfigurationProperty.Jsii$Proxy that = (JsonTokenTypeConfigurationProperty.Jsii$Proxy) o;

                if (!groupAttributeField.equals(that.groupAttributeField)) return false;
                return this.userNameAttributeField.equals(that.userNameAttributeField);
            }

            @Override
            public final int hashCode() {
                int result = this.groupAttributeField.hashCode();
                result = 31 * result + (this.userNameAttributeField.hashCode());
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for the JWT token type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * JwtTokenTypeConfigurationProperty jwtTokenTypeConfigurationProperty = JwtTokenTypeConfigurationProperty.builder()
     *         .keyLocation("keyLocation")
     *         // the properties below are optional
     *         .claimRegex("claimRegex")
     *         .groupAttributeField("groupAttributeField")
     *         .issuer("issuer")
     *         .secretManagerArn("secretManagerArn")
     *         .url("url")
     *         .userNameAttributeField("userNameAttributeField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnIndex.JwtTokenTypeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(JwtTokenTypeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JwtTokenTypeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-keylocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-keylocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyLocation();

        /**
         * The regular expression that identifies the claim.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-claimregex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-claimregex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClaimRegex() {
            return null;
        }

        /**
         * The group attribute field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-groupattributefield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-groupattributefield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupAttributeField() {
            return null;
        }

        /**
         * The issuer of the token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-issuer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-issuer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIssuer() {
            return null;
        }

        /**
         * The Amazon Resource Name (arn) of the secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-secretmanagerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-secretmanagerarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretManagerArn() {
            return null;
        }

        /**
         * The signing key URL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * The user name attribute field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-usernameattributefield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-usernameattributefield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserNameAttributeField() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JwtTokenTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JwtTokenTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JwtTokenTypeConfigurationProperty> {
            java.lang.String keyLocation;
            java.lang.String claimRegex;
            java.lang.String groupAttributeField;
            java.lang.String issuer;
            java.lang.String secretManagerArn;
            java.lang.String url;
            java.lang.String userNameAttributeField;

            /**
             * Sets the value of {@link JwtTokenTypeConfigurationProperty#getKeyLocation}
             * @param keyLocation The location of the key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyLocation(java.lang.String keyLocation) {
                this.keyLocation = keyLocation;
                return this;
            }

            /**
             * Sets the value of {@link JwtTokenTypeConfigurationProperty#getClaimRegex}
             * @param claimRegex The regular expression that identifies the claim.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder claimRegex(java.lang.String claimRegex) {
                this.claimRegex = claimRegex;
                return this;
            }

            /**
             * Sets the value of {@link JwtTokenTypeConfigurationProperty#getGroupAttributeField}
             * @param groupAttributeField The group attribute field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupAttributeField(java.lang.String groupAttributeField) {
                this.groupAttributeField = groupAttributeField;
                return this;
            }

            /**
             * Sets the value of {@link JwtTokenTypeConfigurationProperty#getIssuer}
             * @param issuer The issuer of the token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Sets the value of {@link JwtTokenTypeConfigurationProperty#getSecretManagerArn}
             * @param secretManagerArn The Amazon Resource Name (arn) of the secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretManagerArn(java.lang.String secretManagerArn) {
                this.secretManagerArn = secretManagerArn;
                return this;
            }

            /**
             * Sets the value of {@link JwtTokenTypeConfigurationProperty#getUrl}
             * @param url The signing key URL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link JwtTokenTypeConfigurationProperty#getUserNameAttributeField}
             * @param userNameAttributeField The user name attribute field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userNameAttributeField(java.lang.String userNameAttributeField) {
                this.userNameAttributeField = userNameAttributeField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JwtTokenTypeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JwtTokenTypeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JwtTokenTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JwtTokenTypeConfigurationProperty {
            private final java.lang.String keyLocation;
            private final java.lang.String claimRegex;
            private final java.lang.String groupAttributeField;
            private final java.lang.String issuer;
            private final java.lang.String secretManagerArn;
            private final java.lang.String url;
            private final java.lang.String userNameAttributeField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyLocation = software.amazon.jsii.Kernel.get(this, "keyLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.claimRegex = software.amazon.jsii.Kernel.get(this, "claimRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupAttributeField = software.amazon.jsii.Kernel.get(this, "groupAttributeField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.issuer = software.amazon.jsii.Kernel.get(this, "issuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretManagerArn = software.amazon.jsii.Kernel.get(this, "secretManagerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userNameAttributeField = software.amazon.jsii.Kernel.get(this, "userNameAttributeField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyLocation = java.util.Objects.requireNonNull(builder.keyLocation, "keyLocation is required");
                this.claimRegex = builder.claimRegex;
                this.groupAttributeField = builder.groupAttributeField;
                this.issuer = builder.issuer;
                this.secretManagerArn = builder.secretManagerArn;
                this.url = builder.url;
                this.userNameAttributeField = builder.userNameAttributeField;
            }

            @Override
            public final java.lang.String getKeyLocation() {
                return this.keyLocation;
            }

            @Override
            public final java.lang.String getClaimRegex() {
                return this.claimRegex;
            }

            @Override
            public final java.lang.String getGroupAttributeField() {
                return this.groupAttributeField;
            }

            @Override
            public final java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            public final java.lang.String getSecretManagerArn() {
                return this.secretManagerArn;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            public final java.lang.String getUserNameAttributeField() {
                return this.userNameAttributeField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keyLocation", om.valueToTree(this.getKeyLocation()));
                if (this.getClaimRegex() != null) {
                    data.set("claimRegex", om.valueToTree(this.getClaimRegex()));
                }
                if (this.getGroupAttributeField() != null) {
                    data.set("groupAttributeField", om.valueToTree(this.getGroupAttributeField()));
                }
                if (this.getIssuer() != null) {
                    data.set("issuer", om.valueToTree(this.getIssuer()));
                }
                if (this.getSecretManagerArn() != null) {
                    data.set("secretManagerArn", om.valueToTree(this.getSecretManagerArn()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }
                if (this.getUserNameAttributeField() != null) {
                    data.set("userNameAttributeField", om.valueToTree(this.getUserNameAttributeField()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnIndex.JwtTokenTypeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JwtTokenTypeConfigurationProperty.Jsii$Proxy that = (JwtTokenTypeConfigurationProperty.Jsii$Proxy) o;

                if (!keyLocation.equals(that.keyLocation)) return false;
                if (this.claimRegex != null ? !this.claimRegex.equals(that.claimRegex) : that.claimRegex != null) return false;
                if (this.groupAttributeField != null ? !this.groupAttributeField.equals(that.groupAttributeField) : that.groupAttributeField != null) return false;
                if (this.issuer != null ? !this.issuer.equals(that.issuer) : that.issuer != null) return false;
                if (this.secretManagerArn != null ? !this.secretManagerArn.equals(that.secretManagerArn) : that.secretManagerArn != null) return false;
                if (this.url != null ? !this.url.equals(that.url) : that.url != null) return false;
                return this.userNameAttributeField != null ? this.userNameAttributeField.equals(that.userNameAttributeField) : that.userNameAttributeField == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keyLocation.hashCode();
                result = 31 * result + (this.claimRegex != null ? this.claimRegex.hashCode() : 0);
                result = 31 * result + (this.groupAttributeField != null ? this.groupAttributeField.hashCode() : 0);
                result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
                result = 31 * result + (this.secretManagerArn != null ? this.secretManagerArn.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                result = 31 * result + (this.userNameAttributeField != null ? this.userNameAttributeField.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information for tuning the relevance of a field in a search.
     * <p>
     * When a query includes terms that match the field, the results are given a boost in the response based on these tuning parameters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * RelevanceProperty relevanceProperty = RelevanceProperty.builder()
     *         .duration("duration")
     *         .freshness(false)
     *         .importance(123)
     *         .rankOrder("rankOrder")
     *         .valueImportanceItems(List.of(ValueImportanceItemProperty.builder()
     *                 .key("key")
     *                 .value(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnIndex.RelevanceProperty")
    @software.amazon.jsii.Jsii.Proxy(RelevanceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelevanceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the time period that the boost applies to.
         * <p>
         * For example, to make the boost apply to documents with the field value within the last month, you would use "2628000s". Once the field value is beyond the specified range, the effect of the boost drops off. The higher the importance, the faster the effect drops off. If you don't specify a value, the default is 3 months. The value of the field is a numeric string followed by the character "s", for example "86400s" for one day, or "604800s" for one week.
         * <p>
         * Only applies to <code>DATE</code> fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-duration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-duration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDuration() {
            return null;
        }

        /**
         * Indicates that this field determines how "fresh" a document is.
         * <p>
         * For example, if document 1 was created on November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. Only applies to <code>DATE</code> fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-freshness">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-freshness</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFreshness() {
            return null;
        }

        /**
         * The relative importance of the field in the search.
         * <p>
         * Larger numbers provide more of a boost than smaller numbers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-importance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-importance</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getImportance() {
            return null;
        }

        /**
         * Determines how values should be interpreted.
         * <p>
         * When the <code>RankOrder</code> field is <code>ASCENDING</code> , higher numbers are better. For example, a document with a rating score of 10 is higher ranking than a document with a rating score of 1.
         * <p>
         * When the <code>RankOrder</code> field is <code>DESCENDING</code> , lower numbers are better. For example, in a task tracking application, a priority 1 task is more important than a priority 5 task.
         * <p>
         * Only applies to <code>LONG</code> fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-rankorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-rankorder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRankOrder() {
            return null;
        }

        /**
         * An array of key-value pairs for different boosts when they appear in the search result list.
         * <p>
         * For example, if you want to boost query terms that match the "department" field in the result, query terms that match this field are boosted in the result. You can add entries from the department field to boost documents with those values higher.
         * <p>
         * For example, you can add entries to the map with names of departments. If you add "HR", 5 and "Legal",3 those departments are given special attention when they appear in the metadata of a document.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-valueimportanceitems">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-valueimportanceitems</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValueImportanceItems() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelevanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelevanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelevanceProperty> {
            java.lang.String duration;
            java.lang.Object freshness;
            java.lang.Number importance;
            java.lang.String rankOrder;
            java.lang.Object valueImportanceItems;

            /**
             * Sets the value of {@link RelevanceProperty#getDuration}
             * @param duration Specifies the time period that the boost applies to.
             *                 For example, to make the boost apply to documents with the field value within the last month, you would use "2628000s". Once the field value is beyond the specified range, the effect of the boost drops off. The higher the importance, the faster the effect drops off. If you don't specify a value, the default is 3 months. The value of the field is a numeric string followed by the character "s", for example "86400s" for one day, or "604800s" for one week.
             *                 <p>
             *                 Only applies to <code>DATE</code> fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder duration(java.lang.String duration) {
                this.duration = duration;
                return this;
            }

            /**
             * Sets the value of {@link RelevanceProperty#getFreshness}
             * @param freshness Indicates that this field determines how "fresh" a document is.
             *                  For example, if document 1 was created on November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. Only applies to <code>DATE</code> fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder freshness(java.lang.Boolean freshness) {
                this.freshness = freshness;
                return this;
            }

            /**
             * Sets the value of {@link RelevanceProperty#getFreshness}
             * @param freshness Indicates that this field determines how "fresh" a document is.
             *                  For example, if document 1 was created on November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. Only applies to <code>DATE</code> fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder freshness(software.amazon.awscdk.IResolvable freshness) {
                this.freshness = freshness;
                return this;
            }

            /**
             * Sets the value of {@link RelevanceProperty#getImportance}
             * @param importance The relative importance of the field in the search.
             *                   Larger numbers provide more of a boost than smaller numbers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder importance(java.lang.Number importance) {
                this.importance = importance;
                return this;
            }

            /**
             * Sets the value of {@link RelevanceProperty#getRankOrder}
             * @param rankOrder Determines how values should be interpreted.
             *                  When the <code>RankOrder</code> field is <code>ASCENDING</code> , higher numbers are better. For example, a document with a rating score of 10 is higher ranking than a document with a rating score of 1.
             *                  <p>
             *                  When the <code>RankOrder</code> field is <code>DESCENDING</code> , lower numbers are better. For example, in a task tracking application, a priority 1 task is more important than a priority 5 task.
             *                  <p>
             *                  Only applies to <code>LONG</code> fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rankOrder(java.lang.String rankOrder) {
                this.rankOrder = rankOrder;
                return this;
            }

            /**
             * Sets the value of {@link RelevanceProperty#getValueImportanceItems}
             * @param valueImportanceItems An array of key-value pairs for different boosts when they appear in the search result list.
             *                             For example, if you want to boost query terms that match the "department" field in the result, query terms that match this field are boosted in the result. You can add entries from the department field to boost documents with those values higher.
             *                             <p>
             *                             For example, you can add entries to the map with names of departments. If you add "HR", 5 and "Legal",3 those departments are given special attention when they appear in the metadata of a document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueImportanceItems(software.amazon.awscdk.IResolvable valueImportanceItems) {
                this.valueImportanceItems = valueImportanceItems;
                return this;
            }

            /**
             * Sets the value of {@link RelevanceProperty#getValueImportanceItems}
             * @param valueImportanceItems An array of key-value pairs for different boosts when they appear in the search result list.
             *                             For example, if you want to boost query terms that match the "department" field in the result, query terms that match this field are boosted in the result. You can add entries from the department field to boost documents with those values higher.
             *                             <p>
             *                             For example, you can add entries to the map with names of departments. If you add "HR", 5 and "Legal",3 those departments are given special attention when they appear in the metadata of a document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueImportanceItems(java.util.List<? extends java.lang.Object> valueImportanceItems) {
                this.valueImportanceItems = valueImportanceItems;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelevanceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelevanceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelevanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelevanceProperty {
            private final java.lang.String duration;
            private final java.lang.Object freshness;
            private final java.lang.Number importance;
            private final java.lang.String rankOrder;
            private final java.lang.Object valueImportanceItems;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.duration = software.amazon.jsii.Kernel.get(this, "duration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.freshness = software.amazon.jsii.Kernel.get(this, "freshness", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.importance = software.amazon.jsii.Kernel.get(this, "importance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rankOrder = software.amazon.jsii.Kernel.get(this, "rankOrder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueImportanceItems = software.amazon.jsii.Kernel.get(this, "valueImportanceItems", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.duration = builder.duration;
                this.freshness = builder.freshness;
                this.importance = builder.importance;
                this.rankOrder = builder.rankOrder;
                this.valueImportanceItems = builder.valueImportanceItems;
            }

            @Override
            public final java.lang.String getDuration() {
                return this.duration;
            }

            @Override
            public final java.lang.Object getFreshness() {
                return this.freshness;
            }

            @Override
            public final java.lang.Number getImportance() {
                return this.importance;
            }

            @Override
            public final java.lang.String getRankOrder() {
                return this.rankOrder;
            }

            @Override
            public final java.lang.Object getValueImportanceItems() {
                return this.valueImportanceItems;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDuration() != null) {
                    data.set("duration", om.valueToTree(this.getDuration()));
                }
                if (this.getFreshness() != null) {
                    data.set("freshness", om.valueToTree(this.getFreshness()));
                }
                if (this.getImportance() != null) {
                    data.set("importance", om.valueToTree(this.getImportance()));
                }
                if (this.getRankOrder() != null) {
                    data.set("rankOrder", om.valueToTree(this.getRankOrder()));
                }
                if (this.getValueImportanceItems() != null) {
                    data.set("valueImportanceItems", om.valueToTree(this.getValueImportanceItems()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnIndex.RelevanceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelevanceProperty.Jsii$Proxy that = (RelevanceProperty.Jsii$Proxy) o;

                if (this.duration != null ? !this.duration.equals(that.duration) : that.duration != null) return false;
                if (this.freshness != null ? !this.freshness.equals(that.freshness) : that.freshness != null) return false;
                if (this.importance != null ? !this.importance.equals(that.importance) : that.importance != null) return false;
                if (this.rankOrder != null ? !this.rankOrder.equals(that.rankOrder) : that.rankOrder != null) return false;
                return this.valueImportanceItems != null ? this.valueImportanceItems.equals(that.valueImportanceItems) : that.valueImportanceItems == null;
            }

            @Override
            public final int hashCode() {
                int result = this.duration != null ? this.duration.hashCode() : 0;
                result = 31 * result + (this.freshness != null ? this.freshness.hashCode() : 0);
                result = 31 * result + (this.importance != null ? this.importance.hashCode() : 0);
                result = 31 * result + (this.rankOrder != null ? this.rankOrder.hashCode() : 0);
                result = 31 * result + (this.valueImportanceItems != null ? this.valueImportanceItems.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information about how a custom index field is used during a search.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * SearchProperty searchProperty = SearchProperty.builder()
     *         .displayable(false)
     *         .facetable(false)
     *         .searchable(false)
     *         .sortable(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnIndex.SearchProperty")
    @software.amazon.jsii.Jsii.Proxy(SearchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SearchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether the field is returned in the query response.
         * <p>
         * The default is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-displayable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-displayable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisplayable() {
            return null;
        }

        /**
         * Indicates that the field can be used to create search facets, a count of results for each value in the field.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-facetable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-facetable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFacetable() {
            return null;
        }

        /**
         * Determines whether the field is used in the search.
         * <p>
         * If the <code>Searchable</code> field is <code>true</code> , you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is <code>true</code> for string fields and <code>false</code> for number and date fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-searchable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-searchable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSearchable() {
            return null;
        }

        /**
         * Determines whether the field can be used to sort the results of a query.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-sortable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-sortable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSortable() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SearchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SearchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SearchProperty> {
            java.lang.Object displayable;
            java.lang.Object facetable;
            java.lang.Object searchable;
            java.lang.Object sortable;

            /**
             * Sets the value of {@link SearchProperty#getDisplayable}
             * @param displayable Determines whether the field is returned in the query response.
             *                    The default is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayable(java.lang.Boolean displayable) {
                this.displayable = displayable;
                return this;
            }

            /**
             * Sets the value of {@link SearchProperty#getDisplayable}
             * @param displayable Determines whether the field is returned in the query response.
             *                    The default is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayable(software.amazon.awscdk.IResolvable displayable) {
                this.displayable = displayable;
                return this;
            }

            /**
             * Sets the value of {@link SearchProperty#getFacetable}
             * @param facetable Indicates that the field can be used to create search facets, a count of results for each value in the field.
             *                  The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder facetable(java.lang.Boolean facetable) {
                this.facetable = facetable;
                return this;
            }

            /**
             * Sets the value of {@link SearchProperty#getFacetable}
             * @param facetable Indicates that the field can be used to create search facets, a count of results for each value in the field.
             *                  The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder facetable(software.amazon.awscdk.IResolvable facetable) {
                this.facetable = facetable;
                return this;
            }

            /**
             * Sets the value of {@link SearchProperty#getSearchable}
             * @param searchable Determines whether the field is used in the search.
             *                   If the <code>Searchable</code> field is <code>true</code> , you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is <code>true</code> for string fields and <code>false</code> for number and date fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder searchable(java.lang.Boolean searchable) {
                this.searchable = searchable;
                return this;
            }

            /**
             * Sets the value of {@link SearchProperty#getSearchable}
             * @param searchable Determines whether the field is used in the search.
             *                   If the <code>Searchable</code> field is <code>true</code> , you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is <code>true</code> for string fields and <code>false</code> for number and date fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder searchable(software.amazon.awscdk.IResolvable searchable) {
                this.searchable = searchable;
                return this;
            }

            /**
             * Sets the value of {@link SearchProperty#getSortable}
             * @param sortable Determines whether the field can be used to sort the results of a query.
             *                 The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortable(java.lang.Boolean sortable) {
                this.sortable = sortable;
                return this;
            }

            /**
             * Sets the value of {@link SearchProperty#getSortable}
             * @param sortable Determines whether the field can be used to sort the results of a query.
             *                 The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortable(software.amazon.awscdk.IResolvable sortable) {
                this.sortable = sortable;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SearchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SearchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SearchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SearchProperty {
            private final java.lang.Object displayable;
            private final java.lang.Object facetable;
            private final java.lang.Object searchable;
            private final java.lang.Object sortable;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.displayable = software.amazon.jsii.Kernel.get(this, "displayable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.facetable = software.amazon.jsii.Kernel.get(this, "facetable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.searchable = software.amazon.jsii.Kernel.get(this, "searchable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sortable = software.amazon.jsii.Kernel.get(this, "sortable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.displayable = builder.displayable;
                this.facetable = builder.facetable;
                this.searchable = builder.searchable;
                this.sortable = builder.sortable;
            }

            @Override
            public final java.lang.Object getDisplayable() {
                return this.displayable;
            }

            @Override
            public final java.lang.Object getFacetable() {
                return this.facetable;
            }

            @Override
            public final java.lang.Object getSearchable() {
                return this.searchable;
            }

            @Override
            public final java.lang.Object getSortable() {
                return this.sortable;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDisplayable() != null) {
                    data.set("displayable", om.valueToTree(this.getDisplayable()));
                }
                if (this.getFacetable() != null) {
                    data.set("facetable", om.valueToTree(this.getFacetable()));
                }
                if (this.getSearchable() != null) {
                    data.set("searchable", om.valueToTree(this.getSearchable()));
                }
                if (this.getSortable() != null) {
                    data.set("sortable", om.valueToTree(this.getSortable()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnIndex.SearchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SearchProperty.Jsii$Proxy that = (SearchProperty.Jsii$Proxy) o;

                if (this.displayable != null ? !this.displayable.equals(that.displayable) : that.displayable != null) return false;
                if (this.facetable != null ? !this.facetable.equals(that.facetable) : that.facetable != null) return false;
                if (this.searchable != null ? !this.searchable.equals(that.searchable) : that.searchable != null) return false;
                return this.sortable != null ? this.sortable.equals(that.sortable) : that.sortable == null;
            }

            @Override
            public final int hashCode() {
                int result = this.displayable != null ? this.displayable.hashCode() : 0;
                result = 31 * result + (this.facetable != null ? this.facetable.hashCode() : 0);
                result = 31 * result + (this.searchable != null ? this.searchable.hashCode() : 0);
                result = 31 * result + (this.sortable != null ? this.sortable.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt data indexed by Amazon Kendra.
     * <p>
     * We suggest that you use a CMK from your account to help secure your index. Amazon Kendra doesn't support asymmetric CMKs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ServerSideEncryptionConfigurationProperty serverSideEncryptionConfigurationProperty = ServerSideEncryptionConfigurationProperty.builder()
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-serversideencryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-serversideencryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnIndex.ServerSideEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerSideEncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the AWS KMS key .
         * <p>
         * Amazon Kendra doesn't support asymmetric keys.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-serversideencryptionconfiguration.html#cfn-kendra-index-serversideencryptionconfiguration-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-serversideencryptionconfiguration.html#cfn-kendra-index-serversideencryptionconfiguration-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerSideEncryptionConfigurationProperty> {
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link ServerSideEncryptionConfigurationProperty#getKmsKeyId}
             * @param kmsKeyId The identifier of the AWS KMS key .
             *                 Amazon Kendra doesn't support asymmetric keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerSideEncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionConfigurationProperty {
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnIndex.ServerSideEncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionConfigurationProperty.Jsii$Proxy that = (ServerSideEncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for a token.
     * <p>
     * <blockquote>
     * <p>
     * If you're using an Amazon Kendra Gen AI Enterprise Edition index and you try to use <code>UserTokenConfigurations</code> to configure user context policy, Amazon Kendra returns a <code>ValidationException</code> error.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * UserTokenConfigurationProperty userTokenConfigurationProperty = UserTokenConfigurationProperty.builder()
     *         .jsonTokenTypeConfiguration(JsonTokenTypeConfigurationProperty.builder()
     *                 .groupAttributeField("groupAttributeField")
     *                 .userNameAttributeField("userNameAttributeField")
     *                 .build())
     *         .jwtTokenTypeConfiguration(JwtTokenTypeConfigurationProperty.builder()
     *                 .keyLocation("keyLocation")
     *                 // the properties below are optional
     *                 .claimRegex("claimRegex")
     *                 .groupAttributeField("groupAttributeField")
     *                 .issuer("issuer")
     *                 .secretManagerArn("secretManagerArn")
     *                 .url("url")
     *                 .userNameAttributeField("userNameAttributeField")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnIndex.UserTokenConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(UserTokenConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserTokenConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the JSON token type configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html#cfn-kendra-index-usertokenconfiguration-jsontokentypeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html#cfn-kendra-index-usertokenconfiguration-jsontokentypeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJsonTokenTypeConfiguration() {
            return null;
        }

        /**
         * Information about the JWT token type configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html#cfn-kendra-index-usertokenconfiguration-jwttokentypeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html#cfn-kendra-index-usertokenconfiguration-jwttokentypeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJwtTokenTypeConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserTokenConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserTokenConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserTokenConfigurationProperty> {
            java.lang.Object jsonTokenTypeConfiguration;
            java.lang.Object jwtTokenTypeConfiguration;

            /**
             * Sets the value of {@link UserTokenConfigurationProperty#getJsonTokenTypeConfiguration}
             * @param jsonTokenTypeConfiguration Information about the JSON token type configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonTokenTypeConfiguration(software.amazon.awscdk.IResolvable jsonTokenTypeConfiguration) {
                this.jsonTokenTypeConfiguration = jsonTokenTypeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link UserTokenConfigurationProperty#getJsonTokenTypeConfiguration}
             * @param jsonTokenTypeConfiguration Information about the JSON token type configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonTokenTypeConfiguration(software.amazon.awscdk.services.kendra.CfnIndex.JsonTokenTypeConfigurationProperty jsonTokenTypeConfiguration) {
                this.jsonTokenTypeConfiguration = jsonTokenTypeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link UserTokenConfigurationProperty#getJwtTokenTypeConfiguration}
             * @param jwtTokenTypeConfiguration Information about the JWT token type configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jwtTokenTypeConfiguration(software.amazon.awscdk.IResolvable jwtTokenTypeConfiguration) {
                this.jwtTokenTypeConfiguration = jwtTokenTypeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link UserTokenConfigurationProperty#getJwtTokenTypeConfiguration}
             * @param jwtTokenTypeConfiguration Information about the JWT token type configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jwtTokenTypeConfiguration(software.amazon.awscdk.services.kendra.CfnIndex.JwtTokenTypeConfigurationProperty jwtTokenTypeConfiguration) {
                this.jwtTokenTypeConfiguration = jwtTokenTypeConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserTokenConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserTokenConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserTokenConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserTokenConfigurationProperty {
            private final java.lang.Object jsonTokenTypeConfiguration;
            private final java.lang.Object jwtTokenTypeConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jsonTokenTypeConfiguration = software.amazon.jsii.Kernel.get(this, "jsonTokenTypeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jwtTokenTypeConfiguration = software.amazon.jsii.Kernel.get(this, "jwtTokenTypeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jsonTokenTypeConfiguration = builder.jsonTokenTypeConfiguration;
                this.jwtTokenTypeConfiguration = builder.jwtTokenTypeConfiguration;
            }

            @Override
            public final java.lang.Object getJsonTokenTypeConfiguration() {
                return this.jsonTokenTypeConfiguration;
            }

            @Override
            public final java.lang.Object getJwtTokenTypeConfiguration() {
                return this.jwtTokenTypeConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJsonTokenTypeConfiguration() != null) {
                    data.set("jsonTokenTypeConfiguration", om.valueToTree(this.getJsonTokenTypeConfiguration()));
                }
                if (this.getJwtTokenTypeConfiguration() != null) {
                    data.set("jwtTokenTypeConfiguration", om.valueToTree(this.getJwtTokenTypeConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnIndex.UserTokenConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserTokenConfigurationProperty.Jsii$Proxy that = (UserTokenConfigurationProperty.Jsii$Proxy) o;

                if (this.jsonTokenTypeConfiguration != null ? !this.jsonTokenTypeConfiguration.equals(that.jsonTokenTypeConfiguration) : that.jsonTokenTypeConfiguration != null) return false;
                return this.jwtTokenTypeConfiguration != null ? this.jwtTokenTypeConfiguration.equals(that.jwtTokenTypeConfiguration) : that.jwtTokenTypeConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jsonTokenTypeConfiguration != null ? this.jsonTokenTypeConfiguration.hashCode() : 0;
                result = 31 * result + (this.jwtTokenTypeConfiguration != null ? this.jwtTokenTypeConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a key-value pair of the search boost value for a document when the key is part of the metadata of a document.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ValueImportanceItemProperty valueImportanceItemProperty = ValueImportanceItemProperty.builder()
     *         .key("key")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnIndex.ValueImportanceItemProperty")
    @software.amazon.jsii.Jsii.Proxy(ValueImportanceItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ValueImportanceItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The document metadata value used for the search boost.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html#cfn-kendra-index-valueimportanceitem-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html#cfn-kendra-index-valueimportanceitem-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The boost value for a document when the key is part of the metadata of a document.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html#cfn-kendra-index-valueimportanceitem-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html#cfn-kendra-index-valueimportanceitem-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ValueImportanceItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ValueImportanceItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ValueImportanceItemProperty> {
            java.lang.String key;
            java.lang.Number value;

            /**
             * Sets the value of {@link ValueImportanceItemProperty#getKey}
             * @param key The document metadata value used for the search boost.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ValueImportanceItemProperty#getValue}
             * @param value The boost value for a document when the key is part of the metadata of a document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ValueImportanceItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ValueImportanceItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ValueImportanceItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ValueImportanceItemProperty {
            private final java.lang.String key;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnIndex.ValueImportanceItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ValueImportanceItemProperty.Jsii$Proxy that = (ValueImportanceItemProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kendra.CfnIndex}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kendra.CfnIndex> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kendra.CfnIndexProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kendra.CfnIndexProps.Builder();
        }

        /**
         * Indicates whether the index is a Enterprise Edition index, a Developer Edition index, or a GenAI Enterprise Edition index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-edition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-edition</a>
         * @param edition Indicates whether the index is a Enterprise Edition index, a Developer Edition index, or a GenAI Enterprise Edition index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edition(final java.lang.String edition) {
            this.props.edition(edition);
            return this;
        }

        /**
         * The name of the index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-name</a>
         * @param name The name of the index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * An IAM role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics.
         * <p>
         * This is also the role used when you use the <a href="https://docs.aws.amazon.com/kendra/latest/dg/BatchPutDocument.html">BatchPutDocument</a> operation to index documents from an Amazon S3 bucket.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-rolearn</a>
         * @param roleArn An IAM role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Specifies additional capacity units configured for your Enterprise Edition index.
         * <p>
         * You can add and remove capacity units to fit your usage requirements.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits</a>
         * @param capacityUnits Specifies additional capacity units configured for your Enterprise Edition index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityUnits(final software.amazon.awscdk.IResolvable capacityUnits) {
            this.props.capacityUnits(capacityUnits);
            return this;
        }
        /**
         * Specifies additional capacity units configured for your Enterprise Edition index.
         * <p>
         * You can add and remove capacity units to fit your usage requirements.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits</a>
         * @param capacityUnits Specifies additional capacity units configured for your Enterprise Edition index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityUnits(final software.amazon.awscdk.services.kendra.CfnIndex.CapacityUnitsConfigurationProperty capacityUnits) {
            this.props.capacityUnits(capacityUnits);
            return this;
        }

        /**
         * A description for the index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-description</a>
         * @param description A description for the index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies the properties of an index field.
         * <p>
         * You can add either a custom or a built-in field. You can add and remove built-in fields at any time. When a built-in field is removed it's configuration reverts to the default for the field. Custom fields can't be removed from an index after they are added.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations</a>
         * @param documentMetadataConfigurations Specifies the properties of an index field. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentMetadataConfigurations(final software.amazon.awscdk.IResolvable documentMetadataConfigurations) {
            this.props.documentMetadataConfigurations(documentMetadataConfigurations);
            return this;
        }
        /**
         * Specifies the properties of an index field.
         * <p>
         * You can add either a custom or a built-in field. You can add and remove built-in fields at any time. When a built-in field is removed it's configuration reverts to the default for the field. Custom fields can't be removed from an index after they are added.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations</a>
         * @param documentMetadataConfigurations Specifies the properties of an index field. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentMetadataConfigurations(final java.util.List<? extends java.lang.Object> documentMetadataConfigurations) {
            this.props.documentMetadataConfigurations(documentMetadataConfigurations);
            return this;
        }

        /**
         * The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
         * <p>
         * Amazon Kendra doesn't support asymmetric CMKs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration</a>
         * @param serverSideEncryptionConfiguration The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(final software.amazon.awscdk.IResolvable serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }
        /**
         * The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra.
         * <p>
         * Amazon Kendra doesn't support asymmetric CMKs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration</a>
         * @param serverSideEncryptionConfiguration The identifier of the AWS KMS customer managed key (CMK) to use to encrypt data indexed by Amazon Kendra. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(final software.amazon.awscdk.services.kendra.CfnIndex.ServerSideEncryptionConfigurationProperty serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The user context policy.
         * <p>
         * ATTRIBUTE_FILTER
         * <p>
         * <ul>
         * <li>All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can provide user and group information in <code>UserContext</code> .</li>
         * </ul>
         * <p>
         * USER_TOKEN
         * <p>
         * <ul>
         * <li>Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usercontextpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usercontextpolicy</a>
         * @param userContextPolicy The user context policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userContextPolicy(final java.lang.String userContextPolicy) {
            this.props.userContextPolicy(userContextPolicy);
            return this;
        }

        /**
         * Defines the type of user token used for the index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations</a>
         * @param userTokenConfigurations Defines the type of user token used for the index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userTokenConfigurations(final software.amazon.awscdk.IResolvable userTokenConfigurations) {
            this.props.userTokenConfigurations(userTokenConfigurations);
            return this;
        }
        /**
         * Defines the type of user token used for the index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations</a>
         * @param userTokenConfigurations Defines the type of user token used for the index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userTokenConfigurations(final java.util.List<? extends java.lang.Object> userTokenConfigurations) {
            this.props.userTokenConfigurations(userTokenConfigurations);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kendra.CfnIndex}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kendra.CfnIndex build() {
            return new software.amazon.awscdk.services.kendra.CfnIndex(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
