package software.amazon.awscdk.services.kinesis;

/**
 * What kind of server-side encryption to apply to this stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role lambdaRole = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("lambda.amazonaws.com"))
 *         .description("Example role...")
 *         .build();
 * Stream stream = Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.KMS)
 *         .build();
 * // give lambda permissions to read stream
 * stream.grantRead(lambdaRole);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:35.015Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesis.StreamEncryption")
public enum StreamEncryption {
    /**
     * Records in the stream are not encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    UNENCRYPTED,
    /**
     * Server-side encryption with a KMS key managed by the user.
     * <p>
     * If <code>encryptionKey</code> is specified, this key will be used, otherwise, one will be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KMS,
    /**
     * Server-side encryption with a master key managed by Amazon Kinesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MANAGED,
}
