package software.amazon.awscdk.services.kinesisfirehose;

/**
 * A full specification of a delivery stream that can be used to import it fluently into the CDK application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * Role role;
 * DeliveryStreamAttributes deliveryStreamAttributes = DeliveryStreamAttributes.builder()
 *         .deliveryStreamArn("deliveryStreamArn")
 *         .deliveryStreamName("deliveryStreamName")
 *         .role(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:35.200Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DeliveryStreamAttributes")
@software.amazon.jsii.Jsii.Proxy(DeliveryStreamAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeliveryStreamAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the delivery stream.
     * <p>
     * At least one of deliveryStreamArn and deliveryStreamName must be provided.
     * <p>
     * Default: - derived from `deliveryStreamName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamArn() {
        return null;
    }

    /**
     * The name of the delivery stream.
     * <p>
     * At least one of deliveryStreamName and deliveryStreamArn  must be provided.
     * <p>
     * Default: - derived from `deliveryStreamArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamName() {
        return null;
    }

    /**
     * The IAM role associated with this delivery stream.
     * <p>
     * Assumed by Kinesis Data Firehose to read from sources and encrypt data server-side.
     * <p>
     * Default: - the imported stream cannot be granted access to other resources as an `iam.IGrantable`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeliveryStreamAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeliveryStreamAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeliveryStreamAttributes> {
        java.lang.String deliveryStreamArn;
        java.lang.String deliveryStreamName;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link DeliveryStreamAttributes#getDeliveryStreamArn}
         * @param deliveryStreamArn The ARN of the delivery stream.
         *                          At least one of deliveryStreamArn and deliveryStreamName must be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamArn(java.lang.String deliveryStreamArn) {
            this.deliveryStreamArn = deliveryStreamArn;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamAttributes#getDeliveryStreamName}
         * @param deliveryStreamName The name of the delivery stream.
         *                           At least one of deliveryStreamName and deliveryStreamArn  must be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamName(java.lang.String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryStreamAttributes#getRole}
         * @param role The IAM role associated with this delivery stream.
         *             Assumed by Kinesis Data Firehose to read from sources and encrypt data server-side.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeliveryStreamAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeliveryStreamAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeliveryStreamAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryStreamAttributes {
        private final java.lang.String deliveryStreamArn;
        private final java.lang.String deliveryStreamName;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deliveryStreamArn = software.amazon.jsii.Kernel.get(this, "deliveryStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliveryStreamName = software.amazon.jsii.Kernel.get(this, "deliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deliveryStreamArn = builder.deliveryStreamArn;
            this.deliveryStreamName = builder.deliveryStreamName;
            this.role = builder.role;
        }

        @Override
        public final java.lang.String getDeliveryStreamArn() {
            return this.deliveryStreamArn;
        }

        @Override
        public final java.lang.String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeliveryStreamArn() != null) {
                data.set("deliveryStreamArn", om.valueToTree(this.getDeliveryStreamArn()));
            }
            if (this.getDeliveryStreamName() != null) {
                data.set("deliveryStreamName", om.valueToTree(this.getDeliveryStreamName()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.DeliveryStreamAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeliveryStreamAttributes.Jsii$Proxy that = (DeliveryStreamAttributes.Jsii$Proxy) o;

            if (this.deliveryStreamArn != null ? !this.deliveryStreamArn.equals(that.deliveryStreamArn) : that.deliveryStreamArn != null) return false;
            if (this.deliveryStreamName != null ? !this.deliveryStreamName.equals(that.deliveryStreamName) : that.deliveryStreamName != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deliveryStreamArn != null ? this.deliveryStreamArn.hashCode() : 0;
            result = 31 * result + (this.deliveryStreamName != null ? this.deliveryStreamName.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
