package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Represents server-side encryption for a Kinesis Firehose Delivery Stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IDestination destination;
 * // SSE with an customer-managed key that is explicitly specified
 * Key key;
 * // SSE with an AWS-owned key
 * // SSE with an AWS-owned key
 * DeliveryStream.Builder.create(this, "Delivery Stream with AWS Owned Key")
 *         .encryption(StreamEncryption.awsOwnedKey())
 *         .destination(destination)
 *         .build();
 * // SSE with an customer-managed key that is created automatically by the CDK
 * // SSE with an customer-managed key that is created automatically by the CDK
 * DeliveryStream.Builder.create(this, "Delivery Stream with Customer Managed Key")
 *         .encryption(StreamEncryption.customerManagedKey())
 *         .destination(destination)
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream with Customer Managed and Provided Key")
 *         .encryption(StreamEncryption.customerManagedKey(key))
 *         .destination(destination)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:35.210Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.StreamEncryption")
public abstract class StreamEncryption extends software.amazon.jsii.JsiiObject {

    protected StreamEncryption(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StreamEncryption(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Configure server-side encryption using an AWS owned key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.StreamEncryption awsOwnedKey() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption.class, "awsOwnedKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption.class));
    }

    /**
     * Configure server-side encryption using customer managed keys.
     * <p>
     * @param encryptionKey the KMS key for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.StreamEncryption customerManagedKey(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey encryptionKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption.class, "customerManagedKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption.class), new Object[] { encryptionKey });
    }

    /**
     * Configure server-side encryption using customer managed keys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.StreamEncryption customerManagedKey() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption.class, "customerManagedKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption.class));
    }

    /**
     * No server-side encryption is configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.StreamEncryption unencrypted() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption.class, "unencrypted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.StreamEncryption.class));
    }

    /**
     * The type of server-side encryption for the Kinesis Firehose delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.StreamEncryptionType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.StreamEncryptionType.class));
    }

    /**
     * Optional KMS key used for customer managed encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.kinesisfirehose.StreamEncryption {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
