package software.amazon.awscdk.services.lambda;

/**
 * An ADOT Lambda layer version that's specific to a lambda layer type and an architecture.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.AdotLambdaExecWrapper;
 * import software.amazon.awscdk.services.lambda.AdotLayerVersion;
 * import software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion;
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromInline("exports.handler = function(event, ctx, cb) { return cb(null, \"hi\"); }"))
 *         .adotInstrumentation(AdotInstrumentationConfig.builder()
 *                 .layerVersion(AdotLayerVersion.fromJavaScriptSdkLayerVersion(AdotLambdaLayerJavaScriptSdkVersion.LATEST))
 *                 .execWrapper(AdotLambdaExecWrapper.REGULAR_HANDLER)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:35.323Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.AdotLayerVersion")
public abstract class AdotLayerVersion extends software.amazon.jsii.JsiiObject {

    protected AdotLayerVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AdotLayerVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected AdotLayerVersion() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * The ADOT Lambda layer for generic use cases.
     * <p>
     * @param version The version of the Lambda layer to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLayerVersion fromGenericLayerVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLambdaLayerGenericVersion version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.AdotLayerVersion.class, "fromGenericLayerVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLayerVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * The ADOT Lambda layer for Java auto instrumentation.
     * <p>
     * @param version The version of the Lambda layer to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLayerVersion fromJavaAutoInstrumentationLayerVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaAutoInstrumentationVersion version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.AdotLayerVersion.class, "fromJavaAutoInstrumentationLayerVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLayerVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * The ADOT Lambda layer for JavaScript SDK.
     * <p>
     * @param version The version of the Lambda layer to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLayerVersion fromJavaScriptSdkLayerVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.AdotLayerVersion.class, "fromJavaScriptSdkLayerVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLayerVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * The ADOT Lambda layer for Java SDK.
     * <p>
     * @param version The version of the Lambda layer to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLayerVersion fromJavaSdkLayerVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaSdkVersion version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.AdotLayerVersion.class, "fromJavaSdkLayerVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLayerVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * The ADOT Lambda layer for Python SDK.
     * <p>
     * @param version The version of the Lambda layer to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLayerVersion fromPythonSdkLayerVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLambdaLayerPythonSdkVersion version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.AdotLayerVersion.class, "fromPythonSdkLayerVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLayerVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.lambda.AdotLayerVersion {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
