package software.amazon.awscdk.services.lambda;

/**
 * Properties to initialize a new EcrImageCode.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * EcrImageCodeProps ecrImageCodeProps = EcrImageCodeProps.builder()
 *         .cmd(List.of("cmd"))
 *         .entrypoint(List.of("entrypoint"))
 *         .tag("tag")
 *         .tagOrDigest("tagOrDigest")
 *         .workingDirectory("workingDirectory")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:35.426Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.EcrImageCodeProps")
@software.amazon.jsii.Jsii.Proxy(EcrImageCodeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcrImageCodeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specify or override the CMD on the specified Docker image or Dockerfile.
     * <p>
     * This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
     * <p>
     * Default: - use the CMD specified in the docker image or Dockerfile.
     * <p>
     * @see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCmd() {
        return null;
    }

    /**
     * Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile.
     * <p>
     * An ENTRYPOINT allows you to configure a container that will run as an executable.
     * This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
     * <p>
     * Default: - use the ENTRYPOINT in the docker image or Dockerfile.
     * <p>
     * @see <a href="https://docs.docker.com/engine/reference/builder/#entrypoint">https://docs.docker.com/engine/reference/builder/#entrypoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntrypoint() {
        return null;
    }

    /**
     * (deprecated) The image tag to use when pulling the image from ECR.
     * <p>
     * Default: 'latest'
     * <p>
     * @deprecated use <code>tagOrDigest</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getTag() {
        return null;
    }

    /**
     * The image tag or digest to use when pulling the image from ECR (digests must start with <code>sha256:</code>).
     * <p>
     * Default: 'latest'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTagOrDigest() {
        return null;
    }

    /**
     * Specify or override the WORKDIR on the specified Docker image or Dockerfile.
     * <p>
     * A WORKDIR allows you to configure the working directory the container will use.
     * <p>
     * Default: - use the WORKDIR in the docker image or Dockerfile.
     * <p>
     * @see <a href="https://docs.docker.com/engine/reference/builder/#workdir">https://docs.docker.com/engine/reference/builder/#workdir</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcrImageCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcrImageCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcrImageCodeProps> {
        java.util.List<java.lang.String> cmd;
        java.util.List<java.lang.String> entrypoint;
        java.lang.String tag;
        java.lang.String tagOrDigest;
        java.lang.String workingDirectory;

        /**
         * Sets the value of {@link EcrImageCodeProps#getCmd}
         * @param cmd Specify or override the CMD on the specified Docker image or Dockerfile.
         *            This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmd(java.util.List<java.lang.String> cmd) {
            this.cmd = cmd;
            return this;
        }

        /**
         * Sets the value of {@link EcrImageCodeProps#getEntrypoint}
         * @param entrypoint Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile.
         *                   An ENTRYPOINT allows you to configure a container that will run as an executable.
         *                   This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entrypoint(java.util.List<java.lang.String> entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        /**
         * Sets the value of {@link EcrImageCodeProps#getTag}
         * @param tag The image tag to use when pulling the image from ECR.
         * @return {@code this}
         * @deprecated use `tagOrDigest`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder tag(java.lang.String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Sets the value of {@link EcrImageCodeProps#getTagOrDigest}
         * @param tagOrDigest The image tag or digest to use when pulling the image from ECR (digests must start with <code>sha256:</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagOrDigest(java.lang.String tagOrDigest) {
            this.tagOrDigest = tagOrDigest;
            return this;
        }

        /**
         * Sets the value of {@link EcrImageCodeProps#getWorkingDirectory}
         * @param workingDirectory Specify or override the WORKDIR on the specified Docker image or Dockerfile.
         *                         A WORKDIR allows you to configure the working directory the container will use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcrImageCodeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcrImageCodeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcrImageCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcrImageCodeProps {
        private final java.util.List<java.lang.String> cmd;
        private final java.util.List<java.lang.String> entrypoint;
        private final java.lang.String tag;
        private final java.lang.String tagOrDigest;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cmd = software.amazon.jsii.Kernel.get(this, "cmd", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.entrypoint = software.amazon.jsii.Kernel.get(this, "entrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tag = software.amazon.jsii.Kernel.get(this, "tag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tagOrDigest = software.amazon.jsii.Kernel.get(this, "tagOrDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cmd = builder.cmd;
            this.entrypoint = builder.entrypoint;
            this.tag = builder.tag;
            this.tagOrDigest = builder.tagOrDigest;
            this.workingDirectory = builder.workingDirectory;
        }

        @Override
        public final java.util.List<java.lang.String> getCmd() {
            return this.cmd;
        }

        @Override
        public final java.util.List<java.lang.String> getEntrypoint() {
            return this.entrypoint;
        }

        @Override
        public final java.lang.String getTag() {
            return this.tag;
        }

        @Override
        public final java.lang.String getTagOrDigest() {
            return this.tagOrDigest;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCmd() != null) {
                data.set("cmd", om.valueToTree(this.getCmd()));
            }
            if (this.getEntrypoint() != null) {
                data.set("entrypoint", om.valueToTree(this.getEntrypoint()));
            }
            if (this.getTag() != null) {
                data.set("tag", om.valueToTree(this.getTag()));
            }
            if (this.getTagOrDigest() != null) {
                data.set("tagOrDigest", om.valueToTree(this.getTagOrDigest()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.EcrImageCodeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcrImageCodeProps.Jsii$Proxy that = (EcrImageCodeProps.Jsii$Proxy) o;

            if (this.cmd != null ? !this.cmd.equals(that.cmd) : that.cmd != null) return false;
            if (this.entrypoint != null ? !this.entrypoint.equals(that.entrypoint) : that.entrypoint != null) return false;
            if (this.tag != null ? !this.tag.equals(that.tag) : that.tag != null) return false;
            if (this.tagOrDigest != null ? !this.tagOrDigest.equals(that.tagOrDigest) : that.tagOrDigest != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cmd != null ? this.cmd.hashCode() : 0;
            result = 31 * result + (this.entrypoint != null ? this.entrypoint.hashCode() : 0);
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            result = 31 * result + (this.tagOrDigest != null ? this.tagOrDigest.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
