package software.amazon.awscdk.services.logs;

/**
 * Properties for a LogStream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.logs.*;
 * LogGroup logGroup;
 * LogStreamProps logStreamProps = LogStreamProps.builder()
 *         .logGroup(logGroup)
 *         // the properties below are optional
 *         .logStreamName("logStreamName")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:35.863Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.LogStreamProps")
@software.amazon.jsii.Jsii.Proxy(LogStreamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogStreamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The log group to create a log stream for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup getLogGroup();

    /**
     * The name of the log stream to create.
     * <p>
     * The name must be unique within the log group.
     * <p>
     * Default: Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogStreamName() {
        return null;
    }

    /**
     * Determine what happens when the log stream resource is removed from the app.
     * <p>
     * Normally you want to retain the log stream so you can diagnose issues from
     * logs even after a deployment that no longer includes the log stream.
     * <p>
     * The date-based retention policy of your log group will age out the logs
     * after a certain time.
     * <p>
     * Default: RemovalPolicy.Retain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogStreamProps> {
        software.amazon.awscdk.services.logs.ILogGroup logGroup;
        java.lang.String logStreamName;
        software.amazon.awscdk.RemovalPolicy removalPolicy;

        /**
         * Sets the value of {@link LogStreamProps#getLogGroup}
         * @param logGroup The log group to create a log stream for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link LogStreamProps#getLogStreamName}
         * @param logStreamName The name of the log stream to create.
         *                      The name must be unique within the log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logStreamName(java.lang.String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        /**
         * Sets the value of {@link LogStreamProps#getRemovalPolicy}
         * @param removalPolicy Determine what happens when the log stream resource is removed from the app.
         *                      Normally you want to retain the log stream so you can diagnose issues from
         *                      logs even after a deployment that no longer includes the log stream.
         *                      <p>
         *                      The date-based retention policy of your log group will age out the logs
         *                      after a certain time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogStreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogStreamProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogStreamProps {
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final java.lang.String logStreamName;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.logStreamName = software.amazon.jsii.Kernel.get(this, "logStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logGroup = java.util.Objects.requireNonNull(builder.logGroup, "logGroup is required");
            this.logStreamName = builder.logStreamName;
            this.removalPolicy = builder.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final java.lang.String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logGroup", om.valueToTree(this.getLogGroup()));
            if (this.getLogStreamName() != null) {
                data.set("logStreamName", om.valueToTree(this.getLogStreamName()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.LogStreamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogStreamProps.Jsii$Proxy that = (LogStreamProps.Jsii$Proxy) o;

            if (!logGroup.equals(that.logGroup)) return false;
            if (this.logStreamName != null ? !this.logStreamName.equals(that.logStreamName) : that.logStreamName != null) return false;
            return this.removalPolicy != null ? this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.logGroup.hashCode();
            result = 31 * result + (this.logStreamName != null ? this.logStreamName.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            return result;
        }
    }
}
