package software.amazon.awscdk.services.logs;

/**
 * Properties for a new SubscriptionFilter created from a LogGroup.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * IFilterPattern filterPattern;
 * ILogSubscriptionDestination logSubscriptionDestination;
 * SubscriptionFilterOptions subscriptionFilterOptions = SubscriptionFilterOptions.builder()
 *         .destination(logSubscriptionDestination)
 *         .filterPattern(filterPattern)
 *         // the properties below are optional
 *         .distribution(Distribution.BY_LOG_STREAM)
 *         .filterName("filterName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:35.871Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.SubscriptionFilterOptions")
@software.amazon.jsii.Jsii.Proxy(SubscriptionFilterOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubscriptionFilterOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The destination to send the filtered events to.
     * <p>
     * For example, a Kinesis stream or a Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogSubscriptionDestination getDestination();

    /**
     * Log events matching this pattern will be sent to the destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.IFilterPattern getFilterPattern();

    /**
     * The method used to distribute log data to the destination.
     * <p>
     * This property can only be used with KinesisDestination.
     * <p>
     * Default: Distribution.BY_LOG_STREAM
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.Distribution getDistribution() {
        return null;
    }

    /**
     * The name of the subscription filter.
     * <p>
     * Default: Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFilterName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SubscriptionFilterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubscriptionFilterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubscriptionFilterOptions> {
        software.amazon.awscdk.services.logs.ILogSubscriptionDestination destination;
        software.amazon.awscdk.services.logs.IFilterPattern filterPattern;
        software.amazon.awscdk.services.logs.Distribution distribution;
        java.lang.String filterName;

        /**
         * Sets the value of {@link SubscriptionFilterOptions#getDestination}
         * @param destination The destination to send the filtered events to. This parameter is required.
         *                    For example, a Kinesis stream or a Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.logs.ILogSubscriptionDestination destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionFilterOptions#getFilterPattern}
         * @param filterPattern Log events matching this pattern will be sent to the destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPattern(software.amazon.awscdk.services.logs.IFilterPattern filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionFilterOptions#getDistribution}
         * @param distribution The method used to distribute log data to the destination.
         *                     This property can only be used with KinesisDestination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distribution(software.amazon.awscdk.services.logs.Distribution distribution) {
            this.distribution = distribution;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionFilterOptions#getFilterName}
         * @param filterName The name of the subscription filter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterName(java.lang.String filterName) {
            this.filterName = filterName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubscriptionFilterOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubscriptionFilterOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubscriptionFilterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubscriptionFilterOptions {
        private final software.amazon.awscdk.services.logs.ILogSubscriptionDestination destination;
        private final software.amazon.awscdk.services.logs.IFilterPattern filterPattern;
        private final software.amazon.awscdk.services.logs.Distribution distribution;
        private final java.lang.String filterName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogSubscriptionDestination.class));
            this.filterPattern = software.amazon.jsii.Kernel.get(this, "filterPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.IFilterPattern.class));
            this.distribution = software.amazon.jsii.Kernel.get(this, "distribution", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.Distribution.class));
            this.filterName = software.amazon.jsii.Kernel.get(this, "filterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
            this.filterPattern = java.util.Objects.requireNonNull(builder.filterPattern, "filterPattern is required");
            this.distribution = builder.distribution;
            this.filterName = builder.filterName;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogSubscriptionDestination getDestination() {
            return this.destination;
        }

        @Override
        public final software.amazon.awscdk.services.logs.IFilterPattern getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final software.amazon.awscdk.services.logs.Distribution getDistribution() {
            return this.distribution;
        }

        @Override
        public final java.lang.String getFilterName() {
            return this.filterName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destination", om.valueToTree(this.getDestination()));
            data.set("filterPattern", om.valueToTree(this.getFilterPattern()));
            if (this.getDistribution() != null) {
                data.set("distribution", om.valueToTree(this.getDistribution()));
            }
            if (this.getFilterName() != null) {
                data.set("filterName", om.valueToTree(this.getFilterName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.SubscriptionFilterOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubscriptionFilterOptions.Jsii$Proxy that = (SubscriptionFilterOptions.Jsii$Proxy) o;

            if (!destination.equals(that.destination)) return false;
            if (!filterPattern.equals(that.filterPattern)) return false;
            if (this.distribution != null ? !this.distribution.equals(that.distribution) : that.distribution != null) return false;
            return this.filterName != null ? this.filterName.equals(that.filterName) : that.filterName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destination.hashCode();
            result = 31 * result + (this.filterPattern.hashCode());
            result = 31 * result + (this.distribution != null ? this.distribution.hashCode() : 0);
            result = 31 * result + (this.filterName != null ? this.filterName.hashCode() : 0);
            return result;
        }
    }
}
