package software.amazon.awscdk.services.mediaconnect;

/**
 * Properties for defining a <code>CfnFlowSource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnFlowSourceProps cfnFlowSourceProps = CfnFlowSourceProps.builder()
 *         .description("description")
 *         .name("name")
 *         // the properties below are optional
 *         .decryption(EncryptionProperty.builder()
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .algorithm("algorithm")
 *                 .constantInitializationVector("constantInitializationVector")
 *                 .deviceId("deviceId")
 *                 .keyType("keyType")
 *                 .region("region")
 *                 .resourceId("resourceId")
 *                 .secretArn("secretArn")
 *                 .url("url")
 *                 .build())
 *         .entitlementArn("entitlementArn")
 *         .flowArn("flowArn")
 *         .gatewayBridgeSource(GatewayBridgeSourceProperty.builder()
 *                 .bridgeArn("bridgeArn")
 *                 // the properties below are optional
 *                 .vpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
 *                         .vpcInterfaceName("vpcInterfaceName")
 *                         .build())
 *                 .build())
 *         .ingestPort(123)
 *         .maxBitrate(123)
 *         .maxLatency(123)
 *         .minLatency(123)
 *         .protocol("protocol")
 *         .senderControlPort(123)
 *         .senderIpAddress("senderIpAddress")
 *         .sourceListenerAddress("sourceListenerAddress")
 *         .sourceListenerPort(123)
 *         .streamId("streamId")
 *         .vpcInterfaceName("vpcInterfaceName")
 *         .whitelistCidr("whitelistCidr")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:35.992Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowSourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlowSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlowSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description of the source.
     * <p>
     * This description is not visible outside of the current AWS account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * The name of the source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The type of encryption that is used on the content ingested from the source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-decryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-decryption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDecryption() {
        return null;
    }

    /**
     * The ARN of the entitlement that allows you to subscribe to the flow.
     * <p>
     * The entitlement is set by the content originator, and the ARN is generated as part of the originator's flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-entitlementarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-entitlementarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEntitlementArn() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the flow this source is connected to.
     * <p>
     * The flow must have Failover enabled to add an additional source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-flowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-flowarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFlowArn() {
        return null;
    }

    /**
     * The source configuration for cloud flows receiving a stream from a bridge.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-gatewaybridgesource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-gatewaybridgesource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGatewayBridgeSource() {
        return null;
    }

    /**
     * The port that the flow listens on for incoming content.
     * <p>
     * If the protocol of the source is Zixi, the port must be set to 2088.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-ingestport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-ingestport</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIngestPort() {
        return null;
    }

    /**
     * The maximum bitrate for RIST, RTP, and RTP-FEC streams.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxbitrate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBitrate() {
        return null;
    }

    /**
     * The maximum latency in milliseconds.
     * <p>
     * This parameter applies only to RIST-based and Zixi-based streams.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxlatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxlatency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxLatency() {
        return null;
    }

    /**
     * The minimum latency in milliseconds for SRT-based streams.
     * <p>
     * In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-minlatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-minlatency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinLatency() {
        return null;
    }

    /**
     * The protocol that the source uses to deliver the content to MediaConnect.
     * <p>
     * Adding additional sources to an existing flow requires Failover to be enabled. When you enable Failover, the additional source must use the same protocol as the existing source. Only the following protocols support failover: Zixi-push, RTP-FEC, RTP, RIST and SRT protocols.
     * <p>
     * If you use failover with SRT caller or listener, the <code>FailoverMode</code> property must be set to <code>FAILOVER</code> . The <code>FailoverMode</code> property is found in the <code>FailoverConfig</code> resource of the same flow ARN you used for the source's <code>FlowArn</code> property. SRT caller/listener does not support merge mode failover.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-protocol</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
        return null;
    }

    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sendercontrolport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sendercontrolport</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSenderControlPort() {
        return null;
    }

    /**
     * The IP address that the flow communicates with to initiate connection with the sender.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-senderipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-senderipaddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSenderIpAddress() {
        return null;
    }

    /**
     * Source IP or domain name for SRT-caller protocol.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sourcelisteneraddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sourcelisteneraddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceListenerAddress() {
        return null;
    }

    /**
     * Source port for SRT-caller protocol.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sourcelistenerport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sourcelistenerport</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSourceListenerPort() {
        return null;
    }

    /**
     * The stream ID that you want to use for this transport.
     * <p>
     * This parameter applies only to Zixi and SRT caller-based streams.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-streamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-streamid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStreamId() {
        return null;
    }

    /**
     * The name of the VPC interface that you want to send your output to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-vpcinterfacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-vpcinterfacename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcInterfaceName() {
        return null;
    }

    /**
     * The range of IP addresses that are allowed to contribute content to your source.
     * <p>
     * Format the IP addresses as a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-whitelistcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-whitelistcidr</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWhitelistCidr() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlowSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlowSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlowSourceProps> {
        java.lang.String description;
        java.lang.String name;
        java.lang.Object decryption;
        java.lang.String entitlementArn;
        java.lang.String flowArn;
        java.lang.Object gatewayBridgeSource;
        java.lang.Number ingestPort;
        java.lang.Number maxBitrate;
        java.lang.Number maxLatency;
        java.lang.Number minLatency;
        java.lang.String protocol;
        java.lang.Number senderControlPort;
        java.lang.String senderIpAddress;
        java.lang.String sourceListenerAddress;
        java.lang.Number sourceListenerPort;
        java.lang.String streamId;
        java.lang.String vpcInterfaceName;
        java.lang.String whitelistCidr;

        /**
         * Sets the value of {@link CfnFlowSourceProps#getDescription}
         * @param description A description of the source. This parameter is required.
         *                    This description is not visible outside of the current AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getName}
         * @param name The name of the source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getDecryption}
         * @param decryption The type of encryption that is used on the content ingested from the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder decryption(software.amazon.awscdk.IResolvable decryption) {
            this.decryption = decryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getDecryption}
         * @param decryption The type of encryption that is used on the content ingested from the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder decryption(software.amazon.awscdk.services.mediaconnect.CfnFlowSource.EncryptionProperty decryption) {
            this.decryption = decryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getEntitlementArn}
         * @param entitlementArn The ARN of the entitlement that allows you to subscribe to the flow.
         *                       The entitlement is set by the content originator, and the ARN is generated as part of the originator's flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entitlementArn(java.lang.String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getFlowArn}
         * @param flowArn The Amazon Resource Name (ARN) of the flow this source is connected to.
         *                The flow must have Failover enabled to add an additional source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowArn(java.lang.String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getGatewayBridgeSource}
         * @param gatewayBridgeSource The source configuration for cloud flows receiving a stream from a bridge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayBridgeSource(software.amazon.awscdk.IResolvable gatewayBridgeSource) {
            this.gatewayBridgeSource = gatewayBridgeSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getGatewayBridgeSource}
         * @param gatewayBridgeSource The source configuration for cloud flows receiving a stream from a bridge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayBridgeSource(software.amazon.awscdk.services.mediaconnect.CfnFlowSource.GatewayBridgeSourceProperty gatewayBridgeSource) {
            this.gatewayBridgeSource = gatewayBridgeSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getIngestPort}
         * @param ingestPort The port that the flow listens on for incoming content.
         *                   If the protocol of the source is Zixi, the port must be set to 2088.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestPort(java.lang.Number ingestPort) {
            this.ingestPort = ingestPort;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getMaxBitrate}
         * @param maxBitrate The maximum bitrate for RIST, RTP, and RTP-FEC streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBitrate(java.lang.Number maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getMaxLatency}
         * @param maxLatency The maximum latency in milliseconds.
         *                   This parameter applies only to RIST-based and Zixi-based streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxLatency(java.lang.Number maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getMinLatency}
         * @param minLatency The minimum latency in milliseconds for SRT-based streams.
         *                   In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minLatency(java.lang.Number minLatency) {
            this.minLatency = minLatency;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getProtocol}
         * @param protocol The protocol that the source uses to deliver the content to MediaConnect.
         *                 Adding additional sources to an existing flow requires Failover to be enabled. When you enable Failover, the additional source must use the same protocol as the existing source. Only the following protocols support failover: Zixi-push, RTP-FEC, RTP, RIST and SRT protocols.
         *                 <p>
         *                 If you use failover with SRT caller or listener, the <code>FailoverMode</code> property must be set to <code>FAILOVER</code> . The <code>FailoverMode</code> property is found in the <code>FailoverConfig</code> resource of the same flow ARN you used for the source's <code>FlowArn</code> property. SRT caller/listener does not support merge mode failover.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getSenderControlPort}
         * @param senderControlPort The port that the flow uses to send outbound requests to initiate connection with the sender.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder senderControlPort(java.lang.Number senderControlPort) {
            this.senderControlPort = senderControlPort;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getSenderIpAddress}
         * @param senderIpAddress The IP address that the flow communicates with to initiate connection with the sender.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder senderIpAddress(java.lang.String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getSourceListenerAddress}
         * @param sourceListenerAddress Source IP or domain name for SRT-caller protocol.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceListenerAddress(java.lang.String sourceListenerAddress) {
            this.sourceListenerAddress = sourceListenerAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getSourceListenerPort}
         * @param sourceListenerPort Source port for SRT-caller protocol.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceListenerPort(java.lang.Number sourceListenerPort) {
            this.sourceListenerPort = sourceListenerPort;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getStreamId}
         * @param streamId The stream ID that you want to use for this transport.
         *                 This parameter applies only to Zixi and SRT caller-based streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamId(java.lang.String streamId) {
            this.streamId = streamId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getVpcInterfaceName}
         * @param vpcInterfaceName The name of the VPC interface that you want to send your output to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcInterfaceName(java.lang.String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowSourceProps#getWhitelistCidr}
         * @param whitelistCidr The range of IP addresses that are allowed to contribute content to your source.
         *                      Format the IP addresses as a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder whitelistCidr(java.lang.String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlowSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlowSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFlowSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlowSourceProps {
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.lang.Object decryption;
        private final java.lang.String entitlementArn;
        private final java.lang.String flowArn;
        private final java.lang.Object gatewayBridgeSource;
        private final java.lang.Number ingestPort;
        private final java.lang.Number maxBitrate;
        private final java.lang.Number maxLatency;
        private final java.lang.Number minLatency;
        private final java.lang.String protocol;
        private final java.lang.Number senderControlPort;
        private final java.lang.String senderIpAddress;
        private final java.lang.String sourceListenerAddress;
        private final java.lang.Number sourceListenerPort;
        private final java.lang.String streamId;
        private final java.lang.String vpcInterfaceName;
        private final java.lang.String whitelistCidr;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.decryption = software.amazon.jsii.Kernel.get(this, "decryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.entitlementArn = software.amazon.jsii.Kernel.get(this, "entitlementArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.flowArn = software.amazon.jsii.Kernel.get(this, "flowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gatewayBridgeSource = software.amazon.jsii.Kernel.get(this, "gatewayBridgeSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ingestPort = software.amazon.jsii.Kernel.get(this, "ingestPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxBitrate = software.amazon.jsii.Kernel.get(this, "maxBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxLatency = software.amazon.jsii.Kernel.get(this, "maxLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minLatency = software.amazon.jsii.Kernel.get(this, "minLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.senderControlPort = software.amazon.jsii.Kernel.get(this, "senderControlPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.senderIpAddress = software.amazon.jsii.Kernel.get(this, "senderIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceListenerAddress = software.amazon.jsii.Kernel.get(this, "sourceListenerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceListenerPort = software.amazon.jsii.Kernel.get(this, "sourceListenerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.streamId = software.amazon.jsii.Kernel.get(this, "streamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcInterfaceName = software.amazon.jsii.Kernel.get(this, "vpcInterfaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.whitelistCidr = software.amazon.jsii.Kernel.get(this, "whitelistCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.decryption = builder.decryption;
            this.entitlementArn = builder.entitlementArn;
            this.flowArn = builder.flowArn;
            this.gatewayBridgeSource = builder.gatewayBridgeSource;
            this.ingestPort = builder.ingestPort;
            this.maxBitrate = builder.maxBitrate;
            this.maxLatency = builder.maxLatency;
            this.minLatency = builder.minLatency;
            this.protocol = builder.protocol;
            this.senderControlPort = builder.senderControlPort;
            this.senderIpAddress = builder.senderIpAddress;
            this.sourceListenerAddress = builder.sourceListenerAddress;
            this.sourceListenerPort = builder.sourceListenerPort;
            this.streamId = builder.streamId;
            this.vpcInterfaceName = builder.vpcInterfaceName;
            this.whitelistCidr = builder.whitelistCidr;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getDecryption() {
            return this.decryption;
        }

        @Override
        public final java.lang.String getEntitlementArn() {
            return this.entitlementArn;
        }

        @Override
        public final java.lang.String getFlowArn() {
            return this.flowArn;
        }

        @Override
        public final java.lang.Object getGatewayBridgeSource() {
            return this.gatewayBridgeSource;
        }

        @Override
        public final java.lang.Number getIngestPort() {
            return this.ingestPort;
        }

        @Override
        public final java.lang.Number getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final java.lang.Number getMaxLatency() {
            return this.maxLatency;
        }

        @Override
        public final java.lang.Number getMinLatency() {
            return this.minLatency;
        }

        @Override
        public final java.lang.String getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.lang.Number getSenderControlPort() {
            return this.senderControlPort;
        }

        @Override
        public final java.lang.String getSenderIpAddress() {
            return this.senderIpAddress;
        }

        @Override
        public final java.lang.String getSourceListenerAddress() {
            return this.sourceListenerAddress;
        }

        @Override
        public final java.lang.Number getSourceListenerPort() {
            return this.sourceListenerPort;
        }

        @Override
        public final java.lang.String getStreamId() {
            return this.streamId;
        }

        @Override
        public final java.lang.String getVpcInterfaceName() {
            return this.vpcInterfaceName;
        }

        @Override
        public final java.lang.String getWhitelistCidr() {
            return this.whitelistCidr;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("description", om.valueToTree(this.getDescription()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDecryption() != null) {
                data.set("decryption", om.valueToTree(this.getDecryption()));
            }
            if (this.getEntitlementArn() != null) {
                data.set("entitlementArn", om.valueToTree(this.getEntitlementArn()));
            }
            if (this.getFlowArn() != null) {
                data.set("flowArn", om.valueToTree(this.getFlowArn()));
            }
            if (this.getGatewayBridgeSource() != null) {
                data.set("gatewayBridgeSource", om.valueToTree(this.getGatewayBridgeSource()));
            }
            if (this.getIngestPort() != null) {
                data.set("ingestPort", om.valueToTree(this.getIngestPort()));
            }
            if (this.getMaxBitrate() != null) {
                data.set("maxBitrate", om.valueToTree(this.getMaxBitrate()));
            }
            if (this.getMaxLatency() != null) {
                data.set("maxLatency", om.valueToTree(this.getMaxLatency()));
            }
            if (this.getMinLatency() != null) {
                data.set("minLatency", om.valueToTree(this.getMinLatency()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getSenderControlPort() != null) {
                data.set("senderControlPort", om.valueToTree(this.getSenderControlPort()));
            }
            if (this.getSenderIpAddress() != null) {
                data.set("senderIpAddress", om.valueToTree(this.getSenderIpAddress()));
            }
            if (this.getSourceListenerAddress() != null) {
                data.set("sourceListenerAddress", om.valueToTree(this.getSourceListenerAddress()));
            }
            if (this.getSourceListenerPort() != null) {
                data.set("sourceListenerPort", om.valueToTree(this.getSourceListenerPort()));
            }
            if (this.getStreamId() != null) {
                data.set("streamId", om.valueToTree(this.getStreamId()));
            }
            if (this.getVpcInterfaceName() != null) {
                data.set("vpcInterfaceName", om.valueToTree(this.getVpcInterfaceName()));
            }
            if (this.getWhitelistCidr() != null) {
                data.set("whitelistCidr", om.valueToTree(this.getWhitelistCidr()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlowSourceProps.Jsii$Proxy that = (CfnFlowSourceProps.Jsii$Proxy) o;

            if (!description.equals(that.description)) return false;
            if (!name.equals(that.name)) return false;
            if (this.decryption != null ? !this.decryption.equals(that.decryption) : that.decryption != null) return false;
            if (this.entitlementArn != null ? !this.entitlementArn.equals(that.entitlementArn) : that.entitlementArn != null) return false;
            if (this.flowArn != null ? !this.flowArn.equals(that.flowArn) : that.flowArn != null) return false;
            if (this.gatewayBridgeSource != null ? !this.gatewayBridgeSource.equals(that.gatewayBridgeSource) : that.gatewayBridgeSource != null) return false;
            if (this.ingestPort != null ? !this.ingestPort.equals(that.ingestPort) : that.ingestPort != null) return false;
            if (this.maxBitrate != null ? !this.maxBitrate.equals(that.maxBitrate) : that.maxBitrate != null) return false;
            if (this.maxLatency != null ? !this.maxLatency.equals(that.maxLatency) : that.maxLatency != null) return false;
            if (this.minLatency != null ? !this.minLatency.equals(that.minLatency) : that.minLatency != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.senderControlPort != null ? !this.senderControlPort.equals(that.senderControlPort) : that.senderControlPort != null) return false;
            if (this.senderIpAddress != null ? !this.senderIpAddress.equals(that.senderIpAddress) : that.senderIpAddress != null) return false;
            if (this.sourceListenerAddress != null ? !this.sourceListenerAddress.equals(that.sourceListenerAddress) : that.sourceListenerAddress != null) return false;
            if (this.sourceListenerPort != null ? !this.sourceListenerPort.equals(that.sourceListenerPort) : that.sourceListenerPort != null) return false;
            if (this.streamId != null ? !this.streamId.equals(that.streamId) : that.streamId != null) return false;
            if (this.vpcInterfaceName != null ? !this.vpcInterfaceName.equals(that.vpcInterfaceName) : that.vpcInterfaceName != null) return false;
            return this.whitelistCidr != null ? this.whitelistCidr.equals(that.whitelistCidr) : that.whitelistCidr == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.decryption != null ? this.decryption.hashCode() : 0);
            result = 31 * result + (this.entitlementArn != null ? this.entitlementArn.hashCode() : 0);
            result = 31 * result + (this.flowArn != null ? this.flowArn.hashCode() : 0);
            result = 31 * result + (this.gatewayBridgeSource != null ? this.gatewayBridgeSource.hashCode() : 0);
            result = 31 * result + (this.ingestPort != null ? this.ingestPort.hashCode() : 0);
            result = 31 * result + (this.maxBitrate != null ? this.maxBitrate.hashCode() : 0);
            result = 31 * result + (this.maxLatency != null ? this.maxLatency.hashCode() : 0);
            result = 31 * result + (this.minLatency != null ? this.minLatency.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.senderControlPort != null ? this.senderControlPort.hashCode() : 0);
            result = 31 * result + (this.senderIpAddress != null ? this.senderIpAddress.hashCode() : 0);
            result = 31 * result + (this.sourceListenerAddress != null ? this.sourceListenerAddress.hashCode() : 0);
            result = 31 * result + (this.sourceListenerPort != null ? this.sourceListenerPort.hashCode() : 0);
            result = 31 * result + (this.streamId != null ? this.streamId.hashCode() : 0);
            result = 31 * result + (this.vpcInterfaceName != null ? this.vpcInterfaceName.hashCode() : 0);
            result = 31 * result + (this.whitelistCidr != null ? this.whitelistCidr.hashCode() : 0);
            return result;
        }
    }
}
