package software.amazon.awscdk.services.mediapackagev2;

/**
 * Properties for defining a <code>CfnOriginEndpoint</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediapackagev2.*;
 * CfnOriginEndpointProps cfnOriginEndpointProps = CfnOriginEndpointProps.builder()
 *         .channelGroupName("channelGroupName")
 *         .channelName("channelName")
 *         .containerType("containerType")
 *         .originEndpointName("originEndpointName")
 *         // the properties below are optional
 *         .dashManifests(List.of(DashManifestConfigurationProperty.builder()
 *                 .manifestName("manifestName")
 *                 // the properties below are optional
 *                 .drmSignaling("drmSignaling")
 *                 .filterConfiguration(FilterConfigurationProperty.builder()
 *                         .clipStartTime("clipStartTime")
 *                         .end("end")
 *                         .manifestFilter("manifestFilter")
 *                         .start("start")
 *                         .timeDelaySeconds(123)
 *                         .build())
 *                 .manifestWindowSeconds(123)
 *                 .minBufferTimeSeconds(123)
 *                 .minUpdatePeriodSeconds(123)
 *                 .periodTriggers(List.of("periodTriggers"))
 *                 .scteDash(ScteDashProperty.builder()
 *                         .adMarkerDash("adMarkerDash")
 *                         .build())
 *                 .segmentTemplateFormat("segmentTemplateFormat")
 *                 .suggestedPresentationDelaySeconds(123)
 *                 .utcTiming(DashUtcTimingProperty.builder()
 *                         .timingMode("timingMode")
 *                         .timingSource("timingSource")
 *                         .build())
 *                 .build()))
 *         .description("description")
 *         .forceEndpointErrorConfiguration(ForceEndpointErrorConfigurationProperty.builder()
 *                 .endpointErrorConditions(List.of("endpointErrorConditions"))
 *                 .build())
 *         .hlsManifests(List.of(HlsManifestConfigurationProperty.builder()
 *                 .manifestName("manifestName")
 *                 // the properties below are optional
 *                 .childManifestName("childManifestName")
 *                 .filterConfiguration(FilterConfigurationProperty.builder()
 *                         .clipStartTime("clipStartTime")
 *                         .end("end")
 *                         .manifestFilter("manifestFilter")
 *                         .start("start")
 *                         .timeDelaySeconds(123)
 *                         .build())
 *                 .manifestWindowSeconds(123)
 *                 .programDateTimeIntervalSeconds(123)
 *                 .scteHls(ScteHlsProperty.builder()
 *                         .adMarkerHls("adMarkerHls")
 *                         .build())
 *                 .startTag(StartTagProperty.builder()
 *                         .timeOffset(123)
 *                         // the properties below are optional
 *                         .precise(false)
 *                         .build())
 *                 .url("url")
 *                 .build()))
 *         .lowLatencyHlsManifests(List.of(LowLatencyHlsManifestConfigurationProperty.builder()
 *                 .manifestName("manifestName")
 *                 // the properties below are optional
 *                 .childManifestName("childManifestName")
 *                 .filterConfiguration(FilterConfigurationProperty.builder()
 *                         .clipStartTime("clipStartTime")
 *                         .end("end")
 *                         .manifestFilter("manifestFilter")
 *                         .start("start")
 *                         .timeDelaySeconds(123)
 *                         .build())
 *                 .manifestWindowSeconds(123)
 *                 .programDateTimeIntervalSeconds(123)
 *                 .scteHls(ScteHlsProperty.builder()
 *                         .adMarkerHls("adMarkerHls")
 *                         .build())
 *                 .startTag(StartTagProperty.builder()
 *                         .timeOffset(123)
 *                         // the properties below are optional
 *                         .precise(false)
 *                         .build())
 *                 .url("url")
 *                 .build()))
 *         .segment(SegmentProperty.builder()
 *                 .encryption(EncryptionProperty.builder()
 *                         .encryptionMethod(EncryptionMethodProperty.builder()
 *                                 .cmafEncryptionMethod("cmafEncryptionMethod")
 *                                 .tsEncryptionMethod("tsEncryptionMethod")
 *                                 .build())
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .drmSystems(List.of("drmSystems"))
 *                                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
 *                                         .presetSpeke20Audio("presetSpeke20Audio")
 *                                         .presetSpeke20Video("presetSpeke20Video")
 *                                         .build())
 *                                 .resourceId("resourceId")
 *                                 .roleArn("roleArn")
 *                                 .url("url")
 *                                 .build())
 *                         // the properties below are optional
 *                         .constantInitializationVector("constantInitializationVector")
 *                         .keyRotationIntervalSeconds(123)
 *                         .build())
 *                 .includeIframeOnlyStreams(false)
 *                 .scte(ScteProperty.builder()
 *                         .scteFilter(List.of("scteFilter"))
 *                         .build())
 *                 .segmentDurationSeconds(123)
 *                 .segmentName("segmentName")
 *                 .tsIncludeDvbSubtitles(false)
 *                 .tsUseAudioRenditionGroup(false)
 *                 .build())
 *         .startoverWindowSeconds(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:36.301Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnOriginEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOriginEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the channel group associated with the origin endpoint configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-channelgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-channelgroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelGroupName();

    /**
     * The channel name associated with the origin endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-channelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-channelname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelName();

    /**
     * The container type associated with the origin endpoint configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-containertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-containertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContainerType();

    /**
     * The name of the origin endpoint associated with the origin endpoint configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-originendpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-originendpointname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOriginEndpointName();

    /**
     * A DASH manifest configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-dashmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-dashmanifests</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDashManifests() {
        return null;
    }

    /**
     * The description associated with the origin endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The failover settings for the endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-forceendpointerrorconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-forceendpointerrorconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getForceEndpointErrorConfiguration() {
        return null;
    }

    /**
     * The HLS manfiests associated with the origin endpoint configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-hlsmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-hlsmanifests</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHlsManifests() {
        return null;
    }

    /**
     * The low-latency HLS (LL-HLS) manifests associated with the origin endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifests</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLowLatencyHlsManifests() {
        return null;
    }

    /**
     * The segment associated with the origin endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-segment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-segment</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSegment() {
        return null;
    }

    /**
     * The size of the window (in seconds) to specify a window of the live stream that's available for on-demand viewing.
     * <p>
     * Viewers can start-over or catch-up on content that falls within the window.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-startoverwindowseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-startoverwindowseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStartoverWindowSeconds() {
        return null;
    }

    /**
     * The tags associated with the origin endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnOriginEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnOriginEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnOriginEndpointProps> {
        java.lang.String channelGroupName;
        java.lang.String channelName;
        java.lang.String containerType;
        java.lang.String originEndpointName;
        java.lang.Object dashManifests;
        java.lang.String description;
        java.lang.Object forceEndpointErrorConfiguration;
        java.lang.Object hlsManifests;
        java.lang.Object lowLatencyHlsManifests;
        java.lang.Object segment;
        java.lang.Number startoverWindowSeconds;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getChannelGroupName}
         * @param channelGroupName The name of the channel group associated with the origin endpoint configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelGroupName(java.lang.String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getChannelName}
         * @param channelName The channel name associated with the origin endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelName(java.lang.String channelName) {
            this.channelName = channelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getContainerType}
         * @param containerType The container type associated with the origin endpoint configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerType(java.lang.String containerType) {
            this.containerType = containerType;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getOriginEndpointName}
         * @param originEndpointName The name of the origin endpoint associated with the origin endpoint configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originEndpointName(java.lang.String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getDashManifests}
         * @param dashManifests A DASH manifest configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashManifests(software.amazon.awscdk.IResolvable dashManifests) {
            this.dashManifests = dashManifests;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getDashManifests}
         * @param dashManifests A DASH manifest configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashManifests(java.util.List<? extends java.lang.Object> dashManifests) {
            this.dashManifests = dashManifests;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getDescription}
         * @param description The description associated with the origin endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getForceEndpointErrorConfiguration}
         * @param forceEndpointErrorConfiguration The failover settings for the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceEndpointErrorConfiguration(software.amazon.awscdk.IResolvable forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getForceEndpointErrorConfiguration}
         * @param forceEndpointErrorConfiguration The failover settings for the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceEndpointErrorConfiguration(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ForceEndpointErrorConfigurationProperty forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getHlsManifests}
         * @param hlsManifests The HLS manfiests associated with the origin endpoint configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsManifests(software.amazon.awscdk.IResolvable hlsManifests) {
            this.hlsManifests = hlsManifests;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getHlsManifests}
         * @param hlsManifests The HLS manfiests associated with the origin endpoint configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsManifests(java.util.List<? extends java.lang.Object> hlsManifests) {
            this.hlsManifests = hlsManifests;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getLowLatencyHlsManifests}
         * @param lowLatencyHlsManifests The low-latency HLS (LL-HLS) manifests associated with the origin endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowLatencyHlsManifests(software.amazon.awscdk.IResolvable lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = lowLatencyHlsManifests;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getLowLatencyHlsManifests}
         * @param lowLatencyHlsManifests The low-latency HLS (LL-HLS) manifests associated with the origin endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowLatencyHlsManifests(java.util.List<? extends java.lang.Object> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = lowLatencyHlsManifests;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getSegment}
         * @param segment The segment associated with the origin endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segment(software.amazon.awscdk.IResolvable segment) {
            this.segment = segment;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getSegment}
         * @param segment The segment associated with the origin endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segment(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.SegmentProperty segment) {
            this.segment = segment;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getStartoverWindowSeconds}
         * @param startoverWindowSeconds The size of the window (in seconds) to specify a window of the live stream that's available for on-demand viewing.
         *                               Viewers can start-over or catch-up on content that falls within the window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startoverWindowSeconds(java.lang.Number startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginEndpointProps#getTags}
         * @param tags The tags associated with the origin endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOriginEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnOriginEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnOriginEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOriginEndpointProps {
        private final java.lang.String channelGroupName;
        private final java.lang.String channelName;
        private final java.lang.String containerType;
        private final java.lang.String originEndpointName;
        private final java.lang.Object dashManifests;
        private final java.lang.String description;
        private final java.lang.Object forceEndpointErrorConfiguration;
        private final java.lang.Object hlsManifests;
        private final java.lang.Object lowLatencyHlsManifests;
        private final java.lang.Object segment;
        private final java.lang.Number startoverWindowSeconds;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelGroupName = software.amazon.jsii.Kernel.get(this, "channelGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.channelName = software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containerType = software.amazon.jsii.Kernel.get(this, "containerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.originEndpointName = software.amazon.jsii.Kernel.get(this, "originEndpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dashManifests = software.amazon.jsii.Kernel.get(this, "dashManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.forceEndpointErrorConfiguration = software.amazon.jsii.Kernel.get(this, "forceEndpointErrorConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.hlsManifests = software.amazon.jsii.Kernel.get(this, "hlsManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lowLatencyHlsManifests = software.amazon.jsii.Kernel.get(this, "lowLatencyHlsManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.segment = software.amazon.jsii.Kernel.get(this, "segment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.startoverWindowSeconds = software.amazon.jsii.Kernel.get(this, "startoverWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelGroupName = java.util.Objects.requireNonNull(builder.channelGroupName, "channelGroupName is required");
            this.channelName = java.util.Objects.requireNonNull(builder.channelName, "channelName is required");
            this.containerType = java.util.Objects.requireNonNull(builder.containerType, "containerType is required");
            this.originEndpointName = java.util.Objects.requireNonNull(builder.originEndpointName, "originEndpointName is required");
            this.dashManifests = builder.dashManifests;
            this.description = builder.description;
            this.forceEndpointErrorConfiguration = builder.forceEndpointErrorConfiguration;
            this.hlsManifests = builder.hlsManifests;
            this.lowLatencyHlsManifests = builder.lowLatencyHlsManifests;
            this.segment = builder.segment;
            this.startoverWindowSeconds = builder.startoverWindowSeconds;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getChannelGroupName() {
            return this.channelGroupName;
        }

        @Override
        public final java.lang.String getChannelName() {
            return this.channelName;
        }

        @Override
        public final java.lang.String getContainerType() {
            return this.containerType;
        }

        @Override
        public final java.lang.String getOriginEndpointName() {
            return this.originEndpointName;
        }

        @Override
        public final java.lang.Object getDashManifests() {
            return this.dashManifests;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getForceEndpointErrorConfiguration() {
            return this.forceEndpointErrorConfiguration;
        }

        @Override
        public final java.lang.Object getHlsManifests() {
            return this.hlsManifests;
        }

        @Override
        public final java.lang.Object getLowLatencyHlsManifests() {
            return this.lowLatencyHlsManifests;
        }

        @Override
        public final java.lang.Object getSegment() {
            return this.segment;
        }

        @Override
        public final java.lang.Number getStartoverWindowSeconds() {
            return this.startoverWindowSeconds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelGroupName", om.valueToTree(this.getChannelGroupName()));
            data.set("channelName", om.valueToTree(this.getChannelName()));
            data.set("containerType", om.valueToTree(this.getContainerType()));
            data.set("originEndpointName", om.valueToTree(this.getOriginEndpointName()));
            if (this.getDashManifests() != null) {
                data.set("dashManifests", om.valueToTree(this.getDashManifests()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getForceEndpointErrorConfiguration() != null) {
                data.set("forceEndpointErrorConfiguration", om.valueToTree(this.getForceEndpointErrorConfiguration()));
            }
            if (this.getHlsManifests() != null) {
                data.set("hlsManifests", om.valueToTree(this.getHlsManifests()));
            }
            if (this.getLowLatencyHlsManifests() != null) {
                data.set("lowLatencyHlsManifests", om.valueToTree(this.getLowLatencyHlsManifests()));
            }
            if (this.getSegment() != null) {
                data.set("segment", om.valueToTree(this.getSegment()));
            }
            if (this.getStartoverWindowSeconds() != null) {
                data.set("startoverWindowSeconds", om.valueToTree(this.getStartoverWindowSeconds()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOriginEndpointProps.Jsii$Proxy that = (CfnOriginEndpointProps.Jsii$Proxy) o;

            if (!channelGroupName.equals(that.channelGroupName)) return false;
            if (!channelName.equals(that.channelName)) return false;
            if (!containerType.equals(that.containerType)) return false;
            if (!originEndpointName.equals(that.originEndpointName)) return false;
            if (this.dashManifests != null ? !this.dashManifests.equals(that.dashManifests) : that.dashManifests != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.forceEndpointErrorConfiguration != null ? !this.forceEndpointErrorConfiguration.equals(that.forceEndpointErrorConfiguration) : that.forceEndpointErrorConfiguration != null) return false;
            if (this.hlsManifests != null ? !this.hlsManifests.equals(that.hlsManifests) : that.hlsManifests != null) return false;
            if (this.lowLatencyHlsManifests != null ? !this.lowLatencyHlsManifests.equals(that.lowLatencyHlsManifests) : that.lowLatencyHlsManifests != null) return false;
            if (this.segment != null ? !this.segment.equals(that.segment) : that.segment != null) return false;
            if (this.startoverWindowSeconds != null ? !this.startoverWindowSeconds.equals(that.startoverWindowSeconds) : that.startoverWindowSeconds != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.channelGroupName.hashCode();
            result = 31 * result + (this.channelName.hashCode());
            result = 31 * result + (this.containerType.hashCode());
            result = 31 * result + (this.originEndpointName.hashCode());
            result = 31 * result + (this.dashManifests != null ? this.dashManifests.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.forceEndpointErrorConfiguration != null ? this.forceEndpointErrorConfiguration.hashCode() : 0);
            result = 31 * result + (this.hlsManifests != null ? this.hlsManifests.hashCode() : 0);
            result = 31 * result + (this.lowLatencyHlsManifests != null ? this.lowLatencyHlsManifests.hashCode() : 0);
            result = 31 * result + (this.segment != null ? this.segment.hashCode() : 0);
            result = 31 * result + (this.startoverWindowSeconds != null ? this.startoverWindowSeconds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
