package software.amazon.awscdk.services.panorama;

/**
 * Properties for defining a <code>CfnApplicationInstance</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.panorama.*;
 * CfnApplicationInstanceProps cfnApplicationInstanceProps = CfnApplicationInstanceProps.builder()
 *         .defaultRuntimeContextDevice("defaultRuntimeContextDevice")
 *         .manifestPayload(ManifestPayloadProperty.builder()
 *                 .payloadData("payloadData")
 *                 .build())
 *         // the properties below are optional
 *         .applicationInstanceIdToReplace("applicationInstanceIdToReplace")
 *         .description("description")
 *         .manifestOverridesPayload(ManifestOverridesPayloadProperty.builder()
 *                 .payloadData("payloadData")
 *                 .build())
 *         .name("name")
 *         .runtimeRoleArn("runtimeRoleArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:36.775Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_panorama.CfnApplicationInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The device's ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-defaultruntimecontextdevice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-defaultruntimecontextdevice</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDefaultRuntimeContextDevice();

    /**
     * The application's manifest document.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-manifestpayload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-manifestpayload</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getManifestPayload();

    /**
     * The ID of an application instance to replace with the new instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-applicationinstanceidtoreplace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-applicationinstanceidtoreplace</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationInstanceIdToReplace() {
        return null;
    }

    /**
     * A description for the application instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Setting overrides for the application manifest.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-manifestoverridespayload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-manifestoverridespayload</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getManifestOverridesPayload() {
        return null;
    }

    /**
     * A name for the application instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The ARN of a runtime role for the application instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-runtimerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-runtimerolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuntimeRoleArn() {
        return null;
    }

    /**
     * Tags for the application instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-applicationinstance.html#cfn-panorama-applicationinstance-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationInstanceProps> {
        java.lang.String defaultRuntimeContextDevice;
        java.lang.Object manifestPayload;
        java.lang.String applicationInstanceIdToReplace;
        java.lang.String description;
        java.lang.Object manifestOverridesPayload;
        java.lang.String name;
        java.lang.String runtimeRoleArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnApplicationInstanceProps#getDefaultRuntimeContextDevice}
         * @param defaultRuntimeContextDevice The device's ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRuntimeContextDevice(java.lang.String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationInstanceProps#getManifestPayload}
         * @param manifestPayload The application's manifest document. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestPayload(software.amazon.awscdk.IResolvable manifestPayload) {
            this.manifestPayload = manifestPayload;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationInstanceProps#getManifestPayload}
         * @param manifestPayload The application's manifest document. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestPayload(software.amazon.awscdk.services.panorama.CfnApplicationInstance.ManifestPayloadProperty manifestPayload) {
            this.manifestPayload = manifestPayload;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationInstanceProps#getApplicationInstanceIdToReplace}
         * @param applicationInstanceIdToReplace The ID of an application instance to replace with the new instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationInstanceIdToReplace(java.lang.String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationInstanceProps#getDescription}
         * @param description A description for the application instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationInstanceProps#getManifestOverridesPayload}
         * @param manifestOverridesPayload Setting overrides for the application manifest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestOverridesPayload(software.amazon.awscdk.IResolvable manifestOverridesPayload) {
            this.manifestOverridesPayload = manifestOverridesPayload;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationInstanceProps#getManifestOverridesPayload}
         * @param manifestOverridesPayload Setting overrides for the application manifest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestOverridesPayload(software.amazon.awscdk.services.panorama.CfnApplicationInstance.ManifestOverridesPayloadProperty manifestOverridesPayload) {
            this.manifestOverridesPayload = manifestOverridesPayload;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationInstanceProps#getName}
         * @param name A name for the application instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationInstanceProps#getRuntimeRoleArn}
         * @param runtimeRoleArn The ARN of a runtime role for the application instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeRoleArn(java.lang.String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationInstanceProps#getTags}
         * @param tags Tags for the application instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationInstanceProps {
        private final java.lang.String defaultRuntimeContextDevice;
        private final java.lang.Object manifestPayload;
        private final java.lang.String applicationInstanceIdToReplace;
        private final java.lang.String description;
        private final java.lang.Object manifestOverridesPayload;
        private final java.lang.String name;
        private final java.lang.String runtimeRoleArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultRuntimeContextDevice = software.amazon.jsii.Kernel.get(this, "defaultRuntimeContextDevice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.manifestPayload = software.amazon.jsii.Kernel.get(this, "manifestPayload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.applicationInstanceIdToReplace = software.amazon.jsii.Kernel.get(this, "applicationInstanceIdToReplace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.manifestOverridesPayload = software.amazon.jsii.Kernel.get(this, "manifestOverridesPayload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runtimeRoleArn = software.amazon.jsii.Kernel.get(this, "runtimeRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultRuntimeContextDevice = java.util.Objects.requireNonNull(builder.defaultRuntimeContextDevice, "defaultRuntimeContextDevice is required");
            this.manifestPayload = java.util.Objects.requireNonNull(builder.manifestPayload, "manifestPayload is required");
            this.applicationInstanceIdToReplace = builder.applicationInstanceIdToReplace;
            this.description = builder.description;
            this.manifestOverridesPayload = builder.manifestOverridesPayload;
            this.name = builder.name;
            this.runtimeRoleArn = builder.runtimeRoleArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDefaultRuntimeContextDevice() {
            return this.defaultRuntimeContextDevice;
        }

        @Override
        public final java.lang.Object getManifestPayload() {
            return this.manifestPayload;
        }

        @Override
        public final java.lang.String getApplicationInstanceIdToReplace() {
            return this.applicationInstanceIdToReplace;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getManifestOverridesPayload() {
            return this.manifestOverridesPayload;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRuntimeRoleArn() {
            return this.runtimeRoleArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("defaultRuntimeContextDevice", om.valueToTree(this.getDefaultRuntimeContextDevice()));
            data.set("manifestPayload", om.valueToTree(this.getManifestPayload()));
            if (this.getApplicationInstanceIdToReplace() != null) {
                data.set("applicationInstanceIdToReplace", om.valueToTree(this.getApplicationInstanceIdToReplace()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getManifestOverridesPayload() != null) {
                data.set("manifestOverridesPayload", om.valueToTree(this.getManifestOverridesPayload()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRuntimeRoleArn() != null) {
                data.set("runtimeRoleArn", om.valueToTree(this.getRuntimeRoleArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_panorama.CfnApplicationInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationInstanceProps.Jsii$Proxy that = (CfnApplicationInstanceProps.Jsii$Proxy) o;

            if (!defaultRuntimeContextDevice.equals(that.defaultRuntimeContextDevice)) return false;
            if (!manifestPayload.equals(that.manifestPayload)) return false;
            if (this.applicationInstanceIdToReplace != null ? !this.applicationInstanceIdToReplace.equals(that.applicationInstanceIdToReplace) : that.applicationInstanceIdToReplace != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.manifestOverridesPayload != null ? !this.manifestOverridesPayload.equals(that.manifestOverridesPayload) : that.manifestOverridesPayload != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.runtimeRoleArn != null ? !this.runtimeRoleArn.equals(that.runtimeRoleArn) : that.runtimeRoleArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultRuntimeContextDevice.hashCode();
            result = 31 * result + (this.manifestPayload.hashCode());
            result = 31 * result + (this.applicationInstanceIdToReplace != null ? this.applicationInstanceIdToReplace.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.manifestOverridesPayload != null ? this.manifestOverridesPayload.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.runtimeRoleArn != null ? this.runtimeRoleArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
