package software.amazon.awscdk.services.quicksight;

/**
 * Creates a custom permissions profile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnCustomPermissions cfnCustomPermissions = CfnCustomPermissions.Builder.create(this, "MyCfnCustomPermissions")
 *         .awsAccountId("awsAccountId")
 *         .customPermissionsName("customPermissionsName")
 *         // the properties below are optional
 *         .capabilities(CapabilitiesProperty.builder()
 *                 .addOrRunAnomalyDetectionForAnalyses("addOrRunAnomalyDetectionForAnalyses")
 *                 .createAndUpdateDashboardEmailReports("createAndUpdateDashboardEmailReports")
 *                 .createAndUpdateDatasets("createAndUpdateDatasets")
 *                 .createAndUpdateDataSources("createAndUpdateDataSources")
 *                 .createAndUpdateThemes("createAndUpdateThemes")
 *                 .createAndUpdateThresholdAlerts("createAndUpdateThresholdAlerts")
 *                 .createSharedFolders("createSharedFolders")
 *                 .createSpiceDataset("createSpiceDataset")
 *                 .exportToCsv("exportToCsv")
 *                 .exportToExcel("exportToExcel")
 *                 .renameSharedFolders("renameSharedFolders")
 *                 .shareAnalyses("shareAnalyses")
 *                 .shareDashboards("shareDashboards")
 *                 .shareDatasets("shareDatasets")
 *                 .shareDataSources("shareDataSources")
 *                 .subscribeDashboardEmailReports("subscribeDashboardEmailReports")
 *                 .viewAccountSpiceCapacity("viewAccountSpiceCapacity")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:38.615Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnCustomPermissions")
public class CfnCustomPermissions extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnCustomPermissions(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCustomPermissions(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnCustomPermissions.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCustomPermissions(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.quicksight.CfnCustomPermissionsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the custom permissions profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the AWS account that contains the custom permission configuration that you want to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS account that contains the custom permission configuration that you want to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", java.util.Objects.requireNonNull(value, "awsAccountId is required"));
    }

    /**
     * The name of the custom permissions profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCustomPermissionsName() {
        return software.amazon.jsii.Kernel.get(this, "customPermissionsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the custom permissions profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomPermissionsName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customPermissionsName", java.util.Objects.requireNonNull(value, "customPermissionsName is required"));
    }

    /**
     * A set of actions in the custom permissions profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCapabilities() {
        return software.amazon.jsii.Kernel.get(this, "capabilities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of actions in the custom permissions profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapabilities(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "capabilities", value);
    }

    /**
     * A set of actions in the custom permissions profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapabilities(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnCustomPermissions.CapabilitiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "capabilities", value);
    }

    /**
     * The tags to associate with the custom permissions profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to associate with the custom permissions profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * A set of actions that correspond to Amazon QuickSight permissions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CapabilitiesProperty capabilitiesProperty = CapabilitiesProperty.builder()
     *         .addOrRunAnomalyDetectionForAnalyses("addOrRunAnomalyDetectionForAnalyses")
     *         .createAndUpdateDashboardEmailReports("createAndUpdateDashboardEmailReports")
     *         .createAndUpdateDatasets("createAndUpdateDatasets")
     *         .createAndUpdateDataSources("createAndUpdateDataSources")
     *         .createAndUpdateThemes("createAndUpdateThemes")
     *         .createAndUpdateThresholdAlerts("createAndUpdateThresholdAlerts")
     *         .createSharedFolders("createSharedFolders")
     *         .createSpiceDataset("createSpiceDataset")
     *         .exportToCsv("exportToCsv")
     *         .exportToExcel("exportToExcel")
     *         .renameSharedFolders("renameSharedFolders")
     *         .shareAnalyses("shareAnalyses")
     *         .shareDashboards("shareDashboards")
     *         .shareDatasets("shareDatasets")
     *         .shareDataSources("shareDataSources")
     *         .subscribeDashboardEmailReports("subscribeDashboardEmailReports")
     *         .viewAccountSpiceCapacity("viewAccountSpiceCapacity")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnCustomPermissions.CapabilitiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CapabilitiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapabilitiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ability to add or run anomaly detection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-addorrunanomalydetectionforanalyses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-addorrunanomalydetectionforanalyses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddOrRunAnomalyDetectionForAnalyses() {
            return null;
        }

        /**
         * The ability to create and update email reports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createandupdatedashboardemailreports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createandupdatedashboardemailreports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreateAndUpdateDashboardEmailReports() {
            return null;
        }

        /**
         * The ability to create and update datasets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createandupdatedatasets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createandupdatedatasets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreateAndUpdateDatasets() {
            return null;
        }

        /**
         * The ability to create and update data sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createandupdatedatasources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createandupdatedatasources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreateAndUpdateDataSources() {
            return null;
        }

        /**
         * The ability to export to Create and Update themes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createandupdatethemes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createandupdatethemes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreateAndUpdateThemes() {
            return null;
        }

        /**
         * The ability to create and update threshold alerts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createandupdatethresholdalerts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createandupdatethresholdalerts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreateAndUpdateThresholdAlerts() {
            return null;
        }

        /**
         * The ability to create shared folders.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createsharedfolders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createsharedfolders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreateSharedFolders() {
            return null;
        }

        /**
         * The ability to create a SPICE dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createspicedataset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-createspicedataset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreateSpiceDataset() {
            return null;
        }

        /**
         * The ability to export to CSV files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-exporttocsv">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-exporttocsv</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExportToCsv() {
            return null;
        }

        /**
         * The ability to export to Excel files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-exporttoexcel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-exporttoexcel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExportToExcel() {
            return null;
        }

        /**
         * The ability to rename shared folders.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-renamesharedfolders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-renamesharedfolders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRenameSharedFolders() {
            return null;
        }

        /**
         * The ability to share analyses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-shareanalyses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-shareanalyses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShareAnalyses() {
            return null;
        }

        /**
         * The ability to share dashboards.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-sharedashboards">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-sharedashboards</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShareDashboards() {
            return null;
        }

        /**
         * The ability to share datasets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-sharedatasets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-sharedatasets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShareDatasets() {
            return null;
        }

        /**
         * The ability to share data sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-sharedatasources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-sharedatasources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShareDataSources() {
            return null;
        }

        /**
         * The ability to subscribe to email reports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-subscribedashboardemailreports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-subscribedashboardemailreports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubscribeDashboardEmailReports() {
            return null;
        }

        /**
         * The ability to view account SPICE capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-viewaccountspicecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-custompermissions-capabilities.html#cfn-quicksight-custompermissions-capabilities-viewaccountspicecapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getViewAccountSpiceCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapabilitiesProperty> {
            java.lang.String addOrRunAnomalyDetectionForAnalyses;
            java.lang.String createAndUpdateDashboardEmailReports;
            java.lang.String createAndUpdateDatasets;
            java.lang.String createAndUpdateDataSources;
            java.lang.String createAndUpdateThemes;
            java.lang.String createAndUpdateThresholdAlerts;
            java.lang.String createSharedFolders;
            java.lang.String createSpiceDataset;
            java.lang.String exportToCsv;
            java.lang.String exportToExcel;
            java.lang.String renameSharedFolders;
            java.lang.String shareAnalyses;
            java.lang.String shareDashboards;
            java.lang.String shareDatasets;
            java.lang.String shareDataSources;
            java.lang.String subscribeDashboardEmailReports;
            java.lang.String viewAccountSpiceCapacity;

            /**
             * Sets the value of {@link CapabilitiesProperty#getAddOrRunAnomalyDetectionForAnalyses}
             * @param addOrRunAnomalyDetectionForAnalyses The ability to add or run anomaly detection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addOrRunAnomalyDetectionForAnalyses(java.lang.String addOrRunAnomalyDetectionForAnalyses) {
                this.addOrRunAnomalyDetectionForAnalyses = addOrRunAnomalyDetectionForAnalyses;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getCreateAndUpdateDashboardEmailReports}
             * @param createAndUpdateDashboardEmailReports The ability to create and update email reports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createAndUpdateDashboardEmailReports(java.lang.String createAndUpdateDashboardEmailReports) {
                this.createAndUpdateDashboardEmailReports = createAndUpdateDashboardEmailReports;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getCreateAndUpdateDatasets}
             * @param createAndUpdateDatasets The ability to create and update datasets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createAndUpdateDatasets(java.lang.String createAndUpdateDatasets) {
                this.createAndUpdateDatasets = createAndUpdateDatasets;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getCreateAndUpdateDataSources}
             * @param createAndUpdateDataSources The ability to create and update data sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createAndUpdateDataSources(java.lang.String createAndUpdateDataSources) {
                this.createAndUpdateDataSources = createAndUpdateDataSources;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getCreateAndUpdateThemes}
             * @param createAndUpdateThemes The ability to export to Create and Update themes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createAndUpdateThemes(java.lang.String createAndUpdateThemes) {
                this.createAndUpdateThemes = createAndUpdateThemes;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getCreateAndUpdateThresholdAlerts}
             * @param createAndUpdateThresholdAlerts The ability to create and update threshold alerts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createAndUpdateThresholdAlerts(java.lang.String createAndUpdateThresholdAlerts) {
                this.createAndUpdateThresholdAlerts = createAndUpdateThresholdAlerts;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getCreateSharedFolders}
             * @param createSharedFolders The ability to create shared folders.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createSharedFolders(java.lang.String createSharedFolders) {
                this.createSharedFolders = createSharedFolders;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getCreateSpiceDataset}
             * @param createSpiceDataset The ability to create a SPICE dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createSpiceDataset(java.lang.String createSpiceDataset) {
                this.createSpiceDataset = createSpiceDataset;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getExportToCsv}
             * @param exportToCsv The ability to export to CSV files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportToCsv(java.lang.String exportToCsv) {
                this.exportToCsv = exportToCsv;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getExportToExcel}
             * @param exportToExcel The ability to export to Excel files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportToExcel(java.lang.String exportToExcel) {
                this.exportToExcel = exportToExcel;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getRenameSharedFolders}
             * @param renameSharedFolders The ability to rename shared folders.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renameSharedFolders(java.lang.String renameSharedFolders) {
                this.renameSharedFolders = renameSharedFolders;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getShareAnalyses}
             * @param shareAnalyses The ability to share analyses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareAnalyses(java.lang.String shareAnalyses) {
                this.shareAnalyses = shareAnalyses;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getShareDashboards}
             * @param shareDashboards The ability to share dashboards.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareDashboards(java.lang.String shareDashboards) {
                this.shareDashboards = shareDashboards;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getShareDatasets}
             * @param shareDatasets The ability to share datasets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareDatasets(java.lang.String shareDatasets) {
                this.shareDatasets = shareDatasets;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getShareDataSources}
             * @param shareDataSources The ability to share data sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareDataSources(java.lang.String shareDataSources) {
                this.shareDataSources = shareDataSources;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getSubscribeDashboardEmailReports}
             * @param subscribeDashboardEmailReports The ability to subscribe to email reports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subscribeDashboardEmailReports(java.lang.String subscribeDashboardEmailReports) {
                this.subscribeDashboardEmailReports = subscribeDashboardEmailReports;
                return this;
            }

            /**
             * Sets the value of {@link CapabilitiesProperty#getViewAccountSpiceCapacity}
             * @param viewAccountSpiceCapacity The ability to view account SPICE capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewAccountSpiceCapacity(java.lang.String viewAccountSpiceCapacity) {
                this.viewAccountSpiceCapacity = viewAccountSpiceCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapabilitiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapabilitiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapabilitiesProperty {
            private final java.lang.String addOrRunAnomalyDetectionForAnalyses;
            private final java.lang.String createAndUpdateDashboardEmailReports;
            private final java.lang.String createAndUpdateDatasets;
            private final java.lang.String createAndUpdateDataSources;
            private final java.lang.String createAndUpdateThemes;
            private final java.lang.String createAndUpdateThresholdAlerts;
            private final java.lang.String createSharedFolders;
            private final java.lang.String createSpiceDataset;
            private final java.lang.String exportToCsv;
            private final java.lang.String exportToExcel;
            private final java.lang.String renameSharedFolders;
            private final java.lang.String shareAnalyses;
            private final java.lang.String shareDashboards;
            private final java.lang.String shareDatasets;
            private final java.lang.String shareDataSources;
            private final java.lang.String subscribeDashboardEmailReports;
            private final java.lang.String viewAccountSpiceCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addOrRunAnomalyDetectionForAnalyses = software.amazon.jsii.Kernel.get(this, "addOrRunAnomalyDetectionForAnalyses", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createAndUpdateDashboardEmailReports = software.amazon.jsii.Kernel.get(this, "createAndUpdateDashboardEmailReports", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createAndUpdateDatasets = software.amazon.jsii.Kernel.get(this, "createAndUpdateDatasets", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createAndUpdateDataSources = software.amazon.jsii.Kernel.get(this, "createAndUpdateDataSources", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createAndUpdateThemes = software.amazon.jsii.Kernel.get(this, "createAndUpdateThemes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createAndUpdateThresholdAlerts = software.amazon.jsii.Kernel.get(this, "createAndUpdateThresholdAlerts", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createSharedFolders = software.amazon.jsii.Kernel.get(this, "createSharedFolders", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createSpiceDataset = software.amazon.jsii.Kernel.get(this, "createSpiceDataset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exportToCsv = software.amazon.jsii.Kernel.get(this, "exportToCsv", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exportToExcel = software.amazon.jsii.Kernel.get(this, "exportToExcel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.renameSharedFolders = software.amazon.jsii.Kernel.get(this, "renameSharedFolders", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shareAnalyses = software.amazon.jsii.Kernel.get(this, "shareAnalyses", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shareDashboards = software.amazon.jsii.Kernel.get(this, "shareDashboards", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shareDatasets = software.amazon.jsii.Kernel.get(this, "shareDatasets", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shareDataSources = software.amazon.jsii.Kernel.get(this, "shareDataSources", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subscribeDashboardEmailReports = software.amazon.jsii.Kernel.get(this, "subscribeDashboardEmailReports", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.viewAccountSpiceCapacity = software.amazon.jsii.Kernel.get(this, "viewAccountSpiceCapacity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addOrRunAnomalyDetectionForAnalyses = builder.addOrRunAnomalyDetectionForAnalyses;
                this.createAndUpdateDashboardEmailReports = builder.createAndUpdateDashboardEmailReports;
                this.createAndUpdateDatasets = builder.createAndUpdateDatasets;
                this.createAndUpdateDataSources = builder.createAndUpdateDataSources;
                this.createAndUpdateThemes = builder.createAndUpdateThemes;
                this.createAndUpdateThresholdAlerts = builder.createAndUpdateThresholdAlerts;
                this.createSharedFolders = builder.createSharedFolders;
                this.createSpiceDataset = builder.createSpiceDataset;
                this.exportToCsv = builder.exportToCsv;
                this.exportToExcel = builder.exportToExcel;
                this.renameSharedFolders = builder.renameSharedFolders;
                this.shareAnalyses = builder.shareAnalyses;
                this.shareDashboards = builder.shareDashboards;
                this.shareDatasets = builder.shareDatasets;
                this.shareDataSources = builder.shareDataSources;
                this.subscribeDashboardEmailReports = builder.subscribeDashboardEmailReports;
                this.viewAccountSpiceCapacity = builder.viewAccountSpiceCapacity;
            }

            @Override
            public final java.lang.String getAddOrRunAnomalyDetectionForAnalyses() {
                return this.addOrRunAnomalyDetectionForAnalyses;
            }

            @Override
            public final java.lang.String getCreateAndUpdateDashboardEmailReports() {
                return this.createAndUpdateDashboardEmailReports;
            }

            @Override
            public final java.lang.String getCreateAndUpdateDatasets() {
                return this.createAndUpdateDatasets;
            }

            @Override
            public final java.lang.String getCreateAndUpdateDataSources() {
                return this.createAndUpdateDataSources;
            }

            @Override
            public final java.lang.String getCreateAndUpdateThemes() {
                return this.createAndUpdateThemes;
            }

            @Override
            public final java.lang.String getCreateAndUpdateThresholdAlerts() {
                return this.createAndUpdateThresholdAlerts;
            }

            @Override
            public final java.lang.String getCreateSharedFolders() {
                return this.createSharedFolders;
            }

            @Override
            public final java.lang.String getCreateSpiceDataset() {
                return this.createSpiceDataset;
            }

            @Override
            public final java.lang.String getExportToCsv() {
                return this.exportToCsv;
            }

            @Override
            public final java.lang.String getExportToExcel() {
                return this.exportToExcel;
            }

            @Override
            public final java.lang.String getRenameSharedFolders() {
                return this.renameSharedFolders;
            }

            @Override
            public final java.lang.String getShareAnalyses() {
                return this.shareAnalyses;
            }

            @Override
            public final java.lang.String getShareDashboards() {
                return this.shareDashboards;
            }

            @Override
            public final java.lang.String getShareDatasets() {
                return this.shareDatasets;
            }

            @Override
            public final java.lang.String getShareDataSources() {
                return this.shareDataSources;
            }

            @Override
            public final java.lang.String getSubscribeDashboardEmailReports() {
                return this.subscribeDashboardEmailReports;
            }

            @Override
            public final java.lang.String getViewAccountSpiceCapacity() {
                return this.viewAccountSpiceCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddOrRunAnomalyDetectionForAnalyses() != null) {
                    data.set("addOrRunAnomalyDetectionForAnalyses", om.valueToTree(this.getAddOrRunAnomalyDetectionForAnalyses()));
                }
                if (this.getCreateAndUpdateDashboardEmailReports() != null) {
                    data.set("createAndUpdateDashboardEmailReports", om.valueToTree(this.getCreateAndUpdateDashboardEmailReports()));
                }
                if (this.getCreateAndUpdateDatasets() != null) {
                    data.set("createAndUpdateDatasets", om.valueToTree(this.getCreateAndUpdateDatasets()));
                }
                if (this.getCreateAndUpdateDataSources() != null) {
                    data.set("createAndUpdateDataSources", om.valueToTree(this.getCreateAndUpdateDataSources()));
                }
                if (this.getCreateAndUpdateThemes() != null) {
                    data.set("createAndUpdateThemes", om.valueToTree(this.getCreateAndUpdateThemes()));
                }
                if (this.getCreateAndUpdateThresholdAlerts() != null) {
                    data.set("createAndUpdateThresholdAlerts", om.valueToTree(this.getCreateAndUpdateThresholdAlerts()));
                }
                if (this.getCreateSharedFolders() != null) {
                    data.set("createSharedFolders", om.valueToTree(this.getCreateSharedFolders()));
                }
                if (this.getCreateSpiceDataset() != null) {
                    data.set("createSpiceDataset", om.valueToTree(this.getCreateSpiceDataset()));
                }
                if (this.getExportToCsv() != null) {
                    data.set("exportToCsv", om.valueToTree(this.getExportToCsv()));
                }
                if (this.getExportToExcel() != null) {
                    data.set("exportToExcel", om.valueToTree(this.getExportToExcel()));
                }
                if (this.getRenameSharedFolders() != null) {
                    data.set("renameSharedFolders", om.valueToTree(this.getRenameSharedFolders()));
                }
                if (this.getShareAnalyses() != null) {
                    data.set("shareAnalyses", om.valueToTree(this.getShareAnalyses()));
                }
                if (this.getShareDashboards() != null) {
                    data.set("shareDashboards", om.valueToTree(this.getShareDashboards()));
                }
                if (this.getShareDatasets() != null) {
                    data.set("shareDatasets", om.valueToTree(this.getShareDatasets()));
                }
                if (this.getShareDataSources() != null) {
                    data.set("shareDataSources", om.valueToTree(this.getShareDataSources()));
                }
                if (this.getSubscribeDashboardEmailReports() != null) {
                    data.set("subscribeDashboardEmailReports", om.valueToTree(this.getSubscribeDashboardEmailReports()));
                }
                if (this.getViewAccountSpiceCapacity() != null) {
                    data.set("viewAccountSpiceCapacity", om.valueToTree(this.getViewAccountSpiceCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnCustomPermissions.CapabilitiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapabilitiesProperty.Jsii$Proxy that = (CapabilitiesProperty.Jsii$Proxy) o;

                if (this.addOrRunAnomalyDetectionForAnalyses != null ? !this.addOrRunAnomalyDetectionForAnalyses.equals(that.addOrRunAnomalyDetectionForAnalyses) : that.addOrRunAnomalyDetectionForAnalyses != null) return false;
                if (this.createAndUpdateDashboardEmailReports != null ? !this.createAndUpdateDashboardEmailReports.equals(that.createAndUpdateDashboardEmailReports) : that.createAndUpdateDashboardEmailReports != null) return false;
                if (this.createAndUpdateDatasets != null ? !this.createAndUpdateDatasets.equals(that.createAndUpdateDatasets) : that.createAndUpdateDatasets != null) return false;
                if (this.createAndUpdateDataSources != null ? !this.createAndUpdateDataSources.equals(that.createAndUpdateDataSources) : that.createAndUpdateDataSources != null) return false;
                if (this.createAndUpdateThemes != null ? !this.createAndUpdateThemes.equals(that.createAndUpdateThemes) : that.createAndUpdateThemes != null) return false;
                if (this.createAndUpdateThresholdAlerts != null ? !this.createAndUpdateThresholdAlerts.equals(that.createAndUpdateThresholdAlerts) : that.createAndUpdateThresholdAlerts != null) return false;
                if (this.createSharedFolders != null ? !this.createSharedFolders.equals(that.createSharedFolders) : that.createSharedFolders != null) return false;
                if (this.createSpiceDataset != null ? !this.createSpiceDataset.equals(that.createSpiceDataset) : that.createSpiceDataset != null) return false;
                if (this.exportToCsv != null ? !this.exportToCsv.equals(that.exportToCsv) : that.exportToCsv != null) return false;
                if (this.exportToExcel != null ? !this.exportToExcel.equals(that.exportToExcel) : that.exportToExcel != null) return false;
                if (this.renameSharedFolders != null ? !this.renameSharedFolders.equals(that.renameSharedFolders) : that.renameSharedFolders != null) return false;
                if (this.shareAnalyses != null ? !this.shareAnalyses.equals(that.shareAnalyses) : that.shareAnalyses != null) return false;
                if (this.shareDashboards != null ? !this.shareDashboards.equals(that.shareDashboards) : that.shareDashboards != null) return false;
                if (this.shareDatasets != null ? !this.shareDatasets.equals(that.shareDatasets) : that.shareDatasets != null) return false;
                if (this.shareDataSources != null ? !this.shareDataSources.equals(that.shareDataSources) : that.shareDataSources != null) return false;
                if (this.subscribeDashboardEmailReports != null ? !this.subscribeDashboardEmailReports.equals(that.subscribeDashboardEmailReports) : that.subscribeDashboardEmailReports != null) return false;
                return this.viewAccountSpiceCapacity != null ? this.viewAccountSpiceCapacity.equals(that.viewAccountSpiceCapacity) : that.viewAccountSpiceCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addOrRunAnomalyDetectionForAnalyses != null ? this.addOrRunAnomalyDetectionForAnalyses.hashCode() : 0;
                result = 31 * result + (this.createAndUpdateDashboardEmailReports != null ? this.createAndUpdateDashboardEmailReports.hashCode() : 0);
                result = 31 * result + (this.createAndUpdateDatasets != null ? this.createAndUpdateDatasets.hashCode() : 0);
                result = 31 * result + (this.createAndUpdateDataSources != null ? this.createAndUpdateDataSources.hashCode() : 0);
                result = 31 * result + (this.createAndUpdateThemes != null ? this.createAndUpdateThemes.hashCode() : 0);
                result = 31 * result + (this.createAndUpdateThresholdAlerts != null ? this.createAndUpdateThresholdAlerts.hashCode() : 0);
                result = 31 * result + (this.createSharedFolders != null ? this.createSharedFolders.hashCode() : 0);
                result = 31 * result + (this.createSpiceDataset != null ? this.createSpiceDataset.hashCode() : 0);
                result = 31 * result + (this.exportToCsv != null ? this.exportToCsv.hashCode() : 0);
                result = 31 * result + (this.exportToExcel != null ? this.exportToExcel.hashCode() : 0);
                result = 31 * result + (this.renameSharedFolders != null ? this.renameSharedFolders.hashCode() : 0);
                result = 31 * result + (this.shareAnalyses != null ? this.shareAnalyses.hashCode() : 0);
                result = 31 * result + (this.shareDashboards != null ? this.shareDashboards.hashCode() : 0);
                result = 31 * result + (this.shareDatasets != null ? this.shareDatasets.hashCode() : 0);
                result = 31 * result + (this.shareDataSources != null ? this.shareDataSources.hashCode() : 0);
                result = 31 * result + (this.subscribeDashboardEmailReports != null ? this.subscribeDashboardEmailReports.hashCode() : 0);
                result = 31 * result + (this.viewAccountSpiceCapacity != null ? this.viewAccountSpiceCapacity.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.quicksight.CfnCustomPermissions}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.quicksight.CfnCustomPermissions> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.quicksight.CfnCustomPermissionsProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.quicksight.CfnCustomPermissionsProps.Builder();
        }

        /**
         * The ID of the AWS account that contains the custom permission configuration that you want to update.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html#cfn-quicksight-custompermissions-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html#cfn-quicksight-custompermissions-awsaccountid</a>
         * @param awsAccountId The ID of the AWS account that contains the custom permission configuration that you want to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(final java.lang.String awsAccountId) {
            this.props.awsAccountId(awsAccountId);
            return this;
        }

        /**
         * The name of the custom permissions profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html#cfn-quicksight-custompermissions-custompermissionsname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html#cfn-quicksight-custompermissions-custompermissionsname</a>
         * @param customPermissionsName The name of the custom permissions profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customPermissionsName(final java.lang.String customPermissionsName) {
            this.props.customPermissionsName(customPermissionsName);
            return this;
        }

        /**
         * A set of actions in the custom permissions profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html#cfn-quicksight-custompermissions-capabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html#cfn-quicksight-custompermissions-capabilities</a>
         * @param capabilities A set of actions in the custom permissions profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capabilities(final software.amazon.awscdk.IResolvable capabilities) {
            this.props.capabilities(capabilities);
            return this;
        }
        /**
         * A set of actions in the custom permissions profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html#cfn-quicksight-custompermissions-capabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html#cfn-quicksight-custompermissions-capabilities</a>
         * @param capabilities A set of actions in the custom permissions profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capabilities(final software.amazon.awscdk.services.quicksight.CfnCustomPermissions.CapabilitiesProperty capabilities) {
            this.props.capabilities(capabilities);
            return this;
        }

        /**
         * The tags to associate with the custom permissions profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html#cfn-quicksight-custompermissions-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-custompermissions.html#cfn-quicksight-custompermissions-tags</a>
         * @param tags The tags to associate with the custom permissions profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.quicksight.CfnCustomPermissions}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.quicksight.CfnCustomPermissions build() {
            return new software.amazon.awscdk.services.quicksight.CfnCustomPermissions(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
