package software.amazon.awscdk.services.rds;

/**
 * RDS Database Proxy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder()
 *                 .version(AuroraMysqlEngineVersion.VER_3_03_0)
 *                 .build()))
 *         .writer(ClusterInstance.provisioned("writer"))
 *         .vpc(vpc)
 *         .build();
 * DatabaseProxy proxy = DatabaseProxy.Builder.create(this, "Proxy")
 *         .proxyTarget(ProxyTarget.fromCluster(cluster))
 *         .secrets(List.of(cluster.getSecret()))
 *         .vpc(vpc)
 *         .clientPasswordAuthType(ClientPasswordAuthType.MYSQL_NATIVE_PASSWORD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:40.187Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseProxy")
public class DatabaseProxy extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.IConnectable, software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget, software.amazon.awscdk.services.rds.IDatabaseProxy {

    protected DatabaseProxy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseProxy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DatabaseProxy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseProxyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing database proxy.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseProxy fromDatabaseProxyAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseProxyAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseProxy.class, "fromDatabaseProxyAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IDatabaseProxy.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Renders the secret attachment target specifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps asSecretAttachmentTarget() {
        return software.amazon.jsii.Kernel.call(this, "asSecretAttachmentTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps.class));
    }

    /**
     * Grant the given identity connection access to the proxy.
     * <p>
     * @param grantee This parameter is required.
     * @param dbUser
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConnect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.lang.String dbUser) {
        return software.amazon.jsii.Kernel.call(this, "grantConnect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), dbUser });
    }

    /**
     * Grant the given identity connection access to the proxy.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConnect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantConnect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Access to network connections.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * DB Proxy ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbProxyArn() {
        return software.amazon.jsii.Kernel.get(this, "dbProxyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * DB Proxy Name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbProxyName() {
        return software.amazon.jsii.Kernel.get(this, "dbProxyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.DatabaseProxy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.DatabaseProxy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.DatabaseProxyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.DatabaseProxyProps.Builder();
        }

        /**
         * The secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster.
         * <p>
         * These secrets are stored within Amazon Secrets Manager.
         * One or more secrets are required.
         * <p>
         * @return {@code this}
         * @param secrets The secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secrets(final java.util.List<? extends software.amazon.awscdk.services.secretsmanager.ISecret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        /**
         * The VPC to associate with the new proxy.
         * <p>
         * @return {@code this}
         * @param vpc The VPC to associate with the new proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * The duration for a proxy to wait for a connection to become available in the connection pool.
         * <p>
         * Only applies when the proxy has opened its maximum number of connections and all connections are busy with client
         * sessions.
         * <p>
         * Value must be between 1 second and 1 hour, or <code>Duration.seconds(0)</code> to represent unlimited.
         * <p>
         * Default: cdk.Duration.seconds(120)
         * <p>
         * @return {@code this}
         * @param borrowTimeout The duration for a proxy to wait for a connection to become available in the connection pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder borrowTimeout(final software.amazon.awscdk.Duration borrowTimeout) {
            this.props.borrowTimeout(borrowTimeout);
            return this;
        }

        /**
         * Specifies the details of authentication used by a proxy to log in as a specific database user.
         * <p>
         * Default: - CloudFormation defaults will apply given the specified database engine.
         * <p>
         * @return {@code this}
         * @param clientPasswordAuthType Specifies the details of authentication used by a proxy to log in as a specific database user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientPasswordAuthType(final software.amazon.awscdk.services.rds.ClientPasswordAuthType clientPasswordAuthType) {
            this.props.clientPasswordAuthType(clientPasswordAuthType);
            return this;
        }

        /**
         * The identifier for the proxy.
         * <p>
         * This name must be unique for all proxies owned by your AWS account in the specified AWS Region.
         * An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens;
         * it can't end with a hyphen or contain two consecutive hyphens.
         * <p>
         * Default: - Generated by CloudFormation (recommended)
         * <p>
         * @return {@code this}
         * @param dbProxyName The identifier for the proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbProxyName(final java.lang.String dbProxyName) {
            this.props.dbProxyName(dbProxyName);
            return this;
        }

        /**
         * Whether the proxy includes detailed information about SQL statements in its logs.
         * <p>
         * This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections.
         * The debug information includes the text of SQL statements that you submit through the proxy.
         * Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive
         * information that appears in the logs.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param debugLogging Whether the proxy includes detailed information about SQL statements in its logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder debugLogging(final java.lang.Boolean debugLogging) {
            this.props.debugLogging(debugLogging);
            return this;
        }

        /**
         * Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param iamAuth Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamAuth(final java.lang.Boolean iamAuth) {
            this.props.iamAuth(iamAuth);
            return this;
        }

        /**
         * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it.
         * <p>
         * You can set this value higher or lower than the connection timeout limit for the associated database.
         * <p>
         * Default: cdk.Duration.minutes(30)
         * <p>
         * @return {@code this}
         * @param idleClientTimeout The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleClientTimeout(final software.amazon.awscdk.Duration idleClientTimeout) {
            this.props.idleClientTimeout(idleClientTimeout);
            return this;
        }

        /**
         * One or more SQL statements for the proxy to run when opening each new database connection.
         * <p>
         * Typically used with SET statements to make sure that each connection has identical settings such as time zone
         * and character set.
         * For multiple statements, use semicolons as the separator.
         * You can also include multiple variables in a single SET statement, such as SET x=1, y=2.
         * <p>
         * not currently supported for PostgreSQL.
         * <p>
         * Default: - no initialization query
         * <p>
         * @return {@code this}
         * @param initQuery One or more SQL statements for the proxy to run when opening each new database connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initQuery(final java.lang.String initQuery) {
            this.props.initQuery(initQuery);
            return this;
        }

        /**
         * The maximum size of the connection pool for each target in a target group.
         * <p>
         * For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB
         * cluster used by the target group.
         * <p>
         * 1-100
         * <p>
         * Default: 100
         * <p>
         * @return {@code this}
         * @param maxConnectionsPercent The maximum size of the connection pool for each target in a target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConnectionsPercent(final java.lang.Number maxConnectionsPercent) {
            this.props.maxConnectionsPercent(maxConnectionsPercent);
            return this;
        }

        /**
         * Controls how actively the proxy closes idle database connections in the connection pool.
         * <p>
         * A high value enables the proxy to leave a high percentage of idle connections open.
         * A low value causes the proxy to close idle client connections and return the underlying database connections
         * to the connection pool.
         * For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance
         * or Aurora DB cluster used by the target group.
         * <p>
         * between 0 and MaxConnectionsPercent
         * <p>
         * Default: 50
         * <p>
         * @return {@code this}
         * @param maxIdleConnectionsPercent Controls how actively the proxy closes idle database connections in the connection pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxIdleConnectionsPercent(final java.lang.Number maxIdleConnectionsPercent) {
            this.props.maxIdleConnectionsPercent(maxIdleConnectionsPercent);
            return this;
        }

        /**
         * A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
         * <p>
         * By enabling this setting, you can enforce encrypted TLS connections to the proxy.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param requireTls A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireTls(final java.lang.Boolean requireTls) {
            this.props.requireTls(requireTls);
            return this;
        }

        /**
         * IAM role that the proxy uses to access secrets in AWS Secrets Manager.
         * <p>
         * Default: - A role will automatically be created
         * <p>
         * @return {@code this}
         * @param role IAM role that the proxy uses to access secrets in AWS Secrets Manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * One or more VPC security groups to associate with the new proxy.
         * <p>
         * Default: - No security groups
         * <p>
         * @return {@code this}
         * @param securityGroups One or more VPC security groups to associate with the new proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
         * <p>
         * Including an item in the list exempts that class of SQL operations from the pinning behavior.
         * <p>
         * Default: - no session pinning filters
         * <p>
         * @return {@code this}
         * @param sessionPinningFilters Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionPinningFilters(final java.util.List<? extends software.amazon.awscdk.services.rds.SessionPinningFilter> sessionPinningFilters) {
            this.props.sessionPinningFilters(sessionPinningFilters);
            return this;
        }

        /**
         * The subnets used by the proxy.
         * <p>
         * Default: - the VPC default strategy if not specified.
         * <p>
         * @return {@code this}
         * @param vpcSubnets The subnets used by the proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * DB proxy target: Instance or Cluster.
         * <p>
         * @return {@code this}
         * @param proxyTarget DB proxy target: Instance or Cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyTarget(final software.amazon.awscdk.services.rds.ProxyTarget proxyTarget) {
            this.props.proxyTarget(proxyTarget);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.rds.DatabaseProxy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.DatabaseProxy build() {
            return new software.amazon.awscdk.services.rds.DatabaseProxy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
