package software.amazon.awscdk.services.redshift;

/**
 * Properties for defining a <code>CfnCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshift.*;
 * Object namespaceResourcePolicy;
 * CfnClusterProps cfnClusterProps = CfnClusterProps.builder()
 *         .clusterType("clusterType")
 *         .dbName("dbName")
 *         .masterUsername("masterUsername")
 *         .nodeType("nodeType")
 *         // the properties below are optional
 *         .allowVersionUpgrade(false)
 *         .aquaConfigurationStatus("aquaConfigurationStatus")
 *         .automatedSnapshotRetentionPeriod(123)
 *         .availabilityZone("availabilityZone")
 *         .availabilityZoneRelocation(false)
 *         .availabilityZoneRelocationStatus("availabilityZoneRelocationStatus")
 *         .classic(false)
 *         .clusterIdentifier("clusterIdentifier")
 *         .clusterParameterGroupName("clusterParameterGroupName")
 *         .clusterSecurityGroups(List.of("clusterSecurityGroups"))
 *         .clusterSubnetGroupName("clusterSubnetGroupName")
 *         .clusterVersion("clusterVersion")
 *         .deferMaintenance(false)
 *         .deferMaintenanceDuration(123)
 *         .deferMaintenanceEndTime("deferMaintenanceEndTime")
 *         .deferMaintenanceStartTime("deferMaintenanceStartTime")
 *         .destinationRegion("destinationRegion")
 *         .elasticIp("elasticIp")
 *         .encrypted(false)
 *         .endpoint(EndpointProperty.builder()
 *                 .address("address")
 *                 .port("port")
 *                 .build())
 *         .enhancedVpcRouting(false)
 *         .hsmClientCertificateIdentifier("hsmClientCertificateIdentifier")
 *         .hsmConfigurationIdentifier("hsmConfigurationIdentifier")
 *         .iamRoles(List.of("iamRoles"))
 *         .kmsKeyId("kmsKeyId")
 *         .loggingProperties(LoggingPropertiesProperty.builder()
 *                 .bucketName("bucketName")
 *                 .logDestinationType("logDestinationType")
 *                 .logExports(List.of("logExports"))
 *                 .s3KeyPrefix("s3KeyPrefix")
 *                 .build())
 *         .maintenanceTrackName("maintenanceTrackName")
 *         .manageMasterPassword(false)
 *         .manualSnapshotRetentionPeriod(123)
 *         .masterPasswordSecretKmsKeyId("masterPasswordSecretKmsKeyId")
 *         .masterUserPassword("masterUserPassword")
 *         .multiAz(false)
 *         .namespaceResourcePolicy(namespaceResourcePolicy)
 *         .numberOfNodes(123)
 *         .ownerAccount("ownerAccount")
 *         .port(123)
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .publiclyAccessible(false)
 *         .resourceAction("resourceAction")
 *         .revisionTarget("revisionTarget")
 *         .rotateEncryptionKey(false)
 *         .snapshotClusterIdentifier("snapshotClusterIdentifier")
 *         .snapshotCopyGrantName("snapshotCopyGrantName")
 *         .snapshotCopyManual(false)
 *         .snapshotCopyRetentionPeriod(123)
 *         .snapshotIdentifier("snapshotIdentifier")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:40.283Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of the cluster. When cluster type is specified as.
     * <p>
     * <ul>
     * <li><code>single-node</code> , the <em>NumberOfNodes</em> parameter is not required.</li>
     * <li><code>multi-node</code> , the <em>NumberOfNodes</em> parameter is required.</li>
     * </ul>
     * <p>
     * Valid Values: <code>multi-node</code> | <code>single-node</code>
     * <p>
     * Default: <code>multi-node</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clustertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clustertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterType();

    /**
     * The name of the first database to be created when the cluster is created.
     * <p>
     * To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create a Database</a> in the Amazon Redshift Database Developer Guide.
     * <p>
     * Default: <code>dev</code>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 64 alphanumeric characters.</li>
     * <li>Must contain only lowercase letters.</li>
     * <li>Cannot be a word that is reserved by the service. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-dbname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-dbname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbName();

    /**
     * The user name associated with the admin user account for the cluster that is being created.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 - 128 alphanumeric characters or hyphens. The user name can't be <code>PUBLIC</code> .</li>
     * <li>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (&#64;), or hyphen.</li>
     * <li>The first character must be a letter.</li>
     * <li>Must not contain a colon (:) or a slash (/).</li>
     * <li>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-masterusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-masterusername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMasterUsername();

    /**
     * The node type to be provisioned for the cluster.
     * <p>
     * For information about node types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes">Working with Clusters</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
     * <p>
     * Valid Values: <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.large</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-nodetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-nodetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNodeType();

    /**
     * If <code>true</code> , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
     * <p>
     * When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.
     * <p>
     * Default: <code>true</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-allowversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-allowversionupgrade</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowVersionUpgrade() {
        return null;
    }

    /**
     * This parameter is retired.
     * <p>
     * It does not set the AQUA configuration status. Amazon Redshift automatically determines whether to use AQUA (Advanced Query Accelerator).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-aquaconfigurationstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-aquaconfigurationstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAquaConfigurationStatus() {
        return null;
    }

    /**
     * The number of days that automated snapshots are retained.
     * <p>
     * If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <a href="https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterSnapshot.html">CreateClusterSnapshot</a> in the <em>Amazon Redshift API Reference</em> .
     * <p>
     * Default: <code>1</code>
     * <p>
     * Constraints: Must be a value from 0 to 35.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-automatedsnapshotretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-automatedsnapshotretentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAutomatedSnapshotRetentionPeriod() {
        return null;
    }

    /**
     * The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster.
     * <p>
     * For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.
     * <p>
     * Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.
     * <p>
     * Example: <code>us-east-2d</code>
     * <p>
     * Constraint: The specified Availability Zone must be in the same region as the current endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-availabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-availabilityzonerelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-availabilityzonerelocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAvailabilityZoneRelocation() {
        return null;
    }

    /**
     * Describes the status of the Availability Zone relocation operation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-availabilityzonerelocationstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-availabilityzonerelocationstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneRelocationStatus() {
        return null;
    }

    /**
     * A boolean value indicating whether the resize operation is using the classic resize process.
     * <p>
     * If you don't provide this parameter or set the value to <code>false</code> , the resize type is elastic.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-classic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-classic</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClassic() {
        return null;
    }

    /**
     * A unique identifier for the cluster.
     * <p>
     * You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 alphanumeric characters or hyphens.</li>
     * <li>Alphabetic characters must be lowercase.</li>
     * <li>First character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * <li>Must be unique for all clusters within an AWS account .</li>
     * </ul>
     * <p>
     * Example: <code>myexamplecluster</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterIdentifier() {
        return null;
    }

    /**
     * The name of the parameter group to be associated with this cluster.
     * <p>
     * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 to 255 alphanumeric characters or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clusterparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clusterparametergroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterParameterGroupName() {
        return null;
    }

    /**
     * A list of security groups to be associated with this cluster.
     * <p>
     * Default: The default cluster security group for Amazon Redshift.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clustersecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clustersecuritygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClusterSecurityGroups() {
        return null;
    }

    /**
     * The name of a cluster subnet group to be associated with this cluster.
     * <p>
     * If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clustersubnetgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clustersubnetgroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterSubnetGroupName() {
        return null;
    }

    /**
     * The version of the Amazon Redshift engine software that you want to deploy on the cluster.
     * <p>
     * The version selected runs on all the nodes in the cluster.
     * <p>
     * Constraints: Only version 1.0 is currently available.
     * <p>
     * Example: <code>1.0</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clusterversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-clusterversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterVersion() {
        return null;
    }

    /**
     * A Boolean indicating whether to enable the deferred maintenance window.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-defermaintenance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-defermaintenance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeferMaintenance() {
        return null;
    }

    /**
     * An integer indicating the duration of the maintenance window in days.
     * <p>
     * If you specify a duration, you can't specify an end time. The duration must be 45 days or less.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-defermaintenanceduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-defermaintenanceduration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDeferMaintenanceDuration() {
        return null;
    }

    /**
     * A timestamp for the end of the time period when we defer maintenance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-defermaintenanceendtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-defermaintenanceendtime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeferMaintenanceEndTime() {
        return null;
    }

    /**
     * A timestamp indicating the start time for the deferred maintenance window.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-defermaintenancestarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-defermaintenancestarttime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeferMaintenanceStartTime() {
        return null;
    }

    /**
     * The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-destinationregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-destinationregion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationRegion() {
        return null;
    }

    /**
     * The Elastic IP (EIP) address for the cluster.
     * <p>
     * Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. Don't specify the Elastic IP address for a publicly accessible cluster with availability zone relocation turned on. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-elasticip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-elasticip</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getElasticIp() {
        return null;
    }

    /**
     * If <code>true</code> , the data in the cluster is encrypted at rest.
     * <p>
     * If you set the value on this parameter to <code>false</code> , the request will fail.
     * <p>
     * Default: true
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-encrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-encrypted</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
        return null;
    }

    /**
     * The connection endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-endpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEndpoint() {
        return null;
    }

    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled.
     * <p>
     * To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.
     * <p>
     * If this option is <code>true</code> , enhanced VPC routing is enabled.
     * <p>
     * Default: false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-enhancedvpcrouting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-enhancedvpcrouting</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedVpcRouting() {
        return null;
    }

    /**
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-hsmclientcertificateidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-hsmclientcertificateidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHsmClientCertificateIdentifier() {
        return null;
    }

    /**
     * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-hsmconfigurationidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-hsmconfigurationidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHsmConfigurationIdentifier() {
        return null;
    }

    /**
     * A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services.
     * <p>
     * You must supply the IAM roles in their Amazon Resource Name (ARN) format.
     * <p>
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-iamroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-iamroles</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIamRoles() {
        return null;
    }

    /**
     * The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-loggingproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-loggingproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingProperties() {
        return null;
    }

    /**
     * An optional parameter for the name of the maintenance track for the cluster.
     * <p>
     * If you don't provide a maintenance track name, the cluster is assigned to the <code>current</code> track.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-maintenancetrackname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-maintenancetrackname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaintenanceTrackName() {
        return null;
    }

    /**
     * If <code>true</code> , Amazon Redshift uses AWS Secrets Manager to manage this cluster's admin credentials.
     * <p>
     * You can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is true. If <code>ManageMasterPassword</code> is false or not set, Amazon Redshift uses <code>MasterUserPassword</code> for the admin user account's password.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-managemasterpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-managemasterpassword</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getManageMasterPassword() {
        return null;
    }

    /**
     * The default number of days to retain a manual snapshot.
     * <p>
     * If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-manualsnapshotretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-manualsnapshotretentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getManualSnapshotRetentionPeriod() {
        return null;
    }

    /**
     * The ID of the AWS Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials secret.
     * <p>
     * You can only use this parameter if <code>ManageMasterPassword</code> is true.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-masterpasswordsecretkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-masterpasswordsecretkmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterPasswordSecretKmsKeyId() {
        return null;
    }

    /**
     * The password associated with the admin user account for the cluster that is being created.
     * <p>
     * You can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is <code>true</code> .
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be between 8 and 64 characters in length.</li>
     * <li>Must contain at least one uppercase letter.</li>
     * <li>Must contain at least one lowercase letter.</li>
     * <li>Must contain one number.</li>
     * <li>Can be any printable ASCII character (ASCII code 33-126) except <code>'</code> (single quote), <code>"</code> (double quote), <code>\</code> , <code>/</code> , or <code>&#64;</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-masteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-masteruserpassword</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return null;
    }

    /**
     * A boolean indicating whether Amazon Redshift should deploy the cluster in two Availability Zones.
     * <p>
     * The default is false.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-multiaz">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-multiaz</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultiAz() {
        return null;
    }

    /**
     * The policy that is attached to a resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-namespaceresourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-namespaceresourcepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNamespaceResourcePolicy() {
        return null;
    }

    /**
     * The number of compute nodes in the cluster.
     * <p>
     * This parameter is required when the <em>ClusterType</em> parameter is specified as <code>multi-node</code> .
     * <p>
     * For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes">Working with Clusters</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
     * <p>
     * If you don't specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.
     * <p>
     * Default: <code>1</code>
     * <p>
     * Constraints: Value must be at least 1 and no more than 100.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-numberofnodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-numberofnodes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfNodes() {
        return null;
    }

    /**
     * The AWS account used to create or copy the snapshot.
     * <p>
     * Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-owneraccount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-owneraccount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwnerAccount() {
        return null;
    }

    /**
     * The port number on which the cluster accepts incoming connections.
     * <p>
     * The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.
     * <p>
     * Default: <code>5439</code>
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li>For clusters with ra3 nodes - Select a port within the ranges <code>5431-5455</code> or <code>8191-8215</code> . (If you have an existing cluster with ra3 nodes, it isn't required that you change the port to these ranges.)</li>
     * <li>For clusters with dc2 nodes - Select a port within the range <code>1150-65535</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-port</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The weekly time range (in UTC) during which automated cluster maintenance can occur.
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
     * <p>
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * <p>
     * Constraints: Minimum 30-minute window.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-preferredmaintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-preferredmaintenancewindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * If <code>true</code> , the cluster can be accessed from a public network.
     * <p>
     * Default: false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-publiclyaccessible</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return null;
    }

    /**
     * The Amazon Redshift operation to be performed.
     * <p>
     * Supported operations are <code>pause-cluster</code> , <code>resume-cluster</code> , and <code>failover-primary-compute</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-resourceaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-resourceaction</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceAction() {
        return null;
    }

    /**
     * Describes a <code>RevisionTarget</code> object.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-revisiontarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-revisiontarget</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRevisionTarget() {
        return null;
    }

    /**
     * Rotates the encryption keys for a cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-rotateencryptionkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-rotateencryptionkey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRotateEncryptionKey() {
        return null;
    }

    /**
     * The name of the cluster the source snapshot was created from.
     * <p>
     * This parameter is required if your user or role has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-snapshotclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-snapshotclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotClusterIdentifier() {
        return null;
    }

    /**
     * The name of the snapshot copy grant.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-snapshotcopygrantname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-snapshotcopygrantname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotCopyGrantName() {
        return null;
    }

    /**
     * Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-snapshotcopymanual">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-snapshotcopymanual</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotCopyManual() {
        return null;
    }

    /**
     * The number of days to retain automated snapshots in the destination AWS Region after they are copied from the source AWS Region .
     * <p>
     * By default, this only changes the retention period of copied automated snapshots.
     * <p>
     * If you decrease the retention period for automated snapshots that are copied to a destination AWS Region , Amazon Redshift deletes any existing automated snapshots that were copied to the destination AWS Region and that fall outside of the new retention period.
     * <p>
     * Constraints: Must be at least 1 and no more than 35 for automated snapshots.
     * <p>
     * If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new retention period.
     * <p>
     * If you specify the value of -1 newly copied manual snapshots are retained indefinitely.
     * <p>
     * Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-snapshotcopyretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-snapshotcopyretentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSnapshotCopyRetentionPeriod() {
        return null;
    }

    /**
     * The name of the snapshot from which to create the new cluster.
     * <p>
     * This parameter isn't case sensitive. You must specify this parameter or <code>snapshotArn</code> , but not both.
     * <p>
     * Example: <code>my-snapshot-id</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-snapshotidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-snapshotidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotIdentifier() {
        return null;
    }

    /**
     * A list of tag instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     * <p>
     * Default: The default VPC security group is associated with the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-vpcsecuritygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html#cfn-redshift-cluster-vpcsecuritygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterProps> {
        java.lang.String clusterType;
        java.lang.String dbName;
        java.lang.String masterUsername;
        java.lang.String nodeType;
        java.lang.Object allowVersionUpgrade;
        java.lang.String aquaConfigurationStatus;
        java.lang.Number automatedSnapshotRetentionPeriod;
        java.lang.String availabilityZone;
        java.lang.Object availabilityZoneRelocation;
        java.lang.String availabilityZoneRelocationStatus;
        java.lang.Object classic;
        java.lang.String clusterIdentifier;
        java.lang.String clusterParameterGroupName;
        java.util.List<java.lang.String> clusterSecurityGroups;
        java.lang.String clusterSubnetGroupName;
        java.lang.String clusterVersion;
        java.lang.Object deferMaintenance;
        java.lang.Number deferMaintenanceDuration;
        java.lang.String deferMaintenanceEndTime;
        java.lang.String deferMaintenanceStartTime;
        java.lang.String destinationRegion;
        java.lang.String elasticIp;
        java.lang.Object encrypted;
        java.lang.Object endpoint;
        java.lang.Object enhancedVpcRouting;
        java.lang.String hsmClientCertificateIdentifier;
        java.lang.String hsmConfigurationIdentifier;
        java.util.List<java.lang.String> iamRoles;
        java.lang.String kmsKeyId;
        java.lang.Object loggingProperties;
        java.lang.String maintenanceTrackName;
        java.lang.Object manageMasterPassword;
        java.lang.Number manualSnapshotRetentionPeriod;
        java.lang.String masterPasswordSecretKmsKeyId;
        java.lang.String masterUserPassword;
        java.lang.Object multiAz;
        java.lang.Object namespaceResourcePolicy;
        java.lang.Number numberOfNodes;
        java.lang.String ownerAccount;
        java.lang.Number port;
        java.lang.String preferredMaintenanceWindow;
        java.lang.Object publiclyAccessible;
        java.lang.String resourceAction;
        java.lang.String revisionTarget;
        java.lang.Object rotateEncryptionKey;
        java.lang.String snapshotClusterIdentifier;
        java.lang.String snapshotCopyGrantName;
        java.lang.Object snapshotCopyManual;
        java.lang.Number snapshotCopyRetentionPeriod;
        java.lang.String snapshotIdentifier;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Sets the value of {@link CfnClusterProps#getClusterType}
         * @param clusterType The type of the cluster. When cluster type is specified as. This parameter is required.
         *                    <ul>
         *                    <li><code>single-node</code> , the <em>NumberOfNodes</em> parameter is not required.</li>
         *                    <li><code>multi-node</code> , the <em>NumberOfNodes</em> parameter is required.</li>
         *                    </ul>
         *                    <p>
         *                    Valid Values: <code>multi-node</code> | <code>single-node</code>
         *                    <p>
         *                    Default: <code>multi-node</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterType(java.lang.String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDbName}
         * @param dbName The name of the first database to be created when the cluster is created. This parameter is required.
         *               To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create a Database</a> in the Amazon Redshift Database Developer Guide.
         *               <p>
         *               Default: <code>dev</code>
         *               <p>
         *               Constraints:
         *               <p>
         *               <ul>
         *               <li>Must contain 1 to 64 alphanumeric characters.</li>
         *               <li>Must contain only lowercase letters.</li>
         *               <li>Cannot be a word that is reserved by the service. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbName(java.lang.String dbName) {
            this.dbName = dbName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getMasterUsername}
         * @param masterUsername The user name associated with the admin user account for the cluster that is being created. This parameter is required.
         *                       Constraints:
         *                       <p>
         *                       <ul>
         *                       <li>Must be 1 - 128 alphanumeric characters or hyphens. The user name can't be <code>PUBLIC</code> .</li>
         *                       <li>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (&#64;), or hyphen.</li>
         *                       <li>The first character must be a letter.</li>
         *                       <li>Must not contain a colon (:) or a slash (/).</li>
         *                       <li>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(java.lang.String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getNodeType}
         * @param nodeType The node type to be provisioned for the cluster. This parameter is required.
         *                 For information about node types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes">Working with Clusters</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
         *                 <p>
         *                 Valid Values: <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.large</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeType(java.lang.String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAllowVersionUpgrade}
         * @param allowVersionUpgrade If <code>true</code> , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
         *                            When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.
         *                            <p>
         *                            Default: <code>true</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowVersionUpgrade(java.lang.Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAllowVersionUpgrade}
         * @param allowVersionUpgrade If <code>true</code> , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
         *                            When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.
         *                            <p>
         *                            Default: <code>true</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowVersionUpgrade(software.amazon.awscdk.IResolvable allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAquaConfigurationStatus}
         * @param aquaConfigurationStatus This parameter is retired.
         *                                It does not set the AQUA configuration status. Amazon Redshift automatically determines whether to use AQUA (Advanced Query Accelerator).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aquaConfigurationStatus(java.lang.String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAutomatedSnapshotRetentionPeriod}
         * @param automatedSnapshotRetentionPeriod The number of days that automated snapshots are retained.
         *                                         If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <a href="https://docs.aws.amazon.com/redshift/latest/APIReference/API_CreateClusterSnapshot.html">CreateClusterSnapshot</a> in the <em>Amazon Redshift API Reference</em> .
         *                                         <p>
         *                                         Default: <code>1</code>
         *                                         <p>
         *                                         Constraints: Must be a value from 0 to 35.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automatedSnapshotRetentionPeriod(java.lang.Number automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAvailabilityZone}
         * @param availabilityZone The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster.
         *                         For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.
         *                         <p>
         *                         Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.
         *                         <p>
         *                         Example: <code>us-east-2d</code>
         *                         <p>
         *                         Constraint: The specified Availability Zone must be in the same region as the current endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAvailabilityZoneRelocation}
         * @param availabilityZoneRelocation The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneRelocation(java.lang.Boolean availabilityZoneRelocation) {
            this.availabilityZoneRelocation = availabilityZoneRelocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAvailabilityZoneRelocation}
         * @param availabilityZoneRelocation The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneRelocation(software.amazon.awscdk.IResolvable availabilityZoneRelocation) {
            this.availabilityZoneRelocation = availabilityZoneRelocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAvailabilityZoneRelocationStatus}
         * @param availabilityZoneRelocationStatus Describes the status of the Availability Zone relocation operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneRelocationStatus(java.lang.String availabilityZoneRelocationStatus) {
            this.availabilityZoneRelocationStatus = availabilityZoneRelocationStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClassic}
         * @param classic A boolean value indicating whether the resize operation is using the classic resize process.
         *                If you don't provide this parameter or set the value to <code>false</code> , the resize type is elastic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classic(java.lang.Boolean classic) {
            this.classic = classic;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClassic}
         * @param classic A boolean value indicating whether the resize operation is using the classic resize process.
         *                If you don't provide this parameter or set the value to <code>false</code> , the resize type is elastic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classic(software.amazon.awscdk.IResolvable classic) {
            this.classic = classic;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterIdentifier}
         * @param clusterIdentifier A unique identifier for the cluster.
         *                          You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.
         *                          <p>
         *                          Constraints:
         *                          <p>
         *                          <ul>
         *                          <li>Must contain from 1 to 63 alphanumeric characters or hyphens.</li>
         *                          <li>Alphabetic characters must be lowercase.</li>
         *                          <li>First character must be a letter.</li>
         *                          <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
         *                          <li>Must be unique for all clusters within an AWS account .</li>
         *                          </ul>
         *                          <p>
         *                          Example: <code>myexamplecluster</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterParameterGroupName}
         * @param clusterParameterGroupName The name of the parameter group to be associated with this cluster.
         *                                  Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a>
         *                                  <p>
         *                                  Constraints:
         *                                  <p>
         *                                  <ul>
         *                                  <li>Must be 1 to 255 alphanumeric characters or hyphens.</li>
         *                                  <li>First character must be a letter.</li>
         *                                  <li>Cannot end with a hyphen or contain two consecutive hyphens.</li>
         *                                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterParameterGroupName(java.lang.String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterSecurityGroups}
         * @param clusterSecurityGroups A list of security groups to be associated with this cluster.
         *                              Default: The default cluster security group for Amazon Redshift.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSecurityGroups(java.util.List<java.lang.String> clusterSecurityGroups) {
            this.clusterSecurityGroups = clusterSecurityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterSubnetGroupName}
         * @param clusterSubnetGroupName The name of a cluster subnet group to be associated with this cluster.
         *                               If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSubnetGroupName(java.lang.String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterVersion}
         * @param clusterVersion The version of the Amazon Redshift engine software that you want to deploy on the cluster.
         *                       The version selected runs on all the nodes in the cluster.
         *                       <p>
         *                       Constraints: Only version 1.0 is currently available.
         *                       <p>
         *                       Example: <code>1.0</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterVersion(java.lang.String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeferMaintenance}
         * @param deferMaintenance A Boolean indicating whether to enable the deferred maintenance window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenance(java.lang.Boolean deferMaintenance) {
            this.deferMaintenance = deferMaintenance;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeferMaintenance}
         * @param deferMaintenance A Boolean indicating whether to enable the deferred maintenance window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenance(software.amazon.awscdk.IResolvable deferMaintenance) {
            this.deferMaintenance = deferMaintenance;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeferMaintenanceDuration}
         * @param deferMaintenanceDuration An integer indicating the duration of the maintenance window in days.
         *                                 If you specify a duration, you can't specify an end time. The duration must be 45 days or less.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenanceDuration(java.lang.Number deferMaintenanceDuration) {
            this.deferMaintenanceDuration = deferMaintenanceDuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeferMaintenanceEndTime}
         * @param deferMaintenanceEndTime A timestamp for the end of the time period when we defer maintenance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenanceEndTime(java.lang.String deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDeferMaintenanceStartTime}
         * @param deferMaintenanceStartTime A timestamp indicating the start time for the deferred maintenance window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deferMaintenanceStartTime(java.lang.String deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDestinationRegion}
         * @param destinationRegion The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationRegion(java.lang.String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getElasticIp}
         * @param elasticIp The Elastic IP (EIP) address for the cluster.
         *                  Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. Don't specify the Elastic IP address for a publicly accessible cluster with availability zone relocation turned on. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticIp(java.lang.String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEncrypted}
         * @param encrypted If <code>true</code> , the data in the cluster is encrypted at rest.
         *                  If you set the value on this parameter to <code>false</code> , the request will fail.
         *                  <p>
         *                  Default: true
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEncrypted}
         * @param encrypted If <code>true</code> , the data in the cluster is encrypted at rest.
         *                  If you set the value on this parameter to <code>false</code> , the request will fail.
         *                  <p>
         *                  Default: true
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(software.amazon.awscdk.IResolvable encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEndpoint}
         * @param endpoint The connection endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(software.amazon.awscdk.IResolvable endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEndpoint}
         * @param endpoint The connection endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(software.amazon.awscdk.services.redshift.CfnCluster.EndpointProperty endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEnhancedVpcRouting}
         * @param enhancedVpcRouting An option that specifies whether to create the cluster with enhanced VPC routing enabled.
         *                           To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.
         *                           <p>
         *                           If this option is <code>true</code> , enhanced VPC routing is enabled.
         *                           <p>
         *                           Default: false
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(java.lang.Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEnhancedVpcRouting}
         * @param enhancedVpcRouting An option that specifies whether to create the cluster with enhanced VPC routing enabled.
         *                           To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.
         *                           <p>
         *                           If this option is <code>true</code> , enhanced VPC routing is enabled.
         *                           <p>
         *                           Default: false
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(software.amazon.awscdk.IResolvable enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getHsmClientCertificateIdentifier}
         * @param hsmClientCertificateIdentifier Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hsmClientCertificateIdentifier(java.lang.String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getHsmConfigurationIdentifier}
         * @param hsmConfigurationIdentifier Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hsmConfigurationIdentifier(java.lang.String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getIamRoles}
         * @param iamRoles A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services.
         *                 You must supply the IAM roles in their Amazon Resource Name (ARN) format.
         *                 <p>
         *                 The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRoles(java.util.List<java.lang.String> iamRoles) {
            this.iamRoles = iamRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getKmsKeyId}
         * @param kmsKeyId The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLoggingProperties}
         * @param loggingProperties Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingProperties(software.amazon.awscdk.IResolvable loggingProperties) {
            this.loggingProperties = loggingProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLoggingProperties}
         * @param loggingProperties Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingProperties(software.amazon.awscdk.services.redshift.CfnCluster.LoggingPropertiesProperty loggingProperties) {
            this.loggingProperties = loggingProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getMaintenanceTrackName}
         * @param maintenanceTrackName An optional parameter for the name of the maintenance track for the cluster.
         *                             If you don't provide a maintenance track name, the cluster is assigned to the <code>current</code> track.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceTrackName(java.lang.String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getManageMasterPassword}
         * @param manageMasterPassword If <code>true</code> , Amazon Redshift uses AWS Secrets Manager to manage this cluster's admin credentials.
         *                             You can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is true. If <code>ManageMasterPassword</code> is false or not set, Amazon Redshift uses <code>MasterUserPassword</code> for the admin user account's password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageMasterPassword(java.lang.Boolean manageMasterPassword) {
            this.manageMasterPassword = manageMasterPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getManageMasterPassword}
         * @param manageMasterPassword If <code>true</code> , Amazon Redshift uses AWS Secrets Manager to manage this cluster's admin credentials.
         *                             You can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is true. If <code>ManageMasterPassword</code> is false or not set, Amazon Redshift uses <code>MasterUserPassword</code> for the admin user account's password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageMasterPassword(software.amazon.awscdk.IResolvable manageMasterPassword) {
            this.manageMasterPassword = manageMasterPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getManualSnapshotRetentionPeriod}
         * @param manualSnapshotRetentionPeriod The default number of days to retain a manual snapshot.
         *                                      If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.
         *                                      <p>
         *                                      The value must be either -1 or an integer between 1 and 3,653.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manualSnapshotRetentionPeriod(java.lang.Number manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getMasterPasswordSecretKmsKeyId}
         * @param masterPasswordSecretKmsKeyId The ID of the AWS Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials secret.
         *                                     You can only use this parameter if <code>ManageMasterPassword</code> is true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterPasswordSecretKmsKeyId(java.lang.String masterPasswordSecretKmsKeyId) {
            this.masterPasswordSecretKmsKeyId = masterPasswordSecretKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getMasterUserPassword}
         * @param masterUserPassword The password associated with the admin user account for the cluster that is being created.
         *                           You can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is <code>true</code> .
         *                           <p>
         *                           Constraints:
         *                           <p>
         *                           <ul>
         *                           <li>Must be between 8 and 64 characters in length.</li>
         *                           <li>Must contain at least one uppercase letter.</li>
         *                           <li>Must contain at least one lowercase letter.</li>
         *                           <li>Must contain one number.</li>
         *                           <li>Can be any printable ASCII character (ASCII code 33-126) except <code>'</code> (single quote), <code>"</code> (double quote), <code>\</code> , <code>/</code> , or <code>&#64;</code> .</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(java.lang.String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getMultiAz}
         * @param multiAz A boolean indicating whether Amazon Redshift should deploy the cluster in two Availability Zones.
         *                The default is false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAz(java.lang.Boolean multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getMultiAz}
         * @param multiAz A boolean indicating whether Amazon Redshift should deploy the cluster in two Availability Zones.
         *                The default is false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAz(software.amazon.awscdk.IResolvable multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getNamespaceResourcePolicy}
         * @param namespaceResourcePolicy The policy that is attached to a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaceResourcePolicy(java.lang.Object namespaceResourcePolicy) {
            this.namespaceResourcePolicy = namespaceResourcePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getNumberOfNodes}
         * @param numberOfNodes The number of compute nodes in the cluster.
         *                      This parameter is required when the <em>ClusterType</em> parameter is specified as <code>multi-node</code> .
         *                      <p>
         *                      For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes">Working with Clusters</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
         *                      <p>
         *                      If you don't specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.
         *                      <p>
         *                      Default: <code>1</code>
         *                      <p>
         *                      Constraints: Value must be at least 1 and no more than 100.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberOfNodes(java.lang.Number numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getOwnerAccount}
         * @param ownerAccount The AWS account used to create or copy the snapshot.
         *                     Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerAccount(java.lang.String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getPort}
         * @param port The port number on which the cluster accepts incoming connections.
         *             The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.
         *             <p>
         *             Default: <code>5439</code>
         *             <p>
         *             Valid Values:
         *             <p>
         *             <ul>
         *             <li>For clusters with ra3 nodes - Select a port within the ranges <code>5431-5455</code> or <code>8191-8215</code> . (If you have an existing cluster with ra3 nodes, it isn't required that you change the port to these ranges.)</li>
         *             <li>For clusters with dc2 nodes - Select a port within the range <code>1150-65535</code> .</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow The weekly time range (in UTC) during which automated cluster maintenance can occur.
         *                                   Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *                                   <p>
         *                                   Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
         *                                   <p>
         *                                   Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         *                                   <p>
         *                                   Constraints: Minimum 30-minute window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getPubliclyAccessible}
         * @param publiclyAccessible If <code>true</code> , the cluster can be accessed from a public network.
         *                           Default: false
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getPubliclyAccessible}
         * @param publiclyAccessible If <code>true</code> , the cluster can be accessed from a public network.
         *                           Default: false
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getResourceAction}
         * @param resourceAction The Amazon Redshift operation to be performed.
         *                       Supported operations are <code>pause-cluster</code> , <code>resume-cluster</code> , and <code>failover-primary-compute</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceAction(java.lang.String resourceAction) {
            this.resourceAction = resourceAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRevisionTarget}
         * @param revisionTarget Describes a <code>RevisionTarget</code> object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revisionTarget(java.lang.String revisionTarget) {
            this.revisionTarget = revisionTarget;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRotateEncryptionKey}
         * @param rotateEncryptionKey Rotates the encryption keys for a cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateEncryptionKey(java.lang.Boolean rotateEncryptionKey) {
            this.rotateEncryptionKey = rotateEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRotateEncryptionKey}
         * @param rotateEncryptionKey Rotates the encryption keys for a cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateEncryptionKey(software.amazon.awscdk.IResolvable rotateEncryptionKey) {
            this.rotateEncryptionKey = rotateEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotClusterIdentifier}
         * @param snapshotClusterIdentifier The name of the cluster the source snapshot was created from.
         *                                  This parameter is required if your user or role has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotClusterIdentifier(java.lang.String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotCopyGrantName}
         * @param snapshotCopyGrantName The name of the snapshot copy grant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyGrantName(java.lang.String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotCopyManual}
         * @param snapshotCopyManual Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyManual(java.lang.Boolean snapshotCopyManual) {
            this.snapshotCopyManual = snapshotCopyManual;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotCopyManual}
         * @param snapshotCopyManual Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyManual(software.amazon.awscdk.IResolvable snapshotCopyManual) {
            this.snapshotCopyManual = snapshotCopyManual;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotCopyRetentionPeriod}
         * @param snapshotCopyRetentionPeriod The number of days to retain automated snapshots in the destination AWS Region after they are copied from the source AWS Region .
         *                                    By default, this only changes the retention period of copied automated snapshots.
         *                                    <p>
         *                                    If you decrease the retention period for automated snapshots that are copied to a destination AWS Region , Amazon Redshift deletes any existing automated snapshots that were copied to the destination AWS Region and that fall outside of the new retention period.
         *                                    <p>
         *                                    Constraints: Must be at least 1 and no more than 35 for automated snapshots.
         *                                    <p>
         *                                    If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new retention period.
         *                                    <p>
         *                                    If you specify the value of -1 newly copied manual snapshots are retained indefinitely.
         *                                    <p>
         *                                    Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCopyRetentionPeriod(java.lang.Number snapshotCopyRetentionPeriod) {
            this.snapshotCopyRetentionPeriod = snapshotCopyRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSnapshotIdentifier}
         * @param snapshotIdentifier The name of the snapshot from which to create the new cluster.
         *                           This parameter isn't case sensitive. You must specify this parameter or <code>snapshotArn</code> , but not both.
         *                           <p>
         *                           Example: <code>my-snapshot-id</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(java.lang.String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTags}
         * @param tags A list of tag instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getVpcSecurityGroupIds}
         * @param vpcSecurityGroupIds A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
         *                            Default: The default VPC security group is associated with the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterProps {
        private final java.lang.String clusterType;
        private final java.lang.String dbName;
        private final java.lang.String masterUsername;
        private final java.lang.String nodeType;
        private final java.lang.Object allowVersionUpgrade;
        private final java.lang.String aquaConfigurationStatus;
        private final java.lang.Number automatedSnapshotRetentionPeriod;
        private final java.lang.String availabilityZone;
        private final java.lang.Object availabilityZoneRelocation;
        private final java.lang.String availabilityZoneRelocationStatus;
        private final java.lang.Object classic;
        private final java.lang.String clusterIdentifier;
        private final java.lang.String clusterParameterGroupName;
        private final java.util.List<java.lang.String> clusterSecurityGroups;
        private final java.lang.String clusterSubnetGroupName;
        private final java.lang.String clusterVersion;
        private final java.lang.Object deferMaintenance;
        private final java.lang.Number deferMaintenanceDuration;
        private final java.lang.String deferMaintenanceEndTime;
        private final java.lang.String deferMaintenanceStartTime;
        private final java.lang.String destinationRegion;
        private final java.lang.String elasticIp;
        private final java.lang.Object encrypted;
        private final java.lang.Object endpoint;
        private final java.lang.Object enhancedVpcRouting;
        private final java.lang.String hsmClientCertificateIdentifier;
        private final java.lang.String hsmConfigurationIdentifier;
        private final java.util.List<java.lang.String> iamRoles;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object loggingProperties;
        private final java.lang.String maintenanceTrackName;
        private final java.lang.Object manageMasterPassword;
        private final java.lang.Number manualSnapshotRetentionPeriod;
        private final java.lang.String masterPasswordSecretKmsKeyId;
        private final java.lang.String masterUserPassword;
        private final java.lang.Object multiAz;
        private final java.lang.Object namespaceResourcePolicy;
        private final java.lang.Number numberOfNodes;
        private final java.lang.String ownerAccount;
        private final java.lang.Number port;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.lang.Object publiclyAccessible;
        private final java.lang.String resourceAction;
        private final java.lang.String revisionTarget;
        private final java.lang.Object rotateEncryptionKey;
        private final java.lang.String snapshotClusterIdentifier;
        private final java.lang.String snapshotCopyGrantName;
        private final java.lang.Object snapshotCopyManual;
        private final java.lang.Number snapshotCopyRetentionPeriod;
        private final java.lang.String snapshotIdentifier;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterType = software.amazon.jsii.Kernel.get(this, "clusterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbName = software.amazon.jsii.Kernel.get(this, "dbName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUsername = software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodeType = software.amazon.jsii.Kernel.get(this, "nodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowVersionUpgrade = software.amazon.jsii.Kernel.get(this, "allowVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.aquaConfigurationStatus = software.amazon.jsii.Kernel.get(this, "aquaConfigurationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.automatedSnapshotRetentionPeriod = software.amazon.jsii.Kernel.get(this, "automatedSnapshotRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZoneRelocation = software.amazon.jsii.Kernel.get(this, "availabilityZoneRelocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZoneRelocationStatus = software.amazon.jsii.Kernel.get(this, "availabilityZoneRelocationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.classic = software.amazon.jsii.Kernel.get(this, "classic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterParameterGroupName = software.amazon.jsii.Kernel.get(this, "clusterParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterSecurityGroups = software.amazon.jsii.Kernel.get(this, "clusterSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.clusterSubnetGroupName = software.amazon.jsii.Kernel.get(this, "clusterSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterVersion = software.amazon.jsii.Kernel.get(this, "clusterVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deferMaintenance = software.amazon.jsii.Kernel.get(this, "deferMaintenance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deferMaintenanceDuration = software.amazon.jsii.Kernel.get(this, "deferMaintenanceDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.deferMaintenanceEndTime = software.amazon.jsii.Kernel.get(this, "deferMaintenanceEndTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deferMaintenanceStartTime = software.amazon.jsii.Kernel.get(this, "deferMaintenanceStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationRegion = software.amazon.jsii.Kernel.get(this, "destinationRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.elasticIp = software.amazon.jsii.Kernel.get(this, "elasticIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enhancedVpcRouting = software.amazon.jsii.Kernel.get(this, "enhancedVpcRouting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.hsmClientCertificateIdentifier = software.amazon.jsii.Kernel.get(this, "hsmClientCertificateIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hsmConfigurationIdentifier = software.amazon.jsii.Kernel.get(this, "hsmConfigurationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iamRoles = software.amazon.jsii.Kernel.get(this, "iamRoles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingProperties = software.amazon.jsii.Kernel.get(this, "loggingProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maintenanceTrackName = software.amazon.jsii.Kernel.get(this, "maintenanceTrackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.manageMasterPassword = software.amazon.jsii.Kernel.get(this, "manageMasterPassword", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.manualSnapshotRetentionPeriod = software.amazon.jsii.Kernel.get(this, "manualSnapshotRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.masterPasswordSecretKmsKeyId = software.amazon.jsii.Kernel.get(this, "masterPasswordSecretKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUserPassword = software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiAz = software.amazon.jsii.Kernel.get(this, "multiAz", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.namespaceResourcePolicy = software.amazon.jsii.Kernel.get(this, "namespaceResourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.numberOfNodes = software.amazon.jsii.Kernel.get(this, "numberOfNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ownerAccount = software.amazon.jsii.Kernel.get(this, "ownerAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceAction = software.amazon.jsii.Kernel.get(this, "resourceAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.revisionTarget = software.amazon.jsii.Kernel.get(this, "revisionTarget", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rotateEncryptionKey = software.amazon.jsii.Kernel.get(this, "rotateEncryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snapshotClusterIdentifier = software.amazon.jsii.Kernel.get(this, "snapshotClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snapshotCopyGrantName = software.amazon.jsii.Kernel.get(this, "snapshotCopyGrantName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snapshotCopyManual = software.amazon.jsii.Kernel.get(this, "snapshotCopyManual", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snapshotCopyRetentionPeriod = software.amazon.jsii.Kernel.get(this, "snapshotCopyRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.snapshotIdentifier = software.amazon.jsii.Kernel.get(this, "snapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterType = java.util.Objects.requireNonNull(builder.clusterType, "clusterType is required");
            this.dbName = java.util.Objects.requireNonNull(builder.dbName, "dbName is required");
            this.masterUsername = java.util.Objects.requireNonNull(builder.masterUsername, "masterUsername is required");
            this.nodeType = java.util.Objects.requireNonNull(builder.nodeType, "nodeType is required");
            this.allowVersionUpgrade = builder.allowVersionUpgrade;
            this.aquaConfigurationStatus = builder.aquaConfigurationStatus;
            this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
            this.availabilityZone = builder.availabilityZone;
            this.availabilityZoneRelocation = builder.availabilityZoneRelocation;
            this.availabilityZoneRelocationStatus = builder.availabilityZoneRelocationStatus;
            this.classic = builder.classic;
            this.clusterIdentifier = builder.clusterIdentifier;
            this.clusterParameterGroupName = builder.clusterParameterGroupName;
            this.clusterSecurityGroups = builder.clusterSecurityGroups;
            this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
            this.clusterVersion = builder.clusterVersion;
            this.deferMaintenance = builder.deferMaintenance;
            this.deferMaintenanceDuration = builder.deferMaintenanceDuration;
            this.deferMaintenanceEndTime = builder.deferMaintenanceEndTime;
            this.deferMaintenanceStartTime = builder.deferMaintenanceStartTime;
            this.destinationRegion = builder.destinationRegion;
            this.elasticIp = builder.elasticIp;
            this.encrypted = builder.encrypted;
            this.endpoint = builder.endpoint;
            this.enhancedVpcRouting = builder.enhancedVpcRouting;
            this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
            this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
            this.iamRoles = builder.iamRoles;
            this.kmsKeyId = builder.kmsKeyId;
            this.loggingProperties = builder.loggingProperties;
            this.maintenanceTrackName = builder.maintenanceTrackName;
            this.manageMasterPassword = builder.manageMasterPassword;
            this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
            this.masterPasswordSecretKmsKeyId = builder.masterPasswordSecretKmsKeyId;
            this.masterUserPassword = builder.masterUserPassword;
            this.multiAz = builder.multiAz;
            this.namespaceResourcePolicy = builder.namespaceResourcePolicy;
            this.numberOfNodes = builder.numberOfNodes;
            this.ownerAccount = builder.ownerAccount;
            this.port = builder.port;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.publiclyAccessible = builder.publiclyAccessible;
            this.resourceAction = builder.resourceAction;
            this.revisionTarget = builder.revisionTarget;
            this.rotateEncryptionKey = builder.rotateEncryptionKey;
            this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
            this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
            this.snapshotCopyManual = builder.snapshotCopyManual;
            this.snapshotCopyRetentionPeriod = builder.snapshotCopyRetentionPeriod;
            this.snapshotIdentifier = builder.snapshotIdentifier;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        }

        @Override
        public final java.lang.String getClusterType() {
            return this.clusterType;
        }

        @Override
        public final java.lang.String getDbName() {
            return this.dbName;
        }

        @Override
        public final java.lang.String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final java.lang.String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final java.lang.Object getAllowVersionUpgrade() {
            return this.allowVersionUpgrade;
        }

        @Override
        public final java.lang.String getAquaConfigurationStatus() {
            return this.aquaConfigurationStatus;
        }

        @Override
        public final java.lang.Number getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Object getAvailabilityZoneRelocation() {
            return this.availabilityZoneRelocation;
        }

        @Override
        public final java.lang.String getAvailabilityZoneRelocationStatus() {
            return this.availabilityZoneRelocationStatus;
        }

        @Override
        public final java.lang.Object getClassic() {
            return this.classic;
        }

        @Override
        public final java.lang.String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final java.lang.String getClusterParameterGroupName() {
            return this.clusterParameterGroupName;
        }

        @Override
        public final java.util.List<java.lang.String> getClusterSecurityGroups() {
            return this.clusterSecurityGroups;
        }

        @Override
        public final java.lang.String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final java.lang.String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final java.lang.Object getDeferMaintenance() {
            return this.deferMaintenance;
        }

        @Override
        public final java.lang.Number getDeferMaintenanceDuration() {
            return this.deferMaintenanceDuration;
        }

        @Override
        public final java.lang.String getDeferMaintenanceEndTime() {
            return this.deferMaintenanceEndTime;
        }

        @Override
        public final java.lang.String getDeferMaintenanceStartTime() {
            return this.deferMaintenanceStartTime;
        }

        @Override
        public final java.lang.String getDestinationRegion() {
            return this.destinationRegion;
        }

        @Override
        public final java.lang.String getElasticIp() {
            return this.elasticIp;
        }

        @Override
        public final java.lang.Object getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final java.lang.Object getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final java.lang.Object getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final java.lang.String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final java.lang.String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final java.util.List<java.lang.String> getIamRoles() {
            return this.iamRoles;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getLoggingProperties() {
            return this.loggingProperties;
        }

        @Override
        public final java.lang.String getMaintenanceTrackName() {
            return this.maintenanceTrackName;
        }

        @Override
        public final java.lang.Object getManageMasterPassword() {
            return this.manageMasterPassword;
        }

        @Override
        public final java.lang.Number getManualSnapshotRetentionPeriod() {
            return this.manualSnapshotRetentionPeriod;
        }

        @Override
        public final java.lang.String getMasterPasswordSecretKmsKeyId() {
            return this.masterPasswordSecretKmsKeyId;
        }

        @Override
        public final java.lang.String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final java.lang.Object getMultiAz() {
            return this.multiAz;
        }

        @Override
        public final java.lang.Object getNamespaceResourcePolicy() {
            return this.namespaceResourcePolicy;
        }

        @Override
        public final java.lang.Number getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final java.lang.String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.lang.Object getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final java.lang.String getResourceAction() {
            return this.resourceAction;
        }

        @Override
        public final java.lang.String getRevisionTarget() {
            return this.revisionTarget;
        }

        @Override
        public final java.lang.Object getRotateEncryptionKey() {
            return this.rotateEncryptionKey;
        }

        @Override
        public final java.lang.String getSnapshotClusterIdentifier() {
            return this.snapshotClusterIdentifier;
        }

        @Override
        public final java.lang.String getSnapshotCopyGrantName() {
            return this.snapshotCopyGrantName;
        }

        @Override
        public final java.lang.Object getSnapshotCopyManual() {
            return this.snapshotCopyManual;
        }

        @Override
        public final java.lang.Number getSnapshotCopyRetentionPeriod() {
            return this.snapshotCopyRetentionPeriod;
        }

        @Override
        public final java.lang.String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterType", om.valueToTree(this.getClusterType()));
            data.set("dbName", om.valueToTree(this.getDbName()));
            data.set("masterUsername", om.valueToTree(this.getMasterUsername()));
            data.set("nodeType", om.valueToTree(this.getNodeType()));
            if (this.getAllowVersionUpgrade() != null) {
                data.set("allowVersionUpgrade", om.valueToTree(this.getAllowVersionUpgrade()));
            }
            if (this.getAquaConfigurationStatus() != null) {
                data.set("aquaConfigurationStatus", om.valueToTree(this.getAquaConfigurationStatus()));
            }
            if (this.getAutomatedSnapshotRetentionPeriod() != null) {
                data.set("automatedSnapshotRetentionPeriod", om.valueToTree(this.getAutomatedSnapshotRetentionPeriod()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getAvailabilityZoneRelocation() != null) {
                data.set("availabilityZoneRelocation", om.valueToTree(this.getAvailabilityZoneRelocation()));
            }
            if (this.getAvailabilityZoneRelocationStatus() != null) {
                data.set("availabilityZoneRelocationStatus", om.valueToTree(this.getAvailabilityZoneRelocationStatus()));
            }
            if (this.getClassic() != null) {
                data.set("classic", om.valueToTree(this.getClassic()));
            }
            if (this.getClusterIdentifier() != null) {
                data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
            }
            if (this.getClusterParameterGroupName() != null) {
                data.set("clusterParameterGroupName", om.valueToTree(this.getClusterParameterGroupName()));
            }
            if (this.getClusterSecurityGroups() != null) {
                data.set("clusterSecurityGroups", om.valueToTree(this.getClusterSecurityGroups()));
            }
            if (this.getClusterSubnetGroupName() != null) {
                data.set("clusterSubnetGroupName", om.valueToTree(this.getClusterSubnetGroupName()));
            }
            if (this.getClusterVersion() != null) {
                data.set("clusterVersion", om.valueToTree(this.getClusterVersion()));
            }
            if (this.getDeferMaintenance() != null) {
                data.set("deferMaintenance", om.valueToTree(this.getDeferMaintenance()));
            }
            if (this.getDeferMaintenanceDuration() != null) {
                data.set("deferMaintenanceDuration", om.valueToTree(this.getDeferMaintenanceDuration()));
            }
            if (this.getDeferMaintenanceEndTime() != null) {
                data.set("deferMaintenanceEndTime", om.valueToTree(this.getDeferMaintenanceEndTime()));
            }
            if (this.getDeferMaintenanceStartTime() != null) {
                data.set("deferMaintenanceStartTime", om.valueToTree(this.getDeferMaintenanceStartTime()));
            }
            if (this.getDestinationRegion() != null) {
                data.set("destinationRegion", om.valueToTree(this.getDestinationRegion()));
            }
            if (this.getElasticIp() != null) {
                data.set("elasticIp", om.valueToTree(this.getElasticIp()));
            }
            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getEndpoint() != null) {
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
            }
            if (this.getEnhancedVpcRouting() != null) {
                data.set("enhancedVpcRouting", om.valueToTree(this.getEnhancedVpcRouting()));
            }
            if (this.getHsmClientCertificateIdentifier() != null) {
                data.set("hsmClientCertificateIdentifier", om.valueToTree(this.getHsmClientCertificateIdentifier()));
            }
            if (this.getHsmConfigurationIdentifier() != null) {
                data.set("hsmConfigurationIdentifier", om.valueToTree(this.getHsmConfigurationIdentifier()));
            }
            if (this.getIamRoles() != null) {
                data.set("iamRoles", om.valueToTree(this.getIamRoles()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLoggingProperties() != null) {
                data.set("loggingProperties", om.valueToTree(this.getLoggingProperties()));
            }
            if (this.getMaintenanceTrackName() != null) {
                data.set("maintenanceTrackName", om.valueToTree(this.getMaintenanceTrackName()));
            }
            if (this.getManageMasterPassword() != null) {
                data.set("manageMasterPassword", om.valueToTree(this.getManageMasterPassword()));
            }
            if (this.getManualSnapshotRetentionPeriod() != null) {
                data.set("manualSnapshotRetentionPeriod", om.valueToTree(this.getManualSnapshotRetentionPeriod()));
            }
            if (this.getMasterPasswordSecretKmsKeyId() != null) {
                data.set("masterPasswordSecretKmsKeyId", om.valueToTree(this.getMasterPasswordSecretKmsKeyId()));
            }
            if (this.getMasterUserPassword() != null) {
                data.set("masterUserPassword", om.valueToTree(this.getMasterUserPassword()));
            }
            if (this.getMultiAz() != null) {
                data.set("multiAz", om.valueToTree(this.getMultiAz()));
            }
            if (this.getNamespaceResourcePolicy() != null) {
                data.set("namespaceResourcePolicy", om.valueToTree(this.getNamespaceResourcePolicy()));
            }
            if (this.getNumberOfNodes() != null) {
                data.set("numberOfNodes", om.valueToTree(this.getNumberOfNodes()));
            }
            if (this.getOwnerAccount() != null) {
                data.set("ownerAccount", om.valueToTree(this.getOwnerAccount()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getPubliclyAccessible() != null) {
                data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            }
            if (this.getResourceAction() != null) {
                data.set("resourceAction", om.valueToTree(this.getResourceAction()));
            }
            if (this.getRevisionTarget() != null) {
                data.set("revisionTarget", om.valueToTree(this.getRevisionTarget()));
            }
            if (this.getRotateEncryptionKey() != null) {
                data.set("rotateEncryptionKey", om.valueToTree(this.getRotateEncryptionKey()));
            }
            if (this.getSnapshotClusterIdentifier() != null) {
                data.set("snapshotClusterIdentifier", om.valueToTree(this.getSnapshotClusterIdentifier()));
            }
            if (this.getSnapshotCopyGrantName() != null) {
                data.set("snapshotCopyGrantName", om.valueToTree(this.getSnapshotCopyGrantName()));
            }
            if (this.getSnapshotCopyManual() != null) {
                data.set("snapshotCopyManual", om.valueToTree(this.getSnapshotCopyManual()));
            }
            if (this.getSnapshotCopyRetentionPeriod() != null) {
                data.set("snapshotCopyRetentionPeriod", om.valueToTree(this.getSnapshotCopyRetentionPeriod()));
            }
            if (this.getSnapshotIdentifier() != null) {
                data.set("snapshotIdentifier", om.valueToTree(this.getSnapshotIdentifier()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcSecurityGroupIds() != null) {
                data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshift.CfnClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterProps.Jsii$Proxy that = (CfnClusterProps.Jsii$Proxy) o;

            if (!clusterType.equals(that.clusterType)) return false;
            if (!dbName.equals(that.dbName)) return false;
            if (!masterUsername.equals(that.masterUsername)) return false;
            if (!nodeType.equals(that.nodeType)) return false;
            if (this.allowVersionUpgrade != null ? !this.allowVersionUpgrade.equals(that.allowVersionUpgrade) : that.allowVersionUpgrade != null) return false;
            if (this.aquaConfigurationStatus != null ? !this.aquaConfigurationStatus.equals(that.aquaConfigurationStatus) : that.aquaConfigurationStatus != null) return false;
            if (this.automatedSnapshotRetentionPeriod != null ? !this.automatedSnapshotRetentionPeriod.equals(that.automatedSnapshotRetentionPeriod) : that.automatedSnapshotRetentionPeriod != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.availabilityZoneRelocation != null ? !this.availabilityZoneRelocation.equals(that.availabilityZoneRelocation) : that.availabilityZoneRelocation != null) return false;
            if (this.availabilityZoneRelocationStatus != null ? !this.availabilityZoneRelocationStatus.equals(that.availabilityZoneRelocationStatus) : that.availabilityZoneRelocationStatus != null) return false;
            if (this.classic != null ? !this.classic.equals(that.classic) : that.classic != null) return false;
            if (this.clusterIdentifier != null ? !this.clusterIdentifier.equals(that.clusterIdentifier) : that.clusterIdentifier != null) return false;
            if (this.clusterParameterGroupName != null ? !this.clusterParameterGroupName.equals(that.clusterParameterGroupName) : that.clusterParameterGroupName != null) return false;
            if (this.clusterSecurityGroups != null ? !this.clusterSecurityGroups.equals(that.clusterSecurityGroups) : that.clusterSecurityGroups != null) return false;
            if (this.clusterSubnetGroupName != null ? !this.clusterSubnetGroupName.equals(that.clusterSubnetGroupName) : that.clusterSubnetGroupName != null) return false;
            if (this.clusterVersion != null ? !this.clusterVersion.equals(that.clusterVersion) : that.clusterVersion != null) return false;
            if (this.deferMaintenance != null ? !this.deferMaintenance.equals(that.deferMaintenance) : that.deferMaintenance != null) return false;
            if (this.deferMaintenanceDuration != null ? !this.deferMaintenanceDuration.equals(that.deferMaintenanceDuration) : that.deferMaintenanceDuration != null) return false;
            if (this.deferMaintenanceEndTime != null ? !this.deferMaintenanceEndTime.equals(that.deferMaintenanceEndTime) : that.deferMaintenanceEndTime != null) return false;
            if (this.deferMaintenanceStartTime != null ? !this.deferMaintenanceStartTime.equals(that.deferMaintenanceStartTime) : that.deferMaintenanceStartTime != null) return false;
            if (this.destinationRegion != null ? !this.destinationRegion.equals(that.destinationRegion) : that.destinationRegion != null) return false;
            if (this.elasticIp != null ? !this.elasticIp.equals(that.elasticIp) : that.elasticIp != null) return false;
            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) return false;
            if (this.enhancedVpcRouting != null ? !this.enhancedVpcRouting.equals(that.enhancedVpcRouting) : that.enhancedVpcRouting != null) return false;
            if (this.hsmClientCertificateIdentifier != null ? !this.hsmClientCertificateIdentifier.equals(that.hsmClientCertificateIdentifier) : that.hsmClientCertificateIdentifier != null) return false;
            if (this.hsmConfigurationIdentifier != null ? !this.hsmConfigurationIdentifier.equals(that.hsmConfigurationIdentifier) : that.hsmConfigurationIdentifier != null) return false;
            if (this.iamRoles != null ? !this.iamRoles.equals(that.iamRoles) : that.iamRoles != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.loggingProperties != null ? !this.loggingProperties.equals(that.loggingProperties) : that.loggingProperties != null) return false;
            if (this.maintenanceTrackName != null ? !this.maintenanceTrackName.equals(that.maintenanceTrackName) : that.maintenanceTrackName != null) return false;
            if (this.manageMasterPassword != null ? !this.manageMasterPassword.equals(that.manageMasterPassword) : that.manageMasterPassword != null) return false;
            if (this.manualSnapshotRetentionPeriod != null ? !this.manualSnapshotRetentionPeriod.equals(that.manualSnapshotRetentionPeriod) : that.manualSnapshotRetentionPeriod != null) return false;
            if (this.masterPasswordSecretKmsKeyId != null ? !this.masterPasswordSecretKmsKeyId.equals(that.masterPasswordSecretKmsKeyId) : that.masterPasswordSecretKmsKeyId != null) return false;
            if (this.masterUserPassword != null ? !this.masterUserPassword.equals(that.masterUserPassword) : that.masterUserPassword != null) return false;
            if (this.multiAz != null ? !this.multiAz.equals(that.multiAz) : that.multiAz != null) return false;
            if (this.namespaceResourcePolicy != null ? !this.namespaceResourcePolicy.equals(that.namespaceResourcePolicy) : that.namespaceResourcePolicy != null) return false;
            if (this.numberOfNodes != null ? !this.numberOfNodes.equals(that.numberOfNodes) : that.numberOfNodes != null) return false;
            if (this.ownerAccount != null ? !this.ownerAccount.equals(that.ownerAccount) : that.ownerAccount != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.publiclyAccessible != null ? !this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible != null) return false;
            if (this.resourceAction != null ? !this.resourceAction.equals(that.resourceAction) : that.resourceAction != null) return false;
            if (this.revisionTarget != null ? !this.revisionTarget.equals(that.revisionTarget) : that.revisionTarget != null) return false;
            if (this.rotateEncryptionKey != null ? !this.rotateEncryptionKey.equals(that.rotateEncryptionKey) : that.rotateEncryptionKey != null) return false;
            if (this.snapshotClusterIdentifier != null ? !this.snapshotClusterIdentifier.equals(that.snapshotClusterIdentifier) : that.snapshotClusterIdentifier != null) return false;
            if (this.snapshotCopyGrantName != null ? !this.snapshotCopyGrantName.equals(that.snapshotCopyGrantName) : that.snapshotCopyGrantName != null) return false;
            if (this.snapshotCopyManual != null ? !this.snapshotCopyManual.equals(that.snapshotCopyManual) : that.snapshotCopyManual != null) return false;
            if (this.snapshotCopyRetentionPeriod != null ? !this.snapshotCopyRetentionPeriod.equals(that.snapshotCopyRetentionPeriod) : that.snapshotCopyRetentionPeriod != null) return false;
            if (this.snapshotIdentifier != null ? !this.snapshotIdentifier.equals(that.snapshotIdentifier) : that.snapshotIdentifier != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterType.hashCode();
            result = 31 * result + (this.dbName.hashCode());
            result = 31 * result + (this.masterUsername.hashCode());
            result = 31 * result + (this.nodeType.hashCode());
            result = 31 * result + (this.allowVersionUpgrade != null ? this.allowVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.aquaConfigurationStatus != null ? this.aquaConfigurationStatus.hashCode() : 0);
            result = 31 * result + (this.automatedSnapshotRetentionPeriod != null ? this.automatedSnapshotRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.availabilityZoneRelocation != null ? this.availabilityZoneRelocation.hashCode() : 0);
            result = 31 * result + (this.availabilityZoneRelocationStatus != null ? this.availabilityZoneRelocationStatus.hashCode() : 0);
            result = 31 * result + (this.classic != null ? this.classic.hashCode() : 0);
            result = 31 * result + (this.clusterIdentifier != null ? this.clusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.clusterParameterGroupName != null ? this.clusterParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.clusterSecurityGroups != null ? this.clusterSecurityGroups.hashCode() : 0);
            result = 31 * result + (this.clusterSubnetGroupName != null ? this.clusterSubnetGroupName.hashCode() : 0);
            result = 31 * result + (this.clusterVersion != null ? this.clusterVersion.hashCode() : 0);
            result = 31 * result + (this.deferMaintenance != null ? this.deferMaintenance.hashCode() : 0);
            result = 31 * result + (this.deferMaintenanceDuration != null ? this.deferMaintenanceDuration.hashCode() : 0);
            result = 31 * result + (this.deferMaintenanceEndTime != null ? this.deferMaintenanceEndTime.hashCode() : 0);
            result = 31 * result + (this.deferMaintenanceStartTime != null ? this.deferMaintenanceStartTime.hashCode() : 0);
            result = 31 * result + (this.destinationRegion != null ? this.destinationRegion.hashCode() : 0);
            result = 31 * result + (this.elasticIp != null ? this.elasticIp.hashCode() : 0);
            result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
            result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
            result = 31 * result + (this.enhancedVpcRouting != null ? this.enhancedVpcRouting.hashCode() : 0);
            result = 31 * result + (this.hsmClientCertificateIdentifier != null ? this.hsmClientCertificateIdentifier.hashCode() : 0);
            result = 31 * result + (this.hsmConfigurationIdentifier != null ? this.hsmConfigurationIdentifier.hashCode() : 0);
            result = 31 * result + (this.iamRoles != null ? this.iamRoles.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.loggingProperties != null ? this.loggingProperties.hashCode() : 0);
            result = 31 * result + (this.maintenanceTrackName != null ? this.maintenanceTrackName.hashCode() : 0);
            result = 31 * result + (this.manageMasterPassword != null ? this.manageMasterPassword.hashCode() : 0);
            result = 31 * result + (this.manualSnapshotRetentionPeriod != null ? this.manualSnapshotRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.masterPasswordSecretKmsKeyId != null ? this.masterPasswordSecretKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.masterUserPassword != null ? this.masterUserPassword.hashCode() : 0);
            result = 31 * result + (this.multiAz != null ? this.multiAz.hashCode() : 0);
            result = 31 * result + (this.namespaceResourcePolicy != null ? this.namespaceResourcePolicy.hashCode() : 0);
            result = 31 * result + (this.numberOfNodes != null ? this.numberOfNodes.hashCode() : 0);
            result = 31 * result + (this.ownerAccount != null ? this.ownerAccount.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
            result = 31 * result + (this.resourceAction != null ? this.resourceAction.hashCode() : 0);
            result = 31 * result + (this.revisionTarget != null ? this.revisionTarget.hashCode() : 0);
            result = 31 * result + (this.rotateEncryptionKey != null ? this.rotateEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.snapshotClusterIdentifier != null ? this.snapshotClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.snapshotCopyGrantName != null ? this.snapshotCopyGrantName.hashCode() : 0);
            result = 31 * result + (this.snapshotCopyManual != null ? this.snapshotCopyManual.hashCode() : 0);
            result = 31 * result + (this.snapshotCopyRetentionPeriod != null ? this.snapshotCopyRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.snapshotIdentifier != null ? this.snapshotIdentifier.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
            return result;
        }
    }
}
