package software.amazon.awscdk.services.route53;

/**
 * Properties to create a Route 53 private hosted zone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * PrivateHostedZone zone = PrivateHostedZone.Builder.create(this, "HostedZone")
 *         .zoneName("fully.qualified.domain.com")
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:40.538Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.PrivateHostedZoneProps")
@software.amazon.jsii.Jsii.Proxy(PrivateHostedZoneProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PrivateHostedZoneProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.route53.CommonHostedZoneProps {

    /**
     * A VPC that you want to associate with this hosted zone.
     * <p>
     * Private hosted zones must be associated with at least one VPC. You can
     * associated additional VPCs using <code>addVpc(vpc)</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * @return a {@link Builder} of {@link PrivateHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PrivateHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PrivateHostedZoneProps> {
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.String zoneName;
        java.lang.Boolean addTrailingDot;
        java.lang.String comment;
        java.lang.String queryLogsLogGroupArn;

        /**
         * Sets the value of {@link PrivateHostedZoneProps#getVpc}
         * @param vpc A VPC that you want to associate with this hosted zone. This parameter is required.
         *            Private hosted zones must be associated with at least one VPC. You can
         *            associated additional VPCs using <code>addVpc(vpc)</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link PrivateHostedZoneProps#getZoneName}
         * @param zoneName The name of the domain. This parameter is required.
         *                 For resource record types that include a domain
         *                 name, specify a fully qualified domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zoneName(java.lang.String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        /**
         * Sets the value of {@link PrivateHostedZoneProps#getAddTrailingDot}
         * @param addTrailingDot Whether to add a trailing dot to the zone name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addTrailingDot(java.lang.Boolean addTrailingDot) {
            this.addTrailingDot = addTrailingDot;
            return this;
        }

        /**
         * Sets the value of {@link PrivateHostedZoneProps#getComment}
         * @param comment Any comments that you want to include about the hosted zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link PrivateHostedZoneProps#getQueryLogsLogGroupArn}
         * @param queryLogsLogGroupArn The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogsLogGroupArn(java.lang.String queryLogsLogGroupArn) {
            this.queryLogsLogGroupArn = queryLogsLogGroupArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PrivateHostedZoneProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PrivateHostedZoneProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PrivateHostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateHostedZoneProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.String zoneName;
        private final java.lang.Boolean addTrailingDot;
        private final java.lang.String comment;
        private final java.lang.String queryLogsLogGroupArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.zoneName = software.amazon.jsii.Kernel.get(this, "zoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.addTrailingDot = software.amazon.jsii.Kernel.get(this, "addTrailingDot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLogsLogGroupArn = software.amazon.jsii.Kernel.get(this, "queryLogsLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.zoneName = java.util.Objects.requireNonNull(builder.zoneName, "zoneName is required");
            this.addTrailingDot = builder.addTrailingDot;
            this.comment = builder.comment;
            this.queryLogsLogGroupArn = builder.queryLogsLogGroupArn;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.String getZoneName() {
            return this.zoneName;
        }

        @Override
        public final java.lang.Boolean getAddTrailingDot() {
            return this.addTrailingDot;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getQueryLogsLogGroupArn() {
            return this.queryLogsLogGroupArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            data.set("zoneName", om.valueToTree(this.getZoneName()));
            if (this.getAddTrailingDot() != null) {
                data.set("addTrailingDot", om.valueToTree(this.getAddTrailingDot()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLogsLogGroupArn() != null) {
                data.set("queryLogsLogGroupArn", om.valueToTree(this.getQueryLogsLogGroupArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.PrivateHostedZoneProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PrivateHostedZoneProps.Jsii$Proxy that = (PrivateHostedZoneProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (!zoneName.equals(that.zoneName)) return false;
            if (this.addTrailingDot != null ? !this.addTrailingDot.equals(that.addTrailingDot) : that.addTrailingDot != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            return this.queryLogsLogGroupArn != null ? this.queryLogsLogGroupArn.equals(that.queryLogsLogGroupArn) : that.queryLogsLogGroupArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.zoneName.hashCode());
            result = 31 * result + (this.addTrailingDot != null ? this.addTrailingDot.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLogsLogGroupArn != null ? this.queryLogsLogGroupArn.hashCode() : 0);
            return result;
        }
    }
}
