package software.amazon.awscdk.services.s3.deployment;

/**
 * Bind context for ISources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.s3.deployment.*;
 * Role role;
 * DeploymentSourceContext deploymentSourceContext = DeploymentSourceContext.builder()
 *         .handlerRole(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:40.830Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.DeploymentSourceContext")
@software.amazon.jsii.Jsii.Proxy(DeploymentSourceContext.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeploymentSourceContext extends software.amazon.jsii.JsiiSerializable {

    /**
     * The role for the handler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getHandlerRole();

    /**
     * @return a {@link Builder} of {@link DeploymentSourceContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeploymentSourceContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeploymentSourceContext> {
        software.amazon.awscdk.services.iam.IRole handlerRole;

        /**
         * Sets the value of {@link DeploymentSourceContext#getHandlerRole}
         * @param handlerRole The role for the handler. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handlerRole(software.amazon.awscdk.services.iam.IRole handlerRole) {
            this.handlerRole = handlerRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentSourceContext}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeploymentSourceContext build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeploymentSourceContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentSourceContext {
        private final software.amazon.awscdk.services.iam.IRole handlerRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.handlerRole = software.amazon.jsii.Kernel.get(this, "handlerRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.handlerRole = java.util.Objects.requireNonNull(builder.handlerRole, "handlerRole is required");
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getHandlerRole() {
            return this.handlerRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("handlerRole", om.valueToTree(this.getHandlerRole()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3_deployment.DeploymentSourceContext"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeploymentSourceContext.Jsii$Proxy that = (DeploymentSourceContext.Jsii$Proxy) o;

            return this.handlerRole.equals(that.handlerRole);
        }

        @Override
        public final int hashCode() {
            int result = this.handlerRole.hashCode();
            return result;
        }
    }
}
