package software.amazon.awscdk.services.s3tables;

/**
 * Properties for defining a <code>CfnTableBucket</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3tables.*;
 * CfnTableBucketProps cfnTableBucketProps = CfnTableBucketProps.builder()
 *         .tableBucketName("tableBucketName")
 *         // the properties below are optional
 *         .unreferencedFileRemoval(UnreferencedFileRemovalProperty.builder()
 *                 .noncurrentDays(123)
 *                 .status("status")
 *                 .unreferencedDays(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:40.872Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3tables.CfnTableBucketProps")
@software.amazon.jsii.Jsii.Proxy(CfnTableBucketProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTableBucketProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name for the table bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html#cfn-s3tables-tablebucket-tablebucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html#cfn-s3tables-tablebucket-tablebucketname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableBucketName();

    /**
     * The unreferenced file removal settings for your table bucket.
     * <p>
     * Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots. For more information, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html"><em>Amazon S3 User Guide</em></a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html#cfn-s3tables-tablebucket-unreferencedfileremoval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html#cfn-s3tables-tablebucket-unreferencedfileremoval</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUnreferencedFileRemoval() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTableBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTableBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTableBucketProps> {
        java.lang.String tableBucketName;
        java.lang.Object unreferencedFileRemoval;

        /**
         * Sets the value of {@link CfnTableBucketProps#getTableBucketName}
         * @param tableBucketName The name for the table bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableBucketName(java.lang.String tableBucketName) {
            this.tableBucketName = tableBucketName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableBucketProps#getUnreferencedFileRemoval}
         * @param unreferencedFileRemoval The unreferenced file removal settings for your table bucket.
         *                                Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots. For more information, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html"><em>Amazon S3 User Guide</em></a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unreferencedFileRemoval(software.amazon.awscdk.IResolvable unreferencedFileRemoval) {
            this.unreferencedFileRemoval = unreferencedFileRemoval;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableBucketProps#getUnreferencedFileRemoval}
         * @param unreferencedFileRemoval The unreferenced file removal settings for your table bucket.
         *                                Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots. For more information, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html"><em>Amazon S3 User Guide</em></a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unreferencedFileRemoval(software.amazon.awscdk.services.s3tables.CfnTableBucket.UnreferencedFileRemovalProperty unreferencedFileRemoval) {
            this.unreferencedFileRemoval = unreferencedFileRemoval;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTableBucketProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTableBucketProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTableBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTableBucketProps {
        private final java.lang.String tableBucketName;
        private final java.lang.Object unreferencedFileRemoval;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tableBucketName = software.amazon.jsii.Kernel.get(this, "tableBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.unreferencedFileRemoval = software.amazon.jsii.Kernel.get(this, "unreferencedFileRemoval", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tableBucketName = java.util.Objects.requireNonNull(builder.tableBucketName, "tableBucketName is required");
            this.unreferencedFileRemoval = builder.unreferencedFileRemoval;
        }

        @Override
        public final java.lang.String getTableBucketName() {
            return this.tableBucketName;
        }

        @Override
        public final java.lang.Object getUnreferencedFileRemoval() {
            return this.unreferencedFileRemoval;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("tableBucketName", om.valueToTree(this.getTableBucketName()));
            if (this.getUnreferencedFileRemoval() != null) {
                data.set("unreferencedFileRemoval", om.valueToTree(this.getUnreferencedFileRemoval()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3tables.CfnTableBucketProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTableBucketProps.Jsii$Proxy that = (CfnTableBucketProps.Jsii$Proxy) o;

            if (!tableBucketName.equals(that.tableBucketName)) return false;
            return this.unreferencedFileRemoval != null ? this.unreferencedFileRemoval.equals(that.unreferencedFileRemoval) : that.unreferencedFileRemoval == null;
        }

        @Override
        public final int hashCode() {
            int result = this.tableBucketName.hashCode();
            result = 31 * result + (this.unreferencedFileRemoval != null ? this.unreferencedFileRemoval.hashCode() : 0);
            return result;
        }
    }
}
