package software.amazon.awscdk.services.ses.actions;

/**
 * Construction properties for a S3 action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.ses.actions.*;
 * Bucket bucket = new Bucket(this, "Bucket");
 * Topic topic = new Topic(this, "Topic");
 * ReceiptRuleSet.Builder.create(this, "RuleSet")
 *         .rules(List.of(ReceiptRuleOptions.builder()
 *                 .recipients(List.of("hello&#64;aws.com"))
 *                 .actions(List.of(
 *                     AddHeader.Builder.create()
 *                             .name("X-Special-Header")
 *                             .value("aws")
 *                             .build(),
 *                     S3.Builder.create()
 *                             .bucket(bucket)
 *                             .objectKeyPrefix("emails/")
 *                             .topic(topic)
 *                             .build()))
 *                 .build(), ReceiptRuleOptions.builder()
 *                 .recipients(List.of("aws.com"))
 *                 .actions(List.of(
 *                     Sns.Builder.create()
 *                             .topic(topic)
 *                             .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:41.744Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses_actions.S3Props")
@software.amazon.jsii.Jsii.Proxy(S3Props.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3Props extends software.amazon.jsii.JsiiSerializable {

    /**
     * The S3 bucket that incoming email will be saved to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * The master key that SES should use to encrypt your emails before saving them to the S3 bucket.
     * <p>
     * Default: no encryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * The key prefix of the S3 bucket.
     * <p>
     * Default: no prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getObjectKeyPrefix() {
        return null;
    }

    /**
     * The SNS topic to notify when the S3 action is taken.
     * <p>
     * Default: no notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getTopic() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3Props> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        java.lang.String objectKeyPrefix;
        software.amazon.awscdk.services.sns.ITopic topic;

        /**
         * Sets the value of {@link S3Props#getBucket}
         * @param bucket The S3 bucket that incoming email will be saved to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link S3Props#getKmsKey}
         * @param kmsKey The master key that SES should use to encrypt your emails before saving them to the S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link S3Props#getObjectKeyPrefix}
         * @param objectKeyPrefix The key prefix of the S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectKeyPrefix(java.lang.String objectKeyPrefix) {
            this.objectKeyPrefix = objectKeyPrefix;
            return this;
        }

        /**
         * Sets the value of {@link S3Props#getTopic}
         * @param topic The SNS topic to notify when the S3 action is taken.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3Props build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3Props {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final java.lang.String objectKeyPrefix;
        private final software.amazon.awscdk.services.sns.ITopic topic;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.objectKeyPrefix = software.amazon.jsii.Kernel.get(this, "objectKeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.kmsKey = builder.kmsKey;
            this.objectKeyPrefix = builder.objectKeyPrefix;
            this.topic = builder.topic;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final java.lang.String getObjectKeyPrefix() {
            return this.objectKeyPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getTopic() {
            return this.topic;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getObjectKeyPrefix() != null) {
                data.set("objectKeyPrefix", om.valueToTree(this.getObjectKeyPrefix()));
            }
            if (this.getTopic() != null) {
                data.set("topic", om.valueToTree(this.getTopic()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses_actions.S3Props"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3Props.Jsii$Proxy that = (S3Props.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.objectKeyPrefix != null ? !this.objectKeyPrefix.equals(that.objectKeyPrefix) : that.objectKeyPrefix != null) return false;
            return this.topic != null ? this.topic.equals(that.topic) : that.topic == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.objectKeyPrefix != null ? this.objectKeyPrefix.hashCode() : 0);
            result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
            return result;
        }
    }
}
