package software.amazon.awscdk.services.ses.actions;

/**
 * Integrates an Amazon WorkMail action into a receipt rule set, and optionally publishes a notification to Amazon SNS.
 * <p>
 * Beware that WorkMail should already set up an active <code>INBOUND_MAIL</code> rule set
 * that includes a WorkMail rule action for this exact purpose.
 * This action should be used to customize the behavior of replacement rule set.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.actions.*;
 * import software.amazon.awscdk.services.sns.*;
 * Topic topic;
 * WorkMail workMail = WorkMail.Builder.create()
 *         .organizationArn("organizationArn")
 *         // the properties below are optional
 *         .topic(topic)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-workmail.html">https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-workmail.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:41.746Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses_actions.WorkMail")
public class WorkMail extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ses.IReceiptRuleAction {

    protected WorkMail(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WorkMail(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WorkMail(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.actions.WorkMailProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the receipt rule action specification.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ReceiptRuleActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IReceiptRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ReceiptRuleActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.actions.WorkMail}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.actions.WorkMail> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ses.actions.WorkMailProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ses.actions.WorkMailProps.Builder();
        }

        /**
         * The WorkMail organization ARN.
         * <p>
         * Amazon WorkMail organization ARNs are in the form
         * <code>arn:aws:workmail:region:account_ID:organization/organization_ID</code>
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "arn:aws:workmail:us-east-1:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7";
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param organizationArn The WorkMail organization ARN. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationArn(final java.lang.String organizationArn) {
            this.props.organizationArn(organizationArn);
            return this;
        }

        /**
         * The SNS topic to notify when the WorkMail action is taken.
         * <p>
         * Default: - no topic will be attached to the action
         * <p>
         * @return {@code this}
         * @param topic The SNS topic to notify when the WorkMail action is taken. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.props.topic(topic);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.actions.WorkMail}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.actions.WorkMail build() {
            return new software.amazon.awscdk.services.ses.actions.WorkMail(
                this.props.build()
            );
        }
    }
}
