package software.amazon.awscdk.services.sns;

/**
 * Conditions that can be applied to string attributes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn;
 * Topic myTopic = new Topic(this, "MyTopic");
 * // Lambda should receive only message matching the following conditions on attributes:
 * // color: 'red' or 'orange' or begins with 'bl'
 * // size: anything but 'small' or 'medium'
 * // price: between 100 and 200 or greater than 300
 * // store: attribute must be present
 * myTopic.addSubscription(LambdaSubscription.Builder.create(fn)
 *         .filterPolicy(Map.of(
 *                 "color", SubscriptionFilter.stringFilter(StringConditions.builder()
 *                         .allowlist(List.of("red", "orange"))
 *                         .matchPrefixes(List.of("bl"))
 *                         .matchSuffixes(List.of("ue"))
 *                         .build()),
 *                 "size", SubscriptionFilter.stringFilter(StringConditions.builder()
 *                         .denylist(List.of("small", "medium"))
 *                         .build()),
 *                 "price", SubscriptionFilter.numericFilter(NumericConditions.builder()
 *                         .between(BetweenCondition.builder().start(100).stop(200).build())
 *                         .greaterThan(300)
 *                         .build()),
 *                 "store", SubscriptionFilter.existsFilter()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:41.801Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.StringConditions")
@software.amazon.jsii.Jsii.Proxy(StringConditions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StringConditions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Match one or more values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowlist() {
        return null;
    }

    /**
     * Match any value that doesn't include any of the specified values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDenylist() {
        return null;
    }

    /**
     * Matches values that begins with the specified prefixes.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchPrefixes() {
        return null;
    }

    /**
     * Matches values that end with the specified suffixes.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchSuffixes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StringConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StringConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StringConditions> {
        java.util.List<java.lang.String> allowlist;
        java.util.List<java.lang.String> denylist;
        java.util.List<java.lang.String> matchPrefixes;
        java.util.List<java.lang.String> matchSuffixes;

        /**
         * Sets the value of {@link StringConditions#getAllowlist}
         * @param allowlist Match one or more values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowlist(java.util.List<java.lang.String> allowlist) {
            this.allowlist = allowlist;
            return this;
        }

        /**
         * Sets the value of {@link StringConditions#getDenylist}
         * @param denylist Match any value that doesn't include any of the specified values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder denylist(java.util.List<java.lang.String> denylist) {
            this.denylist = denylist;
            return this;
        }

        /**
         * Sets the value of {@link StringConditions#getMatchPrefixes}
         * @param matchPrefixes Matches values that begins with the specified prefixes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchPrefixes(java.util.List<java.lang.String> matchPrefixes) {
            this.matchPrefixes = matchPrefixes;
            return this;
        }

        /**
         * Sets the value of {@link StringConditions#getMatchSuffixes}
         * @param matchSuffixes Matches values that end with the specified suffixes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchSuffixes(java.util.List<java.lang.String> matchSuffixes) {
            this.matchSuffixes = matchSuffixes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StringConditions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StringConditions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StringConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringConditions {
        private final java.util.List<java.lang.String> allowlist;
        private final java.util.List<java.lang.String> denylist;
        private final java.util.List<java.lang.String> matchPrefixes;
        private final java.util.List<java.lang.String> matchSuffixes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowlist = software.amazon.jsii.Kernel.get(this, "allowlist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.denylist = software.amazon.jsii.Kernel.get(this, "denylist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.matchPrefixes = software.amazon.jsii.Kernel.get(this, "matchPrefixes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.matchSuffixes = software.amazon.jsii.Kernel.get(this, "matchSuffixes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowlist = builder.allowlist;
            this.denylist = builder.denylist;
            this.matchPrefixes = builder.matchPrefixes;
            this.matchSuffixes = builder.matchSuffixes;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowlist() {
            return this.allowlist;
        }

        @Override
        public final java.util.List<java.lang.String> getDenylist() {
            return this.denylist;
        }

        @Override
        public final java.util.List<java.lang.String> getMatchPrefixes() {
            return this.matchPrefixes;
        }

        @Override
        public final java.util.List<java.lang.String> getMatchSuffixes() {
            return this.matchSuffixes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowlist() != null) {
                data.set("allowlist", om.valueToTree(this.getAllowlist()));
            }
            if (this.getDenylist() != null) {
                data.set("denylist", om.valueToTree(this.getDenylist()));
            }
            if (this.getMatchPrefixes() != null) {
                data.set("matchPrefixes", om.valueToTree(this.getMatchPrefixes()));
            }
            if (this.getMatchSuffixes() != null) {
                data.set("matchSuffixes", om.valueToTree(this.getMatchSuffixes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.StringConditions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StringConditions.Jsii$Proxy that = (StringConditions.Jsii$Proxy) o;

            if (this.allowlist != null ? !this.allowlist.equals(that.allowlist) : that.allowlist != null) return false;
            if (this.denylist != null ? !this.denylist.equals(that.denylist) : that.denylist != null) return false;
            if (this.matchPrefixes != null ? !this.matchPrefixes.equals(that.matchPrefixes) : that.matchPrefixes != null) return false;
            return this.matchSuffixes != null ? this.matchSuffixes.equals(that.matchSuffixes) : that.matchSuffixes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowlist != null ? this.allowlist.hashCode() : 0;
            result = 31 * result + (this.denylist != null ? this.denylist.hashCode() : 0);
            result = 31 * result + (this.matchPrefixes != null ? this.matchPrefixes.hashCode() : 0);
            result = 31 * result + (this.matchSuffixes != null ? this.matchSuffixes.hashCode() : 0);
            return result;
        }
    }
}
