package software.amazon.awscdk.services.sns;

/**
 * Properties for creating a new subscription.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.alpha.DeliveryStream;
 * DeliveryStream stream;
 * Topic topic = new Topic(this, "Topic");
 * Subscription.Builder.create(this, "Subscription")
 *         .topic(topic)
 *         .endpoint(stream.getDeliveryStreamArn())
 *         .protocol(SubscriptionProtocol.FIREHOSE)
 *         .subscriptionRoleArn("SAMPLE_ARN")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:41.815Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.SubscriptionProps")
@software.amazon.jsii.Jsii.Proxy(SubscriptionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubscriptionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.sns.SubscriptionOptions {

    /**
     * The topic to subscribe to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic getTopic();

    /**
     * @return a {@link Builder} of {@link SubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubscriptionProps> {
        software.amazon.awscdk.services.sns.ITopic topic;
        java.lang.String endpoint;
        software.amazon.awscdk.services.sns.SubscriptionProtocol protocol;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        software.amazon.awscdk.services.sns.DeliveryPolicy deliveryPolicy;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.FilterOrPolicy> filterPolicyWithMessageBody;
        java.lang.Boolean rawMessageDelivery;
        java.lang.String region;
        java.lang.String subscriptionRoleArn;

        /**
         * Sets the value of {@link SubscriptionProps#getTopic}
         * @param topic The topic to subscribe to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionProps#getEndpoint}
         * @param endpoint The subscription endpoint. This parameter is required.
         *                 The meaning of this value depends on the value for 'protocol'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(java.lang.String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionProps#getProtocol}
         * @param protocol What type of subscription to add. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.sns.SubscriptionProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionProps#getDeadLetterQueue}
         * @param deadLetterQueue Queue to be used as dead letter queue.
         *                        If not passed no dead letter queue is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionProps#getDeliveryPolicy}
         * @param deliveryPolicy The delivery policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryPolicy(software.amazon.awscdk.services.sns.DeliveryPolicy deliveryPolicy) {
            this.deliveryPolicy = deliveryPolicy;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionProps#getFilterPolicy}
         * @param filterPolicy The filter policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder filterPolicy(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.filterPolicy = (java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter>)filterPolicy;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionProps#getFilterPolicyWithMessageBody}
         * @param filterPolicyWithMessageBody The filter policy that is applied on the message body.
         *                                    To apply a filter policy to the message attributes, use <code>filterPolicy</code>. A maximum of one of <code>filterPolicyWithMessageBody</code> and <code>filterPolicy</code> may be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder filterPolicyWithMessageBody(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.FilterOrPolicy> filterPolicyWithMessageBody) {
            this.filterPolicyWithMessageBody = (java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.FilterOrPolicy>)filterPolicyWithMessageBody;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionProps#getRawMessageDelivery}
         * @param rawMessageDelivery true if raw message delivery is enabled for the subscription.
         *                           Raw messages are free of JSON formatting and can be
         *                           sent to HTTP/S and Amazon SQS endpoints. For more information, see GetSubscriptionAttributes in the Amazon Simple
         *                           Notification Service API Reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(java.lang.Boolean rawMessageDelivery) {
            this.rawMessageDelivery = rawMessageDelivery;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionProps#getRegion}
         * @param region The region where the topic resides, in the case of cross-region subscriptions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionProps#getSubscriptionRoleArn}
         * @param subscriptionRoleArn Arn of role allowing access to firehose delivery stream.
         *                            Required for a firehose subscription protocol.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionRoleArn(java.lang.String subscriptionRoleArn) {
            this.subscriptionRoleArn = subscriptionRoleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubscriptionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubscriptionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubscriptionProps {
        private final software.amazon.awscdk.services.sns.ITopic topic;
        private final java.lang.String endpoint;
        private final software.amazon.awscdk.services.sns.SubscriptionProtocol protocol;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final software.amazon.awscdk.services.sns.DeliveryPolicy deliveryPolicy;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.FilterOrPolicy> filterPolicyWithMessageBody;
        private final java.lang.Boolean rawMessageDelivery;
        private final java.lang.String region;
        private final java.lang.String subscriptionRoleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.SubscriptionProtocol.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.deliveryPolicy = software.amazon.jsii.Kernel.get(this, "deliveryPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.DeliveryPolicy.class));
            this.filterPolicy = software.amazon.jsii.Kernel.get(this, "filterPolicy", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.SubscriptionFilter.class)));
            this.filterPolicyWithMessageBody = software.amazon.jsii.Kernel.get(this, "filterPolicyWithMessageBody", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.FilterOrPolicy.class)));
            this.rawMessageDelivery = software.amazon.jsii.Kernel.get(this, "rawMessageDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscriptionRoleArn = software.amazon.jsii.Kernel.get(this, "subscriptionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.topic = java.util.Objects.requireNonNull(builder.topic, "topic is required");
            this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
            this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
            this.deadLetterQueue = builder.deadLetterQueue;
            this.deliveryPolicy = builder.deliveryPolicy;
            this.filterPolicy = (java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter>)builder.filterPolicy;
            this.filterPolicyWithMessageBody = (java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.FilterOrPolicy>)builder.filterPolicyWithMessageBody;
            this.rawMessageDelivery = builder.rawMessageDelivery;
            this.region = builder.region;
            this.subscriptionRoleArn = builder.subscriptionRoleArn;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getTopic() {
            return this.topic;
        }

        @Override
        public final java.lang.String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final software.amazon.awscdk.services.sns.SubscriptionProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final software.amazon.awscdk.services.sns.DeliveryPolicy getDeliveryPolicy() {
            return this.deliveryPolicy;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> getFilterPolicy() {
            return this.filterPolicy;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.FilterOrPolicy> getFilterPolicyWithMessageBody() {
            return this.filterPolicyWithMessageBody;
        }

        @Override
        public final java.lang.Boolean getRawMessageDelivery() {
            return this.rawMessageDelivery;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getSubscriptionRoleArn() {
            return this.subscriptionRoleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("topic", om.valueToTree(this.getTopic()));
            data.set("endpoint", om.valueToTree(this.getEndpoint()));
            data.set("protocol", om.valueToTree(this.getProtocol()));
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getDeliveryPolicy() != null) {
                data.set("deliveryPolicy", om.valueToTree(this.getDeliveryPolicy()));
            }
            if (this.getFilterPolicy() != null) {
                data.set("filterPolicy", om.valueToTree(this.getFilterPolicy()));
            }
            if (this.getFilterPolicyWithMessageBody() != null) {
                data.set("filterPolicyWithMessageBody", om.valueToTree(this.getFilterPolicyWithMessageBody()));
            }
            if (this.getRawMessageDelivery() != null) {
                data.set("rawMessageDelivery", om.valueToTree(this.getRawMessageDelivery()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getSubscriptionRoleArn() != null) {
                data.set("subscriptionRoleArn", om.valueToTree(this.getSubscriptionRoleArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.SubscriptionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubscriptionProps.Jsii$Proxy that = (SubscriptionProps.Jsii$Proxy) o;

            if (!topic.equals(that.topic)) return false;
            if (!endpoint.equals(that.endpoint)) return false;
            if (!protocol.equals(that.protocol)) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.deliveryPolicy != null ? !this.deliveryPolicy.equals(that.deliveryPolicy) : that.deliveryPolicy != null) return false;
            if (this.filterPolicy != null ? !this.filterPolicy.equals(that.filterPolicy) : that.filterPolicy != null) return false;
            if (this.filterPolicyWithMessageBody != null ? !this.filterPolicyWithMessageBody.equals(that.filterPolicyWithMessageBody) : that.filterPolicyWithMessageBody != null) return false;
            if (this.rawMessageDelivery != null ? !this.rawMessageDelivery.equals(that.rawMessageDelivery) : that.rawMessageDelivery != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            return this.subscriptionRoleArn != null ? this.subscriptionRoleArn.equals(that.subscriptionRoleArn) : that.subscriptionRoleArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.topic.hashCode();
            result = 31 * result + (this.endpoint.hashCode());
            result = 31 * result + (this.protocol.hashCode());
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.deliveryPolicy != null ? this.deliveryPolicy.hashCode() : 0);
            result = 31 * result + (this.filterPolicy != null ? this.filterPolicy.hashCode() : 0);
            result = 31 * result + (this.filterPolicyWithMessageBody != null ? this.filterPolicyWithMessageBody.hashCode() : 0);
            result = 31 * result + (this.rawMessageDelivery != null ? this.rawMessageDelivery.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.subscriptionRoleArn != null ? this.subscriptionRoleArn.hashCode() : 0);
            return result;
        }
    }
}
