package software.amazon.awscdk.services.stepfunctions;

/**
 * Configuration for processing a group of items in a single child workflow execution.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object batchInput;
 * ItemBatcher itemBatcher = ItemBatcher.Builder.create()
 *         .batchInput(batchInput)
 *         .maxInputBytesPerBatch(123)
 *         .maxInputBytesPerBatchPath("maxInputBytesPerBatchPath")
 *         .maxItemsPerBatch(123)
 *         .maxItemsPerBatchPath("maxItemsPerBatchPath")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:42.085Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ItemBatcher")
public class ItemBatcher extends software.amazon.jsii.JsiiObject {

    protected ItemBatcher(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ItemBatcher(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ItemBatcher(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.ItemBatcherProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Render ItemBatcher in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object render() {
        return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Validate this ItemBatcher.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateItemBatcher() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateItemBatcher", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.ItemBatcher}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.ItemBatcher> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.ItemBatcherProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.stepfunctions.ItemBatcherProps.Builder();
        }

        /**
         * BatchInput.
         * <p>
         * Fixed JSON input to include in each batch passed to each child workflow execution
         * <p>
         * Default: - No batchInput
         * <p>
         * @return {@code this}
         * @param batchInput BatchInput. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchInput(final com.fasterxml.jackson.databind.node.ObjectNode batchInput) {
            this.props.batchInput(batchInput);
            return this;
        }

        /**
         * MaxInputBytesPerBatch.
         * <p>
         * Specifies the maximum number of bytes that each child workflow execution processes, as static number
         * <p>
         * Default: - uses value of `maxInputBytesPerBatchPath` as the max size per batch,
         * no limits on the batch size under the 256KB limit if that property was also not provided
         * <p>
         * @return {@code this}
         * @param maxInputBytesPerBatch MaxInputBytesPerBatch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInputBytesPerBatch(final java.lang.Number maxInputBytesPerBatch) {
            this.props.maxInputBytesPerBatch(maxInputBytesPerBatch);
            return this;
        }

        /**
         * MaxInputBytesPerBatchPath.
         * <p>
         * Specifies the maximum number of bytes that each child workflow execution processes, as JsonPath
         * <p>
         * Default: - uses value of `maxInputBytesPerBatch` as the max size per batch,
         * no limits on the batch size under the 256KB limit if that property was also not provided
         * <p>
         * @return {@code this}
         * @param maxInputBytesPerBatchPath MaxInputBytesPerBatchPath. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInputBytesPerBatchPath(final java.lang.String maxInputBytesPerBatchPath) {
            this.props.maxInputBytesPerBatchPath(maxInputBytesPerBatchPath);
            return this;
        }

        /**
         * MaxItemsPerBatch.
         * <p>
         * Specifies the maximum number of items that each child workflow execution processes, as static number
         * <p>
         * Default: - uses value of `maxItemsPerBatchPath` as the max items per batch,
         * no limits on the number of items in a batch under the 256KB limit if that property was also not provided
         * <p>
         * @return {@code this}
         * @param maxItemsPerBatch MaxItemsPerBatch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxItemsPerBatch(final java.lang.Number maxItemsPerBatch) {
            this.props.maxItemsPerBatch(maxItemsPerBatch);
            return this;
        }

        /**
         * MaxItemsPerBatchPath.
         * <p>
         * Specifies the maximum number of items that each child workflow execution processes, as JsonPath
         * <p>
         * Default: - uses value of `maxItemsPerBatch` as the max items per batch,
         * no limits on the number of items in a batch under the 256KB limit if that property was also not provided
         * <p>
         * @return {@code this}
         * @param maxItemsPerBatchPath MaxItemsPerBatchPath. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxItemsPerBatchPath(final java.lang.String maxItemsPerBatchPath) {
            this.props.maxItemsPerBatchPath(maxItemsPerBatchPath);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.ItemBatcher}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.ItemBatcher build() {
            return new software.amazon.awscdk.services.stepfunctions.ItemBatcher(
                this.props.build()
            );
        }
    }
}
