package software.amazon.awscdk.services.stepfunctions;

/**
 * Execution type for the Map workflow.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Map map = Map.Builder.create(this, "Map State")
 *         .maxConcurrency(1)
 *         .itemsPath(JsonPath.stringAt("$.inputForMap"))
 *         .itemSelector(Map.of(
 *                 "item", JsonPath.stringAt("$.Map.Item.Value")))
 *         .resultPath("$.mapOutput")
 *         .build();
 * map.itemProcessor(new Pass(this, "Pass State"), ProcessorConfig.builder()
 *         .mode(ProcessorMode.DISTRIBUTED)
 *         .executionType(ProcessorType.STANDARD)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:42.118Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ProcessorType")
public enum ProcessorType {
    /**
     * Standard execution type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Express execution type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXPRESS,
}
