package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for starting a Query Execution.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AthenaStartQueryExecution startQueryExecutionJob = AthenaStartQueryExecution.Builder.create(this, "Start Athena Query")
 *         .queryString(JsonPath.stringAt("$.queryString"))
 *         .queryExecutionContext(QueryExecutionContext.builder()
 *                 .databaseName("mydatabase")
 *                 .build())
 *         .resultConfiguration(ResultConfiguration.builder()
 *                 .encryptionConfiguration(EncryptionConfiguration.builder()
 *                         .encryptionOption(EncryptionOption.S3_MANAGED)
 *                         .build())
 *                 .outputLocation(Location.builder()
 *                         .bucketName("amzn-s3-demo-bucket")
 *                         .objectKey("folder")
 *                         .build())
 *                 .build())
 *         .executionParameters(List.of("param1", "param2"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:42.211Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.AthenaStartQueryExecutionProps")
@software.amazon.jsii.Jsii.Proxy(AthenaStartQueryExecutionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AthenaStartQueryExecutionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * Query that will be started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueryString();

    /**
     * Unique string string to ensure idempotence.
     * <p>
     * Default: - No client request token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientRequestToken() {
        return null;
    }

    /**
     * A list of values for the parameters in a query.
     * <p>
     * The values are applied sequentially to the parameters in the query in the order
     * in which the parameters occur.
     * <p>
     * Default: - No parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExecutionParameters() {
        return null;
    }

    /**
     * Database within which query executes.
     * <p>
     * Default: - No query execution context
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.QueryExecutionContext getQueryExecutionContext() {
        return null;
    }

    /**
     * Configuration on how and where to save query.
     * <p>
     * Default: - No result configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.ResultConfiguration getResultConfiguration() {
        return null;
    }

    /**
     * Specifies, in minutes, the maximum age of a previous query result that Athena should consider for reuse.
     * <p>
     * Default: - Query results are not reused
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getResultReuseConfigurationMaxAge() {
        return null;
    }

    /**
     * Configuration on how and where to save query.
     * <p>
     * Default: - No work group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AthenaStartQueryExecutionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AthenaStartQueryExecutionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AthenaStartQueryExecutionProps> {
        java.lang.String queryString;
        java.lang.String clientRequestToken;
        java.util.List<java.lang.String> executionParameters;
        software.amazon.awscdk.services.stepfunctions.tasks.QueryExecutionContext queryExecutionContext;
        software.amazon.awscdk.services.stepfunctions.tasks.ResultConfiguration resultConfiguration;
        software.amazon.awscdk.Duration resultReuseConfigurationMaxAge;
        java.lang.String workGroup;
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        software.amazon.awscdk.Duration heartbeat;
        software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        software.amazon.awscdk.Duration timeout;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        java.lang.String inputPath;
        java.lang.String outputPath;
        java.lang.Object outputs;

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getQueryString}
         * @param queryString Query that will be started. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryString(java.lang.String queryString) {
            this.queryString = queryString;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getClientRequestToken}
         * @param clientRequestToken Unique string string to ensure idempotence.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientRequestToken(java.lang.String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getExecutionParameters}
         * @param executionParameters A list of values for the parameters in a query.
         *                            The values are applied sequentially to the parameters in the query in the order
         *                            in which the parameters occur.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionParameters(java.util.List<java.lang.String> executionParameters) {
            this.executionParameters = executionParameters;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getQueryExecutionContext}
         * @param queryExecutionContext Database within which query executes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryExecutionContext(software.amazon.awscdk.services.stepfunctions.tasks.QueryExecutionContext queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getResultConfiguration}
         * @param resultConfiguration Configuration on how and where to save query.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultConfiguration(software.amazon.awscdk.services.stepfunctions.tasks.ResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getResultReuseConfigurationMaxAge}
         * @param resultReuseConfigurationMaxAge Specifies, in minutes, the maximum age of a previous query result that Athena should consider for reuse.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultReuseConfigurationMaxAge(software.amazon.awscdk.Duration resultReuseConfigurationMaxAge) {
            this.resultReuseConfigurationMaxAge = resultReuseConfigurationMaxAge;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getWorkGroup}
         * @param workGroup Configuration on how and where to save query.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workGroup(java.lang.String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getCredentials}
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task.
         *                    This enables cross-account resource invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         * @deprecated use `heartbeatTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Timeout for the heartbeat.
         *                         [disable-awslint:duration-prop-type] is needed because all props interface in
         *                         aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns.
         *                           <p>
         *                           Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getTaskTimeout}
         * @param taskTimeout Timeout for the task.
         *                    [disable-awslint:duration-prop-type] is needed because all props interface in
         *                    aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getTimeout}
         * @param timeout Timeout for the task.
         * @return {@code this}
         * @deprecated use `taskTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getOutputPath}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link AthenaStartQueryExecutionProps#getOutputs}
         * @param outputs Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AthenaStartQueryExecutionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AthenaStartQueryExecutionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AthenaStartQueryExecutionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AthenaStartQueryExecutionProps {
        private final java.lang.String queryString;
        private final java.lang.String clientRequestToken;
        private final java.util.List<java.lang.String> executionParameters;
        private final software.amazon.awscdk.services.stepfunctions.tasks.QueryExecutionContext queryExecutionContext;
        private final software.amazon.awscdk.services.stepfunctions.tasks.ResultConfiguration resultConfiguration;
        private final software.amazon.awscdk.Duration resultReuseConfigurationMaxAge;
        private final java.lang.String workGroup;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        private final software.amazon.awscdk.Duration heartbeat;
        private final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final java.lang.String inputPath;
        private final java.lang.String outputPath;
        private final java.lang.Object outputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientRequestToken = software.amazon.jsii.Kernel.get(this, "clientRequestToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionParameters = software.amazon.jsii.Kernel.get(this, "executionParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.queryExecutionContext = software.amazon.jsii.Kernel.get(this, "queryExecutionContext", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.QueryExecutionContext.class));
            this.resultConfiguration = software.amazon.jsii.Kernel.get(this, "resultConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ResultConfiguration.class));
            this.resultReuseConfigurationMaxAge = software.amazon.jsii.Kernel.get(this, "resultReuseConfigurationMaxAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.workGroup = software.amazon.jsii.Kernel.get(this, "workGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Credentials.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.heartbeatTimeout = software.amazon.jsii.Kernel.get(this, "heartbeatTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.taskTimeout = software.amazon.jsii.Kernel.get(this, "taskTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.queryString = java.util.Objects.requireNonNull(builder.queryString, "queryString is required");
            this.clientRequestToken = builder.clientRequestToken;
            this.executionParameters = builder.executionParameters;
            this.queryExecutionContext = builder.queryExecutionContext;
            this.resultConfiguration = builder.resultConfiguration;
            this.resultReuseConfigurationMaxAge = builder.resultReuseConfigurationMaxAge;
            this.workGroup = builder.workGroup;
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.credentials = builder.credentials;
            this.heartbeat = builder.heartbeat;
            this.heartbeatTimeout = builder.heartbeatTimeout;
            this.integrationPattern = builder.integrationPattern;
            this.taskTimeout = builder.taskTimeout;
            this.timeout = builder.timeout;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.inputPath = builder.inputPath;
            this.outputPath = builder.outputPath;
            this.outputs = builder.outputs;
        }

        @Override
        public final java.lang.String getQueryString() {
            return this.queryString;
        }

        @Override
        public final java.lang.String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final java.util.List<java.lang.String> getExecutionParameters() {
            return this.executionParameters;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.QueryExecutionContext getQueryExecutionContext() {
            return this.queryExecutionContext;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.ResultConfiguration getResultConfiguration() {
            return this.resultConfiguration;
        }

        @Override
        public final software.amazon.awscdk.Duration getResultReuseConfigurationMaxAge() {
            return this.resultReuseConfigurationMaxAge;
        }

        @Override
        public final java.lang.String getWorkGroup() {
            return this.workGroup;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getTaskTimeout() {
            return this.taskTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("queryString", om.valueToTree(this.getQueryString()));
            if (this.getClientRequestToken() != null) {
                data.set("clientRequestToken", om.valueToTree(this.getClientRequestToken()));
            }
            if (this.getExecutionParameters() != null) {
                data.set("executionParameters", om.valueToTree(this.getExecutionParameters()));
            }
            if (this.getQueryExecutionContext() != null) {
                data.set("queryExecutionContext", om.valueToTree(this.getQueryExecutionContext()));
            }
            if (this.getResultConfiguration() != null) {
                data.set("resultConfiguration", om.valueToTree(this.getResultConfiguration()));
            }
            if (this.getResultReuseConfigurationMaxAge() != null) {
                data.set("resultReuseConfigurationMaxAge", om.valueToTree(this.getResultReuseConfigurationMaxAge()));
            }
            if (this.getWorkGroup() != null) {
                data.set("workGroup", om.valueToTree(this.getWorkGroup()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getTaskTimeout() != null) {
                data.set("taskTimeout", om.valueToTree(this.getTaskTimeout()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.AthenaStartQueryExecutionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AthenaStartQueryExecutionProps.Jsii$Proxy that = (AthenaStartQueryExecutionProps.Jsii$Proxy) o;

            if (!queryString.equals(that.queryString)) return false;
            if (this.clientRequestToken != null ? !this.clientRequestToken.equals(that.clientRequestToken) : that.clientRequestToken != null) return false;
            if (this.executionParameters != null ? !this.executionParameters.equals(that.executionParameters) : that.executionParameters != null) return false;
            if (this.queryExecutionContext != null ? !this.queryExecutionContext.equals(that.queryExecutionContext) : that.queryExecutionContext != null) return false;
            if (this.resultConfiguration != null ? !this.resultConfiguration.equals(that.resultConfiguration) : that.resultConfiguration != null) return false;
            if (this.resultReuseConfigurationMaxAge != null ? !this.resultReuseConfigurationMaxAge.equals(that.resultReuseConfigurationMaxAge) : that.resultReuseConfigurationMaxAge != null) return false;
            if (this.workGroup != null ? !this.workGroup.equals(that.workGroup) : that.workGroup != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.taskTimeout != null ? !this.taskTimeout.equals(that.taskTimeout) : that.taskTimeout != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.queryString.hashCode();
            result = 31 * result + (this.clientRequestToken != null ? this.clientRequestToken.hashCode() : 0);
            result = 31 * result + (this.executionParameters != null ? this.executionParameters.hashCode() : 0);
            result = 31 * result + (this.queryExecutionContext != null ? this.queryExecutionContext.hashCode() : 0);
            result = 31 * result + (this.resultConfiguration != null ? this.resultConfiguration.hashCode() : 0);
            result = 31 * result + (this.resultReuseConfigurationMaxAge != null ? this.resultReuseConfigurationMaxAge.hashCode() : 0);
            result = 31 * result + (this.workGroup != null ? this.workGroup.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.taskTimeout != null ? this.taskTimeout.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            return result;
        }
    }
}
