package software.amazon.awscdk.services.wisdom;

/**
 * Properties for defining a <code>CfnAIAgentVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnAIAgentVersionProps cfnAIAgentVersionProps = CfnAIAgentVersionProps.builder()
 *         .aiAgentId("aiAgentId")
 *         .assistantId("assistantId")
 *         // the properties below are optional
 *         .modifiedTimeSeconds(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagentversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagentversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:43.112Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgentVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnAIAgentVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAIAgentVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the AI Agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagentversion.html#cfn-wisdom-aiagentversion-aiagentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagentversion.html#cfn-wisdom-aiagentversion-aiagentid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAiAgentId();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagentversion.html#cfn-wisdom-aiagentversion-assistantid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagentversion.html#cfn-wisdom-aiagentversion-assistantid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantId();

    /**
     * The time the AI Agent version was last modified in seconds.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagentversion.html#cfn-wisdom-aiagentversion-modifiedtimeseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagentversion.html#cfn-wisdom-aiagentversion-modifiedtimeseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getModifiedTimeSeconds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAIAgentVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAIAgentVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAIAgentVersionProps> {
        java.lang.String aiAgentId;
        java.lang.String assistantId;
        java.lang.Number modifiedTimeSeconds;

        /**
         * Sets the value of {@link CfnAIAgentVersionProps#getAiAgentId}
         * @param aiAgentId The identifier of the AI Agent. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aiAgentId(java.lang.String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIAgentVersionProps#getAssistantId}
         * @param assistantId the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(java.lang.String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIAgentVersionProps#getModifiedTimeSeconds}
         * @param modifiedTimeSeconds The time the AI Agent version was last modified in seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modifiedTimeSeconds(java.lang.Number modifiedTimeSeconds) {
            this.modifiedTimeSeconds = modifiedTimeSeconds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAIAgentVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAIAgentVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAIAgentVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAIAgentVersionProps {
        private final java.lang.String aiAgentId;
        private final java.lang.String assistantId;
        private final java.lang.Number modifiedTimeSeconds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aiAgentId = software.amazon.jsii.Kernel.get(this, "aiAgentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assistantId = software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modifiedTimeSeconds = software.amazon.jsii.Kernel.get(this, "modifiedTimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aiAgentId = java.util.Objects.requireNonNull(builder.aiAgentId, "aiAgentId is required");
            this.assistantId = java.util.Objects.requireNonNull(builder.assistantId, "assistantId is required");
            this.modifiedTimeSeconds = builder.modifiedTimeSeconds;
        }

        @Override
        public final java.lang.String getAiAgentId() {
            return this.aiAgentId;
        }

        @Override
        public final java.lang.String getAssistantId() {
            return this.assistantId;
        }

        @Override
        public final java.lang.Number getModifiedTimeSeconds() {
            return this.modifiedTimeSeconds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aiAgentId", om.valueToTree(this.getAiAgentId()));
            data.set("assistantId", om.valueToTree(this.getAssistantId()));
            if (this.getModifiedTimeSeconds() != null) {
                data.set("modifiedTimeSeconds", om.valueToTree(this.getModifiedTimeSeconds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgentVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAIAgentVersionProps.Jsii$Proxy that = (CfnAIAgentVersionProps.Jsii$Proxy) o;

            if (!aiAgentId.equals(that.aiAgentId)) return false;
            if (!assistantId.equals(that.assistantId)) return false;
            return this.modifiedTimeSeconds != null ? this.modifiedTimeSeconds.equals(that.modifiedTimeSeconds) : that.modifiedTimeSeconds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.aiAgentId.hashCode();
            result = 31 * result + (this.assistantId.hashCode());
            result = 31 * result + (this.modifiedTimeSeconds != null ? this.modifiedTimeSeconds.hashCode() : 0);
            return result;
        }
    }
}
