/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.certificatemanager.ICertificate;
import software.amazon.awscdk.services.cloudfront.AddBehaviorOptions;
import software.amazon.awscdk.services.cloudfront.BehaviorOptions;
import software.amazon.awscdk.services.cloudfront.DistributionAttributes;
import software.amazon.awscdk.services.cloudfront.DistributionProps;
import software.amazon.awscdk.services.cloudfront.ErrorResponse;
import software.amazon.awscdk.services.cloudfront.GeoRestriction;
import software.amazon.awscdk.services.cloudfront.HttpVersion;
import software.amazon.awscdk.services.cloudfront.IDistribution;
import software.amazon.awscdk.services.cloudfront.IOrigin;
import software.amazon.awscdk.services.cloudfront.PriceClass;
import software.amazon.awscdk.services.cloudfront.SSLMethod;
import software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudfront.Distribution")
public class Distribution
extends Resource
implements IDistribution {
    protected Distribution(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Distribution(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Distribution(@NotNull Construct scope, @NotNull String id, @NotNull DistributionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IDistribution fromDistributionAttributes(@NotNull Construct scope, @NotNull String id, @NotNull DistributionAttributes attrs) {
        return (IDistribution)JsiiObject.jsiiStaticCall(Distribution.class, (String)"fromDistributionAttributes", (NativeType)NativeType.forClass(IDistribution.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addBehavior(@NotNull String pathPattern, @NotNull IOrigin origin, @Nullable AddBehaviorOptions behaviorOptions) {
        Kernel.call((Object)this, (String)"addBehavior", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pathPattern, "pathPattern is required"), Objects.requireNonNull(origin, "origin is required"), behaviorOptions});
    }

    public void addBehavior(@NotNull String pathPattern, @NotNull IOrigin origin) {
        Kernel.call((Object)this, (String)"addBehavior", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pathPattern, "pathPattern is required"), Objects.requireNonNull(origin, "origin is required")});
    }

    public void attachWebAclId(@NotNull String webAclId) {
        Kernel.call((Object)this, (String)"attachWebAclId", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(webAclId, "webAclId is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable identity, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(identity, "identity is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantCreateInvalidation(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantCreateInvalidation", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @NotNull
    public Metric metric401ErrorRate(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric401ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metric401ErrorRate() {
        return (Metric)Kernel.call((Object)this, (String)"metric401ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metric403ErrorRate(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric403ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metric403ErrorRate() {
        return (Metric)Kernel.call((Object)this, (String)"metric403ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metric404ErrorRate(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric404ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metric404ErrorRate() {
        return (Metric)Kernel.call((Object)this, (String)"metric404ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metric4xxErrorRate(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric4xxErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metric4xxErrorRate() {
        return (Metric)Kernel.call((Object)this, (String)"metric4xxErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metric502ErrorRate(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric502ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metric502ErrorRate() {
        return (Metric)Kernel.call((Object)this, (String)"metric502ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metric503ErrorRate(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric503ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metric503ErrorRate() {
        return (Metric)Kernel.call((Object)this, (String)"metric503ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metric504ErrorRate(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric504ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metric504ErrorRate() {
        return (Metric)Kernel.call((Object)this, (String)"metric504ErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metric5xxErrorRate(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric5xxErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metric5xxErrorRate() {
        return (Metric)Kernel.call((Object)this, (String)"metric5xxErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metricBytesDownloaded(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricBytesDownloaded", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricBytesDownloaded() {
        return (Metric)Kernel.call((Object)this, (String)"metricBytesDownloaded", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metricBytesUploaded(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricBytesUploaded", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricBytesUploaded() {
        return (Metric)Kernel.call((Object)this, (String)"metricBytesUploaded", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metricCacheHitRate(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCacheHitRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricCacheHitRate() {
        return (Metric)Kernel.call((Object)this, (String)"metricCacheHitRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metricOriginLatency(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricOriginLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricOriginLatency() {
        return (Metric)Kernel.call((Object)this, (String)"metricOriginLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metricRequests(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricRequests", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricRequests() {
        return (Metric)Kernel.call((Object)this, (String)"metricRequests", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metricTotalErrorRate(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTotalErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricTotalErrorRate() {
        return (Metric)Kernel.call((Object)this, (String)"metricTotalErrorRate", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDistributionArn() {
        return (String)Kernel.get((Object)this, (String)"distributionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDistributionDomainName() {
        return (String)Kernel.get((Object)this, (String)"distributionDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDistributionId() {
        return (String)Kernel.get((Object)this, (String)"distributionId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getDomainName() {
        return (String)Kernel.get((Object)this, (String)"domainName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Distribution> {
        private final Construct scope;
        private final String id;
        private final DistributionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DistributionProps.Builder();
        }

        public Builder defaultBehavior(BehaviorOptions defaultBehavior) {
            this.props.defaultBehavior(defaultBehavior);
            return this;
        }

        public Builder additionalBehaviors(Map<String, ? extends BehaviorOptions> additionalBehaviors) {
            this.props.additionalBehaviors(additionalBehaviors);
            return this;
        }

        public Builder certificate(ICertificate certificate) {
            this.props.certificate(certificate);
            return this;
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder defaultRootObject(String defaultRootObject) {
            this.props.defaultRootObject(defaultRootObject);
            return this;
        }

        public Builder domainNames(List<String> domainNames) {
            this.props.domainNames(domainNames);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder enableIpv6(Boolean enableIpv6) {
            this.props.enableIpv6(enableIpv6);
            return this;
        }

        public Builder enableLogging(Boolean enableLogging) {
            this.props.enableLogging(enableLogging);
            return this;
        }

        public Builder errorResponses(List<? extends ErrorResponse> errorResponses) {
            this.props.errorResponses(errorResponses);
            return this;
        }

        public Builder geoRestriction(GeoRestriction geoRestriction) {
            this.props.geoRestriction(geoRestriction);
            return this;
        }

        public Builder httpVersion(HttpVersion httpVersion) {
            this.props.httpVersion(httpVersion);
            return this;
        }

        public Builder logBucket(IBucket logBucket) {
            this.props.logBucket(logBucket);
            return this;
        }

        public Builder logFilePrefix(String logFilePrefix) {
            this.props.logFilePrefix(logFilePrefix);
            return this;
        }

        public Builder logIncludesCookies(Boolean logIncludesCookies) {
            this.props.logIncludesCookies(logIncludesCookies);
            return this;
        }

        public Builder minimumProtocolVersion(SecurityPolicyProtocol minimumProtocolVersion) {
            this.props.minimumProtocolVersion(minimumProtocolVersion);
            return this;
        }

        public Builder priceClass(PriceClass priceClass) {
            this.props.priceClass(priceClass);
            return this;
        }

        public Builder publishAdditionalMetrics(Boolean publishAdditionalMetrics) {
            this.props.publishAdditionalMetrics(publishAdditionalMetrics);
            return this;
        }

        public Builder sslSupportMethod(SSLMethod sslSupportMethod) {
            this.props.sslSupportMethod(sslSupportMethod);
            return this;
        }

        public Builder webAclId(String webAclId) {
            this.props.webAclId(webAclId);
            return this;
        }

        public Distribution build() {
            return new Distribution(this.scope, this.id, this.props.build());
        }
    }
}

