/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.IKeyPair;
import software.amazon.awscdk.services.ec2.KeyPairAttributes;
import software.amazon.awscdk.services.ec2.KeyPairFormat;
import software.amazon.awscdk.services.ec2.KeyPairProps;
import software.amazon.awscdk.services.ec2.KeyPairType;
import software.amazon.awscdk.services.ssm.IStringParameter;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.KeyPair")
public class KeyPair
extends Resource
implements IKeyPair {
    protected KeyPair(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KeyPair(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public KeyPair(@NotNull Construct scope, @NotNull String id, @Nullable KeyPairProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public KeyPair(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IKeyPair fromKeyPairAttributes(@NotNull Construct scope, @NotNull String id, @NotNull KeyPairAttributes attrs) {
        return (IKeyPair)JsiiObject.jsiiStaticCall(KeyPair.class, (String)"fromKeyPairAttributes", (NativeType)NativeType.forClass(IKeyPair.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IKeyPair fromKeyPairName(@NotNull Construct scope, @NotNull String id, @NotNull String keyPairName) {
        return (IKeyPair)JsiiObject.jsiiStaticCall(KeyPair.class, (String)"fromKeyPairName", (NativeType)NativeType.forClass(IKeyPair.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(keyPairName, "keyPairName is required")});
    }

    @NotNull
    public KeyPairFormat getFormat() {
        return (KeyPairFormat)((Object)Kernel.get((Object)this, (String)"format", (NativeType)NativeType.forClass(KeyPairFormat.class)));
    }

    @NotNull
    public Boolean getHasImportedMaterial() {
        return (Boolean)Kernel.get((Object)this, (String)"hasImportedMaterial", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public String getKeyPairFingerprint() {
        return (String)Kernel.get((Object)this, (String)"keyPairFingerprint", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getKeyPairId() {
        return (String)Kernel.get((Object)this, (String)"keyPairId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getKeyPairName() {
        return (String)Kernel.get((Object)this, (String)"keyPairName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IStringParameter getPrivateKey() {
        return (IStringParameter)Kernel.get((Object)this, (String)"privateKey", (NativeType)NativeType.forClass(IStringParameter.class));
    }

    @Override
    @Nullable
    public KeyPairType getType() {
        return (KeyPairType)((Object)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(KeyPairType.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<KeyPair> {
        private final Construct scope;
        private final String id;
        private KeyPairProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder account(String account) {
            this.props().account(account);
            return this;
        }

        public Builder environmentFromArn(String environmentFromArn) {
            this.props().environmentFromArn(environmentFromArn);
            return this;
        }

        public Builder physicalName(String physicalName) {
            this.props().physicalName(physicalName);
            return this;
        }

        public Builder region(String region) {
            this.props().region(region);
            return this;
        }

        public Builder format(KeyPairFormat format) {
            this.props().format(format);
            return this;
        }

        public Builder keyPairName(String keyPairName) {
            this.props().keyPairName(keyPairName);
            return this;
        }

        public Builder publicKeyMaterial(String publicKeyMaterial) {
            this.props().publicKeyMaterial(publicKeyMaterial);
            return this;
        }

        public Builder type(KeyPairType type) {
            this.props().type(type);
            return this;
        }

        public KeyPair build() {
            return new KeyPair(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private KeyPairProps.Builder props() {
            if (this.props == null) {
                this.props = new KeyPairProps.Builder();
            }
            return this.props;
        }
    }
}

