/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.events.IRule;
import software.amazon.awscdk.services.events.IRuleTarget;
import software.amazon.awscdk.services.events.RuleTargetConfig;
import software.amazon.awscdk.services.events.RuleTargetInput;
import software.amazon.awscdk.services.events.targets.RedshiftQueryProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_events_targets.RedshiftQuery")
public class RedshiftQuery
extends JsiiObject
implements IRuleTarget {
    protected RedshiftQuery(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RedshiftQuery(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public RedshiftQuery(@NotNull String clusterArn, @NotNull RedshiftQueryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(clusterArn, "clusterArn is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule rule, @Nullable String _id) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required"), _id});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule rule) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<RedshiftQuery> {
        private final String clusterArn;
        private final RedshiftQueryProps.Builder props;

        public static Builder create(String clusterArn) {
            return new Builder(clusterArn);
        }

        private Builder(String clusterArn) {
            this.clusterArn = clusterArn;
            this.props = new RedshiftQueryProps.Builder();
        }

        public Builder database(String database) {
            this.props.database(database);
            return this;
        }

        public Builder sql(List<String> sql) {
            this.props.sql(sql);
            return this;
        }

        public Builder dbUser(String dbUser) {
            this.props.dbUser(dbUser);
            return this;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder input(RuleTargetInput input) {
            this.props.input(input);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder secret(ISecret secret) {
            this.props.secret(secret);
            return this;
        }

        public Builder sendEventBridgeEvent(Boolean sendEventBridgeEvent) {
            this.props.sendEventBridgeEvent(sendEventBridgeEvent);
            return this;
        }

        public Builder statementName(String statementName) {
            this.props.statementName(statementName);
            return this;
        }

        public RedshiftQuery build() {
            return new RedshiftQuery(this.clusterArn, this.props.build());
        }
    }
}

