/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.guardduty;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.guardduty.CfnPublishingDestination;
import software.amazon.awscdk.services.guardduty.CfnPublishingDestinationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_guardduty.CfnPublishingDestination")
public class CfnPublishingDestination
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnPublishingDestination.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnPublishingDestination(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPublishingDestination(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnPublishingDestination(@NotNull Construct scope, @NotNull String id, @NotNull CfnPublishingDestinationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrPublishingFailureStartTimestamp() {
        return (String)Kernel.get((Object)this, (String)"attrPublishingFailureStartTimestamp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getDestinationProperties() {
        return Kernel.get((Object)this, (String)"destinationProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDestinationProperties(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"destinationProperties", (Object)Objects.requireNonNull(value, "destinationProperties is required"));
    }

    public void setDestinationProperties(@NotNull CFNDestinationPropertiesProperty value) {
        Kernel.set((Object)this, (String)"destinationProperties", (Object)Objects.requireNonNull(value, "destinationProperties is required"));
    }

    @NotNull
    public String getDestinationType() {
        return (String)Kernel.get((Object)this, (String)"destinationType", (NativeType)NativeType.forClass(String.class));
    }

    public void setDestinationType(@NotNull String value) {
        Kernel.set((Object)this, (String)"destinationType", (Object)Objects.requireNonNull(value, "destinationType is required"));
    }

    @NotNull
    public String getDetectorId() {
        return (String)Kernel.get((Object)this, (String)"detectorId", (NativeType)NativeType.forClass(String.class));
    }

    public void setDetectorId(@NotNull String value) {
        Kernel.set((Object)this, (String)"detectorId", (Object)Objects.requireNonNull(value, "detectorId is required"));
    }

    @Nullable
    public List<TagItemProperty> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(TagItemProperty.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<TagItemProperty> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_guardduty.CfnPublishingDestination.TagItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagItemProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagItemProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnPublishingDestination> {
        private final Construct scope;
        private final String id;
        private final CfnPublishingDestinationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnPublishingDestinationProps.Builder();
        }

        public Builder destinationProperties(IResolvable destinationProperties) {
            this.props.destinationProperties(destinationProperties);
            return this;
        }

        public Builder destinationProperties(CFNDestinationPropertiesProperty destinationProperties) {
            this.props.destinationProperties(destinationProperties);
            return this;
        }

        public Builder destinationType(String destinationType) {
            this.props.destinationType(destinationType);
            return this;
        }

        public Builder detectorId(String detectorId) {
            this.props.detectorId(detectorId);
            return this;
        }

        public Builder tags(List<? extends TagItemProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnPublishingDestination build() {
            return new CfnPublishingDestination(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_guardduty.CfnPublishingDestination.CFNDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CFNDestinationPropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDestinationArn() {
            return null;
        }

        @Nullable
        default public String getKmsKeyArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CFNDestinationPropertiesProperty> {
            String destinationArn;
            String kmsKeyArn;

            public Builder destinationArn(String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            public Builder kmsKeyArn(String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            public CFNDestinationPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

