/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.pcs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.pcs.CfnCluster;
import software.amazon.awscdk.services.pcs.CfnClusterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcs.CfnCluster")
public class CfnCluster
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id, @NotNull CfnClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrEndpoints() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrEndpoints", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public IResolvable getAttrErrorInfo() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrErrorInfo", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getNetworking() {
        return Kernel.get((Object)this, (String)"networking", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNetworking(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"networking", (Object)Objects.requireNonNull(value, "networking is required"));
    }

    public void setNetworking(@NotNull NetworkingProperty value) {
        Kernel.set((Object)this, (String)"networking", (Object)Objects.requireNonNull(value, "networking is required"));
    }

    @NotNull
    public Object getScheduler() {
        return Kernel.get((Object)this, (String)"scheduler", (NativeType)NativeType.forClass(Object.class));
    }

    public void setScheduler(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"scheduler", (Object)Objects.requireNonNull(value, "scheduler is required"));
    }

    public void setScheduler(@NotNull SchedulerProperty value) {
        Kernel.set((Object)this, (String)"scheduler", (Object)Objects.requireNonNull(value, "scheduler is required"));
    }

    @NotNull
    public String getSize() {
        return (String)Kernel.get((Object)this, (String)"size", (NativeType)NativeType.forClass(String.class));
    }

    public void setSize(@NotNull String value) {
        Kernel.set((Object)this, (String)"size", (Object)Objects.requireNonNull(value, "size is required"));
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Object getSlurmConfiguration() {
        return Kernel.get((Object)this, (String)"slurmConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSlurmConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"slurmConfiguration", (Object)value);
    }

    public void setSlurmConfiguration(@Nullable SlurmConfigurationProperty value) {
        Kernel.set((Object)this, (String)"slurmConfiguration", (Object)value);
    }

    @Nullable
    public Map<String, String> getTags() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTags(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCluster> {
        private final Construct scope;
        private final String id;
        private final CfnClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnClusterProps.Builder();
        }

        public Builder networking(IResolvable networking) {
            this.props.networking(networking);
            return this;
        }

        public Builder networking(NetworkingProperty networking) {
            this.props.networking(networking);
            return this;
        }

        public Builder scheduler(IResolvable scheduler) {
            this.props.scheduler(scheduler);
            return this;
        }

        public Builder scheduler(SchedulerProperty scheduler) {
            this.props.scheduler(scheduler);
            return this;
        }

        public Builder size(String size) {
            this.props.size(size);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder slurmConfiguration(IResolvable slurmConfiguration) {
            this.props.slurmConfiguration(slurmConfiguration);
            return this;
        }

        public Builder slurmConfiguration(SlurmConfigurationProperty slurmConfiguration) {
            this.props.slurmConfiguration(slurmConfiguration);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnCluster build() {
            return new CfnCluster(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcs.CfnCluster.SlurmCustomSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlurmCustomSettingProperty
    extends JsiiSerializable {
        @NotNull
        public String getParameterName();

        @NotNull
        public String getParameterValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlurmCustomSettingProperty> {
            String parameterName;
            String parameterValue;

            public Builder parameterName(String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            public Builder parameterValue(String parameterValue) {
                this.parameterValue = parameterValue;
                return this;
            }

            public SlurmCustomSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcs.CfnCluster.SlurmConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SlurmConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAuthKey() {
            return null;
        }

        @Nullable
        default public Number getScaleDownIdleTimeInSeconds() {
            return null;
        }

        @Nullable
        default public Object getSlurmCustomSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SlurmConfigurationProperty> {
            Object authKey;
            Number scaleDownIdleTimeInSeconds;
            Object slurmCustomSettings;

            public Builder authKey(IResolvable authKey) {
                this.authKey = authKey;
                return this;
            }

            public Builder authKey(AuthKeyProperty authKey) {
                this.authKey = authKey;
                return this;
            }

            public Builder scaleDownIdleTimeInSeconds(Number scaleDownIdleTimeInSeconds) {
                this.scaleDownIdleTimeInSeconds = scaleDownIdleTimeInSeconds;
                return this;
            }

            public Builder slurmCustomSettings(IResolvable slurmCustomSettings) {
                this.slurmCustomSettings = slurmCustomSettings;
                return this;
            }

            public Builder slurmCustomSettings(List<? extends Object> slurmCustomSettings) {
                this.slurmCustomSettings = slurmCustomSettings;
                return this;
            }

            public SlurmConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcs.CfnCluster.SchedulerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SchedulerProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @NotNull
        public String getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SchedulerProperty> {
            String type;
            String version;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public SchedulerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcs.CfnCluster.NetworkingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkingProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        @Nullable
        default public List<String> getSubnetIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkingProperty> {
            List<String> securityGroupIds;
            List<String> subnetIds;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public NetworkingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcs.CfnCluster.ErrorInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ErrorInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCode() {
            return null;
        }

        @Nullable
        default public String getMessage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ErrorInfoProperty> {
            String code;
            String message;

            public Builder code(String code) {
                this.code = code;
                return this;
            }

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public ErrorInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcs.CfnCluster.EndpointProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointProperty
    extends JsiiSerializable {
        @NotNull
        public String getPort();

        @NotNull
        public String getPrivateIpAddress();

        @NotNull
        public String getType();

        @Nullable
        default public String getPublicIpAddress() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointProperty> {
            String port;
            String privateIpAddress;
            String type;
            String publicIpAddress;

            public Builder port(String port) {
                this.port = port;
                return this;
            }

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder publicIpAddress(String publicIpAddress) {
                this.publicIpAddress = publicIpAddress;
                return this;
            }

            public EndpointProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcs.CfnCluster.AuthKeyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthKeyProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretArn();

        @NotNull
        public String getSecretVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthKeyProperty> {
            String secretArn;
            String secretVersion;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder secretVersion(String secretVersion) {
                this.secretVersion = secretVersion;
                return this;
            }

            public AuthKeyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

