package software.amazon.awscdk;

/**
 * File system utilities.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * FileSystem fileSystem = new FileSystem();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:18.336Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.FileSystem")
public class FileSystem extends software.amazon.jsii.JsiiObject {

    protected FileSystem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FileSystem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FileSystem() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Copies an entire directory structure.
     * <p>
     * @param srcDir Source directory. This parameter is required.
     * @param destDir Destination directory. This parameter is required.
     * @param options options.
     * @param rootDir Root directory to calculate exclusions from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void copyDirectory(final @org.jetbrains.annotations.NotNull java.lang.String srcDir, final @org.jetbrains.annotations.NotNull java.lang.String destDir, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.CopyOptions options, final @org.jetbrains.annotations.Nullable java.lang.String rootDir) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.FileSystem.class, "copyDirectory", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(srcDir, "srcDir is required"), java.util.Objects.requireNonNull(destDir, "destDir is required"), options, rootDir });
    }

    /**
     * Copies an entire directory structure.
     * <p>
     * @param srcDir Source directory. This parameter is required.
     * @param destDir Destination directory. This parameter is required.
     * @param options options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void copyDirectory(final @org.jetbrains.annotations.NotNull java.lang.String srcDir, final @org.jetbrains.annotations.NotNull java.lang.String destDir, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.CopyOptions options) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.FileSystem.class, "copyDirectory", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(srcDir, "srcDir is required"), java.util.Objects.requireNonNull(destDir, "destDir is required"), options });
    }

    /**
     * Copies an entire directory structure.
     * <p>
     * @param srcDir Source directory. This parameter is required.
     * @param destDir Destination directory. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void copyDirectory(final @org.jetbrains.annotations.NotNull java.lang.String srcDir, final @org.jetbrains.annotations.NotNull java.lang.String destDir) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.FileSystem.class, "copyDirectory", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(srcDir, "srcDir is required"), java.util.Objects.requireNonNull(destDir, "destDir is required") });
    }

    /**
     * Produces fingerprint based on the contents of a single file or an entire directory tree.
     * <p>
     * Line endings are converted from CRLF to LF.
     * <p>
     * The fingerprint will also include:
     * <p>
     * <ol>
     * <li>An extra string if defined in <code>options.extra</code>.</li>
     * <li>The symlink follow mode value.</li>
     * </ol>
     * <p>
     * @param fileOrDirectory The directory or file to fingerprint. This parameter is required.
     * @param options Fingerprinting options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String fingerprint(final @org.jetbrains.annotations.NotNull java.lang.String fileOrDirectory, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.FingerprintOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.FileSystem.class, "fingerprint", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(fileOrDirectory, "fileOrDirectory is required"), options });
    }

    /**
     * Produces fingerprint based on the contents of a single file or an entire directory tree.
     * <p>
     * Line endings are converted from CRLF to LF.
     * <p>
     * The fingerprint will also include:
     * <p>
     * <ol>
     * <li>An extra string if defined in <code>options.extra</code>.</li>
     * <li>The symlink follow mode value.</li>
     * </ol>
     * <p>
     * @param fileOrDirectory The directory or file to fingerprint. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String fingerprint(final @org.jetbrains.annotations.NotNull java.lang.String fileOrDirectory) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.FileSystem.class, "fingerprint", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(fileOrDirectory, "fileOrDirectory is required") });
    }

    /**
     * Checks whether a directory is empty.
     * <p>
     * @param dir The directory to check. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isEmpty(final @org.jetbrains.annotations.NotNull java.lang.String dir) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.FileSystem.class, "isEmpty", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(dir, "dir is required") });
    }

    /**
     * Creates a unique temporary directory in the <strong>system temp directory</strong>.
     * <p>
     * @param prefix A prefix for the directory name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String mkdtemp(final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.FileSystem.class, "mkdtemp", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * The real path of the system temp directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getTmpdir() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.FileSystem.class, "tmpdir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
