package software.amazon.awscdk.aws_apigatewayv2_integrations;

/**
 * Lambda WebSocket Integration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration;
 * Function messageHandler;
 * WebSocketApi webSocketApi = new WebSocketApi(this, "mywsapi");
 * WebSocketStage.Builder.create(this, "mystage")
 *         .webSocketApi(webSocketApi)
 *         .stageName("dev")
 *         .autoDeploy(true)
 *         .build();
 * webSocketApi.addRoute("sendMessage", WebSocketRouteOptions.builder()
 *         .integration(new WebSocketLambdaIntegration("SendMessageIntegration", messageHandler))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:19.025Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_integrations.WebSocketLambdaIntegration")
public class WebSocketLambdaIntegration extends software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration {

    protected WebSocketLambdaIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketLambdaIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param handler the Lambda function handler. This parameter is required.
     * @param props properties to configure the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WebSocketLambdaIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction handler, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(handler, "handler is required"), props });
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param handler the Lambda function handler. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WebSocketLambdaIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction handler) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * Bind this integration to the route.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegrationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegrationBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegrationConfig.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id id of the underlying integration construct. This parameter is required.
         * @param handler the Lambda function handler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id, final software.amazon.awscdk.services.lambda.IFunction handler) {
            return new Builder(id, handler);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegrationProps.Builder props;

        private Builder(final java.lang.String id, final software.amazon.awscdk.services.lambda.IFunction handler) {
            this.id = id;
            this.handler = handler;
        }

        /**
         * Specifies how to handle response payload content type conversions.
         * <p>
         * Default: - The response payload will be passed through from the integration response to
         * the route response or method response without modification.
         * <p>
         * @return {@code this}
         * @param contentHandling Specifies how to handle response payload content type conversions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(final software.amazon.awscdk.services.apigatewayv2.ContentHandling contentHandling) {
            this.props().contentHandling(contentHandling);
            return this;
        }

        /**
         * The maximum amount of time an integration will run before it returns without a response.
         * <p>
         * Must be between 50 milliseconds and 29 seconds.
         * <p>
         * Default: Duration.seconds(29)
         * <p>
         * @return {@code this}
         * @param timeout The maximum amount of time an integration will run before it returns without a response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration build() {
            return new software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration(
                this.id,
                this.handler,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegrationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegrationProps.Builder();
            }
            return this.props;
        }
    }
}
