package software.amazon.awscdk.cloud_assembly_schema;

/**
 * Artifact properties for CloudFormation stacks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloud_assembly_schema.*;
 * Object assumeRoleAdditionalOptions;
 * AwsCloudFormationStackProperties awsCloudFormationStackProperties = AwsCloudFormationStackProperties.builder()
 *         .templateFile("templateFile")
 *         // the properties below are optional
 *         .assumeRoleAdditionalOptions(Map.of(
 *                 "assumeRoleAdditionalOptionsKey", assumeRoleAdditionalOptions))
 *         .assumeRoleArn("assumeRoleArn")
 *         .assumeRoleExternalId("assumeRoleExternalId")
 *         .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *         .cloudFormationExecutionRoleArn("cloudFormationExecutionRoleArn")
 *         .lookupRole(BootstrapRole.builder()
 *                 .arn("arn")
 *                 // the properties below are optional
 *                 .assumeRoleAdditionalOptions(Map.of(
 *                         "assumeRoleAdditionalOptionsKey", assumeRoleAdditionalOptions))
 *                 .assumeRoleExternalId("assumeRoleExternalId")
 *                 .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                 .requiresBootstrapStackVersion(123)
 *                 .build())
 *         .notificationArns(List.of("notificationArns"))
 *         .parameters(Map.of(
 *                 "parametersKey", "parameters"))
 *         .requiresBootstrapStackVersion(123)
 *         .stackName("stackName")
 *         .stackTemplateAssetObjectUrl("stackTemplateAssetObjectUrl")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .terminationProtection(false)
 *         .validateOnSynth(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:34.625Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.AwsCloudFormationStackProperties")
@software.amazon.jsii.Jsii.Proxy(AwsCloudFormationStackProperties.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsCloudFormationStackProperties extends software.amazon.jsii.JsiiSerializable {

    /**
     * A file relative to the assembly root which contains the CloudFormation template for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateFile();

    /**
     * Additional options to pass to STS when assuming the role.
     * <p>
     * <ul>
     * <li><code>RoleArn</code> should not be used. Use the dedicated <code>assumeRoleArn</code> property instead.</li>
     * <li><code>ExternalId</code> should not be used. Use the dedicated <code>assumeRoleExternalId</code> instead.</li>
     * </ul>
     * <p>
     * Default: - No additional options.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getAssumeRoleAdditionalOptions() {
        return null;
    }

    /**
     * The role that needs to be assumed to deploy the stack.
     * <p>
     * Default: - No role is assumed (current credentials are used)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssumeRoleArn() {
        return null;
    }

    /**
     * External ID to use when assuming role for cloudformation deployments.
     * <p>
     * Default: - No external ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssumeRoleExternalId() {
        return null;
    }

    /**
     * SSM parameter where the bootstrap stack version number can be found.
     * <p>
     * Only used if <code>requiresBootstrapStackVersion</code> is set.
     * <p>
     * <ul>
     * <li>If this value is not set, the bootstrap stack name must be known at
     * deployment time so the stack version can be looked up from the stack
     * outputs.</li>
     * <li>If this value is set, the bootstrap stack can have any name because
     * we won't need to look it up.</li>
     * </ul>
     * <p>
     * Default: - Bootstrap stack version number looked up
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBootstrapStackVersionSsmParameter() {
        return null;
    }

    /**
     * The role that is passed to CloudFormation to execute the change set.
     * <p>
     * Default: - No role is passed (currently assumed role/credentials are used)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudFormationExecutionRoleArn() {
        return null;
    }

    /**
     * The role to use to look up values from the target AWS account.
     * <p>
     * Default: - No role is assumed (current credentials are used)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloud_assembly_schema.BootstrapRole getLookupRole() {
        return null;
    }

    /**
     * SNS Notification ARNs that should receive CloudFormation Stack Events.
     * <p>
     * Default: - No notification arns
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationArns() {
        return null;
    }

    /**
     * Values for CloudFormation stack parameters that should be passed when the stack is deployed.
     * <p>
     * Default: - No parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getParameters() {
        return null;
    }

    /**
     * Version of bootstrap stack required to deploy this stack.
     * <p>
     * Default: - No bootstrap stack required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRequiresBootstrapStackVersion() {
        return null;
    }

    /**
     * The name to use for the CloudFormation stack.
     * <p>
     * Default: - name derived from artifact ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStackName() {
        return null;
    }

    /**
     * If the stack template has already been included in the asset manifest, its asset URL.
     * <p>
     * Default: - Not uploaded yet, upload just before deploying
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStackTemplateAssetObjectUrl() {
        return null;
    }

    /**
     * Values for CloudFormation stack tags that should be passed when the stack is deployed.
     * <p>
     * Default: - No tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * Whether to enable termination protection for this stack.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminationProtection() {
        return null;
    }

    /**
     * Whether this stack should be validated by the CLI after synthesis.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getValidateOnSynth() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsCloudFormationStackProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsCloudFormationStackProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AwsCloudFormationStackProperties> {
        java.lang.String templateFile;
        java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        java.lang.String assumeRoleArn;
        java.lang.String assumeRoleExternalId;
        java.lang.String bootstrapStackVersionSsmParameter;
        java.lang.String cloudFormationExecutionRoleArn;
        software.amazon.awscdk.cloud_assembly_schema.BootstrapRole lookupRole;
        java.util.List<java.lang.String> notificationArns;
        java.util.Map<java.lang.String, java.lang.String> parameters;
        java.lang.Number requiresBootstrapStackVersion;
        java.lang.String stackName;
        java.lang.String stackTemplateAssetObjectUrl;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Boolean terminationProtection;
        java.lang.Boolean validateOnSynth;

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getTemplateFile}
         * @param templateFile A file relative to the assembly root which contains the CloudFormation template for this stack. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateFile(java.lang.String templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getAssumeRoleAdditionalOptions}
         * @param assumeRoleAdditionalOptions Additional options to pass to STS when assuming the role.
         *                                    <ul>
         *                                    <li><code>RoleArn</code> should not be used. Use the dedicated <code>assumeRoleArn</code> property instead.</li>
         *                                    <li><code>ExternalId</code> should not be used. Use the dedicated <code>assumeRoleExternalId</code> instead.</li>
         *                                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assumeRoleAdditionalOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> assumeRoleAdditionalOptions) {
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)assumeRoleAdditionalOptions;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getAssumeRoleArn}
         * @param assumeRoleArn The role that needs to be assumed to deploy the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleArn(java.lang.String assumeRoleArn) {
            this.assumeRoleArn = assumeRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getAssumeRoleExternalId}
         * @param assumeRoleExternalId External ID to use when assuming role for cloudformation deployments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleExternalId(java.lang.String assumeRoleExternalId) {
            this.assumeRoleExternalId = assumeRoleExternalId;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getBootstrapStackVersionSsmParameter}
         * @param bootstrapStackVersionSsmParameter SSM parameter where the bootstrap stack version number can be found.
         *                                          Only used if <code>requiresBootstrapStackVersion</code> is set.
         *                                          <p>
         *                                          <ul>
         *                                          <li>If this value is not set, the bootstrap stack name must be known at
         *                                          deployment time so the stack version can be looked up from the stack
         *                                          outputs.</li>
         *                                          <li>If this value is set, the bootstrap stack can have any name because
         *                                          we won't need to look it up.</li>
         *                                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapStackVersionSsmParameter(java.lang.String bootstrapStackVersionSsmParameter) {
            this.bootstrapStackVersionSsmParameter = bootstrapStackVersionSsmParameter;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getCloudFormationExecutionRoleArn}
         * @param cloudFormationExecutionRoleArn The role that is passed to CloudFormation to execute the change set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRoleArn(java.lang.String cloudFormationExecutionRoleArn) {
            this.cloudFormationExecutionRoleArn = cloudFormationExecutionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getLookupRole}
         * @param lookupRole The role to use to look up values from the target AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRole(software.amazon.awscdk.cloud_assembly_schema.BootstrapRole lookupRole) {
            this.lookupRole = lookupRole;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getNotificationArns}
         * @param notificationArns SNS Notification ARNs that should receive CloudFormation Stack Events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationArns(java.util.List<java.lang.String> notificationArns) {
            this.notificationArns = notificationArns;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getParameters}
         * @param parameters Values for CloudFormation stack parameters that should be passed when the stack is deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getRequiresBootstrapStackVersion}
         * @param requiresBootstrapStackVersion Version of bootstrap stack required to deploy this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requiresBootstrapStackVersion(java.lang.Number requiresBootstrapStackVersion) {
            this.requiresBootstrapStackVersion = requiresBootstrapStackVersion;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getStackName}
         * @param stackName The name to use for the CloudFormation stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(java.lang.String stackName) {
            this.stackName = stackName;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getStackTemplateAssetObjectUrl}
         * @param stackTemplateAssetObjectUrl If the stack template has already been included in the asset manifest, its asset URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackTemplateAssetObjectUrl(java.lang.String stackTemplateAssetObjectUrl) {
            this.stackTemplateAssetObjectUrl = stackTemplateAssetObjectUrl;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getTags}
         * @param tags Values for CloudFormation stack tags that should be passed when the stack is deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getTerminationProtection}
         * @param terminationProtection Whether to enable termination protection for this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtection(java.lang.Boolean terminationProtection) {
            this.terminationProtection = terminationProtection;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getValidateOnSynth}
         * @param validateOnSynth Whether this stack should be validated by the CLI after synthesis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateOnSynth(java.lang.Boolean validateOnSynth) {
            this.validateOnSynth = validateOnSynth;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsCloudFormationStackProperties}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AwsCloudFormationStackProperties build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AwsCloudFormationStackProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsCloudFormationStackProperties {
        private final java.lang.String templateFile;
        private final java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        private final java.lang.String assumeRoleArn;
        private final java.lang.String assumeRoleExternalId;
        private final java.lang.String bootstrapStackVersionSsmParameter;
        private final java.lang.String cloudFormationExecutionRoleArn;
        private final software.amazon.awscdk.cloud_assembly_schema.BootstrapRole lookupRole;
        private final java.util.List<java.lang.String> notificationArns;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final java.lang.Number requiresBootstrapStackVersion;
        private final java.lang.String stackName;
        private final java.lang.String stackTemplateAssetObjectUrl;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Boolean terminationProtection;
        private final java.lang.Boolean validateOnSynth;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.templateFile = software.amazon.jsii.Kernel.get(this, "templateFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumeRoleAdditionalOptions = software.amazon.jsii.Kernel.get(this, "assumeRoleAdditionalOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.assumeRoleArn = software.amazon.jsii.Kernel.get(this, "assumeRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumeRoleExternalId = software.amazon.jsii.Kernel.get(this, "assumeRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bootstrapStackVersionSsmParameter = software.amazon.jsii.Kernel.get(this, "bootstrapStackVersionSsmParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudFormationExecutionRoleArn = software.amazon.jsii.Kernel.get(this, "cloudFormationExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lookupRole = software.amazon.jsii.Kernel.get(this, "lookupRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.BootstrapRole.class));
            this.notificationArns = software.amazon.jsii.Kernel.get(this, "notificationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.requiresBootstrapStackVersion = software.amazon.jsii.Kernel.get(this, "requiresBootstrapStackVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.stackName = software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackTemplateAssetObjectUrl = software.amazon.jsii.Kernel.get(this, "stackTemplateAssetObjectUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.terminationProtection = software.amazon.jsii.Kernel.get(this, "terminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.validateOnSynth = software.amazon.jsii.Kernel.get(this, "validateOnSynth", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.templateFile = java.util.Objects.requireNonNull(builder.templateFile, "templateFile is required");
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.assumeRoleAdditionalOptions;
            this.assumeRoleArn = builder.assumeRoleArn;
            this.assumeRoleExternalId = builder.assumeRoleExternalId;
            this.bootstrapStackVersionSsmParameter = builder.bootstrapStackVersionSsmParameter;
            this.cloudFormationExecutionRoleArn = builder.cloudFormationExecutionRoleArn;
            this.lookupRole = builder.lookupRole;
            this.notificationArns = builder.notificationArns;
            this.parameters = builder.parameters;
            this.requiresBootstrapStackVersion = builder.requiresBootstrapStackVersion;
            this.stackName = builder.stackName;
            this.stackTemplateAssetObjectUrl = builder.stackTemplateAssetObjectUrl;
            this.tags = builder.tags;
            this.terminationProtection = builder.terminationProtection;
            this.validateOnSynth = builder.validateOnSynth;
        }

        @Override
        public final java.lang.String getTemplateFile() {
            return this.templateFile;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssumeRoleAdditionalOptions() {
            return this.assumeRoleAdditionalOptions;
        }

        @Override
        public final java.lang.String getAssumeRoleArn() {
            return this.assumeRoleArn;
        }

        @Override
        public final java.lang.String getAssumeRoleExternalId() {
            return this.assumeRoleExternalId;
        }

        @Override
        public final java.lang.String getBootstrapStackVersionSsmParameter() {
            return this.bootstrapStackVersionSsmParameter;
        }

        @Override
        public final java.lang.String getCloudFormationExecutionRoleArn() {
            return this.cloudFormationExecutionRoleArn;
        }

        @Override
        public final software.amazon.awscdk.cloud_assembly_schema.BootstrapRole getLookupRole() {
            return this.lookupRole;
        }

        @Override
        public final java.util.List<java.lang.String> getNotificationArns() {
            return this.notificationArns;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Number getRequiresBootstrapStackVersion() {
            return this.requiresBootstrapStackVersion;
        }

        @Override
        public final java.lang.String getStackName() {
            return this.stackName;
        }

        @Override
        public final java.lang.String getStackTemplateAssetObjectUrl() {
            return this.stackTemplateAssetObjectUrl;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Boolean getTerminationProtection() {
            return this.terminationProtection;
        }

        @Override
        public final java.lang.Boolean getValidateOnSynth() {
            return this.validateOnSynth;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("templateFile", om.valueToTree(this.getTemplateFile()));
            if (this.getAssumeRoleAdditionalOptions() != null) {
                data.set("assumeRoleAdditionalOptions", om.valueToTree(this.getAssumeRoleAdditionalOptions()));
            }
            if (this.getAssumeRoleArn() != null) {
                data.set("assumeRoleArn", om.valueToTree(this.getAssumeRoleArn()));
            }
            if (this.getAssumeRoleExternalId() != null) {
                data.set("assumeRoleExternalId", om.valueToTree(this.getAssumeRoleExternalId()));
            }
            if (this.getBootstrapStackVersionSsmParameter() != null) {
                data.set("bootstrapStackVersionSsmParameter", om.valueToTree(this.getBootstrapStackVersionSsmParameter()));
            }
            if (this.getCloudFormationExecutionRoleArn() != null) {
                data.set("cloudFormationExecutionRoleArn", om.valueToTree(this.getCloudFormationExecutionRoleArn()));
            }
            if (this.getLookupRole() != null) {
                data.set("lookupRole", om.valueToTree(this.getLookupRole()));
            }
            if (this.getNotificationArns() != null) {
                data.set("notificationArns", om.valueToTree(this.getNotificationArns()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getRequiresBootstrapStackVersion() != null) {
                data.set("requiresBootstrapStackVersion", om.valueToTree(this.getRequiresBootstrapStackVersion()));
            }
            if (this.getStackName() != null) {
                data.set("stackName", om.valueToTree(this.getStackName()));
            }
            if (this.getStackTemplateAssetObjectUrl() != null) {
                data.set("stackTemplateAssetObjectUrl", om.valueToTree(this.getStackTemplateAssetObjectUrl()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTerminationProtection() != null) {
                data.set("terminationProtection", om.valueToTree(this.getTerminationProtection()));
            }
            if (this.getValidateOnSynth() != null) {
                data.set("validateOnSynth", om.valueToTree(this.getValidateOnSynth()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.AwsCloudFormationStackProperties"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsCloudFormationStackProperties.Jsii$Proxy that = (AwsCloudFormationStackProperties.Jsii$Proxy) o;

            if (!templateFile.equals(that.templateFile)) return false;
            if (this.assumeRoleAdditionalOptions != null ? !this.assumeRoleAdditionalOptions.equals(that.assumeRoleAdditionalOptions) : that.assumeRoleAdditionalOptions != null) return false;
            if (this.assumeRoleArn != null ? !this.assumeRoleArn.equals(that.assumeRoleArn) : that.assumeRoleArn != null) return false;
            if (this.assumeRoleExternalId != null ? !this.assumeRoleExternalId.equals(that.assumeRoleExternalId) : that.assumeRoleExternalId != null) return false;
            if (this.bootstrapStackVersionSsmParameter != null ? !this.bootstrapStackVersionSsmParameter.equals(that.bootstrapStackVersionSsmParameter) : that.bootstrapStackVersionSsmParameter != null) return false;
            if (this.cloudFormationExecutionRoleArn != null ? !this.cloudFormationExecutionRoleArn.equals(that.cloudFormationExecutionRoleArn) : that.cloudFormationExecutionRoleArn != null) return false;
            if (this.lookupRole != null ? !this.lookupRole.equals(that.lookupRole) : that.lookupRole != null) return false;
            if (this.notificationArns != null ? !this.notificationArns.equals(that.notificationArns) : that.notificationArns != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.requiresBootstrapStackVersion != null ? !this.requiresBootstrapStackVersion.equals(that.requiresBootstrapStackVersion) : that.requiresBootstrapStackVersion != null) return false;
            if (this.stackName != null ? !this.stackName.equals(that.stackName) : that.stackName != null) return false;
            if (this.stackTemplateAssetObjectUrl != null ? !this.stackTemplateAssetObjectUrl.equals(that.stackTemplateAssetObjectUrl) : that.stackTemplateAssetObjectUrl != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.terminationProtection != null ? !this.terminationProtection.equals(that.terminationProtection) : that.terminationProtection != null) return false;
            return this.validateOnSynth != null ? this.validateOnSynth.equals(that.validateOnSynth) : that.validateOnSynth == null;
        }

        @Override
        public final int hashCode() {
            int result = this.templateFile.hashCode();
            result = 31 * result + (this.assumeRoleAdditionalOptions != null ? this.assumeRoleAdditionalOptions.hashCode() : 0);
            result = 31 * result + (this.assumeRoleArn != null ? this.assumeRoleArn.hashCode() : 0);
            result = 31 * result + (this.assumeRoleExternalId != null ? this.assumeRoleExternalId.hashCode() : 0);
            result = 31 * result + (this.bootstrapStackVersionSsmParameter != null ? this.bootstrapStackVersionSsmParameter.hashCode() : 0);
            result = 31 * result + (this.cloudFormationExecutionRoleArn != null ? this.cloudFormationExecutionRoleArn.hashCode() : 0);
            result = 31 * result + (this.lookupRole != null ? this.lookupRole.hashCode() : 0);
            result = 31 * result + (this.notificationArns != null ? this.notificationArns.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.requiresBootstrapStackVersion != null ? this.requiresBootstrapStackVersion.hashCode() : 0);
            result = 31 * result + (this.stackName != null ? this.stackName.hashCode() : 0);
            result = 31 * result + (this.stackTemplateAssetObjectUrl != null ? this.stackTemplateAssetObjectUrl.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.terminationProtection != null ? this.terminationProtection.hashCode() : 0);
            result = 31 * result + (this.validateOnSynth != null ? this.validateOnSynth.hashCode() : 0);
            return result;
        }
    }
}
