package software.amazon.awscdk.services.apigateway;

/**
 * Use a Firehose delivery stream as a custom access log destination for API Gateway.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket destinationBucket = new Bucket(this, "Bucket");
 * Role deliveryStreamRole = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("firehose.amazonaws.com"))
 *         .build();
 * CfnDeliveryStream stream = CfnDeliveryStream.Builder.create(this, "MyStream")
 *         .deliveryStreamName("amazon-apigateway-delivery-stream")
 *         .s3DestinationConfiguration(S3DestinationConfigurationProperty.builder()
 *                 .bucketArn(destinationBucket.getBucketArn())
 *                 .roleArn(deliveryStreamRole.getRoleArn())
 *                 .build())
 *         .build();
 * RestApi api = RestApi.Builder.create(this, "books")
 *         .deployOptions(StageOptions.builder()
 *                 .accessLogDestination(new FirehoseLogDestination(stream))
 *                 .accessLogFormat(AccessLogFormat.jsonWithStandardFields())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:18.745Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.FirehoseLogDestination")
public class FirehoseLogDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.IAccessLogDestination {

    protected FirehoseLogDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirehoseLogDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stream This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FirehoseLogDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream stream) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required") });
    }

    /**
     * Binds this destination to the Firehose delivery stream.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AccessLogDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AccessLogDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }
}
