package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaIntegration integration;
 * RestApi api = new RestApi(this, "hello-api");
 * Resource v1 = api.root.addResource("v1");
 * Resource echo = v1.addResource("echo");
 * Method echoMethod = echo.addMethod("GET", integration, MethodOptions.builder().apiKeyRequired(true).build());
 * UsagePlan plan = api.addUsagePlan("UsagePlan", UsagePlanProps.builder()
 *         .name("Easy")
 *         .throttle(ThrottleSettings.builder()
 *                 .rateLimit(10)
 *                 .burstLimit(2)
 *                 .build())
 *         .build());
 * IApiKey key = api.addApiKey("ApiKey");
 * plan.addApiKey(key);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:18.859Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.UsagePlan")
public class UsagePlan extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigateway.IUsagePlan {

    protected UsagePlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UsagePlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UsagePlan(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.UsagePlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UsagePlan(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an externally defined usage plan using its ARN.
     * <p>
     * @param scope the construct that will "own" the imported usage plan. This parameter is required.
     * @param id the id of the imported usage plan in the construct tree. This parameter is required.
     * @param usagePlanId the id of an existing usage plan. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IUsagePlan fromUsagePlanId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String usagePlanId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.UsagePlan.class, "fromUsagePlanId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IUsagePlan.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(usagePlanId, "usagePlanId is required") });
    }

    /**
     * Adds an ApiKey.
     * <p>
     * @param apiKey the api key to associate with this usage plan. This parameter is required.
     * @param options options that control the behaviour of this method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addApiKey(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IApiKey apiKey, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.AddApiKeyOptions options) {
        software.amazon.jsii.Kernel.call(this, "addApiKey", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(apiKey, "apiKey is required"), options });
    }

    /**
     * Adds an ApiKey.
     * <p>
     * @param apiKey the api key to associate with this usage plan. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addApiKey(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IApiKey apiKey) {
        software.amazon.jsii.Kernel.call(this, "addApiKey", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(apiKey, "apiKey is required") });
    }

    /**
     * Adds an apiStage.
     * <p>
     * @param apiStage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addApiStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage apiStage) {
        software.amazon.jsii.Kernel.call(this, "addApiStage", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(apiStage, "apiStage is required") });
    }

    /**
     * Id of the usage plan.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUsagePlanId() {
        return software.amazon.jsii.Kernel.get(this, "usagePlanId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.UsagePlan}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.UsagePlan> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigateway.UsagePlanProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * API Stages to be associated with the usage plan.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param apiStages API Stages to be associated with the usage plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStages(final java.util.List<? extends software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages) {
            this.props().apiStages(apiStages);
            return this;
        }

        /**
         * Represents usage plan purpose.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param description Represents usage plan purpose. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Name for this usage plan.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param name Name for this usage plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * Number of requests clients can make in a given time period.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param quota Number of requests clients can make in a given time period. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(final software.amazon.awscdk.services.apigateway.QuotaSettings quota) {
            this.props().quota(quota);
            return this;
        }

        /**
         * Overall throttle settings for the API.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param throttle Overall throttle settings for the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(final software.amazon.awscdk.services.apigateway.ThrottleSettings throttle) {
            this.props().throttle(throttle);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigateway.UsagePlan}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.UsagePlan build() {
            return new software.amazon.awscdk.services.apigateway.UsagePlan(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.UsagePlanProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigateway.UsagePlanProps.Builder();
            }
            return this.props;
        }
    }
}
