package software.amazon.awscdk.services.apigatewayv2;

/**
 * Options for the CORS Configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HttpApi.Builder.create(this, "HttpProxyApi")
 *         .corsPreflight(CorsPreflightOptions.builder()
 *                 .allowHeaders(List.of("Authorization"))
 *                 .allowMethods(List.of(CorsHttpMethod.GET, CorsHttpMethod.HEAD, CorsHttpMethod.OPTIONS, CorsHttpMethod.POST))
 *                 .allowOrigins(List.of("*"))
 *                 .maxAge(Duration.days(10))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:18.930Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CorsPreflightOptions")
@software.amazon.jsii.Jsii.Proxy(CorsPreflightOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CorsPreflightOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether credentials are included in the CORS request.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowCredentials() {
        return null;
    }

    /**
     * Represents a collection of allowed headers.
     * <p>
     * Default: - No Headers are allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowHeaders() {
        return null;
    }

    /**
     * Represents a collection of allowed HTTP methods.
     * <p>
     * Default: - No Methods are allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigatewayv2.CorsHttpMethod> getAllowMethods() {
        return null;
    }

    /**
     * Represents a collection of allowed origins.
     * <p>
     * Default: - No Origins are allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowOrigins() {
        return null;
    }

    /**
     * Represents a collection of exposed headers.
     * <p>
     * Default: - No Expose Headers are allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExposeHeaders() {
        return null;
    }

    /**
     * The duration that the browser should cache preflight request results.
     * <p>
     * Default: Duration.seconds(0)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxAge() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CorsPreflightOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CorsPreflightOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CorsPreflightOptions> {
        java.lang.Boolean allowCredentials;
        java.util.List<java.lang.String> allowHeaders;
        java.util.List<software.amazon.awscdk.services.apigatewayv2.CorsHttpMethod> allowMethods;
        java.util.List<java.lang.String> allowOrigins;
        java.util.List<java.lang.String> exposeHeaders;
        software.amazon.awscdk.Duration maxAge;

        /**
         * Sets the value of {@link CorsPreflightOptions#getAllowCredentials}
         * @param allowCredentials Specifies whether credentials are included in the CORS request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowCredentials(java.lang.Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        /**
         * Sets the value of {@link CorsPreflightOptions#getAllowHeaders}
         * @param allowHeaders Represents a collection of allowed headers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowHeaders(java.util.List<java.lang.String> allowHeaders) {
            this.allowHeaders = allowHeaders;
            return this;
        }

        /**
         * Sets the value of {@link CorsPreflightOptions#getAllowMethods}
         * @param allowMethods Represents a collection of allowed HTTP methods.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder allowMethods(java.util.List<? extends software.amazon.awscdk.services.apigatewayv2.CorsHttpMethod> allowMethods) {
            this.allowMethods = (java.util.List<software.amazon.awscdk.services.apigatewayv2.CorsHttpMethod>)allowMethods;
            return this;
        }

        /**
         * Sets the value of {@link CorsPreflightOptions#getAllowOrigins}
         * @param allowOrigins Represents a collection of allowed origins.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowOrigins(java.util.List<java.lang.String> allowOrigins) {
            this.allowOrigins = allowOrigins;
            return this;
        }

        /**
         * Sets the value of {@link CorsPreflightOptions#getExposeHeaders}
         * @param exposeHeaders Represents a collection of exposed headers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exposeHeaders(java.util.List<java.lang.String> exposeHeaders) {
            this.exposeHeaders = exposeHeaders;
            return this;
        }

        /**
         * Sets the value of {@link CorsPreflightOptions#getMaxAge}
         * @param maxAge The duration that the browser should cache preflight request results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAge(software.amazon.awscdk.Duration maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CorsPreflightOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CorsPreflightOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CorsPreflightOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsPreflightOptions {
        private final java.lang.Boolean allowCredentials;
        private final java.util.List<java.lang.String> allowHeaders;
        private final java.util.List<software.amazon.awscdk.services.apigatewayv2.CorsHttpMethod> allowMethods;
        private final java.util.List<java.lang.String> allowOrigins;
        private final java.util.List<java.lang.String> exposeHeaders;
        private final software.amazon.awscdk.Duration maxAge;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowCredentials = software.amazon.jsii.Kernel.get(this, "allowCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.allowHeaders = software.amazon.jsii.Kernel.get(this, "allowHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.allowMethods = software.amazon.jsii.Kernel.get(this, "allowMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.CorsHttpMethod.class)));
            this.allowOrigins = software.amazon.jsii.Kernel.get(this, "allowOrigins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.exposeHeaders = software.amazon.jsii.Kernel.get(this, "exposeHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.maxAge = software.amazon.jsii.Kernel.get(this, "maxAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowCredentials = builder.allowCredentials;
            this.allowHeaders = builder.allowHeaders;
            this.allowMethods = (java.util.List<software.amazon.awscdk.services.apigatewayv2.CorsHttpMethod>)builder.allowMethods;
            this.allowOrigins = builder.allowOrigins;
            this.exposeHeaders = builder.exposeHeaders;
            this.maxAge = builder.maxAge;
        }

        @Override
        public final java.lang.Boolean getAllowCredentials() {
            return this.allowCredentials;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowHeaders() {
            return this.allowHeaders;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigatewayv2.CorsHttpMethod> getAllowMethods() {
            return this.allowMethods;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowOrigins() {
            return this.allowOrigins;
        }

        @Override
        public final java.util.List<java.lang.String> getExposeHeaders() {
            return this.exposeHeaders;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxAge() {
            return this.maxAge;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowCredentials() != null) {
                data.set("allowCredentials", om.valueToTree(this.getAllowCredentials()));
            }
            if (this.getAllowHeaders() != null) {
                data.set("allowHeaders", om.valueToTree(this.getAllowHeaders()));
            }
            if (this.getAllowMethods() != null) {
                data.set("allowMethods", om.valueToTree(this.getAllowMethods()));
            }
            if (this.getAllowOrigins() != null) {
                data.set("allowOrigins", om.valueToTree(this.getAllowOrigins()));
            }
            if (this.getExposeHeaders() != null) {
                data.set("exposeHeaders", om.valueToTree(this.getExposeHeaders()));
            }
            if (this.getMaxAge() != null) {
                data.set("maxAge", om.valueToTree(this.getMaxAge()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CorsPreflightOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CorsPreflightOptions.Jsii$Proxy that = (CorsPreflightOptions.Jsii$Proxy) o;

            if (this.allowCredentials != null ? !this.allowCredentials.equals(that.allowCredentials) : that.allowCredentials != null) return false;
            if (this.allowHeaders != null ? !this.allowHeaders.equals(that.allowHeaders) : that.allowHeaders != null) return false;
            if (this.allowMethods != null ? !this.allowMethods.equals(that.allowMethods) : that.allowMethods != null) return false;
            if (this.allowOrigins != null ? !this.allowOrigins.equals(that.allowOrigins) : that.allowOrigins != null) return false;
            if (this.exposeHeaders != null ? !this.exposeHeaders.equals(that.exposeHeaders) : that.exposeHeaders != null) return false;
            return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowCredentials != null ? this.allowCredentials.hashCode() : 0;
            result = 31 * result + (this.allowHeaders != null ? this.allowHeaders.hashCode() : 0);
            result = 31 * result + (this.allowMethods != null ? this.allowMethods.hashCode() : 0);
            result = 31 * result + (this.allowOrigins != null ? this.allowOrigins.hashCode() : 0);
            result = 31 * result + (this.exposeHeaders != null ? this.exposeHeaders.hashCode() : 0);
            result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
            return result;
        }
    }
}
