package software.amazon.awscdk.services.apigatewayv2;

/**
 * Represents the currently available API Key Selection Expressions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * WebSocketApi webSocketApi = WebSocketApi.Builder.create(this, "mywsapi")
 *         .apiKeySelectionExpression(WebSocketApiKeySelectionExpression.HEADER_X_API_KEY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:18.982Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketApiKeySelectionExpression")
public class WebSocketApiKeySelectionExpression extends software.amazon.jsii.JsiiObject {

    protected WebSocketApiKeySelectionExpression(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketApiKeySelectionExpression(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AUTHORIZER_USAGE_IDENTIFIER_KEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression.class, "AUTHORIZER_USAGE_IDENTIFIER_KEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression.class));
        HEADER_X_API_KEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression.class, "HEADER_X_API_KEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression.class));
    }

    /**
     * @param customApiKeySelector The expression used by API Gateway. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WebSocketApiKeySelectionExpression(final @org.jetbrains.annotations.NotNull java.lang.String customApiKeySelector) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(customApiKeySelector, "customApiKeySelector is required") });
    }

    /**
     * The API will extract the key value from the <code>usageIdentifierKey</code> attribute in the <code>context</code> map, returned by the Lambda Authorizer.
     * <p>
     * See https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression AUTHORIZER_USAGE_IDENTIFIER_KEY;

    /**
     * The API will extract the key value from the <code>x-api-key</code> header in the user request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression HEADER_X_API_KEY;

    /**
     * The expression used by API Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCustomApiKeySelector() {
        return software.amazon.jsii.Kernel.get(this, "customApiKeySelector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
