package software.amazon.awscdk.services.appmesh;

/**
 * Enum of DNS service discovery response type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // A Virtual Node with a gRPC listener with a connection pool set
 * Mesh mesh;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         // DNS service discovery can optionally specify the DNS response type as either LOAD_BALANCER or ENDPOINTS.
 *         // LOAD_BALANCER means that the DNS resolver returns a loadbalanced set of endpoints,
 *         // whereas ENDPOINTS means that the DNS resolver is returning all the endpoints.
 *         // By default, the response type is assumed to be LOAD_BALANCER
 *         .serviceDiscovery(ServiceDiscovery.dns("node", DnsResponseType.ENDPOINTS))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(80)
 *                 .connectionPool(HttpConnectionPool.builder()
 *                         .maxConnections(100)
 *                         .maxPendingRequests(10)
 *                         .build())
 *                 .build())))
 *         .build();
 * // A Virtual Gateway with a gRPC listener with a connection pool set
 * VirtualGateway gateway = VirtualGateway.Builder.create(this, "gateway")
 *         .mesh(mesh)
 *         .listeners(List.of(VirtualGatewayListener.grpc(GrpcGatewayListenerOptions.builder()
 *                 .port(8080)
 *                 .connectionPool(GrpcConnectionPool.builder()
 *                         .maxRequests(10)
 *                         .build())
 *                 .build())))
 *         .virtualGatewayName("gateway")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:19.458Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.DnsResponseType")
public enum DnsResponseType {
    /**
     * DNS resolver returns a loadbalanced set of endpoints and the traffic would be sent to the given endpoints.
     * <p>
     * It would not drain existing connections to other endpoints that are not part of this list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LOAD_BALANCER,
    /**
     * DNS resolver is returning all the endpoints.
     * <p>
     * This also means that if an endpoint is missing, it would drain the current connections to the missing endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ENDPOINTS,
}
