package software.amazon.awscdk.services.appmesh;

/**
 * Interface with properties necessary to import a reusable GatewayRoute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * VirtualGateway virtualGateway;
 * GatewayRouteAttributes gatewayRouteAttributes = GatewayRouteAttributes.builder()
 *         .gatewayRouteName("gatewayRouteName")
 *         .virtualGateway(virtualGateway)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:19.460Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.GatewayRouteAttributes")
@software.amazon.jsii.Jsii.Proxy(GatewayRouteAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GatewayRouteAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the GatewayRoute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGatewayRouteName();

    /**
     * The VirtualGateway this GatewayRoute is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualGateway getVirtualGateway();

    /**
     * @return a {@link Builder} of {@link GatewayRouteAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GatewayRouteAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteAttributes> {
        java.lang.String gatewayRouteName;
        software.amazon.awscdk.services.appmesh.IVirtualGateway virtualGateway;

        /**
         * Sets the value of {@link GatewayRouteAttributes#getGatewayRouteName}
         * @param gatewayRouteName The name of the GatewayRoute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayRouteName(java.lang.String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        /**
         * Sets the value of {@link GatewayRouteAttributes#getVirtualGateway}
         * @param virtualGateway The VirtualGateway this GatewayRoute is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualGateway(software.amazon.awscdk.services.appmesh.IVirtualGateway virtualGateway) {
            this.virtualGateway = virtualGateway;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayRouteAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GatewayRouteAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GatewayRouteAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteAttributes {
        private final java.lang.String gatewayRouteName;
        private final software.amazon.awscdk.services.appmesh.IVirtualGateway virtualGateway;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.gatewayRouteName = software.amazon.jsii.Kernel.get(this, "gatewayRouteName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.virtualGateway = software.amazon.jsii.Kernel.get(this, "virtualGateway", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualGateway.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.gatewayRouteName = java.util.Objects.requireNonNull(builder.gatewayRouteName, "gatewayRouteName is required");
            this.virtualGateway = java.util.Objects.requireNonNull(builder.virtualGateway, "virtualGateway is required");
        }

        @Override
        public final java.lang.String getGatewayRouteName() {
            return this.gatewayRouteName;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IVirtualGateway getVirtualGateway() {
            return this.virtualGateway;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("gatewayRouteName", om.valueToTree(this.getGatewayRouteName()));
            data.set("virtualGateway", om.valueToTree(this.getVirtualGateway()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.GatewayRouteAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GatewayRouteAttributes.Jsii$Proxy that = (GatewayRouteAttributes.Jsii$Proxy) o;

            if (!gatewayRouteName.equals(that.gatewayRouteName)) return false;
            return this.virtualGateway.equals(that.virtualGateway);
        }

        @Override
        public final int hashCode() {
            int result = this.gatewayRouteName.hashCode();
            result = 31 * result + (this.virtualGateway.hashCode());
            return result;
        }
    }
}
