package software.amazon.awscdk.services.appmesh;

/**
 * Properties specific for a gRPC GatewayRoute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualGateway gateway;
 * VirtualService virtualService;
 * gateway.addGatewayRoute("gateway-route-grpc", GatewayRouteBaseProps.builder()
 *         .routeSpec(GatewayRouteSpec.grpc(GrpcGatewayRouteSpecOptions.builder()
 *                 .routeTarget(virtualService)
 *                 .match(GrpcGatewayRouteMatch.builder()
 *                         .hostname(GatewayRouteHostnameMatch.endsWith(".example.com"))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:19.479Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.GrpcGatewayRouteSpecOptions")
@software.amazon.jsii.Jsii.Proxy(GrpcGatewayRouteSpecOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GrpcGatewayRouteSpecOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appmesh.CommonGatewayRouteSpecOptions {

    /**
     * The criterion for determining a request match for this GatewayRoute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GrpcGatewayRouteMatch getMatch();

    /**
     * The VirtualService this GatewayRoute directs traffic to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualService getRouteTarget();

    /**
     * @return a {@link Builder} of {@link GrpcGatewayRouteSpecOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrpcGatewayRouteSpecOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GrpcGatewayRouteSpecOptions> {
        software.amazon.awscdk.services.appmesh.GrpcGatewayRouteMatch match;
        software.amazon.awscdk.services.appmesh.IVirtualService routeTarget;
        java.lang.Number priority;

        /**
         * Sets the value of {@link GrpcGatewayRouteSpecOptions#getMatch}
         * @param match The criterion for determining a request match for this GatewayRoute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder match(software.amazon.awscdk.services.appmesh.GrpcGatewayRouteMatch match) {
            this.match = match;
            return this;
        }

        /**
         * Sets the value of {@link GrpcGatewayRouteSpecOptions#getRouteTarget}
         * @param routeTarget The VirtualService this GatewayRoute directs traffic to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeTarget(software.amazon.awscdk.services.appmesh.IVirtualService routeTarget) {
            this.routeTarget = routeTarget;
            return this;
        }

        /**
         * Sets the value of {@link GrpcGatewayRouteSpecOptions#getPriority}
         * @param priority The priority for the gateway route.
         *                 When a Virtual Gateway has multiple gateway routes, gateway route match
         *                 is performed in the order of specified value, where 0 is the highest priority,
         *                 and first matched gateway route is selected.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrpcGatewayRouteSpecOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GrpcGatewayRouteSpecOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GrpcGatewayRouteSpecOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcGatewayRouteSpecOptions {
        private final software.amazon.awscdk.services.appmesh.GrpcGatewayRouteMatch match;
        private final software.amazon.awscdk.services.appmesh.IVirtualService routeTarget;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GrpcGatewayRouteMatch.class));
            this.routeTarget = software.amazon.jsii.Kernel.get(this, "routeTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualService.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.match = java.util.Objects.requireNonNull(builder.match, "match is required");
            this.routeTarget = java.util.Objects.requireNonNull(builder.routeTarget, "routeTarget is required");
            this.priority = builder.priority;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.GrpcGatewayRouteMatch getMatch() {
            return this.match;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IVirtualService getRouteTarget() {
            return this.routeTarget;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("match", om.valueToTree(this.getMatch()));
            data.set("routeTarget", om.valueToTree(this.getRouteTarget()));
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.GrpcGatewayRouteSpecOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrpcGatewayRouteSpecOptions.Jsii$Proxy that = (GrpcGatewayRouteSpecOptions.Jsii$Proxy) o;

            if (!match.equals(that.match)) return false;
            if (!routeTarget.equals(that.routeTarget)) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public final int hashCode() {
            int result = this.match.hashCode();
            result = 31 * result + (this.routeTarget.hashCode());
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
