package software.amazon.awscdk.services.appsync;

/**
 * AppSync Functions are local functions that perform certain operations onto a backend data source.
 * <p>
 * Developers can compose operations (Functions)
 * and execute them in sequence with Pipeline Resolvers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * AppsyncFunction appsyncFunction = AppsyncFunction.Builder.create(this, "function")
 *         .name("appsync_function")
 *         .api(api)
 *         .dataSource(api.addNoneDataSource("none"))
 *         .requestMappingTemplate(MappingTemplate.fromFile("request.vtl"))
 *         .responseMappingTemplate(MappingTemplate.fromFile("response.vtl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:19.650Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppsyncFunction")
public class AppsyncFunction extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appsync.IAppsyncFunction {

    protected AppsyncFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppsyncFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AppsyncFunction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppsyncFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import Appsync Function from arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IAppsyncFunction fromAppsyncFunctionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppsyncFunctionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.AppsyncFunction.class, "fromAppsyncFunctionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IAppsyncFunction.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * the data source of this AppSync Function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.BaseDataSource getDataSource() {
        return software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.BaseDataSource.class));
    }

    /**
     * the ARN of the AppSync function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the ID of the AppSync function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionId() {
        return software.amazon.jsii.Kernel.get(this, "functionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the name of this AppSync Function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
        return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.AppsyncFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.AppsyncFunction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.AppsyncFunctionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.AppsyncFunctionProps.Builder();
        }

        /**
         * the name of the AppSync Function.
         * <p>
         * @return {@code this}
         * @param name the name of the AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The function code.
         * <p>
         * Default: - no code is used
         * <p>
         * @return {@code this}
         * @param code The function code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.appsync.Code code) {
            this.props.code(code);
            return this;
        }

        /**
         * the description for this AppSync Function.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param description the description for this AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a BatchInvoke operation.
         * <p>
         * Can only be set when using LambdaDataSource.
         * <p>
         * Default: - No max batch size
         * <p>
         * @return {@code this}
         * @param maxBatchSize The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a BatchInvoke operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchSize(final java.lang.Number maxBatchSize) {
            this.props.maxBatchSize(maxBatchSize);
            return this;
        }

        /**
         * the request mapping template for the AppSync Function.
         * <p>
         * Default: - no request mapping template
         * <p>
         * @return {@code this}
         * @param requestMappingTemplate the request mapping template for the AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestMappingTemplate(final software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate) {
            this.props.requestMappingTemplate(requestMappingTemplate);
            return this;
        }

        /**
         * the response mapping template for the AppSync Function.
         * <p>
         * Default: - no response mapping template
         * <p>
         * @return {@code this}
         * @param responseMappingTemplate the response mapping template for the AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseMappingTemplate(final software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate) {
            this.props.responseMappingTemplate(responseMappingTemplate);
            return this;
        }

        /**
         * The functions runtime.
         * <p>
         * Default: - no function runtime, VTL mapping templates used
         * <p>
         * @return {@code this}
         * @param runtime The functions runtime. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(final software.amazon.awscdk.services.appsync.FunctionRuntime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        /**
         * the GraphQL Api linked to this AppSync Function.
         * <p>
         * @return {@code this}
         * @param api the GraphQL Api linked to this AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(final software.amazon.awscdk.services.appsync.IGraphqlApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * the data source linked to this AppSync Function.
         * <p>
         * @return {@code this}
         * @param dataSource the data source linked to this AppSync Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSource(final software.amazon.awscdk.services.appsync.BaseDataSource dataSource) {
            this.props.dataSource(dataSource);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.AppsyncFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.AppsyncFunction build() {
            return new software.amazon.awscdk.services.appsync.AppsyncFunction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
