package software.amazon.awscdk.services.appsync;

/**
 * The <code>AWS::AppSync::GraphQLApi</code> resource creates a new AWS AppSync GraphQL API.
 * <p>
 * This is the top-level construct for your application. For more information, see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/quickstart.html">Quick Start</a> in the <em>AWS AppSync Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnGraphQLApi cfnGraphQLApi = CfnGraphQLApi.Builder.create(this, "MyCfnGraphQLApi")
 *         .authenticationType("authenticationType")
 *         .name("name")
 *         // the properties below are optional
 *         .additionalAuthenticationProviders(List.of(AdditionalAuthenticationProviderProperty.builder()
 *                 .authenticationType("authenticationType")
 *                 // the properties below are optional
 *                 .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
 *                         .authorizerResultTtlInSeconds(123)
 *                         .authorizerUri("authorizerUri")
 *                         .identityValidationExpression("identityValidationExpression")
 *                         .build())
 *                 .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
 *                         .authTtl(123)
 *                         .clientId("clientId")
 *                         .iatTtl(123)
 *                         .issuer("issuer")
 *                         .build())
 *                 .userPoolConfig(CognitoUserPoolConfigProperty.builder()
 *                         .appIdClientRegex("appIdClientRegex")
 *                         .awsRegion("awsRegion")
 *                         .userPoolId("userPoolId")
 *                         .build())
 *                 .build()))
 *         .apiType("apiType")
 *         .enhancedMetricsConfig(EnhancedMetricsConfigProperty.builder()
 *                 .dataSourceLevelMetricsBehavior("dataSourceLevelMetricsBehavior")
 *                 .operationLevelMetricsConfig("operationLevelMetricsConfig")
 *                 .resolverLevelMetricsBehavior("resolverLevelMetricsBehavior")
 *                 .build())
 *         .environmentVariables(Map.of(
 *                 "environmentVariablesKey", "environmentVariables"))
 *         .introspectionConfig("introspectionConfig")
 *         .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
 *                 .authorizerResultTtlInSeconds(123)
 *                 .authorizerUri("authorizerUri")
 *                 .identityValidationExpression("identityValidationExpression")
 *                 .build())
 *         .logConfig(LogConfigProperty.builder()
 *                 .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
 *                 .excludeVerboseContent(false)
 *                 .fieldLogLevel("fieldLogLevel")
 *                 .build())
 *         .mergedApiExecutionRoleArn("mergedApiExecutionRoleArn")
 *         .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
 *                 .authTtl(123)
 *                 .clientId("clientId")
 *                 .iatTtl(123)
 *                 .issuer("issuer")
 *                 .build())
 *         .ownerContact("ownerContact")
 *         .queryDepthLimit(123)
 *         .resolverCountLimit(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userPoolConfig(UserPoolConfigProperty.builder()
 *                 .appIdClientRegex("appIdClientRegex")
 *                 .awsRegion("awsRegion")
 *                 .defaultAction("defaultAction")
 *                 .userPoolId("userPoolId")
 *                 .build())
 *         .visibility("visibility")
 *         .xrayEnabled(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:19.700Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi")
public class CfnGraphQLApi extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnGraphQLApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGraphQLApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appsync.CfnGraphQLApi.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGraphQLApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CfnGraphQLApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Unique AWS AppSync GraphQL API identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrApiId() {
        return software.amazon.jsii.Kernel.get(this, "attrApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the API key, such as <code>arn:aws:appsync:us-east-1:123456789012:apis/graphqlapiid</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The fully qualified domain name (FQDN) of the endpoint URL of your GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGraphQlDns() {
        return software.amazon.jsii.Kernel.get(this, "attrGraphQlDns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The GraphQL endpoint ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGraphQlEndpointArn() {
        return software.amazon.jsii.Kernel.get(this, "attrGraphQlEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Endpoint URL of your GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGraphQlUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrGraphQlUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The fully qualified domain name (FQDN) of the real-time endpoint URL of your GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRealtimeDns() {
        return software.amazon.jsii.Kernel.get(this, "attrRealtimeDns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The GraphQL API real-time endpoint URL.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/real-time-websocket-client.html#handshake-details-to-establish-the-websocket-connection">Discovering the real-time endpoint from the GraphQL endpoint</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRealtimeUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrRealtimeUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Security configuration for your GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType() {
        return software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Security configuration for your GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authenticationType", java.util.Objects.requireNonNull(value, "authenticationType is required"));
    }

    /**
     * The API name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The API name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A list of additional authentication providers for the <code>GraphqlApi</code> API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalAuthenticationProviders() {
        return software.amazon.jsii.Kernel.get(this, "additionalAuthenticationProviders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of additional authentication providers for the <code>GraphqlApi</code> API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalAuthenticationProviders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "additionalAuthenticationProviders", value);
    }

    /**
     * A list of additional authentication providers for the <code>GraphqlApi</code> API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalAuthenticationProviders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.appsync.CfnGraphQLApi.AdditionalAuthenticationProviderProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.appsync.CfnGraphQLApi.AdditionalAuthenticationProviderProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "additionalAuthenticationProviders", value);
    }

    /**
     * The value that indicates whether the GraphQL API is a standard API ( <code>GRAPHQL</code> ) or merged API ( <code>MERGED</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApiType() {
        return software.amazon.jsii.Kernel.get(this, "apiType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The value that indicates whether the GraphQL API is a standard API ( <code>GRAPHQL</code> ) or merged API ( <code>MERGED</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "apiType", value);
    }

    /**
     * Enables and controls the enhanced metrics feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedMetricsConfig() {
        return software.amazon.jsii.Kernel.get(this, "enhancedMetricsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables and controls the enhanced metrics feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedMetricsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enhancedMetricsConfig", value);
    }

    /**
     * Enables and controls the enhanced metrics feature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedMetricsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.EnhancedMetricsConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "enhancedMetricsConfig", value);
    }

    /**
     * A map containing the list of resources with their properties and environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
        return software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A map containing the list of resources with their properties and environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentVariables(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "environmentVariables", value);
    }

    /**
     * A map containing the list of resources with their properties and environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentVariables(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "environmentVariables", value);
    }

    /**
     * Sets the value of the GraphQL API to enable ( <code>ENABLED</code> ) or disable ( <code>DISABLED</code> ) introspection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIntrospectionConfig() {
        return software.amazon.jsii.Kernel.get(this, "introspectionConfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Sets the value of the GraphQL API to enable ( <code>ENABLED</code> ) or disable ( <code>DISABLED</code> ) introspection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntrospectionConfig(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "introspectionConfig", value);
    }

    /**
     * A <code>LambdaAuthorizerConfig</code> holds configuration on how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLambdaAuthorizerConfig() {
        return software.amazon.jsii.Kernel.get(this, "lambdaAuthorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A <code>LambdaAuthorizerConfig</code> holds configuration on how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaAuthorizerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lambdaAuthorizerConfig", value);
    }

    /**
     * A <code>LambdaAuthorizerConfig</code> holds configuration on how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaAuthorizerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "lambdaAuthorizerConfig", value);
    }

    /**
     * The Amazon CloudWatch Logs configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogConfig() {
        return software.amazon.jsii.Kernel.get(this, "logConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon CloudWatch Logs configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logConfig", value);
    }

    /**
     * The Amazon CloudWatch Logs configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.LogConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "logConfig", value);
    }

    /**
     * The AWS Identity and Access Management service role ARN for a merged API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMergedApiExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "mergedApiExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Identity and Access Management service role ARN for a merged API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMergedApiExecutionRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "mergedApiExecutionRoleArn", value);
    }

    /**
     * The OpenID Connect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOpenIdConnectConfig() {
        return software.amazon.jsii.Kernel.get(this, "openIdConnectConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The OpenID Connect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenIdConnectConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "openIdConnectConfig", value);
    }

    /**
     * The OpenID Connect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenIdConnectConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "openIdConnectConfig", value);
    }

    /**
     * The owner contact information for an API resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOwnerContact() {
        return software.amazon.jsii.Kernel.get(this, "ownerContact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The owner contact information for an API resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOwnerContact(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ownerContact", value);
    }

    /**
     * The maximum depth a query can have in a single request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getQueryDepthLimit() {
        return software.amazon.jsii.Kernel.get(this, "queryDepthLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum depth a query can have in a single request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueryDepthLimit(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "queryDepthLimit", value);
    }

    /**
     * The maximum number of resolvers that can be invoked in a single request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getResolverCountLimit() {
        return software.amazon.jsii.Kernel.get(this, "resolverCountLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of resolvers that can be invoked in a single request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResolverCountLimit(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "resolverCountLimit", value);
    }

    /**
     * An arbitrary set of tags (key-value pairs) for this GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An arbitrary set of tags (key-value pairs) for this GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolConfig() {
        return software.amazon.jsii.Kernel.get(this, "userPoolConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "userPoolConfig", value);
    }

    /**
     * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnGraphQLApi.UserPoolConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "userPoolConfig", value);
    }

    /**
     * Sets the scope of the GraphQL API to public ( <code>GLOBAL</code> ) or private ( <code>PRIVATE</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVisibility() {
        return software.amazon.jsii.Kernel.get(this, "visibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Sets the scope of the GraphQL API to public ( <code>GLOBAL</code> ) or private ( <code>PRIVATE</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisibility(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "visibility", value);
    }

    /**
     * A flag indicating whether to use AWS X-Ray tracing for this <code>GraphqlApi</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getXrayEnabled() {
        return software.amazon.jsii.Kernel.get(this, "xrayEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A flag indicating whether to use AWS X-Ray tracing for this <code>GraphqlApi</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setXrayEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "xrayEnabled", value);
    }

    /**
     * A flag indicating whether to use AWS X-Ray tracing for this <code>GraphqlApi</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setXrayEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "xrayEnabled", value);
    }
    /**
     * Describes an additional authentication provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * AdditionalAuthenticationProviderProperty additionalAuthenticationProviderProperty = AdditionalAuthenticationProviderProperty.builder()
     *         .authenticationType("authenticationType")
     *         // the properties below are optional
     *         .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
     *                 .authorizerResultTtlInSeconds(123)
     *                 .authorizerUri("authorizerUri")
     *                 .identityValidationExpression("identityValidationExpression")
     *                 .build())
     *         .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
     *                 .authTtl(123)
     *                 .clientId("clientId")
     *                 .iatTtl(123)
     *                 .issuer("issuer")
     *                 .build())
     *         .userPoolConfig(CognitoUserPoolConfigProperty.builder()
     *                 .appIdClientRegex("appIdClientRegex")
     *                 .awsRegion("awsRegion")
     *                 .userPoolId("userPoolId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.AdditionalAuthenticationProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(AdditionalAuthenticationProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdditionalAuthenticationProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authentication type for API key, AWS Identity and Access Management , OIDC, Amazon Cognito user pools , or AWS Lambda .
         * <p>
         * Valid Values: <code>API_KEY</code> | <code>AWS_IAM</code> | <code>OPENID_CONNECT</code> | <code>AMAZON_COGNITO_USER_POOLS</code> | <code>AWS_LAMBDA</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html#cfn-appsync-graphqlapi-additionalauthenticationprovider-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html#cfn-appsync-graphqlapi-additionalauthenticationprovider-authenticationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType();

        /**
         * Configuration for AWS Lambda function authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html#cfn-appsync-graphqlapi-additionalauthenticationprovider-lambdaauthorizerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html#cfn-appsync-graphqlapi-additionalauthenticationprovider-lambdaauthorizerconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaAuthorizerConfig() {
            return null;
        }

        /**
         * The OIDC configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html#cfn-appsync-graphqlapi-additionalauthenticationprovider-openidconnectconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html#cfn-appsync-graphqlapi-additionalauthenticationprovider-openidconnectconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpenIdConnectConfig() {
            return null;
        }

        /**
         * The Amazon Cognito user pool configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html#cfn-appsync-graphqlapi-additionalauthenticationprovider-userpoolconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html#cfn-appsync-graphqlapi-additionalauthenticationprovider-userpoolconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdditionalAuthenticationProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdditionalAuthenticationProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdditionalAuthenticationProviderProperty> {
            java.lang.String authenticationType;
            java.lang.Object lambdaAuthorizerConfig;
            java.lang.Object openIdConnectConfig;
            java.lang.Object userPoolConfig;

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getAuthenticationType}
             * @param authenticationType The authentication type for API key, AWS Identity and Access Management , OIDC, Amazon Cognito user pools , or AWS Lambda . This parameter is required.
             *                           Valid Values: <code>API_KEY</code> | <code>AWS_IAM</code> | <code>OPENID_CONNECT</code> | <code>AMAZON_COGNITO_USER_POOLS</code> | <code>AWS_LAMBDA</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationType(java.lang.String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getLambdaAuthorizerConfig}
             * @param lambdaAuthorizerConfig Configuration for AWS Lambda function authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaAuthorizerConfig(software.amazon.awscdk.IResolvable lambdaAuthorizerConfig) {
                this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getLambdaAuthorizerConfig}
             * @param lambdaAuthorizerConfig Configuration for AWS Lambda function authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaAuthorizerConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty lambdaAuthorizerConfig) {
                this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getOpenIdConnectConfig}
             * @param openIdConnectConfig The OIDC configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdConnectConfig(software.amazon.awscdk.IResolvable openIdConnectConfig) {
                this.openIdConnectConfig = openIdConnectConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getOpenIdConnectConfig}
             * @param openIdConnectConfig The OIDC configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdConnectConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty openIdConnectConfig) {
                this.openIdConnectConfig = openIdConnectConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getUserPoolConfig}
             * @param userPoolConfig The Amazon Cognito user pool configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolConfig(software.amazon.awscdk.IResolvable userPoolConfig) {
                this.userPoolConfig = userPoolConfig;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalAuthenticationProviderProperty#getUserPoolConfig}
             * @param userPoolConfig The Amazon Cognito user pool configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.CognitoUserPoolConfigProperty userPoolConfig) {
                this.userPoolConfig = userPoolConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdditionalAuthenticationProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdditionalAuthenticationProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdditionalAuthenticationProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdditionalAuthenticationProviderProperty {
            private final java.lang.String authenticationType;
            private final java.lang.Object lambdaAuthorizerConfig;
            private final java.lang.Object openIdConnectConfig;
            private final java.lang.Object userPoolConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lambdaAuthorizerConfig = software.amazon.jsii.Kernel.get(this, "lambdaAuthorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.openIdConnectConfig = software.amazon.jsii.Kernel.get(this, "openIdConnectConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userPoolConfig = software.amazon.jsii.Kernel.get(this, "userPoolConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationType = java.util.Objects.requireNonNull(builder.authenticationType, "authenticationType is required");
                this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
                this.openIdConnectConfig = builder.openIdConnectConfig;
                this.userPoolConfig = builder.userPoolConfig;
            }

            @Override
            public final java.lang.String getAuthenticationType() {
                return this.authenticationType;
            }

            @Override
            public final java.lang.Object getLambdaAuthorizerConfig() {
                return this.lambdaAuthorizerConfig;
            }

            @Override
            public final java.lang.Object getOpenIdConnectConfig() {
                return this.openIdConnectConfig;
            }

            @Override
            public final java.lang.Object getUserPoolConfig() {
                return this.userPoolConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
                if (this.getLambdaAuthorizerConfig() != null) {
                    data.set("lambdaAuthorizerConfig", om.valueToTree(this.getLambdaAuthorizerConfig()));
                }
                if (this.getOpenIdConnectConfig() != null) {
                    data.set("openIdConnectConfig", om.valueToTree(this.getOpenIdConnectConfig()));
                }
                if (this.getUserPoolConfig() != null) {
                    data.set("userPoolConfig", om.valueToTree(this.getUserPoolConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.AdditionalAuthenticationProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdditionalAuthenticationProviderProperty.Jsii$Proxy that = (AdditionalAuthenticationProviderProperty.Jsii$Proxy) o;

                if (!authenticationType.equals(that.authenticationType)) return false;
                if (this.lambdaAuthorizerConfig != null ? !this.lambdaAuthorizerConfig.equals(that.lambdaAuthorizerConfig) : that.lambdaAuthorizerConfig != null) return false;
                if (this.openIdConnectConfig != null ? !this.openIdConnectConfig.equals(that.openIdConnectConfig) : that.openIdConnectConfig != null) return false;
                return this.userPoolConfig != null ? this.userPoolConfig.equals(that.userPoolConfig) : that.userPoolConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationType.hashCode();
                result = 31 * result + (this.lambdaAuthorizerConfig != null ? this.lambdaAuthorizerConfig.hashCode() : 0);
                result = 31 * result + (this.openIdConnectConfig != null ? this.openIdConnectConfig.hashCode() : 0);
                result = 31 * result + (this.userPoolConfig != null ? this.userPoolConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an Amazon Cognito user pool configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * CognitoUserPoolConfigProperty cognitoUserPoolConfigProperty = CognitoUserPoolConfigProperty.builder()
     *         .appIdClientRegex("appIdClientRegex")
     *         .awsRegion("awsRegion")
     *         .userPoolId("userPoolId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.CognitoUserPoolConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoUserPoolConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoUserPoolConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A regular expression for validating the incoming Amazon Cognito user pool app client ID.
         * <p>
         * If this value isn't set, no filtering is applied.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html#cfn-appsync-graphqlapi-cognitouserpoolconfig-appidclientregex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html#cfn-appsync-graphqlapi-cognitouserpoolconfig-appidclientregex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAppIdClientRegex() {
            return null;
        }

        /**
         * The AWS Region in which the user pool was created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html#cfn-appsync-graphqlapi-cognitouserpoolconfig-awsregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html#cfn-appsync-graphqlapi-cognitouserpoolconfig-awsregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsRegion() {
            return null;
        }

        /**
         * The user pool ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html#cfn-appsync-graphqlapi-cognitouserpoolconfig-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html#cfn-appsync-graphqlapi-cognitouserpoolconfig-userpoolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoUserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoUserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoUserPoolConfigProperty> {
            java.lang.String appIdClientRegex;
            java.lang.String awsRegion;
            java.lang.String userPoolId;

            /**
             * Sets the value of {@link CognitoUserPoolConfigProperty#getAppIdClientRegex}
             * @param appIdClientRegex A regular expression for validating the incoming Amazon Cognito user pool app client ID.
             *                         If this value isn't set, no filtering is applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIdClientRegex(java.lang.String appIdClientRegex) {
                this.appIdClientRegex = appIdClientRegex;
                return this;
            }

            /**
             * Sets the value of {@link CognitoUserPoolConfigProperty#getAwsRegion}
             * @param awsRegion The AWS Region in which the user pool was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link CognitoUserPoolConfigProperty#getUserPoolId}
             * @param userPoolId The user pool ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolId(java.lang.String userPoolId) {
                this.userPoolId = userPoolId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoUserPoolConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoUserPoolConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoUserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoUserPoolConfigProperty {
            private final java.lang.String appIdClientRegex;
            private final java.lang.String awsRegion;
            private final java.lang.String userPoolId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appIdClientRegex = software.amazon.jsii.Kernel.get(this, "appIdClientRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appIdClientRegex = builder.appIdClientRegex;
                this.awsRegion = builder.awsRegion;
                this.userPoolId = builder.userPoolId;
            }

            @Override
            public final java.lang.String getAppIdClientRegex() {
                return this.appIdClientRegex;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getUserPoolId() {
                return this.userPoolId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppIdClientRegex() != null) {
                    data.set("appIdClientRegex", om.valueToTree(this.getAppIdClientRegex()));
                }
                if (this.getAwsRegion() != null) {
                    data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                }
                if (this.getUserPoolId() != null) {
                    data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.CognitoUserPoolConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoUserPoolConfigProperty.Jsii$Proxy that = (CognitoUserPoolConfigProperty.Jsii$Proxy) o;

                if (this.appIdClientRegex != null ? !this.appIdClientRegex.equals(that.appIdClientRegex) : that.appIdClientRegex != null) return false;
                if (this.awsRegion != null ? !this.awsRegion.equals(that.awsRegion) : that.awsRegion != null) return false;
                return this.userPoolId != null ? this.userPoolId.equals(that.userPoolId) : that.userPoolId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appIdClientRegex != null ? this.appIdClientRegex.hashCode() : 0;
                result = 31 * result + (this.awsRegion != null ? this.awsRegion.hashCode() : 0);
                result = 31 * result + (this.userPoolId != null ? this.userPoolId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an enhanced metrics configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * EnhancedMetricsConfigProperty enhancedMetricsConfigProperty = EnhancedMetricsConfigProperty.builder()
     *         .dataSourceLevelMetricsBehavior("dataSourceLevelMetricsBehavior")
     *         .operationLevelMetricsConfig("operationLevelMetricsConfig")
     *         .resolverLevelMetricsBehavior("resolverLevelMetricsBehavior")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-enhancedmetricsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-enhancedmetricsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.EnhancedMetricsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EnhancedMetricsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnhancedMetricsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:.
         * <p>
         * <ul>
         * <li><em>Requests</em> : The number of invocations that occured during a request.</li>
         * <li><em>Latency</em> : The time to complete a data source invocation.</li>
         * <li><em>Errors</em> : The number of errors that occurred during a data source invocation.</li>
         * </ul>
         * <p>
         * These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics will be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code> accepts one of these values at a time:
         * <p>
         * <ul>
         * <li><code>FULL_REQUEST_DATA_SOURCE_METRICS</code> : Records and emits metric data for all data sources in the request.</li>
         * <li><code>PER_DATA_SOURCE_METRICS</code> : Records and emits metric data for data sources that have the <code>MetricsConfig</code> value set to <code>ENABLED</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-enhancedmetricsconfig.html#cfn-appsync-graphqlapi-enhancedmetricsconfig-datasourcelevelmetricsbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-enhancedmetricsconfig.html#cfn-appsync-graphqlapi-enhancedmetricsconfig-datasourcelevelmetricsbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceLevelMetricsBehavior();

        /**
         * Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:.
         * <p>
         * <ul>
         * <li><em>Requests</em> : The number of times a specified GraphQL operation was called.</li>
         * <li><em>GraphQL errors</em> : The number of GraphQL errors that occurred during a specified GraphQL operation.</li>
         * </ul>
         * <p>
         * Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code> or <code>DISABLED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-enhancedmetricsconfig.html#cfn-appsync-graphqlapi-enhancedmetricsconfig-operationlevelmetricsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-enhancedmetricsconfig.html#cfn-appsync-graphqlapi-enhancedmetricsconfig-operationlevelmetricsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperationLevelMetricsConfig();

        /**
         * Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:.
         * <p>
         * <ul>
         * <li><em>GraphQL errors</em> : The number of GraphQL errors that occurred.</li>
         * <li><em>Requests</em> : The number of invocations that occurred during a request.</li>
         * <li><em>Latency</em> : The time to complete a resolver invocation.</li>
         * <li><em>Cache hits</em> : The number of cache hits during a request.</li>
         * <li><em>Cache misses</em> : The number of cache misses during a request.</li>
         * </ul>
         * <p>
         * These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of these values at a time:
         * <p>
         * <ul>
         * <li><code>FULL_REQUEST_RESOLVER_METRICS</code> : Records and emits metric data for all resolvers in the request.</li>
         * <li><code>PER_RESOLVER_METRICS</code> : Records and emits metric data for resolvers that have the <code>MetricsConfig</code> value set to <code>ENABLED</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-enhancedmetricsconfig.html#cfn-appsync-graphqlapi-enhancedmetricsconfig-resolverlevelmetricsbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-enhancedmetricsconfig.html#cfn-appsync-graphqlapi-enhancedmetricsconfig-resolverlevelmetricsbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResolverLevelMetricsBehavior();

        /**
         * @return a {@link Builder} of {@link EnhancedMetricsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnhancedMetricsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnhancedMetricsConfigProperty> {
            java.lang.String dataSourceLevelMetricsBehavior;
            java.lang.String operationLevelMetricsConfig;
            java.lang.String resolverLevelMetricsBehavior;

            /**
             * Sets the value of {@link EnhancedMetricsConfigProperty#getDataSourceLevelMetricsBehavior}
             * @param dataSourceLevelMetricsBehavior Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:. This parameter is required.
             *                                       <ul>
             *                                       <li><em>Requests</em> : The number of invocations that occured during a request.</li>
             *                                       <li><em>Latency</em> : The time to complete a data source invocation.</li>
             *                                       <li><em>Errors</em> : The number of errors that occurred during a data source invocation.</li>
             *                                       </ul>
             *                                       <p>
             *                                       These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics will be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code> accepts one of these values at a time:
             *                                       <p>
             *                                       <ul>
             *                                       <li><code>FULL_REQUEST_DATA_SOURCE_METRICS</code> : Records and emits metric data for all data sources in the request.</li>
             *                                       <li><code>PER_DATA_SOURCE_METRICS</code> : Records and emits metric data for data sources that have the <code>MetricsConfig</code> value set to <code>ENABLED</code> .</li>
             *                                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceLevelMetricsBehavior(java.lang.String dataSourceLevelMetricsBehavior) {
                this.dataSourceLevelMetricsBehavior = dataSourceLevelMetricsBehavior;
                return this;
            }

            /**
             * Sets the value of {@link EnhancedMetricsConfigProperty#getOperationLevelMetricsConfig}
             * @param operationLevelMetricsConfig Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:. This parameter is required.
             *                                    <ul>
             *                                    <li><em>Requests</em> : The number of times a specified GraphQL operation was called.</li>
             *                                    <li><em>GraphQL errors</em> : The number of GraphQL errors that occurred during a specified GraphQL operation.</li>
             *                                    </ul>
             *                                    <p>
             *                                    Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code> or <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operationLevelMetricsConfig(java.lang.String operationLevelMetricsConfig) {
                this.operationLevelMetricsConfig = operationLevelMetricsConfig;
                return this;
            }

            /**
             * Sets the value of {@link EnhancedMetricsConfigProperty#getResolverLevelMetricsBehavior}
             * @param resolverLevelMetricsBehavior Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:. This parameter is required.
             *                                     <ul>
             *                                     <li><em>GraphQL errors</em> : The number of GraphQL errors that occurred.</li>
             *                                     <li><em>Requests</em> : The number of invocations that occurred during a request.</li>
             *                                     <li><em>Latency</em> : The time to complete a resolver invocation.</li>
             *                                     <li><em>Cache hits</em> : The number of cache hits during a request.</li>
             *                                     <li><em>Cache misses</em> : The number of cache misses during a request.</li>
             *                                     </ul>
             *                                     <p>
             *                                     These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of these values at a time:
             *                                     <p>
             *                                     <ul>
             *                                     <li><code>FULL_REQUEST_RESOLVER_METRICS</code> : Records and emits metric data for all resolvers in the request.</li>
             *                                     <li><code>PER_RESOLVER_METRICS</code> : Records and emits metric data for resolvers that have the <code>MetricsConfig</code> value set to <code>ENABLED</code> .</li>
             *                                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resolverLevelMetricsBehavior(java.lang.String resolverLevelMetricsBehavior) {
                this.resolverLevelMetricsBehavior = resolverLevelMetricsBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnhancedMetricsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnhancedMetricsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnhancedMetricsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnhancedMetricsConfigProperty {
            private final java.lang.String dataSourceLevelMetricsBehavior;
            private final java.lang.String operationLevelMetricsConfig;
            private final java.lang.String resolverLevelMetricsBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceLevelMetricsBehavior = software.amazon.jsii.Kernel.get(this, "dataSourceLevelMetricsBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operationLevelMetricsConfig = software.amazon.jsii.Kernel.get(this, "operationLevelMetricsConfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resolverLevelMetricsBehavior = software.amazon.jsii.Kernel.get(this, "resolverLevelMetricsBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceLevelMetricsBehavior = java.util.Objects.requireNonNull(builder.dataSourceLevelMetricsBehavior, "dataSourceLevelMetricsBehavior is required");
                this.operationLevelMetricsConfig = java.util.Objects.requireNonNull(builder.operationLevelMetricsConfig, "operationLevelMetricsConfig is required");
                this.resolverLevelMetricsBehavior = java.util.Objects.requireNonNull(builder.resolverLevelMetricsBehavior, "resolverLevelMetricsBehavior is required");
            }

            @Override
            public final java.lang.String getDataSourceLevelMetricsBehavior() {
                return this.dataSourceLevelMetricsBehavior;
            }

            @Override
            public final java.lang.String getOperationLevelMetricsConfig() {
                return this.operationLevelMetricsConfig;
            }

            @Override
            public final java.lang.String getResolverLevelMetricsBehavior() {
                return this.resolverLevelMetricsBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceLevelMetricsBehavior", om.valueToTree(this.getDataSourceLevelMetricsBehavior()));
                data.set("operationLevelMetricsConfig", om.valueToTree(this.getOperationLevelMetricsConfig()));
                data.set("resolverLevelMetricsBehavior", om.valueToTree(this.getResolverLevelMetricsBehavior()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.EnhancedMetricsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnhancedMetricsConfigProperty.Jsii$Proxy that = (EnhancedMetricsConfigProperty.Jsii$Proxy) o;

                if (!dataSourceLevelMetricsBehavior.equals(that.dataSourceLevelMetricsBehavior)) return false;
                if (!operationLevelMetricsConfig.equals(that.operationLevelMetricsConfig)) return false;
                return this.resolverLevelMetricsBehavior.equals(that.resolverLevelMetricsBehavior);
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceLevelMetricsBehavior.hashCode();
                result = 31 * result + (this.operationLevelMetricsConfig.hashCode());
                result = 31 * result + (this.resolverLevelMetricsBehavior.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration for AWS Lambda function authorization.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * LambdaAuthorizerConfigProperty lambdaAuthorizerConfigProperty = LambdaAuthorizerConfigProperty.builder()
     *         .authorizerResultTtlInSeconds(123)
     *         .authorizerUri("authorizerUri")
     *         .identityValidationExpression("identityValidationExpression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-lambdaauthorizerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-lambdaauthorizerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaAuthorizerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaAuthorizerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of seconds a response should be cached for.
         * <p>
         * The default is 0 seconds, which disables caching. If you don't specify a value for <code>authorizerResultTtlInSeconds</code> , the default value is used. The maximum value is one hour (3600 seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key in its response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-lambdaauthorizerconfig.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig-authorizerresultttlinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-lambdaauthorizerconfig.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig-authorizerresultttlinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAuthorizerResultTtlInSeconds() {
            return null;
        }

        /**
         * The ARN of the Lambda function to be called for authorization.
         * <p>
         * This may be a standard Lambda ARN, a version ARN ( <code>.../v3</code> ) or alias ARN.
         * <p>
         * <em>Note</em> : This Lambda function must have the following resource-based policy assigned to it. When configuring Lambda authorizers in the console, this is done for you. To do so with the AWS CLI , run the following:
         * <p>
         * <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-lambdaauthorizerconfig.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig-authorizeruri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-lambdaauthorizerconfig.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig-authorizeruri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerUri() {
            return null;
        }

        /**
         * A regular expression for validation of tokens before the Lambda function is called.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-lambdaauthorizerconfig.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig-identityvalidationexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-lambdaauthorizerconfig.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig-identityvalidationexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityValidationExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaAuthorizerConfigProperty> {
            java.lang.Number authorizerResultTtlInSeconds;
            java.lang.String authorizerUri;
            java.lang.String identityValidationExpression;

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getAuthorizerResultTtlInSeconds}
             * @param authorizerResultTtlInSeconds The number of seconds a response should be cached for.
             *                                     The default is 0 seconds, which disables caching. If you don't specify a value for <code>authorizerResultTtlInSeconds</code> , the default value is used. The maximum value is one hour (3600 seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key in its response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizerResultTtlInSeconds(java.lang.Number authorizerResultTtlInSeconds) {
                this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getAuthorizerUri}
             * @param authorizerUri The ARN of the Lambda function to be called for authorization.
             *                      This may be a standard Lambda ARN, a version ARN ( <code>.../v3</code> ) or alias ARN.
             *                      <p>
             *                      <em>Note</em> : This Lambda function must have the following resource-based policy assigned to it. When configuring Lambda authorizers in the console, this is done for you. To do so with the AWS CLI , run the following:
             *                      <p>
             *                      <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizerUri(java.lang.String authorizerUri) {
                this.authorizerUri = authorizerUri;
                return this;
            }

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getIdentityValidationExpression}
             * @param identityValidationExpression A regular expression for validation of tokens before the Lambda function is called.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityValidationExpression(java.lang.String identityValidationExpression) {
                this.identityValidationExpression = identityValidationExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaAuthorizerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaAuthorizerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaAuthorizerConfigProperty {
            private final java.lang.Number authorizerResultTtlInSeconds;
            private final java.lang.String authorizerUri;
            private final java.lang.String identityValidationExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizerResultTtlInSeconds = software.amazon.jsii.Kernel.get(this, "authorizerResultTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.authorizerUri = software.amazon.jsii.Kernel.get(this, "authorizerUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identityValidationExpression = software.amazon.jsii.Kernel.get(this, "identityValidationExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizerResultTtlInSeconds = builder.authorizerResultTtlInSeconds;
                this.authorizerUri = builder.authorizerUri;
                this.identityValidationExpression = builder.identityValidationExpression;
            }

            @Override
            public final java.lang.Number getAuthorizerResultTtlInSeconds() {
                return this.authorizerResultTtlInSeconds;
            }

            @Override
            public final java.lang.String getAuthorizerUri() {
                return this.authorizerUri;
            }

            @Override
            public final java.lang.String getIdentityValidationExpression() {
                return this.identityValidationExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthorizerResultTtlInSeconds() != null) {
                    data.set("authorizerResultTtlInSeconds", om.valueToTree(this.getAuthorizerResultTtlInSeconds()));
                }
                if (this.getAuthorizerUri() != null) {
                    data.set("authorizerUri", om.valueToTree(this.getAuthorizerUri()));
                }
                if (this.getIdentityValidationExpression() != null) {
                    data.set("identityValidationExpression", om.valueToTree(this.getIdentityValidationExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaAuthorizerConfigProperty.Jsii$Proxy that = (LambdaAuthorizerConfigProperty.Jsii$Proxy) o;

                if (this.authorizerResultTtlInSeconds != null ? !this.authorizerResultTtlInSeconds.equals(that.authorizerResultTtlInSeconds) : that.authorizerResultTtlInSeconds != null) return false;
                if (this.authorizerUri != null ? !this.authorizerUri.equals(that.authorizerUri) : that.authorizerUri != null) return false;
                return this.identityValidationExpression != null ? this.identityValidationExpression.equals(that.identityValidationExpression) : that.identityValidationExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizerResultTtlInSeconds != null ? this.authorizerResultTtlInSeconds.hashCode() : 0;
                result = 31 * result + (this.authorizerUri != null ? this.authorizerUri.hashCode() : 0);
                result = 31 * result + (this.identityValidationExpression != null ? this.identityValidationExpression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>LogConfig</code> property type specifies the logging configuration when writing GraphQL operations and tracing to Amazon CloudWatch for an AWS AppSync GraphQL API.
     * <p>
     * <code>LogConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html">AWS::AppSync::GraphQLApi</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * LogConfigProperty logConfigProperty = LogConfigProperty.builder()
     *         .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
     *         .excludeVerboseContent(false)
     *         .fieldLogLevel("fieldLogLevel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.LogConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LogConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The service role that AWS AppSync will assume to publish to Amazon CloudWatch Logs in your account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html#cfn-appsync-graphqlapi-logconfig-cloudwatchlogsrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html#cfn-appsync-graphqlapi-logconfig-cloudwatchlogsrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsRoleArn() {
            return null;
        }

        /**
         * Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html#cfn-appsync-graphqlapi-logconfig-excludeverbosecontent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html#cfn-appsync-graphqlapi-logconfig-excludeverbosecontent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeVerboseContent() {
            return null;
        }

        /**
         * The field logging level. Values can be NONE, ERROR, INFO, DEBUG, or ALL.
         * <p>
         * <ul>
         * <li><em>NONE</em> : No field-level logs are captured.</li>
         * <li><em>ERROR</em> : Logs the following information <em>only</em> for the fields that are in the error category:</li>
         * <li>The error section in the server response.</li>
         * <li>Field-level errors.</li>
         * <li>The generated request/response functions that got resolved for error fields.</li>
         * <li><em>INFO</em> : Logs the following information <em>only</em> for the fields that are in the info and error categories:</li>
         * <li>Info-level messages.</li>
         * <li>The user messages sent through <code>$util.log.info</code> and <code>console.log</code> .</li>
         * <li>Field-level tracing and mapping logs are not shown.</li>
         * <li><em>DEBUG</em> : Logs the following information <em>only</em> for the fields that are in the debug, info, and error categories:</li>
         * <li>Debug-level messages.</li>
         * <li>The user messages sent through <code>$util.log.info</code> , <code>$util.log.debug</code> , <code>console.log</code> , and <code>console.debug</code> .</li>
         * <li>Field-level tracing and mapping logs are not shown.</li>
         * <li><em>ALL</em> : The following information is logged for all fields in the query:</li>
         * <li>Field-level tracing information.</li>
         * <li>The generated request/response functions that were resolved for each field.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html#cfn-appsync-graphqlapi-logconfig-fieldloglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html#cfn-appsync-graphqlapi-logconfig-fieldloglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldLogLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogConfigProperty> {
            java.lang.String cloudWatchLogsRoleArn;
            java.lang.Object excludeVerboseContent;
            java.lang.String fieldLogLevel;

            /**
             * Sets the value of {@link LogConfigProperty#getCloudWatchLogsRoleArn}
             * @param cloudWatchLogsRoleArn The service role that AWS AppSync will assume to publish to Amazon CloudWatch Logs in your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsRoleArn(java.lang.String cloudWatchLogsRoleArn) {
                this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigProperty#getExcludeVerboseContent}
             * @param excludeVerboseContent Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeVerboseContent(java.lang.Boolean excludeVerboseContent) {
                this.excludeVerboseContent = excludeVerboseContent;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigProperty#getExcludeVerboseContent}
             * @param excludeVerboseContent Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeVerboseContent(software.amazon.awscdk.IResolvable excludeVerboseContent) {
                this.excludeVerboseContent = excludeVerboseContent;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigProperty#getFieldLogLevel}
             * @param fieldLogLevel The field logging level. Values can be NONE, ERROR, INFO, DEBUG, or ALL.
             *                      <ul>
             *                      <li><em>NONE</em> : No field-level logs are captured.</li>
             *                      <li><em>ERROR</em> : Logs the following information <em>only</em> for the fields that are in the error category:</li>
             *                      <li>The error section in the server response.</li>
             *                      <li>Field-level errors.</li>
             *                      <li>The generated request/response functions that got resolved for error fields.</li>
             *                      <li><em>INFO</em> : Logs the following information <em>only</em> for the fields that are in the info and error categories:</li>
             *                      <li>Info-level messages.</li>
             *                      <li>The user messages sent through <code>$util.log.info</code> and <code>console.log</code> .</li>
             *                      <li>Field-level tracing and mapping logs are not shown.</li>
             *                      <li><em>DEBUG</em> : Logs the following information <em>only</em> for the fields that are in the debug, info, and error categories:</li>
             *                      <li>Debug-level messages.</li>
             *                      <li>The user messages sent through <code>$util.log.info</code> , <code>$util.log.debug</code> , <code>console.log</code> , and <code>console.debug</code> .</li>
             *                      <li>Field-level tracing and mapping logs are not shown.</li>
             *                      <li><em>ALL</em> : The following information is logged for all fields in the query:</li>
             *                      <li>Field-level tracing information.</li>
             *                      <li>The generated request/response functions that were resolved for each field.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldLogLevel(java.lang.String fieldLogLevel) {
                this.fieldLogLevel = fieldLogLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfigProperty {
            private final java.lang.String cloudWatchLogsRoleArn;
            private final java.lang.Object excludeVerboseContent;
            private final java.lang.String fieldLogLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsRoleArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeVerboseContent = software.amazon.jsii.Kernel.get(this, "excludeVerboseContent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fieldLogLevel = software.amazon.jsii.Kernel.get(this, "fieldLogLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
                this.excludeVerboseContent = builder.excludeVerboseContent;
                this.fieldLogLevel = builder.fieldLogLevel;
            }

            @Override
            public final java.lang.String getCloudWatchLogsRoleArn() {
                return this.cloudWatchLogsRoleArn;
            }

            @Override
            public final java.lang.Object getExcludeVerboseContent() {
                return this.excludeVerboseContent;
            }

            @Override
            public final java.lang.String getFieldLogLevel() {
                return this.fieldLogLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogsRoleArn() != null) {
                    data.set("cloudWatchLogsRoleArn", om.valueToTree(this.getCloudWatchLogsRoleArn()));
                }
                if (this.getExcludeVerboseContent() != null) {
                    data.set("excludeVerboseContent", om.valueToTree(this.getExcludeVerboseContent()));
                }
                if (this.getFieldLogLevel() != null) {
                    data.set("fieldLogLevel", om.valueToTree(this.getFieldLogLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.LogConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogConfigProperty.Jsii$Proxy that = (LogConfigProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogsRoleArn != null ? !this.cloudWatchLogsRoleArn.equals(that.cloudWatchLogsRoleArn) : that.cloudWatchLogsRoleArn != null) return false;
                if (this.excludeVerboseContent != null ? !this.excludeVerboseContent.equals(that.excludeVerboseContent) : that.excludeVerboseContent != null) return false;
                return this.fieldLogLevel != null ? this.fieldLogLevel.equals(that.fieldLogLevel) : that.fieldLogLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogsRoleArn != null ? this.cloudWatchLogsRoleArn.hashCode() : 0;
                result = 31 * result + (this.excludeVerboseContent != null ? this.excludeVerboseContent.hashCode() : 0);
                result = 31 * result + (this.fieldLogLevel != null ? this.fieldLogLevel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>OpenIDConnectConfig</code> property type specifies the optional authorization configuration for using an OpenID Connect compliant service with your GraphQL endpoint for an AWS AppSync GraphQL API.
     * <p>
     * <code>OpenIDConnectConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html">AWS::AppSync::GraphQLApi</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * OpenIDConnectConfigProperty openIDConnectConfigProperty = OpenIDConnectConfigProperty.builder()
     *         .authTtl(123)
     *         .clientId("clientId")
     *         .iatTtl(123)
     *         .issuer("issuer")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.OpenIDConnectConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenIDConnectConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenIDConnectConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of milliseconds that a token is valid after being authenticated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-authttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-authttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAuthTtl() {
            return null;
        }

        /**
         * The client identifier of the Relying party at the OpenID identity provider.
         * <p>
         * This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so that AWS AppSync can validate against multiple client identifiers at a time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
            return null;
        }

        /**
         * The number of milliseconds that a token is valid after it's issued to a user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-iatttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-iatttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIatTtl() {
            return null;
        }

        /**
         * The issuer for the OIDC configuration.
         * <p>
         * The issuer returned by discovery must exactly match the value of <code>iss</code> in the ID token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-issuer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-issuer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIssuer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenIDConnectConfigProperty> {
            java.lang.Number authTtl;
            java.lang.String clientId;
            java.lang.Number iatTtl;
            java.lang.String issuer;

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getAuthTtl}
             * @param authTtl The number of milliseconds that a token is valid after being authenticated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authTtl(java.lang.Number authTtl) {
                this.authTtl = authTtl;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getClientId}
             * @param clientId The client identifier of the Relying party at the OpenID identity provider.
             *                 This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so that AWS AppSync can validate against multiple client identifiers at a time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getIatTtl}
             * @param iatTtl The number of milliseconds that a token is valid after it's issued to a user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iatTtl(java.lang.Number iatTtl) {
                this.iatTtl = iatTtl;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getIssuer}
             * @param issuer The issuer for the OIDC configuration.
             *               The issuer returned by discovery must exactly match the value of <code>iss</code> in the ID token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenIDConnectConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenIDConnectConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenIDConnectConfigProperty {
            private final java.lang.Number authTtl;
            private final java.lang.String clientId;
            private final java.lang.Number iatTtl;
            private final java.lang.String issuer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authTtl = software.amazon.jsii.Kernel.get(this, "authTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iatTtl = software.amazon.jsii.Kernel.get(this, "iatTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.issuer = software.amazon.jsii.Kernel.get(this, "issuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authTtl = builder.authTtl;
                this.clientId = builder.clientId;
                this.iatTtl = builder.iatTtl;
                this.issuer = builder.issuer;
            }

            @Override
            public final java.lang.Number getAuthTtl() {
                return this.authTtl;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.Number getIatTtl() {
                return this.iatTtl;
            }

            @Override
            public final java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthTtl() != null) {
                    data.set("authTtl", om.valueToTree(this.getAuthTtl()));
                }
                if (this.getClientId() != null) {
                    data.set("clientId", om.valueToTree(this.getClientId()));
                }
                if (this.getIatTtl() != null) {
                    data.set("iatTtl", om.valueToTree(this.getIatTtl()));
                }
                if (this.getIssuer() != null) {
                    data.set("issuer", om.valueToTree(this.getIssuer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.OpenIDConnectConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenIDConnectConfigProperty.Jsii$Proxy that = (OpenIDConnectConfigProperty.Jsii$Proxy) o;

                if (this.authTtl != null ? !this.authTtl.equals(that.authTtl) : that.authTtl != null) return false;
                if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) return false;
                if (this.iatTtl != null ? !this.iatTtl.equals(that.iatTtl) : that.iatTtl != null) return false;
                return this.issuer != null ? this.issuer.equals(that.issuer) : that.issuer == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authTtl != null ? this.authTtl.hashCode() : 0;
                result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
                result = 31 * result + (this.iatTtl != null ? this.iatTtl.hashCode() : 0);
                result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>UserPoolConfig</code> property type specifies the optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint for an AWS AppSync GraphQL API.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * UserPoolConfigProperty userPoolConfigProperty = UserPoolConfigProperty.builder()
     *         .appIdClientRegex("appIdClientRegex")
     *         .awsRegion("awsRegion")
     *         .defaultAction("defaultAction")
     *         .userPoolId("userPoolId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApi.UserPoolConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(UserPoolConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserPoolConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A regular expression for validating the incoming Amazon Cognito user pool app client ID.
         * <p>
         * If this value isn't set, no filtering is applied.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-appidclientregex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-appidclientregex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAppIdClientRegex() {
            return null;
        }

        /**
         * The AWS Region in which the user pool was created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-awsregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-awsregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsRegion() {
            return null;
        }

        /**
         * The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool configuration.
         * <p>
         * When specifying Amazon Cognito user pools as the default authentication, you must set the value for <code>DefaultAction</code> to <code>ALLOW</code> if specifying <code>AdditionalAuthenticationProviders</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-defaultaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-defaultaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultAction() {
            return null;
        }

        /**
         * The user pool ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-userpoolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserPoolConfigProperty> {
            java.lang.String appIdClientRegex;
            java.lang.String awsRegion;
            java.lang.String defaultAction;
            java.lang.String userPoolId;

            /**
             * Sets the value of {@link UserPoolConfigProperty#getAppIdClientRegex}
             * @param appIdClientRegex A regular expression for validating the incoming Amazon Cognito user pool app client ID.
             *                         If this value isn't set, no filtering is applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIdClientRegex(java.lang.String appIdClientRegex) {
                this.appIdClientRegex = appIdClientRegex;
                return this;
            }

            /**
             * Sets the value of {@link UserPoolConfigProperty#getAwsRegion}
             * @param awsRegion The AWS Region in which the user pool was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link UserPoolConfigProperty#getDefaultAction}
             * @param defaultAction The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn't match the Amazon Cognito user pool configuration.
             *                      When specifying Amazon Cognito user pools as the default authentication, you must set the value for <code>DefaultAction</code> to <code>ALLOW</code> if specifying <code>AdditionalAuthenticationProviders</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultAction(java.lang.String defaultAction) {
                this.defaultAction = defaultAction;
                return this;
            }

            /**
             * Sets the value of {@link UserPoolConfigProperty#getUserPoolId}
             * @param userPoolId The user pool ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolId(java.lang.String userPoolId) {
                this.userPoolId = userPoolId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserPoolConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserPoolConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserPoolConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolConfigProperty {
            private final java.lang.String appIdClientRegex;
            private final java.lang.String awsRegion;
            private final java.lang.String defaultAction;
            private final java.lang.String userPoolId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appIdClientRegex = software.amazon.jsii.Kernel.get(this, "appIdClientRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultAction = software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appIdClientRegex = builder.appIdClientRegex;
                this.awsRegion = builder.awsRegion;
                this.defaultAction = builder.defaultAction;
                this.userPoolId = builder.userPoolId;
            }

            @Override
            public final java.lang.String getAppIdClientRegex() {
                return this.appIdClientRegex;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getDefaultAction() {
                return this.defaultAction;
            }

            @Override
            public final java.lang.String getUserPoolId() {
                return this.userPoolId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppIdClientRegex() != null) {
                    data.set("appIdClientRegex", om.valueToTree(this.getAppIdClientRegex()));
                }
                if (this.getAwsRegion() != null) {
                    data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                }
                if (this.getDefaultAction() != null) {
                    data.set("defaultAction", om.valueToTree(this.getDefaultAction()));
                }
                if (this.getUserPoolId() != null) {
                    data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApi.UserPoolConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserPoolConfigProperty.Jsii$Proxy that = (UserPoolConfigProperty.Jsii$Proxy) o;

                if (this.appIdClientRegex != null ? !this.appIdClientRegex.equals(that.appIdClientRegex) : that.appIdClientRegex != null) return false;
                if (this.awsRegion != null ? !this.awsRegion.equals(that.awsRegion) : that.awsRegion != null) return false;
                if (this.defaultAction != null ? !this.defaultAction.equals(that.defaultAction) : that.defaultAction != null) return false;
                return this.userPoolId != null ? this.userPoolId.equals(that.userPoolId) : that.userPoolId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appIdClientRegex != null ? this.appIdClientRegex.hashCode() : 0;
                result = 31 * result + (this.awsRegion != null ? this.awsRegion.hashCode() : 0);
                result = 31 * result + (this.defaultAction != null ? this.defaultAction.hashCode() : 0);
                result = 31 * result + (this.userPoolId != null ? this.userPoolId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.CfnGraphQLApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.CfnGraphQLApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.CfnGraphQLApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.CfnGraphQLApiProps.Builder();
        }

        /**
         * Security configuration for your GraphQL API.
         * <p>
         * For allowed values (such as <code>API_KEY</code> , <code>AWS_IAM</code> , <code>AMAZON_COGNITO_USER_POOLS</code> , <code>OPENID_CONNECT</code> , or <code>AWS_LAMBDA</code> ), see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/security.html">Security</a> in the <em>AWS AppSync Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-authenticationtype</a>
         * @param authenticationType Security configuration for your GraphQL API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(final java.lang.String authenticationType) {
            this.props.authenticationType(authenticationType);
            return this;
        }

        /**
         * The API name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-name</a>
         * @param name The API name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-additionalauthenticationproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-additionalauthenticationproviders</a>
         * @param additionalAuthenticationProviders A list of additional authentication providers for the <code>GraphqlApi</code> API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalAuthenticationProviders(final software.amazon.awscdk.IResolvable additionalAuthenticationProviders) {
            this.props.additionalAuthenticationProviders(additionalAuthenticationProviders);
            return this;
        }
        /**
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-additionalauthenticationproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-additionalauthenticationproviders</a>
         * @param additionalAuthenticationProviders A list of additional authentication providers for the <code>GraphqlApi</code> API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalAuthenticationProviders(final java.util.List<? extends java.lang.Object> additionalAuthenticationProviders) {
            this.props.additionalAuthenticationProviders(additionalAuthenticationProviders);
            return this;
        }

        /**
         * The value that indicates whether the GraphQL API is a standard API ( <code>GRAPHQL</code> ) or merged API ( <code>MERGED</code> ).
         * <p>
         * <em>WARNING</em> : If the <code>ApiType</code> has not been defined, <em>explicitly</em> setting it to <code>GRAPHQL</code> in a template/stack update will result in an API replacement and new DNS values.
         * <p>
         * The following values are valid:
         * <p>
         * <code>GRAPHQL | MERGED</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-apitype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-apitype</a>
         * @param apiType The value that indicates whether the GraphQL API is a standard API ( <code>GRAPHQL</code> ) or merged API ( <code>MERGED</code> ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiType(final java.lang.String apiType) {
            this.props.apiType(apiType);
            return this;
        }

        /**
         * Enables and controls the enhanced metrics feature.
         * <p>
         * Enhanced metrics emit granular data on API usage and performance such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your CloudWatch account, and you can configure the types of data that will be sent.
         * <p>
         * Enhanced metrics can be configured at the resolver, data source, and operation levels. For more information, see <a href="https://docs.aws.amazon.com//appsync/latest/devguide/monitoring.html#cw-metrics">Monitoring and logging</a> in the <em>AWS AppSync User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-enhancedmetricsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-enhancedmetricsconfig</a>
         * @param enhancedMetricsConfig Enables and controls the enhanced metrics feature. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedMetricsConfig(final software.amazon.awscdk.IResolvable enhancedMetricsConfig) {
            this.props.enhancedMetricsConfig(enhancedMetricsConfig);
            return this;
        }
        /**
         * Enables and controls the enhanced metrics feature.
         * <p>
         * Enhanced metrics emit granular data on API usage and performance such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your CloudWatch account, and you can configure the types of data that will be sent.
         * <p>
         * Enhanced metrics can be configured at the resolver, data source, and operation levels. For more information, see <a href="https://docs.aws.amazon.com//appsync/latest/devguide/monitoring.html#cw-metrics">Monitoring and logging</a> in the <em>AWS AppSync User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-enhancedmetricsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-enhancedmetricsconfig</a>
         * @param enhancedMetricsConfig Enables and controls the enhanced metrics feature. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedMetricsConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.EnhancedMetricsConfigProperty enhancedMetricsConfig) {
            this.props.enhancedMetricsConfig(enhancedMetricsConfig);
            return this;
        }

        /**
         * A map containing the list of resources with their properties and environment variables.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/environmental-variables.html">Environmental variables</a> .
         * <p>
         * <em>Pattern</em> : <code>^[A-Za-z]+\\w*$\\</code>
         * <p>
         * <em>Minimum</em> : 2
         * <p>
         * <em>Maximum</em> : 64
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-environmentvariables</a>
         * @param environmentVariables A map containing the list of resources with their properties and environment variables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(final java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }
        /**
         * A map containing the list of resources with their properties and environment variables.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/environmental-variables.html">Environmental variables</a> .
         * <p>
         * <em>Pattern</em> : <code>^[A-Za-z]+\\w*$\\</code>
         * <p>
         * <em>Minimum</em> : 2
         * <p>
         * <em>Maximum</em> : 64
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-environmentvariables</a>
         * @param environmentVariables A map containing the list of resources with their properties and environment variables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(final software.amazon.awscdk.IResolvable environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        /**
         * Sets the value of the GraphQL API to enable ( <code>ENABLED</code> ) or disable ( <code>DISABLED</code> ) introspection.
         * <p>
         * If no value is provided, the introspection configuration will be set to <code>ENABLED</code> by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.
         * <p>
         * For more information about introspection, see <a href="https://docs.aws.amazon.com/https://graphql.org/learn/introspection/">GraphQL introspection</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-introspectionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-introspectionconfig</a>
         * @param introspectionConfig Sets the value of the GraphQL API to enable ( <code>ENABLED</code> ) or disable ( <code>DISABLED</code> ) introspection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder introspectionConfig(final java.lang.String introspectionConfig) {
            this.props.introspectionConfig(introspectionConfig);
            return this;
        }

        /**
         * A <code>LambdaAuthorizerConfig</code> holds configuration on how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
         * <p>
         * Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig</a>
         * @param lambdaAuthorizerConfig A <code>LambdaAuthorizerConfig</code> holds configuration on how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(final software.amazon.awscdk.IResolvable lambdaAuthorizerConfig) {
            this.props.lambdaAuthorizerConfig(lambdaAuthorizerConfig);
            return this;
        }
        /**
         * A <code>LambdaAuthorizerConfig</code> holds configuration on how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
         * <p>
         * Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig</a>
         * @param lambdaAuthorizerConfig A <code>LambdaAuthorizerConfig</code> holds configuration on how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty lambdaAuthorizerConfig) {
            this.props.lambdaAuthorizerConfig(lambdaAuthorizerConfig);
            return this;
        }

        /**
         * The Amazon CloudWatch Logs configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-logconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-logconfig</a>
         * @param logConfig The Amazon CloudWatch Logs configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(final software.amazon.awscdk.IResolvable logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }
        /**
         * The Amazon CloudWatch Logs configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-logconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-logconfig</a>
         * @param logConfig The Amazon CloudWatch Logs configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.LogConfigProperty logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }

        /**
         * The AWS Identity and Access Management service role ARN for a merged API.
         * <p>
         * The AppSync service assumes this role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-mergedapiexecutionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-mergedapiexecutionrolearn</a>
         * @param mergedApiExecutionRoleArn The AWS Identity and Access Management service role ARN for a merged API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mergedApiExecutionRoleArn(final java.lang.String mergedApiExecutionRoleArn) {
            this.props.mergedApiExecutionRoleArn(mergedApiExecutionRoleArn);
            return this;
        }

        /**
         * The OpenID Connect configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-openidconnectconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-openidconnectconfig</a>
         * @param openIdConnectConfig The OpenID Connect configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(final software.amazon.awscdk.IResolvable openIdConnectConfig) {
            this.props.openIdConnectConfig(openIdConnectConfig);
            return this;
        }
        /**
         * The OpenID Connect configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-openidconnectconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-openidconnectconfig</a>
         * @param openIdConnectConfig The OpenID Connect configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty openIdConnectConfig) {
            this.props.openIdConnectConfig(openIdConnectConfig);
            return this;
        }

        /**
         * The owner contact information for an API resource.
         * <p>
         * This field accepts any string input with a length of 0 - 256 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-ownercontact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-ownercontact</a>
         * @param ownerContact The owner contact information for an API resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerContact(final java.lang.String ownerContact) {
            this.props.ownerContact(ownerContact);
            return this;
        }

        /**
         * The maximum depth a query can have in a single request.
         * <p>
         * Depth refers to the amount of nested levels allowed in the body of query. The default value is <code>0</code> (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between <code>1</code> and <code>75</code> nested levels. This field will produce a limit error if the operation falls out of bounds. Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-querydepthlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-querydepthlimit</a>
         * @param queryDepthLimit The maximum depth a query can have in a single request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryDepthLimit(final java.lang.Number queryDepthLimit) {
            this.props.queryDepthLimit(queryDepthLimit);
            return this;
        }

        /**
         * The maximum number of resolvers that can be invoked in a single request.
         * <p>
         * The default value is <code>0</code> (or unspecified), which will set the limit to <code>10000</code> . When specified, the limit value can be between <code>1</code> and <code>10000</code> . This field will produce a limit error if the operation falls out of bounds.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-resolvercountlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-resolvercountlimit</a>
         * @param resolverCountLimit The maximum number of resolvers that can be invoked in a single request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolverCountLimit(final java.lang.Number resolverCountLimit) {
            this.props.resolverCountLimit(resolverCountLimit);
            return this;
        }

        /**
         * An arbitrary set of tags (key-value pairs) for this GraphQL API.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-tags</a>
         * @param tags An arbitrary set of tags (key-value pairs) for this GraphQL API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-userpoolconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-userpoolconfig</a>
         * @param userPoolConfig Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolConfig(final software.amazon.awscdk.IResolvable userPoolConfig) {
            this.props.userPoolConfig(userPoolConfig);
            return this;
        }
        /**
         * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-userpoolconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-userpoolconfig</a>
         * @param userPoolConfig Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolConfig(final software.amazon.awscdk.services.appsync.CfnGraphQLApi.UserPoolConfigProperty userPoolConfig) {
            this.props.userPoolConfig(userPoolConfig);
            return this;
        }

        /**
         * Sets the scope of the GraphQL API to public ( <code>GLOBAL</code> ) or private ( <code>PRIVATE</code> ).
         * <p>
         * By default, the scope is set to <code>Global</code> if no value is provided.
         * <p>
         * <em>WARNING</em> : If <code>Visibility</code> has not been defined, <em>explicitly</em> setting it to <code>GLOBAL</code> in a template/stack update will result in an API replacement and new DNS values.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-visibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-visibility</a>
         * @param visibility Sets the scope of the GraphQL API to public ( <code>GLOBAL</code> ) or private ( <code>PRIVATE</code> ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibility(final java.lang.String visibility) {
            this.props.visibility(visibility);
            return this;
        }

        /**
         * A flag indicating whether to use AWS X-Ray tracing for this <code>GraphqlApi</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-xrayenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-xrayenabled</a>
         * @param xrayEnabled A flag indicating whether to use AWS X-Ray tracing for this <code>GraphqlApi</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(final java.lang.Boolean xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }
        /**
         * A flag indicating whether to use AWS X-Ray tracing for this <code>GraphqlApi</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-xrayenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-xrayenabled</a>
         * @param xrayEnabled A flag indicating whether to use AWS X-Ray tracing for this <code>GraphqlApi</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(final software.amazon.awscdk.IResolvable xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.CfnGraphQLApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.CfnGraphQLApi build() {
            return new software.amazon.awscdk.services.appsync.CfnGraphQLApi(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
