package software.amazon.awscdk.services.appsync;

/**
 * An AppSync datasource backed by EventBridge.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.events.*;
 * GraphqlApi api = GraphqlApi.Builder.create(this, "EventBridgeApi")
 *         .name("EventBridgeApi")
 *         .definition(Definition.fromFile(join(__dirname, "appsync.eventbridge.graphql")))
 *         .build();
 * EventBus bus = EventBus.Builder.create(this, "DestinationEventBus").build();
 * EventBridgeDataSource dataSource = api.addEventBridgeDataSource("NoneDS", bus);
 * dataSource.createResolver("EventResolver", BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("emitEvent")
 *         .requestMappingTemplate(MappingTemplate.fromFile("request.vtl"))
 *         .responseMappingTemplate(MappingTemplate.fromFile("response.vtl"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:19.739Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.EventBridgeDataSource")
public class EventBridgeDataSource extends software.amazon.awscdk.services.appsync.BackedDataSource {

    protected EventBridgeDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventBridgeDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventBridgeDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.EventBridgeDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.EventBridgeDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.EventBridgeDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.EventBridgeDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.EventBridgeDataSourceProps.Builder();
        }

        /**
         * The API to attach this data source to.
         * <p>
         * @return {@code this}
         * @param api The API to attach this data source to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(final software.amazon.awscdk.services.appsync.IGraphqlApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * the description of the data source.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param description the description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the data source.
         * <p>
         * Default: - id of data source
         * <p>
         * @return {@code this}
         * @param name The name of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The IAM service role to be assumed by AppSync to interact with the data source.
         * <p>
         * Default: -  Create a new role
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM service role to be assumed by AppSync to interact with the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * The EventBridge EventBus.
         * <p>
         * @return {@code this}
         * @param eventBus The EventBridge EventBus. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBus(final software.amazon.awscdk.services.events.IEventBus eventBus) {
            this.props.eventBus(eventBus);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.EventBridgeDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.EventBridgeDataSource build() {
            return new software.amazon.awscdk.services.appsync.EventBridgeDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
