package software.amazon.awscdk.services.appsync;

/**
 * Properties for SourceApiAssociation which associates an AppSync Source API with an AppSync Merged API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi sourceApi = GraphqlApi.Builder.create(this, "FirstSourceAPI")
 *         .name("FirstSourceAPI")
 *         .definition(Definition.fromFile(join(__dirname, "appsync.merged-api-1.graphql")))
 *         .build();
 * IGraphqlApi importedMergedApi = GraphqlApi.fromGraphqlApiAttributes(this, "ImportedMergedApi", GraphqlApiAttributes.builder()
 *         .graphqlApiId("MyApiId")
 *         .graphqlApiArn("MyApiArn")
 *         .build());
 * IRole importedExecutionRole = Role.fromRoleArn(this, "ExecutionRole", "arn:aws:iam::ACCOUNT:role/MyExistingRole");
 * SourceApiAssociation.Builder.create(this, "SourceApiAssociation2")
 *         .sourceApi(sourceApi)
 *         .mergedApi(importedMergedApi)
 *         .mergeType(MergeType.MANUAL_MERGE)
 *         .mergedApiExecutionRole(importedExecutionRole)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:19.785Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.SourceApiAssociationProps")
@software.amazon.jsii.Jsii.Proxy(SourceApiAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SourceApiAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The merged api to associate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi getMergedApi();

    /**
     * The merged api execution role for adding the access policy for the source api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getMergedApiExecutionRole();

    /**
     * The source api to associate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi getSourceApi();

    /**
     * The description of the source api association.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The merge type for the source.
     * <p>
     * Default: - AUTO_MERGE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.MergeType getMergeType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SourceApiAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SourceApiAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SourceApiAssociationProps> {
        software.amazon.awscdk.services.appsync.IGraphqlApi mergedApi;
        software.amazon.awscdk.services.iam.IRole mergedApiExecutionRole;
        software.amazon.awscdk.services.appsync.IGraphqlApi sourceApi;
        java.lang.String description;
        software.amazon.awscdk.services.appsync.MergeType mergeType;

        /**
         * Sets the value of {@link SourceApiAssociationProps#getMergedApi}
         * @param mergedApi The merged api to associate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mergedApi(software.amazon.awscdk.services.appsync.IGraphqlApi mergedApi) {
            this.mergedApi = mergedApi;
            return this;
        }

        /**
         * Sets the value of {@link SourceApiAssociationProps#getMergedApiExecutionRole}
         * @param mergedApiExecutionRole The merged api execution role for adding the access policy for the source api. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mergedApiExecutionRole(software.amazon.awscdk.services.iam.IRole mergedApiExecutionRole) {
            this.mergedApiExecutionRole = mergedApiExecutionRole;
            return this;
        }

        /**
         * Sets the value of {@link SourceApiAssociationProps#getSourceApi}
         * @param sourceApi The source api to associate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceApi(software.amazon.awscdk.services.appsync.IGraphqlApi sourceApi) {
            this.sourceApi = sourceApi;
            return this;
        }

        /**
         * Sets the value of {@link SourceApiAssociationProps#getDescription}
         * @param description The description of the source api association.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link SourceApiAssociationProps#getMergeType}
         * @param mergeType The merge type for the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mergeType(software.amazon.awscdk.services.appsync.MergeType mergeType) {
            this.mergeType = mergeType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SourceApiAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SourceApiAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SourceApiAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceApiAssociationProps {
        private final software.amazon.awscdk.services.appsync.IGraphqlApi mergedApi;
        private final software.amazon.awscdk.services.iam.IRole mergedApiExecutionRole;
        private final software.amazon.awscdk.services.appsync.IGraphqlApi sourceApi;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.appsync.MergeType mergeType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mergedApi = software.amazon.jsii.Kernel.get(this, "mergedApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IGraphqlApi.class));
            this.mergedApiExecutionRole = software.amazon.jsii.Kernel.get(this, "mergedApiExecutionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.sourceApi = software.amazon.jsii.Kernel.get(this, "sourceApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IGraphqlApi.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mergeType = software.amazon.jsii.Kernel.get(this, "mergeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MergeType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mergedApi = java.util.Objects.requireNonNull(builder.mergedApi, "mergedApi is required");
            this.mergedApiExecutionRole = java.util.Objects.requireNonNull(builder.mergedApiExecutionRole, "mergedApiExecutionRole is required");
            this.sourceApi = java.util.Objects.requireNonNull(builder.sourceApi, "sourceApi is required");
            this.description = builder.description;
            this.mergeType = builder.mergeType;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.IGraphqlApi getMergedApi() {
            return this.mergedApi;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getMergedApiExecutionRole() {
            return this.mergedApiExecutionRole;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.IGraphqlApi getSourceApi() {
            return this.sourceApi;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.MergeType getMergeType() {
            return this.mergeType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mergedApi", om.valueToTree(this.getMergedApi()));
            data.set("mergedApiExecutionRole", om.valueToTree(this.getMergedApiExecutionRole()));
            data.set("sourceApi", om.valueToTree(this.getSourceApi()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMergeType() != null) {
                data.set("mergeType", om.valueToTree(this.getMergeType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.SourceApiAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SourceApiAssociationProps.Jsii$Proxy that = (SourceApiAssociationProps.Jsii$Proxy) o;

            if (!mergedApi.equals(that.mergedApi)) return false;
            if (!mergedApiExecutionRole.equals(that.mergedApiExecutionRole)) return false;
            if (!sourceApi.equals(that.sourceApi)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.mergeType != null ? this.mergeType.equals(that.mergeType) : that.mergeType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.mergedApi.hashCode();
            result = 31 * result + (this.mergedApiExecutionRole.hashCode());
            result = 31 * result + (this.sourceApi.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.mergeType != null ? this.mergeType.hashCode() : 0);
            return result;
        }
    }
}
