package software.amazon.awscdk.services.athena;

/**
 * Properties for defining a <code>CfnDataCatalog</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.athena.*;
 * CfnDataCatalogProps cfnDataCatalogProps = CfnDataCatalogProps.builder()
 *         .name("name")
 *         .type("type")
 *         // the properties below are optional
 *         .description("description")
 *         .parameters(Map.of(
 *                 "parametersKey", "parameters"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:19.827Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnDataCatalogProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataCatalogProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataCatalogProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the data catalog.
     * <p>
     * The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The type of data catalog: <code>LAMBDA</code> for a federated catalog, <code>GLUE</code> for AWS Glue Catalog, or <code>HIVE</code> for an external hive metastore.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * A description of the data catalog.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies the Lambda function or functions to use for the data catalog.
     * <p>
     * The mapping used depends on the catalog type.
     * <p>
     * <ul>
     * <li>The <code>HIVE</code> data catalog type uses the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</li>
     * </ul>
     * <p>
     * <code>metadata-function= *lambda_arn* , sdk-version= *version_number*</code>
     * <p>
     * <ul>
     * <li>The <code>LAMBDA</code> data catalog type uses one of the following sets of required parameters, but not both.</li>
     * <li>When one Lambda function processes metadata and another Lambda function reads data, the following syntax is used. Both parameters are required.</li>
     * </ul>
     * <p>
     * <code>metadata-function= *lambda_arn* , record-function= *lambda_arn*</code>
     * <p>
     * <ul>
     * <li>A composite Lambda function that processes both metadata and data uses the following syntax.</li>
     * </ul>
     * <p>
     * <code>function= *lambda_arn*</code>
     * <p>
     * <ul>
     * <li>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code>*catalog_id*</code> is the account ID of the AWS account to which the Glue catalog belongs.</li>
     * </ul>
     * <p>
     * <code>catalog-id= *catalog_id*</code>
     * <p>
     * <ul>
     * <li>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * The tags (key-value pairs) to associate with this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html#cfn-athena-datacatalog-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataCatalogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataCatalogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataCatalogProps> {
        java.lang.String name;
        java.lang.String type;
        java.lang.String description;
        java.lang.Object parameters;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataCatalogProps#getName}
         * @param name The name of the data catalog. This parameter is required.
         *             The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCatalogProps#getType}
         * @param type The type of data catalog: <code>LAMBDA</code> for a federated catalog, <code>GLUE</code> for AWS Glue Catalog, or <code>HIVE</code> for an external hive metastore. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCatalogProps#getDescription}
         * @param description A description of the data catalog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCatalogProps#getParameters}
         * @param parameters Specifies the Lambda function or functions to use for the data catalog.
         *                   The mapping used depends on the catalog type.
         *                   <p>
         *                   <ul>
         *                   <li>The <code>HIVE</code> data catalog type uses the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</li>
         *                   </ul>
         *                   <p>
         *                   <code>metadata-function= *lambda_arn* , sdk-version= *version_number*</code>
         *                   <p>
         *                   <ul>
         *                   <li>The <code>LAMBDA</code> data catalog type uses one of the following sets of required parameters, but not both.</li>
         *                   <li>When one Lambda function processes metadata and another Lambda function reads data, the following syntax is used. Both parameters are required.</li>
         *                   </ul>
         *                   <p>
         *                   <code>metadata-function= *lambda_arn* , record-function= *lambda_arn*</code>
         *                   <p>
         *                   <ul>
         *                   <li>A composite Lambda function that processes both metadata and data uses the following syntax.</li>
         *                   </ul>
         *                   <p>
         *                   <code>function= *lambda_arn*</code>
         *                   <p>
         *                   <ul>
         *                   <li>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code>*catalog_id*</code> is the account ID of the AWS account to which the Glue catalog belongs.</li>
         *                   </ul>
         *                   <p>
         *                   <code>catalog-id= *catalog_id*</code>
         *                   <p>
         *                   <ul>
         *                   <li>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCatalogProps#getParameters}
         * @param parameters Specifies the Lambda function or functions to use for the data catalog.
         *                   The mapping used depends on the catalog type.
         *                   <p>
         *                   <ul>
         *                   <li>The <code>HIVE</code> data catalog type uses the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</li>
         *                   </ul>
         *                   <p>
         *                   <code>metadata-function= *lambda_arn* , sdk-version= *version_number*</code>
         *                   <p>
         *                   <ul>
         *                   <li>The <code>LAMBDA</code> data catalog type uses one of the following sets of required parameters, but not both.</li>
         *                   <li>When one Lambda function processes metadata and another Lambda function reads data, the following syntax is used. Both parameters are required.</li>
         *                   </ul>
         *                   <p>
         *                   <code>metadata-function= *lambda_arn* , record-function= *lambda_arn*</code>
         *                   <p>
         *                   <ul>
         *                   <li>A composite Lambda function that processes both metadata and data uses the following syntax.</li>
         *                   </ul>
         *                   <p>
         *                   <code>function= *lambda_arn*</code>
         *                   <p>
         *                   <ul>
         *                   <li>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code>*catalog_id*</code> is the account ID of the AWS account to which the Glue catalog belongs.</li>
         *                   </ul>
         *                   <p>
         *                   <code>catalog-id= *catalog_id*</code>
         *                   <p>
         *                   <ul>
         *                   <li>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCatalogProps#getTags}
         * @param tags The tags (key-value pairs) to associate with this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataCatalogProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataCatalogProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataCatalogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataCatalogProps {
        private final java.lang.String name;
        private final java.lang.String type;
        private final java.lang.String description;
        private final java.lang.Object parameters;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.description = builder.description;
            this.parameters = builder.parameters;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnDataCatalogProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataCatalogProps.Jsii$Proxy that = (CfnDataCatalogProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!type.equals(that.type)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
