package software.amazon.awscdk.services.autoscaling;

/**
 * Define a warm pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * AutoScalingGroup autoScalingGroup;
 * WarmPool warmPool = WarmPool.Builder.create(this, "MyWarmPool")
 *         .autoScalingGroup(autoScalingGroup)
 *         // the properties below are optional
 *         .maxGroupPreparedCapacity(123)
 *         .minSize(123)
 *         .poolState(PoolState.HIBERNATED)
 *         .reuseOnScaleIn(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-04T22:57:20.033Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.WarmPool")
public class WarmPool extends software.amazon.awscdk.Resource {

    protected WarmPool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WarmPool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WarmPool(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.WarmPoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscaling.WarmPool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscaling.WarmPool> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscaling.WarmPoolProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscaling.WarmPoolProps.Builder();
        }

        /**
         * The maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group.
         * <p>
         * If the value is not specified, Amazon EC2 Auto Scaling launches and maintains
         * the difference between the group's maximum capacity and its desired capacity.
         * <p>
         * Default: - max size of the Auto Scaling group
         * <p>
         * @return {@code this}
         * @param maxGroupPreparedCapacity The maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxGroupPreparedCapacity(final java.lang.Number maxGroupPreparedCapacity) {
            this.props.maxGroupPreparedCapacity(maxGroupPreparedCapacity);
            return this;
        }

        /**
         * The minimum number of instances to maintain in the warm pool.
         * <p>
         * Default: 0
         * <p>
         * @return {@code this}
         * @param minSize The minimum number of instances to maintain in the warm pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(final java.lang.Number minSize) {
            this.props.minSize(minSize);
            return this;
        }

        /**
         * The instance state to transition to after the lifecycle actions are complete.
         * <p>
         * Default: PoolState.STOPPED
         * <p>
         * @return {@code this}
         * @param poolState The instance state to transition to after the lifecycle actions are complete. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder poolState(final software.amazon.awscdk.services.autoscaling.PoolState poolState) {
            this.props.poolState(poolState);
            return this;
        }

        /**
         * Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
         * <p>
         * If the value is not specified, instances in the Auto Scaling group will be terminated
         * when the group scales in.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param reuseOnScaleIn Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reuseOnScaleIn(final java.lang.Boolean reuseOnScaleIn) {
            this.props.reuseOnScaleIn(reuseOnScaleIn);
            return this;
        }

        /**
         * The Auto Scaling group to add the warm pool to.
         * <p>
         * @return {@code this}
         * @param autoScalingGroup The Auto Scaling group to add the warm pool to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroup(final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.props.autoScalingGroup(autoScalingGroup);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.autoscaling.WarmPool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscaling.WarmPool build() {
            return new software.amazon.awscdk.services.autoscaling.WarmPool(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
